/* atr_tab.c */

#include <stdio.h>

#include "atr_tab.h"

extern char *strdup();

typedef struct atr_alias ATRALIAS;

struct atr_alias {
  const char *alias;
  const char *realname;
};

typedef struct atr_ntab_hashentry ATRNHASH;

struct atr_ntab_hashentry {
  ATRNHASH *next;
  const char *name;
  ATTR *ap;
};

static ATRNHASH *atr_name_hashtab[ATR_HASH_SIZE];

/* this table can be expanded as necessary */

static ATRALIAS atr_alias_tab[] =
{
  { "ACONN", "ACONNECT" },
  { "ACON", "ACONNECT" },
  { "ADESC", "ADESCRIBE" },
  { "ADESCR", "ADESCRIBE" },
  { "ADESCRI", "ADESCRIBE" },
  { "ADISC", "ADISCONNECT" },
  { "ADISCON", "ADISCONNECT" },
  { "ADISCONN", "ADISCONNECT" },
  { "AFAIL", "AFAILURE" },
  { "APAY", "APAYMENT" },
  { "ASUCC", "ASUCCESS" },
  { "DESC", "DESCRIBE" },
  { "DESCR", "DESCRIBE" },
  { "DESCRI", "DESCRIBE" },
  { "FAIL", "FAILURE" },
  { "FILTE", "FILTER" },
  { "FILT", "FILTER" },
  { "FIL", "FILTER" },
  { "IDESC", "IDESCRIBE" },
  { "IDESCR", "IDESCRIBE" },
  { "IDESCRI", "IDESCRIBE" },
  { "INFILTE", "INFILTER" },
  { "INFILT", "INFILTER" },
  { "INFIL", "INFILTER" },
  { "INFI", "INFILTER" },
  { "INF", "INFILTER" },
  { "INPREFI", "INPREFIX" },
  { "INPREF", "INPREFIX" },
  { "INPRE", "INPREFIX" },
  { "INPR", "INPREFIX" },
  { "INP", "INPREFIX" },
  { "ODESC", "ODESCRIBE" },
  { "ODESCR", "ODESCRIBE" },
  { "ODESCRI", "ODESCRIBE" },
  { "OFAIL", "OFAILURE" },
  { "OPAY", "OPAYMENT" },
  { "OSUCC", "OSUCCESS" },
  { "PAY", "PAYMENT" },
  { "PREFI", "PREFIX" },
  { "PREF", "PREFIX" },
  { "PRE", "PREFIX" },
  { "SUCC", "SUCCESS" },
  { NULL, NULL }
};

/*----------------------------------------------------------------------
 * Hash functions of various sorts
 */

ATTR *aname_hash_lookup(name)
     char *name;
{
  /* given an attribute name, look it up in the complete attribute table
   * (real names plus aliases), and return the appropriate real attribute.
   */

  ATRNHASH *p;

  for (p = atr_name_hashtab[hash_fn(name, ATR_HASH_MASK)];
       p != NULL; p = p->next)
    if (!strcmp(name, p->name))
      return (ATTR *)p->ap;

  return (ATTR *)NULL;
}

static void aname_hash_insert(name, aptr)
     char *name;
     ATTR *aptr;
{
  /* insert an attribute name into the main attribute hashtable */

  ATRNHASH *newp;
  unsigned hashval;

  /* can assume no duplicates */
  newp = (ATRNHASH *) malloc(sizeof(ATRNHASH));
  newp->name = (char *) strdup(name);
  newp->ap = aptr;
  hashval = hash_fn(name, ATR_HASH_MASK);
  newp->next = atr_name_hashtab[hashval];
  atr_name_hashtab[hashval] = newp;
}

void init_aname_hashtab()
{
  ATTR *ap;
  ATRALIAS *aliasp;

  /* build the basic hash table */
  for (ap = attr; ap->name; ap++)
    aname_hash_insert((char *)ap->name, (ATTR *) ap);

  /* now add in aliases */
  for (aliasp = atr_alias_tab; aliasp->alias; aliasp++) {
    if ((ap = aname_hash_lookup(aliasp->realname)) != NULL)
      aname_hash_insert((char *) aliasp->alias, (ATTR *) ap);
    else 
      fprintf(stderr, 
	      "ATR INIT: attribute alias %s matches no known attribute.\n",
	      aliasp->alias);
  }
}
