/* help.c */
/* $Id: help.c,v 1.5 1993/02/26 23:29:28 nils Exp $ */

#include <stdio.h>

/* commands for giving help */

#include "db.h"
#include "config.h"
#include "interface.h"
#include "externs.h"
#include "help.h"

void spit_file(player,filename,ff)
     dbref player;
 char *filename;
     FILE *ff;
{
  FILE *f;
  char buf[BUFFER_LEN];
  char *p;
  
  if((filename!=NULL)?((f = fopen(filename, "r")) == NULL):((f=ff)==NULL)) {
    if(filename)
      sprintf(buf, "Sorry, %s is broken.  Management has been notified.",
	      filename);
    else
      strcpy(buf,"Sorry, it's broken. management has been notified.");
    notify(player, buf);
    fputs("spit_file:", stderr);
    if(filename)
      perror(filename);
    else
      perror("");
  } else {
    while(fgets(buf, sizeof buf, f)) {
      for(p = buf; *p; p++) if(*p == '\n') {
	*p = '\0';
	break;
      }
      notify(player, buf);
    }
    fclose(f);
  }
}

/*
  void do_news(player)
  dbref player;
  {
  spit_file(player, NEWS_FILE);
  }
  */
void do_text(player, arg1, arg2)
     dbref player;
     char *arg1;
     char *arg2;
{
  char indx[20];
  char text[20];
  if (strlen(arg1) <2 || strlen(arg1)>10 || strchr(arg1,'/') || strchr(arg1,'.')) {
    notify(player, "illegal text file.");
    return;
  }
  sprintf(indx,"msgs/%sindx",arg1);
  sprintf(text,"msgs/%stext",arg1);
  do_help(player, arg2, arg1, indx, text);
}

void do_help(player, arg1, deftopic, indxfile, textfile)
     dbref player;
     char *arg1;
     char *deftopic;
     char *indxfile;
     char *textfile;
{
  int help_found;
  help_indx entry;
  FILE *fp;
  char *p, line[LINE_SIZE+1];
  
  if ( *arg1 == '\0' )
    arg1 = deftopic;
  
  if ( (fp = fopen(indxfile, "r")) == NULL )  {
    notify(player,
	   tprintf("%s is not available.", deftopic));
    log_error(tprintf("can't open %s for reading", indxfile));
    return;
  }
  while ( (help_found = fread(&entry, sizeof(help_indx), 1, fp)) == 1 )
    if ( string_prefix(entry.topic, arg1) )
      break;
  fclose(fp);
  if ( help_found <= 0 )  {
    notify(player, tprintf("No %s for '%s'.", deftopic, arg1));
    return;
  }
  
  if ( (fp = fopen(textfile, "r")) == NULL )  {
    notify(player,
	   tprintf("%s: sorry, temporarily not available.", deftopic));
    log_error(tprintf("can't open %s for reading", textfile));
    return;
  }
  if ( fseek(fp, entry.pos, 0) < 0L )  {
    notify(player,
	   tprintf("%s: sorry, temporarily not available.", deftopic));
    log_error(tprintf("seek error in file %s", textfile));
    return;
  }
  for (;;)  {
    if ( fgets(line, LINE_SIZE, fp) == NULL )
      break;
    if ( line[0] == '&' )
      break;
    for ( p = line; *p != '\0'; p++ )
      if ( *p == '\n' )
	*p = '\0';
    notify(player, line);
  }
  fclose(fp);
}
