#include "move_failure.h"

int pick_command(string str) {
    object ob;
    int res;

    if (!str) {
	notify_fail("Take what ?\n");
	return 0;
    }
    ob = present(str, environment(this_player()));
    if (!ob) {
	if ((int)environment(this_player())->id(str)) {
	    notify_fail("You can't take that!\n");
	    return 0;
	}
	notify_fail("What " + str + "?\n");
	return 0;
    }
    res = (int)ob->move(this_player());
    if (res == MOVE_OK) {
	write("Ok.\n");
	this_object()->message("takes " + (string)ob->query_short(), 0, 0);
	return 1;
    }
    if (res == MOVE_NOT_ALLOWED)
	notify_fail("You can't do that.\n");
    else if (res == MOVE_NO_ROOM)
	notify_fail("Not enough room.\n");
    return 0;
}
