
/* File: tables.c */

/*
 * Copyright (c) 1998 Julian Lighton, Ben Harrison,
 * James E. Wilson, Robert A. Koeneke
 *
 * This software may be copied and distributed for educational, research,
 * and not for profit purposes provided that this copyright and statement
 * are included in all such copies.  Other copyrights may also apply.
 */

#include "angband.h"




/*
 * Global array for looping through the "keypad directions"
 */
s16b ddd[9] =
{2, 8, 6, 4, 3, 1, 9, 7, 5};

/*
 * Global arrays for converting "keypad direction" into offsets
 */
s16b ddx[10] =
{0, -1, 0, 1, -1, 0, 1, -1, 0, 1};

s16b ddy[10] =
{0, 1, 1, 1, 0, 0, 0, -1, -1, -1};

/*
 * Global arrays for optimizing "ddx[ddd[i]]" and "ddy[ddd[i]]"
 */
s16b ddx_ddd[9] =
{0, 0, 1, -1, 1, -1, 1, -1, 0};

s16b ddy_ddd[9] =
{1, -1, 0, 0, 1, 1, -1, -1, 0};



/*
 * Global array for converting numbers to uppercase hecidecimal digit
 * This array can also be used to convert a number to an octal digit
 */
char hexsym[16] =
{
	'0', '1', '2', '3', '4', '5', '6', '7',
	'8', '9', 'A', 'B', 'C', 'D', 'E', 'F'
};


/*
 * Stat Table (INT/WIS/CHR) -- Number of half-spells per level
 */
byte adj_mag_study[] =
{
	0 /* 3 */ ,
	0 /* 4 */ ,
	0 /* 5 */ ,
	0 /* 6 */ ,
	0 /* 7 */ ,
	1 /* 8 */ ,
	1 /* 9 */ ,
	1 /* 10 */ ,
	1 /* 11 */ ,
	2 /* 12 */ ,
	2 /* 13 */ ,
	2 /* 14 */ ,
	2 /* 15 */ ,
	2 /* 16 */ ,
	2 /* 17 */ ,
	2 /* 18/00-18/09 */ ,
	2 /* 18/10-18/19 */ ,
	2 /* 18/20-18/29 */ ,
	2 /* 18/30-18/39 */ ,
	2 /* 18/40-18/49 */ ,
	3 /* 18/50-18/59 */ ,
	3 /* 18/60-18/69 */ ,
	3 /* 18/70-18/79 */ ,
	3 /* 18/80-18/89 */ ,
	4 /* 18/90-18/99 */ ,
	4 /* 18/100-18/109 */ ,
	4 /* 18/110-18/119 */ ,
	5 /* 18/120-18/129 */ ,
	5 /* 18/130-18/139 */ ,
	5 /* 18/140-18/149 */ ,
	5 /* 18/150-18/159 */ ,
	5 /* 18/160-18/169 */ ,
	5 /* 18/170-18/179 */ ,
	5 /* 18/180-18/189 */ ,
	5 /* 18/190-18/199 */ ,
	5 /* 18/200-18/209 */ ,
	5 /* 18/210-18/219 */ ,
	5							/* 18/220+ */
};


/*
 * Stat Table (INT/WIS/CHR) -- extra half-mana-points per level
 */
byte adj_mag_mana[] =
{
	0 /* 3 */ ,
	0 /* 4 */ ,
	0 /* 5 */ ,
	0 /* 6 */ ,
	0 /* 7 */ ,
	1 /* 8 */ ,
	2 /* 9 */ ,
	2 /* 10 */ ,
	2 /* 11 */ ,
	2 /* 12 */ ,
	2 /* 13 */ ,
	2 /* 14 */ ,
	2 /* 15 */ ,
	2 /* 16 */ ,
	2 /* 17 */ ,
	3 /* 18/00-18/09 */ ,
	3 /* 18/10-18/19 */ ,
	3 /* 18/20-18/29 */ ,
	3 /* 18/30-18/39 */ ,
	3 /* 18/40-18/49 */ ,
	4 /* 18/50-18/59 */ ,
	4 /* 18/60-18/69 */ ,
	5 /* 18/70-18/79 */ ,
	6 /* 18/80-18/89 */ ,
	7 /* 18/90-18/99 */ ,
	8 /* 18/100-18/109 */ ,
	9 /* 18/110-18/119 */ ,
	10 /* 18/120-18/129 */ ,
	11 /* 18/130-18/139 */ ,
	12 /* 18/140-18/149 */ ,
	13 /* 18/150-18/159 */ ,
	14 /* 18/160-18/169 */ ,
	15 /* 18/170-18/179 */ ,
	16 /* 18/180-18/189 */ ,
	16 /* 18/190-18/199 */ ,
	16 /* 18/200-18/209 */ ,
	16 /* 18/210-18/219 */ ,
	16							/* 18/220+ */
};


/*
 * Stat Table (INT/WIS/CHR) -- Minimum failure rate (percentage)
 */
byte adj_mag_fail[] =
{
	99 /* 3 */ ,
	99 /* 4 */ ,
	99 /* 5 */ ,
	99 /* 6 */ ,
	99 /* 7 */ ,
	50 /* 8 */ ,
	30 /* 9 */ ,
	20 /* 10 */ ,
	15 /* 11 */ ,
	12 /* 12 */ ,
	11 /* 13 */ ,
	10 /* 14 */ ,
	9 /* 15 */ ,
	8 /* 16 */ ,
	7 /* 17 */ ,
	6 /* 18/00-18/09 */ ,
	6 /* 18/10-18/19 */ ,
	5 /* 18/20-18/29 */ ,
	5 /* 18/30-18/39 */ ,
	5 /* 18/40-18/49 */ ,
	4 /* 18/50-18/59 */ ,
	4 /* 18/60-18/69 */ ,
	4 /* 18/70-18/79 */ ,
	4 /* 18/80-18/89 */ ,
	3 /* 18/90-18/99 */ ,
	3 /* 18/100-18/109 */ ,
	2 /* 18/110-18/119 */ ,
	2 /* 18/120-18/129 */ ,
	2 /* 18/130-18/139 */ ,
	2 /* 18/140-18/149 */ ,
	1 /* 18/150-18/159 */ ,
	1 /* 18/160-18/169 */ ,
	1 /* 18/170-18/179 */ ,
	1 /* 18/180-18/189 */ ,
	1 /* 18/190-18/199 */ ,
	0 /* 18/200-18/209 */ ,
	0 /* 18/210-18/219 */ ,
	0							/* 18/220+ */
};


/*
 * Stat Table (INT/WIS/CHR) -- Various things
 */
byte adj_mag_stat[] =
{
	0 /* 3 */ ,
	0 /* 4 */ ,
	0 /* 5 */ ,
	0 /* 6 */ ,
	0 /* 7 */ ,
	1 /* 8 */ ,
	1 /* 9 */ ,
	1 /* 10 */ ,
	1 /* 11 */ ,
	1 /* 12 */ ,
	1 /* 13 */ ,
	1 /* 14 */ ,
	2 /* 15 */ ,
	2 /* 16 */ ,
	2 /* 17 */ ,
	3 /* 18/00-18/09 */ ,
	3 /* 18/10-18/19 */ ,
	3 /* 18/20-18/29 */ ,
	3 /* 18/30-18/39 */ ,
	3 /* 18/40-18/49 */ ,
	4 /* 18/50-18/59 */ ,
	4 /* 18/60-18/69 */ ,
	5 /* 18/70-18/79 */ ,
	6 /* 18/80-18/89 */ ,
	7 /* 18/90-18/99 */ ,
	8 /* 18/100-18/109 */ ,
	9 /* 18/110-18/119 */ ,
	10 /* 18/120-18/129 */ ,
	11 /* 18/130-18/139 */ ,
	12 /* 18/140-18/149 */ ,
	13 /* 18/150-18/159 */ ,
	14 /* 18/160-18/169 */ ,
	15 /* 18/170-18/179 */ ,
	16 /* 18/180-18/189 */ ,
	17 /* 18/190-18/199 */ ,
	18 /* 18/200-18/209 */ ,
	19 /* 18/210-18/219 */ ,
	20							/* 18/220+ */
};


/*
 * Stat Table (CHR) -- payment percentages
 */
byte adj_chr_gold[] =
{
	130 /* 3 */ ,
	125 /* 4 */ ,
	122 /* 5 */ ,
	120 /* 6 */ ,
	118 /* 7 */ ,
	116 /* 8 */ ,
	114 /* 9 */ ,
	112 /* 10 */ ,
	110 /* 11 */ ,
	108 /* 12 */ ,
	106 /* 13 */ ,
	104 /* 14 */ ,
	103 /* 15 */ ,
	102 /* 16 */ ,
	101 /* 17 */ ,
	100 /* 18/00-18/09 */ ,
	99 /* 18/10-18/19 */ ,
	98 /* 18/20-18/29 */ ,
	97 /* 18/30-18/39 */ ,
	96 /* 18/40-18/49 */ ,
	95 /* 18/50-18/59 */ ,
	94 /* 18/60-18/69 */ ,
	93 /* 18/70-18/79 */ ,
	92 /* 18/80-18/89 */ ,
	91 /* 18/90-18/99 */ ,
	90 /* 18/100-18/109 */ ,
	89 /* 18/110-18/119 */ ,
	88 /* 18/120-18/129 */ ,
	87 /* 18/130-18/139 */ ,
	86 /* 18/140-18/149 */ ,
	85 /* 18/150-18/159 */ ,
	84 /* 18/160-18/169 */ ,
	83 /* 18/170-18/179 */ ,
	82 /* 18/180-18/189 */ ,
	81 /* 18/190-18/199 */ ,
	80 /* 18/200-18/209 */ ,
	80 /* 18/210-18/219 */ ,
	80							/* 18/220+ */
};


/*
 * Stat Table (INT) -- Magic devices
 */
byte adj_int_dev[] =
{
	0 /* 3 */ ,
	0 /* 4 */ ,
	0 /* 5 */ ,
	0 /* 6 */ ,
	0 /* 7 */ ,
	1 /* 8 */ ,
	1 /* 9 */ ,
	1 /* 10 */ ,
	1 /* 11 */ ,
	1 /* 12 */ ,
	1 /* 13 */ ,
	1 /* 14 */ ,
	2 /* 15 */ ,
	2 /* 16 */ ,
	2 /* 17 */ ,
	3 /* 18/00-18/09 */ ,
	3 /* 18/10-18/19 */ ,
	4 /* 18/20-18/29 */ ,
	4 /* 18/30-18/39 */ ,
	5 /* 18/40-18/49 */ ,
	5 /* 18/50-18/59 */ ,
	6 /* 18/60-18/69 */ ,
	6 /* 18/70-18/79 */ ,
	7 /* 18/80-18/89 */ ,
	7 /* 18/90-18/99 */ ,
	8 /* 18/100-18/109 */ ,
	9 /* 18/110-18/119 */ ,
	10 /* 18/120-18/129 */ ,
	11 /* 18/130-18/139 */ ,
	12 /* 18/140-18/149 */ ,
	13 /* 18/150-18/159 */ ,
	14 /* 18/160-18/169 */ ,
	15 /* 18/170-18/179 */ ,
	16 /* 18/180-18/189 */ ,
	17 /* 18/190-18/199 */ ,
	18 /* 18/200-18/209 */ ,
	19 /* 18/210-18/219 */ ,
	20							/* 18/220+ */
};


/*
 * Stat Table (WIS) -- Saving throw
 */
byte adj_wis_sav[] =
{
	0 /* 3 */ ,
	0 /* 4 */ ,
	0 /* 5 */ ,
	0 /* 6 */ ,
	0 /* 7 */ ,
	1 /* 8 */ ,
	1 /* 9 */ ,
	1 /* 10 */ ,
	1 /* 11 */ ,
	1 /* 12 */ ,
	1 /* 13 */ ,
	1 /* 14 */ ,
	2 /* 15 */ ,
	2 /* 16 */ ,
	2 /* 17 */ ,
	3 /* 18/00-18/09 */ ,
	3 /* 18/10-18/19 */ ,
	3 /* 18/20-18/29 */ ,
	3 /* 18/30-18/39 */ ,
	3 /* 18/40-18/49 */ ,
	4 /* 18/50-18/59 */ ,
	4 /* 18/60-18/69 */ ,
	5 /* 18/70-18/79 */ ,
	5 /* 18/80-18/89 */ ,
	6 /* 18/90-18/99 */ ,
	7 /* 18/100-18/109 */ ,
	8 /* 18/110-18/119 */ ,
	9 /* 18/120-18/129 */ ,
	10 /* 18/130-18/139 */ ,
	11 /* 18/140-18/149 */ ,
	12 /* 18/150-18/159 */ ,
	13 /* 18/160-18/169 */ ,
	14 /* 18/170-18/179 */ ,
	15 /* 18/180-18/189 */ ,
	16 /* 18/190-18/199 */ ,
	17 /* 18/200-18/209 */ ,
	18 /* 18/210-18/219 */ ,
	19							/* 18/220+ */
};


/*
 * Stat Table (DEX) -- disarming
 */
byte adj_dex_dis[] =
{
	0 /* 3 */ ,
	0 /* 4 */ ,
	0 /* 5 */ ,
	0 /* 6 */ ,
	0 /* 7 */ ,
	0 /* 8 */ ,
	0 /* 9 */ ,
	0 /* 10 */ ,
	0 /* 11 */ ,
	0 /* 12 */ ,
	1 /* 13 */ ,
	1 /* 14 */ ,
	1 /* 15 */ ,
	2 /* 16 */ ,
	2 /* 17 */ ,
	4 /* 18/00-18/09 */ ,
	4 /* 18/10-18/19 */ ,
	4 /* 18/20-18/29 */ ,
	4 /* 18/30-18/39 */ ,
	5 /* 18/40-18/49 */ ,
	5 /* 18/50-18/59 */ ,
	5 /* 18/60-18/69 */ ,
	6 /* 18/70-18/79 */ ,
	6 /* 18/80-18/89 */ ,
	7 /* 18/90-18/99 */ ,
	8 /* 18/100-18/109 */ ,
	8 /* 18/110-18/119 */ ,
	8 /* 18/120-18/129 */ ,
	8 /* 18/130-18/139 */ ,
	8 /* 18/140-18/149 */ ,
	9 /* 18/150-18/159 */ ,
	9 /* 18/160-18/169 */ ,
	9 /* 18/170-18/179 */ ,
	9 /* 18/180-18/189 */ ,
	9 /* 18/190-18/199 */ ,
	10 /* 18/200-18/209 */ ,
	10 /* 18/210-18/219 */ ,
	10							/* 18/220+ */
};


/*
 * Stat Table (INT) -- disarming
 */
byte adj_int_dis[] =
{
	0 /* 3 */ ,
	0 /* 4 */ ,
	0 /* 5 */ ,
	0 /* 6 */ ,
	0 /* 7 */ ,
	1 /* 8 */ ,
	1 /* 9 */ ,
	1 /* 10 */ ,
	1 /* 11 */ ,
	1 /* 12 */ ,
	1 /* 13 */ ,
	1 /* 14 */ ,
	2 /* 15 */ ,
	2 /* 16 */ ,
	2 /* 17 */ ,
	3 /* 18/00-18/09 */ ,
	3 /* 18/10-18/19 */ ,
	3 /* 18/20-18/29 */ ,
	4 /* 18/30-18/39 */ ,
	4 /* 18/40-18/49 */ ,
	5 /* 18/50-18/59 */ ,
	6 /* 18/60-18/69 */ ,
	7 /* 18/70-18/79 */ ,
	8 /* 18/80-18/89 */ ,
	9 /* 18/90-18/99 */ ,
	10 /* 18/100-18/109 */ ,
	10 /* 18/110-18/119 */ ,
	11 /* 18/120-18/129 */ ,
	12 /* 18/130-18/139 */ ,
	13 /* 18/140-18/149 */ ,
	14 /* 18/150-18/159 */ ,
	15 /* 18/160-18/169 */ ,
	16 /* 18/170-18/179 */ ,
	17 /* 18/180-18/189 */ ,
	18 /* 18/190-18/199 */ ,
	19 /* 18/200-18/209 */ ,
	19 /* 18/210-18/219 */ ,
	19							/* 18/220+ */
};


/*
 * Stat Table (DEX) -- bonus to ac (plus 128)
 */
byte adj_dex_ta[] =
{
	128 + -4 /* 3 */ ,
	128 + -3 /* 4 */ ,
	128 + -2 /* 5 */ ,
	128 + -1 /* 6 */ ,
	128 + 0 /* 7 */ ,
	128 + 0 /* 8 */ ,
	128 + 0 /* 9 */ ,
	128 + 0 /* 10 */ ,
	128 + 0 /* 11 */ ,
	128 + 0 /* 12 */ ,
	128 + 0 /* 13 */ ,
	128 + 0 /* 14 */ ,
	128 + 1 /* 15 */ ,
	128 + 1 /* 16 */ ,
	128 + 1 /* 17 */ ,
	128 + 2 /* 18/00-18/09 */ ,
	128 + 2 /* 18/10-18/19 */ ,
	128 + 2 /* 18/20-18/29 */ ,
	128 + 2 /* 18/30-18/39 */ ,
	128 + 2 /* 18/40-18/49 */ ,
	128 + 3 /* 18/50-18/59 */ ,
	128 + 3 /* 18/60-18/69 */ ,
	128 + 3 /* 18/70-18/79 */ ,
	128 + 4 /* 18/80-18/89 */ ,
	128 + 5 /* 18/90-18/99 */ ,
	128 + 6 /* 18/100-18/109 */ ,
	128 + 7 /* 18/110-18/119 */ ,
	128 + 8 /* 18/120-18/129 */ ,
	128 + 9 /* 18/130-18/139 */ ,
	128 + 9 /* 18/140-18/149 */ ,
	128 + 10 /* 18/150-18/159 */ ,
	128 + 11 /* 18/160-18/169 */ ,
	128 + 12 /* 18/170-18/179 */ ,
	128 + 13 /* 18/180-18/189 */ ,
	128 + 14 /* 18/190-18/199 */ ,
	128 + 15 /* 18/200-18/209 */ ,
	128 + 15 /* 18/210-18/219 */ ,
	128 + 15					/* 18/220+ */
};


/*
 * Stat Table (STR) -- bonus to dam (plus 128)
 */
byte adj_str_td[] =
{
	128 + -2 /* 3 */ ,
	128 + -2 /* 4 */ ,
	128 + -1 /* 5 */ ,
	128 + -1 /* 6 */ ,
	128 + 0 /* 7 */ ,
	128 + 0 /* 8 */ ,
	128 + 0 /* 9 */ ,
	128 + 0 /* 10 */ ,
	128 + 0 /* 11 */ ,
	128 + 0 /* 12 */ ,
	128 + 0 /* 13 */ ,
	128 + 0 /* 14 */ ,
	128 + 0 /* 15 */ ,
	128 + 1 /* 16 */ ,
	128 + 2 /* 17 */ ,
	128 + 2 /* 18/00-18/09 */ ,
	128 + 2 /* 18/10-18/19 */ ,
	128 + 3 /* 18/20-18/29 */ ,
	128 + 3 /* 18/30-18/39 */ ,
	128 + 3 /* 18/40-18/49 */ ,
	128 + 3 /* 18/50-18/59 */ ,
	128 + 3 /* 18/60-18/69 */ ,
	128 + 4 /* 18/70-18/79 */ ,
	128 + 5 /* 18/80-18/89 */ ,
	128 + 5 /* 18/90-18/99 */ ,
	128 + 6 /* 18/100-18/109 */ ,
	128 + 7 /* 18/110-18/119 */ ,
	128 + 8 /* 18/120-18/129 */ ,
	128 + 9 /* 18/130-18/139 */ ,
	128 + 10 /* 18/140-18/149 */ ,
	128 + 11 /* 18/150-18/159 */ ,
	128 + 12 /* 18/160-18/169 */ ,
	128 + 13 /* 18/170-18/179 */ ,
	128 + 14 /* 18/180-18/189 */ ,
	128 + 15 /* 18/190-18/199 */ ,
	128 + 16 /* 18/200-18/209 */ ,
	128 + 18 /* 18/210-18/219 */ ,
	128 + 20					/* 18/220+ */
};


/*
 * Stat Table (DEX) -- bonus to hit (plus 128)
 */
byte adj_dex_th[] =
{
	128 + -3 /* 3 */ ,
	128 + -2 /* 4 */ ,
	128 + -2 /* 5 */ ,
	128 + -1 /* 6 */ ,
	128 + -1 /* 7 */ ,
	128 + 0 /* 8 */ ,
	128 + 0 /* 9 */ ,
	128 + 0 /* 10 */ ,
	128 + 0 /* 11 */ ,
	128 + 0 /* 12 */ ,
	128 + 0 /* 13 */ ,
	128 + 0 /* 14 */ ,
	128 + 0 /* 15 */ ,
	128 + 1 /* 16 */ ,
	128 + 2 /* 17 */ ,
	128 + 3 /* 18/00-18/09 */ ,
	128 + 3 /* 18/10-18/19 */ ,
	128 + 3 /* 18/20-18/29 */ ,
	128 + 3 /* 18/30-18/39 */ ,
	128 + 3 /* 18/40-18/49 */ ,
	128 + 4 /* 18/50-18/59 */ ,
	128 + 4 /* 18/60-18/69 */ ,
	128 + 4 /* 18/70-18/79 */ ,
	128 + 4 /* 18/80-18/89 */ ,
	128 + 5 /* 18/90-18/99 */ ,
	128 + 6 /* 18/100-18/109 */ ,
	128 + 7 /* 18/110-18/119 */ ,
	128 + 8 /* 18/120-18/129 */ ,
	128 + 9 /* 18/130-18/139 */ ,
	128 + 9 /* 18/140-18/149 */ ,
	128 + 10 /* 18/150-18/159 */ ,
	128 + 11 /* 18/160-18/169 */ ,
	128 + 12 /* 18/170-18/179 */ ,
	128 + 13 /* 18/180-18/189 */ ,
	128 + 14 /* 18/190-18/199 */ ,
	128 + 15 /* 18/200-18/209 */ ,
	128 + 15 /* 18/210-18/219 */ ,
	128 + 15					/* 18/220+ */
};


/*
 * Stat Table (STR) -- bonus to hit (plus 128)
 */
byte adj_str_th[] =
{
	128 + -3 /* 3 */ ,
	128 + -2 /* 4 */ ,
	128 + -1 /* 5 */ ,
	128 + -1 /* 6 */ ,
	128 + 0 /* 7 */ ,
	128 + 0 /* 8 */ ,
	128 + 0 /* 9 */ ,
	128 + 0 /* 10 */ ,
	128 + 0 /* 11 */ ,
	128 + 0 /* 12 */ ,
	128 + 0 /* 13 */ ,
	128 + 0 /* 14 */ ,
	128 + 0 /* 15 */ ,
	128 + 0 /* 16 */ ,
	128 + 0 /* 17 */ ,
	128 + 1 /* 18/00-18/09 */ ,
	128 + 1 /* 18/10-18/19 */ ,
	128 + 1 /* 18/20-18/29 */ ,
	128 + 1 /* 18/30-18/39 */ ,
	128 + 1 /* 18/40-18/49 */ ,
	128 + 1 /* 18/50-18/59 */ ,
	128 + 1 /* 18/60-18/69 */ ,
	128 + 2 /* 18/70-18/79 */ ,
	128 + 3 /* 18/80-18/89 */ ,
	128 + 4 /* 18/90-18/99 */ ,
	128 + 5 /* 18/100-18/109 */ ,
	128 + 6 /* 18/110-18/119 */ ,
	128 + 7 /* 18/120-18/129 */ ,
	128 + 8 /* 18/130-18/139 */ ,
	128 + 9 /* 18/140-18/149 */ ,
	128 + 10 /* 18/150-18/159 */ ,
	128 + 11 /* 18/160-18/169 */ ,
	128 + 12 /* 18/170-18/179 */ ,
	128 + 13 /* 18/180-18/189 */ ,
	128 + 14 /* 18/190-18/199 */ ,
	128 + 15 /* 18/200-18/209 */ ,
	128 + 15 /* 18/210-18/219 */ ,
	128 + 15					/* 18/220+ */
};


/*
 * Stat Table (STR) -- weight limit in deca-pounds
 */
byte adj_str_wgt[] =
{
	5 /* 3 */ ,
	6 /* 4 */ ,
	7 /* 5 */ ,
	8 /* 6 */ ,
	9 /* 7 */ ,
	10 /* 8 */ ,
	11 /* 9 */ ,
	12 /* 10 */ ,
	13 /* 11 */ ,
	14 /* 12 */ ,
	15 /* 13 */ ,
	16 /* 14 */ ,
	17 /* 15 */ ,
	18 /* 16 */ ,
	19 /* 17 */ ,
	20 /* 18/00-18/09 */ ,
	22 /* 18/10-18/19 */ ,
	24 /* 18/20-18/29 */ ,
	26 /* 18/30-18/39 */ ,
	28 /* 18/40-18/49 */ ,
	30 /* 18/50-18/59 */ ,
	30 /* 18/60-18/69 */ ,
	30 /* 18/70-18/79 */ ,
	30 /* 18/80-18/89 */ ,
	30 /* 18/90-18/99 */ ,
	30 /* 18/100-18/109 */ ,
	30 /* 18/110-18/119 */ ,
	30 /* 18/120-18/129 */ ,
	30 /* 18/130-18/139 */ ,
	30 /* 18/140-18/149 */ ,
	30 /* 18/150-18/159 */ ,
	30 /* 18/160-18/169 */ ,
	30 /* 18/170-18/179 */ ,
	30 /* 18/180-18/189 */ ,
	30 /* 18/190-18/199 */ ,
	30 /* 18/200-18/209 */ ,
	30 /* 18/210-18/219 */ ,
	30							/* 18/220+ */
};


/*
 * Stat Table (STR) -- weapon weight limit in pounds
 */
byte adj_str_hold[] =
{
	4 /* 3 */ ,
	5 /* 4 */ ,
	6 /* 5 */ ,
	7 /* 6 */ ,
	8 /* 7 */ ,
	10 /* 8 */ ,
	12 /* 9 */ ,
	14 /* 10 */ ,
	16 /* 11 */ ,
	18 /* 12 */ ,
	20 /* 13 */ ,
	22 /* 14 */ ,
	24 /* 15 */ ,
	26 /* 16 */ ,
	28 /* 17 */ ,
	30 /* 18/00-18/09 */ ,
	30 /* 18/10-18/19 */ ,
	35 /* 18/20-18/29 */ ,
	40 /* 18/30-18/39 */ ,
	45 /* 18/40-18/49 */ ,
	50 /* 18/50-18/59 */ ,
	55 /* 18/60-18/69 */ ,
	60 /* 18/70-18/79 */ ,
	65 /* 18/80-18/89 */ ,
	70 /* 18/90-18/99 */ ,
	80 /* 18/100-18/109 */ ,
	80 /* 18/110-18/119 */ ,
	80 /* 18/120-18/129 */ ,
	80 /* 18/130-18/139 */ ,
	80 /* 18/140-18/149 */ ,
	90 /* 18/150-18/159 */ ,
	90 /* 18/160-18/169 */ ,
	90 /* 18/170-18/179 */ ,
	90 /* 18/180-18/189 */ ,
	90 /* 18/190-18/199 */ ,
	100 /* 18/200-18/209 */ ,
	100 /* 18/210-18/219 */ ,
	100							/* 18/220+ */
};


/*
 * Stat Table (STR) -- digging value
 */
byte adj_str_dig[] =
{
	0 /* 3 */ ,
	0 /* 4 */ ,
	1 /* 5 */ ,
	2 /* 6 */ ,
	3 /* 7 */ ,
	4 /* 8 */ ,
	4 /* 9 */ ,
	5 /* 10 */ ,
	5 /* 11 */ ,
	6 /* 12 */ ,
	6 /* 13 */ ,
	7 /* 14 */ ,
	7 /* 15 */ ,
	8 /* 16 */ ,
	8 /* 17 */ ,
	9 /* 18/00-18/09 */ ,
	10 /* 18/10-18/19 */ ,
	12 /* 18/20-18/29 */ ,
	15 /* 18/30-18/39 */ ,
	20 /* 18/40-18/49 */ ,
	25 /* 18/50-18/59 */ ,
	30 /* 18/60-18/69 */ ,
	35 /* 18/70-18/79 */ ,
	40 /* 18/80-18/89 */ ,
	45 /* 18/90-18/99 */ ,
	50 /* 18/100-18/109 */ ,
	55 /* 18/110-18/119 */ ,
	60 /* 18/120-18/129 */ ,
	65 /* 18/130-18/139 */ ,
	70 /* 18/140-18/149 */ ,
	75 /* 18/150-18/159 */ ,
	80 /* 18/160-18/169 */ ,
	85 /* 18/170-18/179 */ ,
	90 /* 18/180-18/189 */ ,
	95 /* 18/190-18/199 */ ,
	100 /* 18/200-18/209 */ ,
	100 /* 18/210-18/219 */ ,
	100							/* 18/220+ */
};

/*
 * Stat Table (STR) -- wrestling (# sides on die)
 */
byte adj_str_wr[] =
{
	1 /* 3 */ ,
	1 /* 4 */ ,
	1 /* 5 */ ,
	1 /* 6 */ ,
	1 /* 7 */ ,
	1 /* 8 */ ,
	1 /* 9 */ ,
	1 /* 10 */ ,
	1 /* 11 */ ,
	1 /* 12 */ ,
	1 /* 13 */ ,
	2 /* 14 */ ,
	2 /* 15 */ ,
	3 /* 16 */ ,
	4 /* 17 */ ,
	5 /* 18/00 - 18/09 */ ,
	6 /* 18/10-18/19 */ ,
	7 /* 18/20-18/29 */ ,
	8 /* 18/30-18/39 */ ,
	9 /* 18/40-18/49 */ ,
	10 /* 18/50-18/59 */ ,
	11 /* 18/60-18/69 */ ,
	12 /* 18/70-18/79 */ ,
	13 /* 18/80-18/89 */ ,
	14 /* 18/90-18/99 */ ,
	15 /* 18/100-18/109 */ ,
	16 /* 18/110-18/119 */ ,
	17 /* 18/120-18/129 */ ,
	18 /* 18/130-18/139 */ ,
	19 /* 18/140-18/149 */ ,
	21 /* 18/150-18/159 */ ,
	22 /* 18/160-18/169 */ ,
	23 /* 18/170-18/179 */ ,
	24 /* 18/180-18/189 */ ,
	25 /* 18/190-18/199 */ ,
	27 /* 18/200-18/209 */ ,
	28 /* 18/210-18/219 */ ,
	30							/* 18/220+ */
};

/*
 * Stat Table (STR) -- help index into the "blow" table
 */
byte adj_str_blow[] =
{
	3 /* 3 */ ,
	4 /* 4 */ ,
	5 /* 5 */ ,
	6 /* 6 */ ,
	7 /* 7 */ ,
	8 /* 8 */ ,
	9 /* 9 */ ,
	10 /* 10 */ ,
	11 /* 11 */ ,
	12 /* 12 */ ,
	13 /* 13 */ ,
	14 /* 14 */ ,
	15 /* 15 */ ,
	16 /* 16 */ ,
	17 /* 17 */ ,
	20 /* 18/00-18/09 */ ,
	30 /* 18/10-18/19 */ ,
	40 /* 18/20-18/29 */ ,
	50 /* 18/30-18/39 */ ,
	60 /* 18/40-18/49 */ ,
	70 /* 18/50-18/59 */ ,
	80 /* 18/60-18/69 */ ,
	90 /* 18/70-18/79 */ ,
	100 /* 18/80-18/89 */ ,
	110 /* 18/90-18/99 */ ,
	120 /* 18/100-18/109 */ ,
	130 /* 18/110-18/119 */ ,
	140 /* 18/120-18/129 */ ,
	150 /* 18/130-18/139 */ ,
	160 /* 18/140-18/149 */ ,
	170 /* 18/150-18/159 */ ,
	180 /* 18/160-18/169 */ ,
	190 /* 18/170-18/179 */ ,
	200 /* 18/180-18/189 */ ,
	210 /* 18/190-18/199 */ ,
	220 /* 18/200-18/209 */ ,
	230 /* 18/210-18/219 */ ,
	240							/* 18/220+ */
};


/*
 * Stat Table (DEX) -- index into the "blow" table
 */
byte adj_dex_blow[] =
{
	0 /* 3 */ ,
	0 /* 4 */ ,
	0 /* 5 */ ,
	0 /* 6 */ ,
	0 /* 7 */ ,
	0 /* 8 */ ,
	0 /* 9 */ ,
	1 /* 10 */ ,
	1 /* 11 */ ,
	1 /* 12 */ ,
	1 /* 13 */ ,
	1 /* 14 */ ,
	1 /* 15 */ ,
	1 /* 16 */ ,
	1 /* 17 */ ,
	1 /* 18/00-18/09 */ ,
	2 /* 18/10-18/19 */ ,
	2 /* 18/20-18/29 */ ,
	2 /* 18/30-18/39 */ ,
	2 /* 18/40-18/49 */ ,
	3 /* 18/50-18/59 */ ,
	3 /* 18/60-18/69 */ ,
	4 /* 18/70-18/79 */ ,
	4 /* 18/80-18/89 */ ,
	5 /* 18/90-18/99 */ ,
	6 /* 18/100-18/109 */ ,
	7 /* 18/110-18/119 */ ,
	8 /* 18/120-18/129 */ ,
	9 /* 18/130-18/139 */ ,
	10 /* 18/140-18/149 */ ,
	11 /* 18/150-18/159 */ ,
	12 /* 18/160-18/169 */ ,
	14 /* 18/170-18/179 */ ,
	16 /* 18/180-18/189 */ ,
	18 /* 18/190-18/199 */ ,
	20 /* 18/200-18/209 */ ,
	20 /* 18/210-18/219 */ ,
	20							/* 18/220+ */
};

/* Stat Table (DEX) -- number of blows/rounds when using karate */
byte adj_dex_kb[] =
{
	1 /* 3 */ ,
	1 /* 4 */ ,
	1 /* 5 */ ,
	1 /* 6 */ ,
	1 /* 7 */ ,
	1 /* 8 */ ,
	1 /* 9 */ ,
	1 /* 10 */ ,
	1 /* 11 */ ,
	1 /* 12 */ ,
	1 /* 13 */ ,
	1 /* 14 */ ,
	1 /* 15 */ ,
	1 /* 16 */ ,
	1 /* 17 */ ,
	1 /* 18/00-18/09 */ ,
	1 /* 18/10-18/19 */ ,
	2 /* 18/20-18/29 */ ,
	2 /* 18/30-18/39 */ ,
	2 /* 18/40-18/49 */ ,
	2 /* 18/50-18/59 */ ,
	2 /* 18/60-18/69 */ ,
	2 /* 18/70-18/79 */ ,
	3 /* 18/80-18/89 */ ,
	3 /* 18/90-18/99 */ ,
	3 /* 18/100-18/109 */ ,
	3 /* 18/110-18/119 */ ,
	3 /* 18/120-18/129 */ ,
	4 /* 18/130-18/139 */ ,
	4 /* 18/140-18/149 */ ,
	4 /* 18/150-18/159 */ ,
	4 /* 18/160-18/169 */ ,
	5 /* 18/170-18/179 */ ,
	5 /* 18/180-18/189 */ ,
	5 /* 18/190-18/199 */ ,
	6 /* 18/200-18/209 */ ,
	6 /* 18/210-18/219 */ ,
	7							/* 18/220+ */
};

/*
 * Stat Table (DEX) -- chance of avoiding "theft" and "falling"
 */
byte adj_dex_safe[] =
{
	0 /* 3 */ ,
	1 /* 4 */ ,
	2 /* 5 */ ,
	3 /* 6 */ ,
	4 /* 7 */ ,
	5 /* 8 */ ,
	5 /* 9 */ ,
	6 /* 10 */ ,
	6 /* 11 */ ,
	7 /* 12 */ ,
	7 /* 13 */ ,
	8 /* 14 */ ,
	8 /* 15 */ ,
	9 /* 16 */ ,
	9 /* 17 */ ,
	10 /* 18/00-18/09 */ ,
	10 /* 18/10-18/19 */ ,
	15 /* 18/20-18/29 */ ,
	15 /* 18/30-18/39 */ ,
	20 /* 18/40-18/49 */ ,
	25 /* 18/50-18/59 */ ,
	30 /* 18/60-18/69 */ ,
	35 /* 18/70-18/79 */ ,
	40 /* 18/80-18/89 */ ,
	45 /* 18/90-18/99 */ ,
	50 /* 18/100-18/109 */ ,
	60 /* 18/110-18/119 */ ,
	70 /* 18/120-18/129 */ ,
	80 /* 18/130-18/139 */ ,
	90 /* 18/140-18/149 */ ,
	100 /* 18/150-18/159 */ ,
	100 /* 18/160-18/169 */ ,
	100 /* 18/170-18/179 */ ,
	100 /* 18/180-18/189 */ ,
	100 /* 18/190-18/199 */ ,
	100 /* 18/200-18/209 */ ,
	100 /* 18/210-18/219 */ ,
	100							/* 18/220+ */
};


/*
 * Stat Table (CON) -- base regeneration rate
 */
byte adj_con_fix[] =
{
	0 /* 3 */ ,
	0 /* 4 */ ,
	0 /* 5 */ ,
	0 /* 6 */ ,
	0 /* 7 */ ,
	0 /* 8 */ ,
	0 /* 9 */ ,
	0 /* 10 */ ,
	0 /* 11 */ ,
	0 /* 12 */ ,
	0 /* 13 */ ,
	1 /* 14 */ ,
	1 /* 15 */ ,
	1 /* 16 */ ,
	1 /* 17 */ ,
	2 /* 18/00-18/09 */ ,
	2 /* 18/10-18/19 */ ,
	2 /* 18/20-18/29 */ ,
	2 /* 18/30-18/39 */ ,
	2 /* 18/40-18/49 */ ,
	3 /* 18/50-18/59 */ ,
	3 /* 18/60-18/69 */ ,
	3 /* 18/70-18/79 */ ,
	3 /* 18/80-18/89 */ ,
	3 /* 18/90-18/99 */ ,
	4 /* 18/100-18/109 */ ,
	4 /* 18/110-18/119 */ ,
	5 /* 18/120-18/129 */ ,
	6 /* 18/130-18/139 */ ,
	6 /* 18/140-18/149 */ ,
	7 /* 18/150-18/159 */ ,
	7 /* 18/160-18/169 */ ,
	8 /* 18/170-18/179 */ ,
	8 /* 18/180-18/189 */ ,
	8 /* 18/190-18/199 */ ,
	9 /* 18/200-18/209 */ ,
	9 /* 18/210-18/219 */ ,
	9							/* 18/220+ */
};


/*
 * Stat Table (CON) -- extra half-hitpoints per level (plus 128)
 */
byte adj_con_mhp[] =
{
	128 + -5 /* 3 */ ,
	128 + -3 /* 4 */ ,
	128 + -2 /* 5 */ ,
	128 + -1 /* 6 */ ,
	128 + 0 /* 7 */ ,
	128 + 0 /* 8 */ ,
	128 + 0 /* 9 */ ,
	128 + 0 /* 10 */ ,
	128 + 0 /* 11 */ ,
	128 + 0 /* 12 */ ,
	128 + 0 /* 13 */ ,
	128 + 0 /* 14 */ ,
	128 + 1 /* 15 */ ,
	128 + 1 /* 16 */ ,
	128 + 2 /* 17 */ ,
	128 + 3 /* 18/00-18/09 */ ,
	128 + 4 /* 18/10-18/19 */ ,
	128 + 4 /* 18/20-18/29 */ ,
	128 + 4 /* 18/30-18/39 */ ,
	128 + 4 /* 18/40-18/49 */ ,
	128 + 5 /* 18/50-18/59 */ ,
	128 + 6 /* 18/60-18/69 */ ,
	128 + 7 /* 18/70-18/79 */ ,
	128 + 8 /* 18/80-18/89 */ ,
	128 + 9 /* 18/90-18/99 */ ,
	128 + 10 /* 18/100-18/109 */ ,
	128 + 11 /* 18/110-18/119 */ ,
	128 + 12 /* 18/120-18/129 */ ,
	128 + 13 /* 18/130-18/139 */ ,
	128 + 14 /* 18/140-18/149 */ ,
	128 + 15 /* 18/150-18/159 */ ,
	128 + 16 /* 18/160-18/169 */ ,
	128 + 18 /* 18/170-18/179 */ ,
	128 + 20 /* 18/180-18/189 */ ,
	128 + 22 /* 18/190-18/199 */ ,
	128 + 25 /* 18/200-18/209 */ ,
	128 + 25 /* 18/210-18/219 */ ,
	128 + 25					/* 18/220+ */
};


/*
 * This table is used to help calculate the number of blows the player can
 * make in a single round of attacks (one player turn) with a normal weapon.
 *
 * This number ranges from a single blow/round for weak players to up to six
 * blows/round for powerful warriors.
 *
 * Note that certain artifacts and ego-items give "bonus" blows/round.
 *
 * First, from the player class, we extract some values:
 *
 *    Warrior --> num = 6; mul = 5; div = MAX(30, weapon_weight);
 *    Mage    --> num = 4; mul = 2; div = MAX(40, weapon_weight);
 *    Priest  --> num = 5; mul = 3; div = MAX(35, weapon_weight);
 *    Rogue   --> num = 5; mul = 3; div = MAX(30, weapon_weight);
 *    Ranger  --> num = 5; mul = 4; div = MAX(35, weapon_weight);
 *    Paladin --> num = 5; mul = 4; div = MAX(30, weapon_weight);
 *
 * To get "P", we look up the relevant "adj_str_blow[]" (see above),
 * multiply it by "mul", and then divide it by "div", rounding down.
 *
 * To get "D", we look up the relevant "adj_dex_blow[]" (see above),
 * note especially column 6 (DEX 18/101) and 11 (DEX 18/150).
 *
 * The player gets "blows_table[P][D]" blows/round, as shown below,
 * up to a maximum of "num" blows/round, plus any "bonus" blows/round.
 */
byte blows_table[12][12] =
{
	/* P/D */
	/* 0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11+ */

	/* 0  */
	{1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3},

	/* 1  */
	{1, 1, 1, 1, 2, 2, 3, 3, 3, 3, 4, 4},

	/* 2  */
	{1, 1, 1, 2, 2, 3, 3, 3, 4, 4, 4, 4},

	/* 3  */
	{1, 1, 2, 2, 3, 3, 4, 4, 4, 4, 4, 5},

	/* 4  */
	{1, 1, 2, 3, 3, 4, 4, 4, 4, 4, 5, 5},

	/* 5  */
	{1, 2, 2, 3, 3, 4, 4, 4, 4, 5, 5, 5},

	/* 6  */
	{2, 2, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5},

	/* 7  */
	{2, 2, 3, 3, 4, 4, 4, 5, 5, 5, 5, 5},

	/* 8  */
	{2, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 5},

	/* 9  */
	{3, 3, 3, 4, 4, 4, 5, 5, 5, 5, 5, 5},

	/* 10 */
	{3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5},

	/* 11+ */
	{3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5},
};


/*
 * Store owners (exactly four "possible" owners per store, chosen randomly)
 * { name, purse, max greed, min greed, haggle_per, tolerance, race, unused }
 */
owner_type owners[MAX_STORES][MAX_OWNERS] =
{
	{
		/* General store */
		{"Bilbo the Friendly", 200, 170, 108, 5, 15, RACE_HOBBIT},
		{"Rincewind the Chicken", 200, 175, 108, 4, 12, RACE_HUMAN},
		{"Sultan the Midget", 300, 170, 107, 5, 15, RACE_GNOME},
		{"Lyar-el the Comely", 300, 165, 107, 6, 18, RACE_ELF},
	},
	{
		/* Armoury */
		{"Kon-Dar the Ugly", 5000, 210, 115, 5, 7,
		 RACE_HALF_ORC},
		{"Darg-Low the Grim", 10000, 190, 111, 4, 9,
		 RACE_HUMAN},
		{"Decado the Handsome", 25000, 200, 112, 4, 10, RACE_DUNADAN},
		{"Mauglin the Grumpy", 30000, 200, 112, 4, 5,
		 RACE_DWARF},
	},
	{
		/* Weapon Smith */
		{"Ithyl-Mak the Beastly", 5000, 210, 115, 6, 6,
		 RACE_HALF_TROLL},
		{"Arndal Beast-Slayer", 10000, 185, 110, 5, 9,
		 RACE_HALF_ELF},
		{"Tarl Beast-Master", 25000, 190, 115, 5, 7,
		 RACE_HOBBIT},
		{"Oglign Dragon-Slayer", 30000, 195, 112, 4, 8,
		 RACE_DWARF},
	},
	{
		/* Temple */
		{"Ludwig the Humble", 5000, 175, 109, 6, 15,
		 RACE_HUMAN},
		{"Gunnar the Paladin", 10000, 185, 110, 5, 23,
		 RACE_HUMAN},
		{"Delilah the Pure", 25000, 180, 107, 6, 20,
		 RACE_ELF},
		{"Bosk the Wise", 30000, 185, 109, 5, 15,
		 RACE_DWARF},
	},
	{
		{"Mauser the Chemist", 10000, 190, 111, 5, 8,
		 RACE_HALF_ELF},
		{"Wizzle the Chaotic", 10000, 190, 110, 6, 8,
		 RACE_HOBBIT},
		{"Ga-nat the Greedy", 15000, 200, 116, 6, 9,
		 RACE_GNOME},
		{"Sasha the Slender", 15000, 220, 111, 4, 9,
		 RACE_ELF},
	},
	{
		/* Magic Shop */
		{"Ariel the Sorceress", 20000, 200, 110, 7, 8,
		 RACE_HALF_ELF},
		{"Buggerby the Great", 20000, 215, 113, 6, 10,
		 RACE_GNOME},
		{"Inglorian the Mage", 30000, 200, 110, 7, 10,
		 RACE_HUMAN},
		{"Luthien Starshine", 30000, 175, 110, 5, 11,
		 RACE_HIGH_ELF},
	},
	{
		/* Black Market */
		{"Lo-Hak the Awful", 20000, 250, 150, 10, 5,
		 RACE_HALF_TROLL},
		{"Histor the Goblin", 20000, 250, 150, 10, 5,
		 RACE_HALF_ORC},
		{"Durwin the Shifty", 30000, 250, 150, 10, 5,
		 RACE_HUMAN},
		{"Drago the Fair", 30000, 250, 150, 10, 5,
		 RACE_ELF},
	},
	{
		/* Home */
		{"Your home", 0, 100, 100, 0, 99, 99},
		{"Your home", 0, 100, 100, 0, 99, 99},
		{"Your home", 0, 100, 100, 0, 99, 99},
		{"Your home", 0, 100, 100, 0, 99, 99}
	},
	{
		/* Bookstore */
		{"Dolaf the Greedy", 10000, 175, 108, 4, 12, RACE_HUMAN},
		{"Odnar the Sage", 15000, 120, 105, 6, 16, RACE_HIGH_ELF},
		{"Gandar the Neutral", 25000, 120, 110, 7, 19, RACE_DARK_ELF},
		{"Ro-sha the Patient", 30000, 140, 105, 6, 12, RACE_ELF},
	}
};




/*
 * This table allows quick conversion from "speed" to "energy"
 * The basic function WAS ((S>=110) ? (S-110) : (100 / (120-S)))
 * Note that table access is *much* quicker than computation.
 *
 * Note that the table has been changed at high speeds.  From
 * "Slow (-40)" to "Fast (+30)" is pretty much unchanged, but
 * at speeds above "Fast (+30)", one approaches an asymptotic
 * effective limit of 50 energy per turn.  This means that it
 * is relatively easy to reach "Fast (+30)" and get about 40
 * energy per turn, but then speed becomes very "expensive",
 * and you must get all the way to "Fast (+50)" to reach the
 * point of getting 45 energy per turn.  After that point,
 * furthur increases in speed are more or less pointless,
 * except to balance out heavy inventory.
 *
 * Note that currently the fastest monster is "Fast (+30)".
 *
 * It should be possible to lower the energy threshhold from
 * 100 units to 50 units, though this may interact badly with
 * the (compiled out) small random energy boost code.  It may
 * also tend to cause more "clumping" at high speeds.
 */
byte extract_energy[200] =
{
	/* Slow */ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	/* Slow */ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	/* Slow */ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	/* Slow */ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	/* Slow */ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	/* Slow */ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	/* S-50 */ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	/* S-40 */ 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
	/* S-30 */ 2, 2, 2, 2, 2, 2, 2, 3, 3, 3,
	/* S-20 */ 3, 3, 3, 3, 3, 4, 4, 4, 4, 4,
	/* S-10 */ 5, 5, 5, 5, 6, 6, 7, 7, 8, 9,
	/* Norm */ 10, 11, 12, 13, 14, 15, 16, 17, 18, 19,
	/* F+10 */ 20, 21, 22, 23, 24, 25, 26, 27, 28, 29,
	/* F+20 */ 30, 31, 32, 33, 34, 35, 36, 36, 37, 37,
	/* F+30 */ 38, 38, 39, 39, 40, 40, 40, 41, 41, 41,
	/* F+40 */ 42, 42, 42, 43, 43, 43, 44, 44, 44, 44,
	/* F+50 */ 45, 45, 45, 45, 45, 46, 46, 46, 46, 46,
	/* F+60 */ 47, 47, 47, 47, 47, 48, 48, 48, 48, 48,
	/* F+70 */ 49, 49, 49, 49, 49, 49, 49, 49, 49, 49,
	/* Fast */ 49, 49, 49, 49, 49, 49, 49, 49, 49, 49,
};



/*
 * Player Sexes
 *
 *  Title,
 *  Winner
 */
player_sex sex_info[MAX_SEXES] =
{
	{
		"Female",
		"Queen"
	},

	{
		"Male",
		"King"
	}
};


/*
 * Player Races
 *
 *    Title,
 *    {STR,INT,WIS,DEX,CON,CHR,LUC},
 *    r_thn, r_thb,
 *    hitdie, life exp,
 *    Age (Base, Mod),
 *    Male (Hgt, Wgt),
 *    Female (Hgt, Wgt)
 *    infra,
 *    { skill advancement speeds },
 *    { skill starting values }
 */
player_race race_info[MAX_RACES] =
{
	{
		"Human",
		{0, 0, 0, 0, 0, 0, 4},
		0, 0,
		15, 38,
		14, 6,
		72, 6, 180, 25,
		66, 4, 150, 20,
		0,
		{7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
		 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 1, 1, 1, 1},
		{12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,
		 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 1, 1, 1, 1}
	},

	{
		"Half-Elf",
		{-1, 1, 0, 1, -1, 1, 0},
		-1, 5,
		14, 20,
		24, 16,
		66, 6, 130, 15,
		62, 6, 100, 10,
		2,
		{6, 5, 5, 5, 7, 7, 8, 7, 8, 7, 8, 8, 5, 7, 6,
		 8, 8, 7, 8, 8, 8, 6, 4, 7, 6, 8, 1, 1, 1, 1},
		{18, 13, 12, 13, 18, 18, 18, 19, 19, 19, 18, 18, 7, 13, 19,
		 18, 18, 13, 7, 7, 7, 13, 7, 18, 19, 18, 1, 1, 1, 1}
	},

	{
		"Elf",
		{-1, 2, 1, 1, -2, 1, -1},
		-5, 15,
		13, 18,
		75, 75,
		60, 4, 100, 6,
		54, 4, 80, 6,
		3,
		{4, 3, 5, 3, 8, 8, 8, 8, 8, 7, 9, 8, 4, 7, 4,
		 7, 9, 7, 7, 8, 8, 7, 2, 7, 4, 9, 1, 1, 1, 1},
		{32, 7, 18, 7, 18, 18, 24, 18, 13, 13, 23, 23, 7, 18, 18,
		 18, 30, 18, 7, 7, 7, 19, 7, 25, 13, 25, 1, 1, 1, 1}
	},

	{
		"Hobbit",
		{-2, 2, 1, 3, 2, 1, 2},
		-10, 20,
		12, 18,
		21, 12,
		36, 3, 60, 3,
		33, 3, 50, 3,
		4,
		{3, 3, 8, 8, 10, 4, 6, 10, 10, 6, 10, 7, 6, 10, 10,
		 6, 6, 10, 7, 7, 7, 8, 4, 10, 8, 5, 1, 1, 1, 1},
		{8, 8, 19, 13, 30, 13, 13, 19, 19, 13, 37, 13, 7, 30, 30,
		 13, 13, 25, 7, 13, 13, 13, 7, 30, 18, 13, 1, 1, 1, 1}
	},

	{
		"Gnome",
		{-1, 2, 0, 2, 1, -2, 3},
		-8, 12,
		13, 17,
		50, 40,
		42, 3, 90, 6,
		39, 3, 75, 3,
		4,
		{3, 3, 7, 3, 7, 7, 7, 8, 7, 7, 7, 7, 3, 8, 7,
		 3, 3, 7, 8, 8, 8, 7, 3, 7, 9, 7, 1, 1, 1, 1},
		{13, 13, 18, 13, 32, 25, 18, 18, 18, 18, 30, 18, 13, 25, 25,
		 13, 13, 25, 13, 13, 13, 19, 13, 18, 18, 19, 1, 1, 1, 1}
	},

	{
		"Dwarf",
		{2, -3, 2, -2, 2, -3, 0},
		15, 0,
		16, 20,
		35, 15,
		48, 3, 150, 10,
		46, 3, 120, 10,
		5,
		{8, 8, 6, 8, 6, 6, 7, 7, 4, 4, 4, 7, 4, 4, 4,
		 10, 8, 4, 9, 9, 9, 8, 9, 4, 3, 6, 1, 1, 1, 1},
		{18, 18, 13, 18, 13, 13, 13, 18, 13, 13, 7, 13, 8, 7, 7,
		 30, 25, 13, 13, 13, 19, 13, 18, 13, 7, 13, 1, 1, 1, 1}
	},

	{
		"Half-Orc",
		{2, -1, 0, 0, 1, -4, -1},
		12, -5,
		15, 21,
		11, 4,
		66, 1, 150, 5,
		62, 1, 120, 5,
		3,
		{10, 8, 8, 9, 4, 4, 4, 4, 3, 3, 3, 4, 3, 3, 4,
		 8, 8, 3, 4, 7, 7, 7, 6, 7, 4, 4, 4, 1, 1, 1},
		{37, 30, 7, 32, 7, 13, 13, 13, 7, 13, 7, 13, 8, 7, 7,
		 18, 18, 7, 13, 13, 13, 7, 30, 7, 13, 7, 1, 1, 1, 1}
	},

	{
		"Half-Troll",
		{4, -4, -2, -4, 3, -6, -2},
		20, -10,
		18, 19,
		20, 10,
		96, 10, 250, 50,
		84, 8, 225, 40,
		3,
		{9, 10, 4, 10, 4, 4, 4, 6, 4, 4, 4, 6, 4, 4, 4,
		 6, 6, 4, 4, 9, 8, 8, 8, 8, 7, 4, 3, 1, 1, 1},
		{30, 42, 7, 42, 7, 13, 13, 7, 7, 19, 8, 7, 8, 7, 8,
		 13, 13, 8, 13, 13, 13, 8, 42, 8, 7, 8, 1, 1, 1, 1}
	},
	{
		"Dunadan",
		{1, 2, 2, 2, 3, 2, 1},
		15, 10,
		15, 38,
		50, 20,
		82, 5, 190, 20,
		78, 6, 180, 15,
		0,
		{4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
		 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4},
		{30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 13, 30, 30,
		 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 1, 1, 1, 1}
	},

	{
		"High-Elf",
		{1, 3, -1, 3, 1, 5, 2},
		10, 25,
		15, 36,
		100, 30,
		90, 10, 190, 20,
		82, 10, 180, 15,
		4,
		{5, 4, 4, 4, 5, 5, 5, 5, 4, 4, 4, 4, 5, 5, 4,
		 5, 5, 4, 4, 7, 7, 6, 3, 3, 5, 5, 1, 1, 1, 1},
		{30, 30, 30, 32, 37, 30, 30, 30, 30, 30, 30, 30, 16, 37, 37,
		 42, 42, 30, 30, 30, 30, 30, 18, 37, 30, 42, 1, 1, 1, 1}
	},

	{
		"Dark-Elf",
		{-1, 3, 0, 2, -3, -2, -1},
		0, 10,
		13, 18,
		80, 150,
		40, 10, 90, 20,
		35, 15, 70, 10,
		6,
		{8, 2, 6, 3, 8, 9, 10, 10, 6, 8, 8, 10, 10, 6, 3,
		 2, 2, 9, 2, 8, 8, 8, 2, 4, 7, 10, 1, 1, 1, 1},
		{32, 7, 13, 8, 25, 37, 30, 30, 18, 18, 18, 32, 37, 19, 25,
		 13, 13, 18, 8, 13, 7, 13, 8, 18, 13, 30, 1, 1, 1, 1}
	},

	{
		"Giant",
		{2, -1, 2, -3, 4, -2, 1},
		20, -10,
		20, 21,
		20, 10,
		120, 70, 255, 50,
		114, 12, 255, 40,
		2,
		{7, 10, 3, 10, 3, 6, 5, 5, 3, 3, 3, 5, 9, 3, 3,
		 6, 6, 3, 3, 10, 8, 8, 10, 4, 3, 5, 1, 1, 1, 1},
		{18, 36, 13, 42, 8, 25, 18, 7, 8, 8, 13, 18, 25, 8, 8,
		 13, 13, 7, 13, 13, 13, 7, 37, 7, 8, 13, 1, 1, 1, 1}
	}
};


/*
 * Hack -- the spell information table.
 *
 *   Realm Name
 *   Spell Book
 *   Spell Stat,
 *   Spell Encumbrance,
 * Skill required.
 *   Array of { Lev, Mana, Fail, Exp }
 */
player_magic magic_info[MAX_REALM + 1] =
{
/*** None (warrior?) ***/
	{
		"Warrior",
		0,
		0,
		0,
		0,
		{
			{99, 0, 0, 0},
			{99, 0, 0, 0},
			{99, 0, 0, 0},
			{99, 0, 0, 0},
			{99, 0, 0, 0},
			{99, 0, 0, 0},
			{99, 0, 0, 0},
			{99, 0, 0, 0},
			{99, 0, 0, 0},

			{99, 0, 0, 0},
			{99, 0, 0, 0},
			{99, 0, 0, 0},
			{99, 0, 0, 0},
			{99, 0, 0, 0},
			{99, 0, 0, 0},
			{99, 0, 0, 0},
			{99, 0, 0, 0},
			{99, 0, 0, 0},
			{99, 0, 0, 0},
			{99, 0, 0, 0},
			{99, 0, 0, 0},
			{99, 0, 0, 0},
			{99, 0, 0, 0},
			{99, 0, 0, 0},
			{99, 0, 0, 0},
			{99, 0, 0, 0},

			{99, 0, 0, 0},
			{99, 0, 0, 0},
			{99, 0, 0, 0},
			{99, 0, 0, 0},
			{99, 0, 0, 0},
			{99, 0, 0, 0},
			{99, 0, 0, 0},

			{99, 0, 0, 0},
			{99, 0, 0, 0},
			{99, 0, 0, 0},
			{99, 0, 0, 0},
			{99, 0, 0, 0},

			{99, 0, 0, 0},
			{99, 0, 0, 0},
			{99, 0, 0, 0},
			{99, 0, 0, 0},
			{99, 0, 0, 0},
			{99, 0, 0, 0},

			{99, 0, 0, 0},
			{99, 0, 0, 0},
			{99, 0, 0, 0},
			{99, 0, 0, 0},
			{99, 0, 0, 0},

			{99, 0, 0, 0},
			{99, 0, 0, 0},
			{99, 0, 0, 0},
			{99, 0, 0, 0},
			{99, 0, 0, 0},

			{99, 0, 0, 0},
			{99, 0, 0, 0},
			{99, 0, 0, 0},
			{99, 0, 0, 0},
			{99, 0, 0, 0},

			{99, 0, 0, 0},
			{99, 0, 0, 0},
			{99, 0, 0, 0},
			{99, 0, 0, 0},
			{99, 0, 0, 0}
		}
	},

	{
/*** Wizard ***/

		"Wizard",
		TV_MAGIC_BOOK,
		A_INT,
		300,
		S_PRECOG,
		{
		  /* Magic for Beginners (sval 0) */
			{1, 1, 22, 1},
			{1, 1, 23, 1},
			{1, 2, 24, 1},
			{3, 2, 25, 1},
			{3, 2, 26, 1},
			{3, 2, 26, 2},
			{3, 2, 27, 2},
			{3, 2, 28, 2},
			{3, 3, 29, 2},

		  /* Conjurings and Tricks (sval 1) */
			{5, 3, 30, 3},
			{5, 3, 31, 3},
			{9, 5, 35, 4},
			{9, 4, 33, 5},
			{11, 4, 35, 6},
			{11, 5, 35, 7},
			{13, 6, 35, 9},
			{15, 6, 42, 12},

		  /* Incantations and Illusions (sval 2) */
			{17, 6, 45, 14},
			{19, 6, 75, 16},
			{21, 7, 45, 18},
			{23, 7, 45, 20},
			{25, 7, 75, 22},
			{27, 7, 45, 20},
			{29, 7, 45, 22},
			{31, 9, 50, 28},

		  /* Sorcery and Evocations (sval 3) */
			{33, 10, 55, 30},
			{35, 11, 90, 32},
			{37, 12, 60, 34},
			{39, 14, 65, 36},
			{41, 16, 65, 38},
			{43, 18, 70, 50},
			{45, 28, 85, 55},

		  /* Resistance of Scarabtarices (sval 4) */
			{12, 5, 50, 50},
			{12, 5, 50, 50},
			{12, 5, 50, 50},
			{18, 10, 75, 100},
			{25, 20, 85, 400},

		  /* Mordenkainen's Escapes (sval 5) */
			{15, 7, 20, 25},
			{20, 12, 40, 50},
			{23, 15, 45, 75},
			{25, 15, 50, 100},
			{30, 20, 60, 140},

		  /* Kelek's Grimoire of Power (sval 6) */
			{5, 5, 30, 5},
			{15, 5, 50, 10},
			{20, 10, 70, 50},
			{25, 30, 95, 200},
			{35, 50, 70, 300},
			{40, 75, 80, 500},

		  /* Tenser's transformations... (sval 7) */
			{25, 5, 50, 100},
			{30, 12, 75, 200},
			{35, 20, 80, 400},
			{40, 30, 50, 800},
			{45, 60, 75, 2000},

		  /* Raal's Tome of Destruction (sval 8) */
			{15, 5, 35, 50},
			{30, 20, 55, 100},
			{35, 25, 50, 120},
			{37, 27, 55, 120},
			{39, 29, 60, 120},
			{41, 31, 65, 120},
			{45, 45, 85, 1000},

			{99, 0, 0, 0},
			{99, 0, 0, 0},
			{99, 0, 0, 0},
			{99, 0, 0, 0}
		}
	},

	{
/*** Priest ***/
		"Priest",
		TV_PRAYER_BOOK,
		A_WIS,
		350,
		S_SLAY_EVIL,
		{
		  /* Beginners Handbook (sval 0) */
			{1, 1, 10, 1},
			{1, 2, 15, 1},
			{1, 2, 20, 1},
			{3, 2, 25, 1},
			{3, 2, 25, 1},
			{3, 3, 27, 2},
			{3, 4, 27, 2},
			{5, 3, 28, 3},

		  /* Words of Wisdom (sval 1) */
			{5, 4, 29, 4},
			{5, 4, 30, 5},
			{7, 4, 32, 5},
			{7, 5, 34, 5},
			{9, 5, 38, 7},
			{9, 6, 38, 9},
			{11, 7, 38, 9},
			{11, 8, 38, 10},

		  /* Chants and Blessings (sval 2) */
			{13, 9, 48, 10},
			{13, 7, 40, 10},
			{15, 8, 42, 10},
			{17, 8, 42, 12},
			{19, 9, 55, 15},
			{21, 10, 45, 15},
			{23, 11, 45, 16},
			{25, 12, 50, 20},

		  /* Exorcism and Dispelling (sval 3) */
			{25, 12, 50, 21},
			{27, 14, 50, 22},
			{29, 14, 55, 32},
			{31, 16, 60, 38},
			{33, 20, 70, 45},
			{39, 55, 90, 55},
			{45, 32, 85, 60},

		  /* Ethereal openings (sval 4) */
			{20, 3, 40, 5},
			{30, 10, 50, 20},
			{36, 20, 70, 80},
			{36, 20, 60, 80},
			{39, 40, 75, 400},
			{45, 60, 75, 1000},

		  /* Godly Insights... (sval 5) */
			{30, 10, 50, 10},
			{33, 20, 60, 50},
			{36, 40, 70, 100},
			{43, 50, 80, 300},
			{45, 70, 90, 500},

		  /* Purifications and Healing (sval 6) */
			{27, 13, 55, 60},
			{30, 25, 58, 100},
			{38, 20, 60, 150},
			{41, 50, 70, 500},
			{43, 60, 80, 800},
			{45, 20, 70, 1000},

		  /* Holy Infusions (sval 7) */
			{31, 6, 50, 50},
			{33, 10, 55, 100},
			{37, 30, 65, 200},
			{40, 40, 70, 300},
			{43, 50, 75, 800},

		  /* Wrath of God (sval 8) */
			{37, 28, 60, 100},
			{39, 30, 65, 200},
			{41, 31, 70, 300},
			{43, 33, 75, 500},
			{45, 45, 80, 700},

			{99, 0, 0, 0},
			{99, 0, 0, 0},
			{99, 0, 0, 0},
			{99, 0, 0, 0},
			{99, 0, 0, 0},
			{99, 0, 0, 0}
		}
	},

	{
/*** Druid ***/
		"Druid",
		TV_NATURE_BOOK,
		A_WIS,
		300,
		S_SLAY_ANIMAL,
		{
		  /* Natural Understandings (sval 0) */
			{1, 1, 15, 1},
			{1, 1, 17, 1},
			{1, 1, 19, 1},
			{1, 2, 21, 1},
			{3, 2, 23, 1},
			{3, 2, 25, 2},
			{3, 3, 27, 2},
			{3, 3, 29, 3},

		  /* Communion with Nature (sval 1) */
			{5, 4, 33, 4},
			{7, 4, 35, 5},
			{9, 5, 37, 6},
			{11, 6, 45, 7},
			{13, 7, 48, 8},
			{15, 9, 50, 9},
			{15, 8, 52, 10},
			{17, 9, 55, 12},

		  /* Gifts of Nature (sval 2) */
			{19, 20, 60, 14},
			{23, 13, 62, 16},
			{27, 15, 65, 19},
			{29, 25, 68, 22},
			{31, 18, 70, 25},
			{33, 30, 72, 30},

		  /* Book of Combat (sval 3) */
			{17, 10, 47, 11},
			{18, 11, 49, 12},
			{19, 12, 51, 13},
			{20, 13, 53, 14},
			{21, 14, 55, 15},
			{33, 17, 63, 25},
			{35, 18, 65, 28},
			{37, 19, 67, 31},
			{39, 20, 69, 34},

		  /* Shapeshifting (sval 4) */
			{25, 25, 60, 500},
			{35, 30, 65, 750},
			{39, 35, 70, 1000},
			{43, 40, 75, 1250},
			{47, 50, 80, 1750},

		  /* Dungeon Insights (sval 5) */
			{15, 10, 50, 85},
			{30, 25, 75, 135},
			{33, 20, 60, 200},
			{36, 30, 65, 300},
			{42, 50, 70, 700},

		  /* Primal Forces (sval 6) */
			{29, 15, 50, 75},
			{32, 18, 57, 150},
			{36, 22, 64, 200},
			{40, 25, 71, 250},
			{45, 60, 85, 1000},

		  /* Weather Control (sval 7) */
			{32, 19, 60, 200},
			{36, 25, 40, 200},
			{36, 25, 40, 200},
			{38, 28, 50, 300},
			{38, 28, 50, 300},
			{40, 31, 60, 400},
			{40, 31, 60, 400},

		  /* Elemental Mastery (sval 8) */
			{40, 26, 72, 200},
			{41, 28, 73, 220},
			{42, 30, 74, 240},
			{43, 32, 75, 260},
			{44, 34, 76, 280},

			{99, 0, 0, 0},
			{99, 0, 0, 0},
			{99, 0, 0, 0},
			{99, 0, 0, 0},
			{99, 0, 0, 0},
			{99, 0, 0, 0}
		}
	},

	{
/*** Necros ***/
		"Necromancer",
		TV_DARK_BOOK,
		A_CHR,
		300,
		S_SLAY_UNDEAD,
		{
		  /* Beginner's Curses (sval 0) */
			{1, 1, 20, 1},
			{1, 2, 22, 1},
			{3, 2, 24, 2},
			{3, 2, 26, 2},
			{3, 3, 28, 2},
			{3, 3, 30, 3},
			{3, 3, 32, 2},
			{5, 5, 40, 5},

		  /* Darker Elements (sval 1) */
			{5, 4, 41, 3},
			{7, 5, 42, 3},
			{7, 6, 43, 4},
			{9, 6, 44, 5},
			{9, 8, 45, 5},
			{11, 9, 46, 7},
			{13, 11, 50, 9},
			{15, 15, 55, 11},

		  /* Frightful Realms (sval 2) */
			{15, 12, 52, 13},
			{17, 14, 55, 15},
			{17, 13, 63, 16},
			{19, 14, 58, 18},
			{21, 15, 65, 20},
			{23, 16, 61, 22},
			{25, 17, 65, 24},
			{27, 19, 63, 26},

		  /* Controlling Life (sval 3) */
			{29, 19, 65, 28},
			{31, 21, 67, 30},
			{33, 23, 69, 32},
			{34, 25, 71, 34},
			{35, 27, 73, 36},
			{37, 29, 75, 38},
			{39, 31, 77, 40},
			{45, 38, 85, 50},

		  /* Spirit Mastery (sval 4) */
			{20, 9, 50, 50},
			{34, 18, 55, 125},
			{38, 20, 60, 175},
			{41, 25, 65, 200},
			{44, 30, 70, 400},

		  /* Protection from Undead (sval 5) */
			{32, 20, 50, 150},
			{35, 30, 60, 300},
			{42, 45, 75, 450},
			{44, 50, 80, 700},

		  /* Unholy Perceptions (sval 6) */
			{5, 4, 35, 10},
			{25, 30, 60, 100},
			{25, 30, 60, 100},
			{35, 35, 70, 300},
			{45, 45, 90, 1000},

		  /* Mastery of Life Force (sval 7) */
			{32, 20, 60, 100},
			{40, 25, 70, 200},
			{42, 30, 75, 350},
			{44, 35, 85, 500},
			{46, 40, 95, 800},

		  /* Bodily Infusions (sval 8) */
			{25, 25, 55, 80},
			{30, 30, 60, 300},
			{35, 35, 65, 600},
			{40, 40, 70, 1000},
			{43, 80, 75, 2000},

			{99, 0, 0, 0},
			{99, 0, 0, 0},
			{99, 0, 0, 0},
			{99, 0, 0, 0},
			{99, 0, 0, 0},
			{99, 0, 0, 0},
			{99, 0, 0, 0},
			{99, 0, 0, 0}
		}
	}
};


/*
 * Spells in each book (mage spells then priest spells)
 */
u32b spell_flags[4][9][2] =
{
	{
/*** Mage spell books ***/
		{0x000001ff, 0x00000000},
		{0x0001fe00, 0x00000000},
		{0x01fe0000, 0x00000000},
		{0xfe000000, 0x00000000},
		{0x00000000, 0x0000001f},
		{0x00000000, 0x000003e0},
		{0x00000000, 0x0000fc00},
		{0x00000000, 0x001f0000},
		{0x00000000, 0x0fe00000}
	},

	{
/*** Priest spell books ***/
		{0x000000ff, 0x00000000},
		{0x0000ff00, 0x00000000},
		{0x00ff0000, 0x00000000},
		{0x7f000000, 0x00000000},
		{0x80000000, 0x0000001f},
		{0x00000000, 0x000003e0},
		{0x00000000, 0x0000fc00},
		{0x00000000, 0x001f0000},
		{0x00000000, 0x03e00000}
	},

	{
/*** Druid spell books ***/
		{0x000000ff, 0x00000000},
		{0x0000ff00, 0x00000000},
		{0x003f0000, 0x00000000},
		{0x7fc00000, 0x00000000},
		{0x80000000, 0x0000000f},
		{0x00000000, 0x000001f0},
		{0x00000000, 0x00003e00},
		{0x00000000, 0x001fc000},
		{0x00000000, 0x03e00000}
	},

	{
/*** Necro spell books */
		{0x000000ff, 0x00000000},
		{0x0000ff00, 0x00000000},
		{0x00ff0000, 0x00000000},
		{0xff000000, 0x00000000},
		{0x00000000, 0x0000001f},
		{0x00000000, 0x000001e0},
		{0x00000000, 0x00003e00},
		{0x00000000, 0x0007c000},
		{0x00000000, 0x00f80000}
	}
};


/*
 * Names of the spells (mage spells then priest spells)
 */
cptr spell_names[4][64] =
{
/*** Mage Spells ***/

	{
	/* Magic for Beginners (sval 0) */
		"Magic Missile",
		"Detect Monsters",
		"Phase Door",
		"Light Area",
		"Treasure/Object Detection",
		"Find Hidden Traps/Doors",
		"Fetch Object",
		"Bar Door",
		"Stinking Cloud",

/* Conjurings and Tricks (sval 1) */
		"Induce Terror",
		"Lightning Bolt",
		"Mana Burst",
		"Sleep I",
		"Cure Poison",
		"Teleport Self",
		"Frost Bolt",
		"Turn Stone to Mud",

/* Incantations and Illusions (sval 2) */
		"Sustenance",
		"Recharge Item I",
		"Sleep II",
		"Polymorph Other",
		"Identify",
		"Lightning Ball",
		"Fire Bolt",
		"Slow Monster",

/* Sorcery and Evocations (sval 3) */
		"Frost Ball",
		"Recharge Item II",
		"Teleport Other",
		"Haste Self",
		"Fire Ball",
		"Word of Destruction",
		"Elemental Strike",

	/* Resistance of Scarabtarices (sval 4) */
		"Resist Fire",
		"Resist Cold",
		"Resist Acid",
		"Resist Poison",
		"Resistance",

	/* Mordenkainen's Escapes (sval 5) */
		"Door Creation",
		"Stair Creation",
		"Invisibility",
		"Teleport Level",
		"Word of Recall",

	/* Kelek's Grimoire of Power (sval 6) */
		"Recover Strength",
		"Detect Evil",
		"Detect Enchantment",
		"Recharge Item III",
		"Genocide",
		"Mass Genocide",

/* Tenser's transformations... (sval 7) */
		"Heroism",
		"Shield",
		"Berserker",
		"Essence of Speed",
		"Globe of Resilience",

	/* Raal's Tome of Destruction (sval 8) */
		"Acid Bolt",
		"Ray of Power",
		"Sonic Storm",
		"Acid Ball",
		"Plasma Vortex",
		"Chaos Vortex",
		"Mana Storm",

		"(blank)",
		"(blank)",
		"(blank)",
		"(blank)"
	},


/*** Priest Spells ***/
	{
	  /* Beginners Handbook (sval 0) */
		"Detect Evil",
		"Cure Light Wounds",
		"Bless",
		"Remove Fear",
		"Radiance",
		"Find Doors/Traps",
		"Spiritual Hammer",
		"Dispel Poison",

/* Words of Wisdom (sval 1) */
		"Induce Peace",
		"Portal",
		"Cure Medium Wounds",
		"Chant",
		"Sustenance",
		"Remove Curse",
		"Resist Heat and Cold",
		"Sense Invisible",

/* Chants and Blessings (sval 2) */
		"Orb of Draining",
		"Cure Serious Wounds",
		"Concealment",
		"Protection from Evil",
		"Earthquake",
		"Sense Surroundings",
		"Cure Critical Wounds",
		"Turn Undead",

/* Exorcism and Dispelling (sval 3) */
		"Unbarring Ways",
		"Banish Evil",
		"Dispel Undead",
		"Heal",
		"Dispel Evil",
		"Glyph of Warding",
		"Holy Word",

	  /* Ethereal openings (sval 4) */
		"Blink",
		"Teleport",
		"Teleport Away",
		"Word of Recall",
		"Teleport Level",
		"Alter Reality",

/* Godly Insights... (sval 5) */
		"Detection",
		"Perception",
		"Probing",
		"Clairvoyance",
		"Self-Knowledge",

	  /* Purifications and Healing (sval 6) */
		"Cure Mortal Wounds",
		"Return to the Center",
		"Holy Shield",
		"Restoration",
		"Remembrance",
		"True Healing",

/* Holy Infusions (sval 7) */
		"Recharging",
		"Dispel Curse",
		"Enchant Weapon",
		"Enchant Armour",
		"Elemental Brand",

	  /* Wrath of God (sval 8) */
		"Dispel Evil",
		"Smite Evil",
		"Banishment",
		"Word of Destruction",
		"Annihilation",

		"(blank)",
		"(blank)",
		"(blank)",
		"(blank)",
		"(blank)",
		"(blank)"
	},
/*** Druid spells ***/
	{
	  /* Natural Understandings (sval 0) */
		"Sense Life",
		"Sense Weather",
		"Nature's Blessing",
		"Remove Fear",
		"Call Sunlight",
		"Find Traps/Doors",
		"Minor Healing",
		"Dispel Poison",

/* Communion with Nature (sval 1) */
		"Induce Peace",
		"Regeneration",
		"Banish Animals",
		"Sustain Self",
		"Spear of Light",
		"Pass Through Stone",
		"Sense Area",
		"Major Healing",

/* Gifts of Nature (sval 2) */
		"Form of the Sheep",
		"Regain Harmony",
		"Calm Weather",
		"Form of the Goat",
		"Resist Elements",
		"Form of the Wolverine",

/* Book of Combat (sval 3) */
		"Putrid Vapors",
		"Chain Lightning",
		"Icy Spear",
		"Heat Wave",
		"Gust of Wind",
		"Blizzard",
		"Burning Fog",
		"Thunderstorm",
		"Sickening Mists",

	  /* Shapeshifting (sval 4) */
		"Form of the Bear",
		"Form of the Lion",
		"Form of the Gazelle",
		"Form of the Cheetah",
		"Form of the Dragon",

	  /* Dungeon Insights (sval 5) */
		"Find Material Goods",
		"Understand Item",
		"Probing",
		"Magical Staircase",
		"Know Dungeon",

	  /* Primal Forces (sval 6) */
		"Silence of the Lamb",
		"Heart of the Lion",
		"Shell of the Tortiose",
		"Mists of Tranquility",
		"Cyclone",

	  /* Weather Control (sval 7) */
		"Hold Weather",
		"Drought",
		"Deluge",
		"Wind Songs",
		"Still Winds",
		"Summer's Gaze",
		"Winter's Grip",

	  /* Elemental Mastery (sval 8) */
		"Essence of Flame",
		"Absolute Zero",
		"Lethal Plague",
		"Hurricane",
		"Thunder Strike",

		"(blank)",
		"(blank)",
		"(blank)",
		"(blank)",
		"(blank)",
		"(blank)"
	},

/*** Necro spells ***/
	{
	  /* Beginner's Curses (sval 0) */
		"Sense Undead",
		"Eyes of the Night",
		"Cloud Mind",
		"Find Doors/Traps",
		"Slow Poison",
		"Door of Shadows",
		"Sleep of the Grave",
		"Undo Curse",

/* Darker Elements (sval 1) */
		"Soul Food",
		"Resistance of the Dead",
		"Slow Undead",
		"Destroy Undead",
		"Shadow Form",
		"Detect Life",
		"Disrupt Life",
		"Cheat Death",

/* Frightful Realms (sval 2) */
		"Shadow Travel",
		"Spear of Darkness",
		"Netherworld Return",
		"Dark Insights",
		"Drain Life",
		"Mists of Lethargy",
		"Dark Banishing",
		"Mists of Death",

/* Controlling Life (sval 3) */
		"Curse Weapon",
		"Wraith Form",
		"Shield of Darkness",
		"Cloak of Nightmares",
		"Slay Living",
		"Infuse Weapon",
		"Battle Rage",
		"Destroy Cavern",

/* Spirit Mastery (sval 4) */
		"Silence of the Grave",
		"Repel Spirits",
		"Banish Spirits",
		"Annihilate Undead",
		"Destroy Life",

	  /* Protection from Undead (sval 5) */
		"Ward Against Evil",
		"Partial Restoration",
		"Rememberance",
		"Restoration",

/* Unholy Perceptions (sval 6) */
		"Corpse Light",
		"Detection",
		"Sense Room",
		"Probing",
		"Map of Blood",

	  /* Mastery of Life Force (sval 7) */
		"Ritual of Blood",
		"Blight Upon Nature",
		"Vampiric Drain",
		"Genocide",
		"Total Genocide",

	  /* Bodily Infusions (sval 8) */
		"Curing",
		"Regeneration",
		"Fighting Rage",
		"Lich Form",
		"Soul Burst",

		"(blank)",
		"(blank)",
		"(blank)",
		"(blank)",
		"(blank)",
		"(blank)",
		"(blank)",
		"(blank)"
	}
};



/*
 * Each chest has a certain set of traps, determined by pval
 * Each chest has a "pval" from 1 to the chest level (max 55)
 * If the "pval" is negative then the trap has been disarmed
 * The "pval" of a chest determines the quality of its treasure
 * Note that disarming a trap on a chest also removes the lock.
 */
byte chest_traps[64] =
{
	0,							/* 0 == empty */
	(CHEST_POISON),
	(CHEST_LOSE_STR),
	(CHEST_LOSE_CON),
	(CHEST_LOSE_STR),
	(CHEST_LOSE_CON),			/* 5 == best small wooden */
	0,
	(CHEST_POISON),
	(CHEST_POISON),
	(CHEST_LOSE_STR),
	(CHEST_LOSE_CON),
	(CHEST_POISON),
	(CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_SUMMON),				/* 15 == best large wooden */
	0,
	(CHEST_LOSE_STR),
	(CHEST_LOSE_CON),
	(CHEST_PARALYZE),
	(CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_SUMMON),
	(CHEST_PARALYZE),
	(CHEST_LOSE_STR),
	(CHEST_LOSE_CON),
	(CHEST_EXPLODE),			/* 25 == best small iron */
	0,
	(CHEST_POISON | CHEST_LOSE_STR),
	(CHEST_POISON | CHEST_LOSE_CON),
	(CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_PARALYZE),
	(CHEST_POISON | CHEST_SUMMON),
	(CHEST_SUMMON),
	(CHEST_EXPLODE),
	(CHEST_EXPLODE | CHEST_SUMMON),		/* 35 == best large iron */
	0,
	(CHEST_SUMMON),
	(CHEST_EXPLODE),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_POISON | CHEST_PARALYZE),
	(CHEST_EXPLODE),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_POISON | CHEST_PARALYZE),	/* 45 == best small steel */
	0,
	(CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_POISON | CHEST_PARALYZE | CHEST_LOSE_STR),
	(CHEST_POISON | CHEST_PARALYZE | CHEST_LOSE_CON),
	(CHEST_POISON | CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_POISON | CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_POISON | CHEST_PARALYZE | CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_POISON | CHEST_PARALYZE),
	(CHEST_POISON | CHEST_PARALYZE),	/* 55 == best large steel */
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
};

/*
 * Hack -- the "basic" color names (see "TERM_xxx")
 */
cptr color_names[16] =
{
	"Dark",
	"White",
	"Slate",
	"Orange",
	"Red",
	"Green",
	"Blue",
	"Umber",
	"Light Dark",
	"Light Slate",
	"Violet",
	"Yellow",
	"Light Red",
	"Light Green",
	"Light Blue",
	"Light Umber",
};


/*
 * Abbreviations of healthy stats
 */
cptr stat_names[7] =
{
	"STR: ", "INT: ", "WIS: ", "DEX: ", "CON: ", "CHR: ", "LUC: "
};

/*
 * Abbreviations of damaged stats
 */
cptr stat_names_reduced[7] =
{
	"Str: ", "Int: ", "Wis: ", "Dex: ", "Con: ", "Chr: ", "Luc: "
};


/*
 * Certain "screens" always use the main screen, including News, Birth,
 * Dungeon, Tomb-stone, High-scores, Macros, Colors, Visuals, Options.
 *
 * Later, special flags may allow sub-windows to "steal" stuff from the
 * main window, including File dump (help), File dump (artifacts, uniques),
 * Character screen, Small scale map, Previous Messages, Store screen, etc.
 */
cptr window_flag_desc[32] =
{
	"Display inven/equip",
	"Display equip/inven",
	"Display player (basic)",
	"Display player (extra)",
	NULL,
	NULL,
	"Display messages",
	"Display overhead view",
	"Display monster recall",
	"Display object recall",
	NULL,
	"Display snap-shot",
	NULL,
	NULL,
	"Display borg messages",
	"Display borg status",
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL
};


/*
 * Options -- textual names (where defined)
 */
cptr option_text[OPT_MAX] =
{
	"rogue_like_commands",		/* OPT_rogue_like_commands */
	"quick_messages",			/* OPT_quick_messages */
	"floor_query_flag",			/* OPT_floor_query_flag */
	"carry_query_flag",			/* OPT_carry_query_flag */
	"use_old_target",			/* OPT_use_old_target */
	"always_pickup",			/* OPT_always_pickup */
	"always_repeat",			/* OPT_always_repeat */
	"depth_in_feet",			/* OPT_depth_in_feet */
	"stack_force_notes",		/* OPT_stack_force_notes */
	"stack_force_costs",		/* OPT_stack_force_costs */
	"show_labels",				/* OPT_show_labels */
	"show_weights",				/* OPT_show_weights */
	"show_choices",				/* OPT_show_choices */
	"show_details",				/* OPT_show_details */
	"ring_bell",				/* OPT_ring_bell */
	"show_flavors",				/* OPT_flavors */
	"raw_skills",				/* OPT_raw_skills */
	"run_ignore_stairs",		/* OPT_run_ignore_stairs */
	"run_ignore_doors",			/* OPT_run_ignore_doors */
	"run_cut_corners",			/* OPT_run_cut_corners */
	"run_use_corners",			/* OPT_run_use_corners */
	"disturb_move",				/* OPT_disturb_move */
	"disturb_near",				/* OPT_disturb_near */
	"disturb_panel",			/* OPT_disturb_panel */
	"disturb_state",			/* OPT_disturb_state */
	"disturb_minor",			/* OPT_disturb_minor */
	"disturb_other",			/* OPT_disturb_other */
	"alert_hitpoint",			/* OPT_alert_hitpoint */
	"alert_failure",			/* OPT_alert_failure */
	"verify_destroy",			/* OPT_verify_destroy */
	"verify_special",			/* OPT_verify_special */
	"allow_quantity",			/* OPT_allow_quantity */
	"auto_haggle",				/* OPT_auto_haggle */
	"auto_scum",				/* OPT_auto_scum */
	"testing_stack",			/* OPT_testing_stack */
	"testing_carry",			/* OPT_testing_carry */
	"expand_look",				/* OPT_expand_look */
	"expand_list",				/* OPT_expand_list */
	"view_perma_grids",			/* OPT_view_perma_grids */
	"view_torch_grids",			/* OPT_view_torch_grids */
	"dungeon_align",			/* OPT_dungeon_align */
	"dungeon_stair",			/* OPT_dungeon_stair */
	"flow_by_sound",			/* OPT_flow_by_sound */
	"flow_by_smell",			/* OPT_flow_by_smell */
	NULL,						/* xxx track_follow */
	NULL,						/* xxx track_target */
	"smart_learn",				/* OPT_smart_learn */
	"smart_cheat",				/* OPT_smart_cheat */
	"view_reduce_lite",			/* OPT_view_reduce_lite */
	"hidden_player",			/* OPT_hidden_player */
	"avoid_abort",				/* OPT_avoid_abort */
	"avoid_other",				/* OPT_avoid_other */
	"flush_failure",			/* OPT_flush_failure */
	"flush_disturb",			/* OPT_flush_disturb */
	NULL,						/* xxx flush_command */
	"fresh_before",				/* OPT_fresh_before */
	"fresh_after",				/* OPT_fresh_after */
	NULL,						/* xxx fresh_message */
	"compress_savefile",		/* OPT_compress_savefile */
	"hilite_player",			/* OPT_hilite_player */
	"view_yellow_lite",			/* OPT_view_yellow_lite */
	"view_bright_lite",			/* OPT_view_bright_lite */
	"view_granite_lite",		/* OPT_view_granite_lite */
	"view_special_lite"			/* OPT_view_special_lite */
};


/*
 * Options -- descriptions (where defined)
 */
cptr option_desc[OPT_MAX] =
{
	"Rogue-like commands",		/* OPT_rogue_like_commands */
	"Activate quick messages",	/* OPT_quick_messages */
	"Prompt for floor item selection",	/* OPT_floor_query_flag */
	"Prompt before picking things up",	/* OPT_carry_query_flag */
	"Use old target by default",	/* OPT_use_old_target */
	"Pick things up by default",	/* OPT_always_pickup */
	"Repeat obvious commands",	/* OPT_always_repeat */
	"Show dungeon level in feet",	/* OPT_depth_in_feet */
	"Merge inscriptions when stacking",		/* OPT_stack_force_notes */
	"Merge discounts when stacking",	/* OPT_stack_force_costs */
	"Show labels in equipment listings",	/* OPT_show_labels */
	"Show weights in all object listings",	/* OPT_show_weights */
	"Show choices in inven/equip windows",	/* OPT_show_choices */
	"Show details in monster descriptions",		/* OPT_show_details */
	"Audible bell (on errors, etc)",	/* OPT_ring_bell */
	"Show flavors in object descriptions",	/* OPT_show_flacors */
	"See raw skill values in skill screen",		/* OPT_raw_skills */
	"When running, ignore stairs",	/* OPT_run_ignore_stairs */
	"When running, ignore doors",	/* OPT_run_ignore_doors */
	"When running, cut corners",	/* OPT_run_cut_corners */
	"When running, use corners",	/* OPT_run_use_corners */
	"Disturb whenever any monster moves",	/* OPT_disturb_move */
	"Disturb whenever viewable monster moves",	/* OPT_disturb_near */
	"Disturb whenever map panel changes",	/* OPT_disturb_panel */
	"Disturb whenever player state changes",	/* OPT_disturb_state */
	"Disturb whenever boring things happen",	/* OPT_disturb_minor */
	"Disturb whenever various things happen",	/* OPT_disturb_other */
	"Alert user to critical hitpoints",		/* OPT_alert_hitpoint */
	"Alert user to various failures",	/* OPT_alert_failure */
	"Verify destruction of objects",	/* OPT_verify_destroy */
	"Verify use of special commands",	/* OPT_verify_special */
	"Allow quantity specification",		/* OPT_allow_quantity */
	"Auto-haggle in stores",	/* OPT_auto_haggle */
	"Auto-scum for good levels",	/* OPT_auto_scum */
	"Allow objects to stack on floor",	/* OPT_testing_stack */
	"Allow monsters to carry objects",	/* OPT_testing_carry */
	"Expand the power of the look command",		/* OPT_expand_look */
	"Expand the power of the list commands",	/* OPT_expand_list */
	"Map remembers all perma-lit grids",	/* OPT_view_perma_grids */
	"Map remembers all torch-lit grids",	/* OPT_view_torch_grids */
	"Generate dungeons with aligned rooms",		/* OPT_dungeon_align */
	"Generate dungeons with connected stairs",	/* OPT_dungeon_stair */
	"Monsters chase current location (v.slow)",		/* OPT_flow_by_sound */
	"Monsters chase recent locations (v.slow)",		/* OPT_flow_by_smell */
	NULL,						/* xxx */
	NULL,						/* xxx */
	"Monsters learn from their mistakes",	/* OPT_smart_learn */
	"Monsters exploit players weaknesses",	/* OPT_smart_cheat */
	"Reduce lite-radius when running",	/* OPT_view_reduce_lite */
	"Hide player symbol when running",	/* OPT_hidden_player */
	"Avoid checking for user abort",	/* OPT_avoid_abort */
	"Avoid processing special colors",	/* OPT_avoid_other */
	"Flush input on various failures",	/* OPT_flush_failure */
	"Flush input whenever disturbed",	/* OPT_flush_disturb */
	NULL,						/* xxx */
	"Flush output before every command",	/* OPT_fresh_before */
	"Flush output after various things",	/* OPT_fresh_after */
	NULL,						/* xxx */
	"Compress messages in savefiles",	/* OPT_compress_savefile */
	"Hilite the player with the cursor",	/* OPT_hilite_player */
	"Use special colors for torch lite",	/* OPT_view_yellow_lite */
	"Use special colors for field of view",		/* OPT_view_bright_lite */
	"Use special colors for wall grids",	/* OPT_view_granite_lite */
	"Use special colors for floor grids"	/* OPT_view_special_lite */
};


/*
 * Options -- normal values
 */
bool option_norm[OPT_MAX] =
{
	FALSE,						/* OPT_rogue_like_commands */
	FALSE,						/* OPT_quick_messages */
	TRUE,						/* OPT_floor_query_flag */
	FALSE,						/* OPT_carry_query_flag */
	FALSE,						/* OPT_use_old_target */
	TRUE,						/* OPT_always_pickup */
	FALSE,						/* OPT_always_repeat */
	FALSE,						/* OPT_depth_in_feet */
	FALSE,						/* OPT_stack_force_notes */
	FALSE,						/* OPT_stack_force_costs */
	TRUE,						/* OPT_show_labels */
	TRUE,						/* OPT_show_weights */
	TRUE,						/* OPT_show_choices */
	TRUE,						/* OPT_show_details */
	TRUE,						/* OPT_ring_bell */
	TRUE,						/* OPT_show_flavors */
	FALSE,						/* OPT_raw_skills */
	TRUE,						/* OPT_run_ignore_stairs */
	TRUE,						/* OPT_run_ignore_doors */
	TRUE,						/* OPT_run_cut_corners */
	TRUE,						/* OPT_run_use_corners */
	TRUE,						/* OPT_disturb_move */
	TRUE,						/* OPT_disturb_near */
	TRUE,						/* OPT_disturb_panel */
	TRUE,						/* OPT_disturb_state */
	TRUE,						/* OPT_disturb_minor */
	TRUE,						/* OPT_disturb_other */
	FALSE,						/* OPT_alert_hitpoint */
	FALSE,						/* OPT_alert_failure */
	TRUE,						/* OPT_verify_destroy */
	TRUE,						/* OPT_verify_special */
	TRUE,						/* OPT_allow_quantity */
	TRUE,						/* OPT_auto_haggle */
	FALSE,						/* OPT_auto_scum */
	FALSE,						/* OPT_testing_stack */
	FALSE,						/* OPT_testing_carry */
	FALSE,						/* OPT_expand_look */
	FALSE,						/* OPT_expand_list */
	TRUE,						/* OPT_view_perma_grids */
	FALSE,						/* OPT_view_torch_grids */
	TRUE,						/* OPT_dungeon_align */
	TRUE,						/* OPT_dungeon_stair */
	FALSE,						/* OPT_flow_by_sound */
	FALSE,						/* OPT_flow_by_smell */
	FALSE,						/* xxx */
	FALSE,						/* xxx */
	FALSE,						/* OPT_smart_learn */
	FALSE,						/* OPT_smart_cheat */
	FALSE,						/* OPT_view_reduce_lite */
	FALSE,						/* OPT_hidden_player */
	FALSE,						/* OPT_avoid_abort */
	FALSE,						/* OPT_avoid_other */
	TRUE,						/* OPT_flush_failure */
	FALSE,						/* OPT_flush_disturb */
	FALSE,						/* xxx */
	TRUE,						/* OPT_fresh_before */
	FALSE,						/* OPT_fresh_after */
	FALSE,						/* xxx */
	TRUE,						/* OPT_compress_savefile */
	FALSE,						/* OPT_hilite_player */
	FALSE,						/* OPT_view_yellow_lite */
	FALSE,						/* OPT_view_bright_lite */
	FALSE,						/* OPT_view_granite_lite */
	FALSE						/* OPT_view_special_lite */
};


/*
 * Option screen interface
 */
byte option_page[4][17] =
{
/*** User-Interface ***/

	{
		OPT_rogue_like_commands,
		OPT_quick_messages,
		OPT_floor_query_flag,
		OPT_carry_query_flag,
		OPT_use_old_target,
		OPT_always_pickup,
		OPT_always_repeat,
		OPT_depth_in_feet,
		OPT_stack_force_notes,
		OPT_stack_force_costs,
		OPT_show_labels,
		OPT_show_weights,
		OPT_show_choices,
		OPT_show_details,
		OPT_show_flavors,
		OPT_raw_skills,
		OPT_ring_bell
	},

/*** Disturbance ***/

	{
		OPT_run_ignore_stairs,
		OPT_run_ignore_doors,
		OPT_run_cut_corners,
		OPT_run_use_corners,
		OPT_disturb_move,
		OPT_disturb_near,
		OPT_disturb_panel,
		OPT_disturb_state,
		OPT_disturb_minor,
		OPT_disturb_other,
		OPT_alert_hitpoint,
		OPT_alert_failure,
		OPT_verify_destroy,
		OPT_verify_special,
		OPT_allow_quantity,
		255,
		255
	},

/*** Game-Play ***/

	{
		OPT_auto_haggle,
		OPT_auto_scum,
		OPT_testing_stack,
		OPT_testing_carry,
		OPT_expand_look,
		OPT_expand_list,
		OPT_view_perma_grids,
		OPT_view_torch_grids,
		OPT_dungeon_align,
		OPT_dungeon_stair,
		OPT_flow_by_sound,
		OPT_flow_by_smell,
		OPT_smart_learn,
		OPT_smart_cheat,
		255,
		255,
		255
	},

/*** Efficiency ***/

	{
		OPT_view_reduce_lite,
		OPT_hidden_player,
		OPT_avoid_abort,
		OPT_avoid_other,
		OPT_flush_failure,
		OPT_flush_disturb,
		OPT_fresh_before,
		OPT_fresh_after,
		OPT_compress_savefile,
		OPT_hilite_player,
		OPT_view_yellow_lite,
		OPT_view_bright_lite,
		OPT_view_granite_lite,
		OPT_view_special_lite,
		255,
		255,
		255
	}
};

/*
 * Skill information table.
 */
skill_type skill_tbl[NUM_SKILLS] =
{
	{"Swordsmanship", "ability to fight with swords", 120},
	{"Clubbing", "ability to fight with blunt weapons", 120},
	{"Jousting", "ability to fight with polearms", 120},
	{"Endurance", "ability to absorb damage", 120},
	{"Archery", "ability to fire missile weapons", 110},
	{"Magical Devices", "ability to use magic items", 135},
	{"Spellcasting", "spell level", 160},
	{"Spell Resistance", "spell resistance", 120},
	{"Disarming", "ability to disarm traps", 90},
	{"Backstabbing", "skill at slaying sleeping creatures", 135},
	{"Sneaking", "stealth", 105},
	{"Magical Power", "mana supply", 130},
	{"Dual Wield", "ability to fight with two weapons at once", 110},
	{"Dodging", "ability to evade attacks", 90},
	{"Karate", "ability to kick and punch your opponents", 110},
	{"Weaponsmithing", "ability to forge custom-made weapons", 150},
	{"Armor Forging", "ability to forge custom-made armor", 150},
	{"Perception", "ability to notice the things around you", 75},
	{"Morality", "understanding of the nature of evil", 75},
	{"Nature Lore", "understanding of nature", 75},
	{"Dark Lore", "understanding of undead creatures", 75},
	{"Magical Perception", "sensitivity to magical fluctuations", 90},
	{"Wrestling", "ability to grapple and throw your opponent", 100},
	{"Bowmaking", "ability to make bows and arrows", 130},
	{"Alchemy", "ability to work with scrolls and potions", 110},
	{"Magical Infusion", "ability to work with wands and staves", 110},
	{NULL, NULL, 100},
	{NULL, NULL, 100},
	{NULL, NULL, 100},
	{NULL, NULL, 100},
};

/*
 * Skill raise table.
 *
 * A human (rate 7) buying a normal difficulty skill (100) in the
 * middle of the mastery range should get about 2-3 points per
 * buy. (510-765.)  call it 2.5 (637.5). These values are stored in
 * this array, indexed by current val/5 to determine size of next
 * boost.  Value stored in the array is for a learning value of 10, so
 * multiply by learning val/10. Base val is 910. To determine amount a
 * skill gets raised, take the base. multiply by 100. divide by
 * difficulty. (A higher difficulty means you get less in the skill
 * for each time you buy it.) multiply by learning val. divide by
 * 10. add to skill.
 */

u16b skill_raises[52] =
{
	1400, 1285, 1135, 990, 885, 735, 650, 665, 710, 750, 785, 815, 845,
	870, 890, 910, 930, 945, 960, 970, 980, 990, 995, 1000, 1005, 1010,
	1005, 1000, 995, 990, 980, 970, 960, 945, 930, 910, 890, 870, 845,
	815, 785, 750, 710, 665, 615, 560, 500, 455, 385, 310, 230, 0
};

/*
 * Talent information table.
 */
talent_type talent_info[NUM_TALENTS] =
{
	{"Find Traps", S_DISARM, 200, 50},
	{"Predict Weather", S_PERCEPTION, 50, 20},
	{"Sense Evil", S_SLAY_EVIL, 200, 100},
	{"Sense Animals", S_SLAY_ANIMAL, 150, 75},
	{"Alchemical Testing", S_ALCHEMY, 50, 50},
	{"Sense Charges", S_INFUSION, 25, 25},
	{"Weapon Forging", S_WEAPON, 50, 0},
	{"Armor Forging", S_ARMOR, 50, 0},
	{"Fletching", S_BOWMAKE, 40, 0},
	{"Bowmaking", S_BOWMAKE, 80, 0},
	{"Fenneling", S_DEVICE, 50, 0},
	{"Alchemy", S_ALCHEMY, 125, 200},
	{"Magical Infusion", S_INFUSION, 140, 200},
	{"Meditation", S_KARATE, 150, 255},
	{"Restore Experience", S_SLAY_UNDEAD, 220, 200},
	{"Recharging", S_INFUSION, 50, 200},
	{"Breathe Fire", S_NOSKILL, 0, 3},
	{NULL, S_NOSKILL, 0, 0},
	{NULL, S_NOSKILL, 0, 0},
	{NULL, S_NOSKILL, 0, 0},
	{NULL, S_NOSKILL, 0, 0},
	{NULL, S_NOSKILL, 0, 0},
	{NULL, S_NOSKILL, 0, 0}
};

/*
 * Ego item allocation table. Initialized in init2.c.
 */
ego_item_alloc ego_alloc_table[] =
{
	{0, 0, 0, 0, 0},			/* EGO_ALLOC_NOGROUP */
	{INVEN_WIELD, 0, 0, 0, 0},	/* EGO_ALLOC_WEAPON */
	{INVEN_BOW, 0, 0, 0, 0},	/* EGO_ALLOC_BOW */
	{0, 0, 0, 0, 0},			/* EGO_ALLOC_MISSILE */
	{INVEN_BODY, 0, 0, 0, 0},	/* EGO_ALLOC_ARMOR */
	{INVEN_ARM, 0, 0, 0, 0},	/* EGO_ALLOC_SHIELD */
	{INVEN_HANDS, 0, 0, 0, 0},	/* EGO_ALLOC_GLOVES */
	{INVEN_FEET, 0, 0, 0, 0},	/* EGO_ALLOC_BOOTS */
	{INVEN_HEAD, 0, 0, 0, 0},	/* EGO_ALLOC_HELM */
	{INVEN_OUTER, 0, 0, 0, 0},	/* EGO_ALLOC_CLOAK */
	{INVEN_WIELD, 0, 0, 0, 0}	/* EGO_ALLOC_DIGGER */
};
