/*
 * wbset.c
 * 
 * Setup loader for the WaveBlaster board using the Linux Sound Driver.
 * 
 * Copyright by Hannu Savolainen 1993
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met: 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer. 2.
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * 
 */
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/soundcard.h>

/*
 * You have to change the CBK_PATH
 */
#ifndef CBK_PATH
#define CBK_PATH	"/C/waveblst/wbpanel/"
#endif

#define BUFLEN 1024
SEQ_DEFINEBUF(4*BUFLEN);

int seqfd;
int mididev;

int verbose = 0;

void
seqbuf_dump ()
{
  if (_seqbufptr)
    if (write (seqfd, _seqbuf, _seqbufptr) == -1)
      {
	perror ("write /dev/sequencer");
	exit (-1);
      }
  _seqbufptr = 0;
}

main (int argc, char *argv[])
{
  int i, tmp, n, p;
  struct midi_info info;

  int cbkfd;	/* Sysex file */
  char cbk_name[1024];

  if ((seqfd = open ("/dev/sequencer", O_RDWR, 0)) == -1)
    {
      perror ("/dev/sequencer");
      exit (-1);
    }

/*
 * First locate the SB16 midi interface. The WaveBlaster is sitting there.
 */

  if (ioctl(seqfd, SNDCTL_SEQ_NRMIDIS, &n)==-1)
    {
      perror ("/dev/sequencer");
      exit (-1);
    }

  mididev = -1;

  for (i=0;i<n && mididev == -1;i++)
  {
    info.device = i;
    if (ioctl(seqfd, SNDCTL_MIDI_INFO, &info)==-1)
    {
      perror ("/dev/sequencer");
      exit (-1);
    }

    if (info.dev_type == SNDCARD_SB16MIDI) 
	mididev=i;
    else
      if (info.dev_type == SNDCARD_SB && mididev ==-1) mididev=i;
  }

  if (mididev == -1)
  {
  	fprintf(stderr, "%s: SB16 Midi device not found\n");
  	exit(-1);
  }

/*
 * Send the System Reset sysex of the Proteus SoundEngine 
 */

   SEQ_MIDIOUT(mididev, 0xf0);
   SEQ_MIDIOUT(mididev, 0x18);
   SEQ_MIDIOUT(mididev, 0x04);
   SEQ_MIDIOUT(mididev, 0x00);
   SEQ_MIDIOUT(mididev, 0x23);
   SEQ_MIDIOUT(mididev, 0xf7);

   SEQ_DUMPBUF();

   exit(0);
}
