/*
 *  Project   : tin - a threaded Netnews reader
 *  Module    : debug.c
 *  Author    : I.Lea
 *  Created   : 01-04-91
 *  Updated   : 03-06-92
 *  Notes     : debug routines
 *  Copyright : (c) Copyright 1991-92 by Iain Lea
 *              You may  freely  copy or  redistribute  this software,
 *              so  long as there is no profit made from its use, sale
 *              trade or  reproduction.  You may not change this copy-
 *              right notice, and it must be included in any copy made
 */

#include "tin.h"

int debug;

/*
 *  nntp specific debug routines
 */
 
void debug_nntp (func, line)
	char *func;	
	char *line;	
{
#ifdef DEBUG
	FILE *fp;

	if (debug != 1)
		return;

	if ((fp = fopen ("/tmp/NNTP","a+")) != NULL) {
		fprintf (fp,"%s: %s\n", func, line);
		fclose (fp);
		chmod ("/tmp/NNTP", 0666);
	}
#endif
}


void debug_nntp_respcode (respcode)
	int respcode;
{
#ifdef DEBUG
	debug_nntp ("get_respcode", nntp_respcode (respcode));
#endif
}	

/*
 *  tin specific debug routines
 */
 
void debug_print_arts ()
{
#ifdef DEBUG
	int i;

	if (debug != 2)
		return;

	for (i = 0; i < top; i++) {	/* for each group */
		debug_print_header (&arts[i]);
	}
#endif
}


void debug_print_header (s)
	struct article_t *s;
{
#ifdef DEBUG
	FILE *fp;

	if (debug != 2)
		return;

	if ((fp = fopen ("/tmp/ARTS","a+")) != NULL) {
		fprintf (fp,"art=[%5ld] tag=[%s] kill=[%s] hot=[%s]\n", s->artnum,
			(s->tagged ? "TRUE" : "FALSE"),
			(s->killed ? "TRUE" : "FALSE"),
			(s->hot ? "TRUE" : "FALSE"));
		fprintf (fp,"subj=[%-38s]\n", s->subject);
		fprintf (fp,"date=[%s]  from=[%s]  name=[%s]\n", s->date, s->from, s->name);
 		if (s->archive) {
 		    fprintf (fp, "arch=[%-38s]  ", s->archive);
 		} else {
 		    fprintf (fp, "arch=[]  ");
 		}
 		if (s->part) {
 		    fprintf (fp, "part=[%s]  ", s->part);
 		} else {
 		    fprintf (fp, "part=[]  ");
 		}
 		if (s->patch) {
 		    fprintf (fp, "patch=[%s]\n", s->patch);
		} else {
 		    fprintf (fp, "patch=[]\n");
 		}
		fprintf (fp,"thread=[%d]  inthread=[%d]  unread=[%d]\n\n",
			s->thread, s->inthread, s->unread);
/*		fprintf (fp,"thread=[%s]  inthread=[%s]  unread=[%s]\n",
			(s->thread == ART_NORMAL ? "ART_NORMAL" : "ART_EXPIRED"),
			(s->inthread ? "TRUE" : "FALSE"),
			(s->unread ? "TRUE" : "FALSE"));
*/
		fflush (fp);
		fclose (fp);
		chmod ("/tmp/DUMP", 0666);
	}
#endif
}


void debug_print_comment (comment)
	char *comment;
{
#ifdef DEBUG
	FILE *fp;

	if (debug != 2)
		return;

	if ((fp = fopen ("/tmp/BASE","a+")) != NULL) {
		fprintf (fp,"\n%s\n\n", comment);
		fflush (fp);
		fclose (fp);
		chmod ("/tmp/BASE", 0666);
	}
#endif
}


void debug_print_base ()
{
#ifdef DEBUG
	FILE *fp;
	int i;

	if (debug != 2)
		return;

	if ((fp = fopen ("/tmp/BASE","a+")) != NULL) {
		for (i = 0; i < top_base; i++) {
			fprintf (fp, "base[%3d]=[%5ld]\n",i,base[i]);
		}
		fflush (fp);
		fclose (fp);
		chmod ("/tmp/BASE", 0666);
	}
#endif
}


void debug_print_active ()
{
#ifdef DEBUG
	FILE *fp;
	int i;

	if (debug != 2)
		return;

	if ((fp = fopen ("/tmp/ACTIVE","w")) != NULL) {
		for (i = 0; i < num_active; i++) {	/* for each group */
			fprintf (fp, "[%4d]=[%-28s] max=[%4ld] min=[%4ld] mod=[%c] nxt=[%4d] flag=[%d]\n",
				i, active[i].name, active[i].max, active[i].min,
				active[i].moderated, active[i].next, active[i].flag);
			fprintf (fp, "hash=[%ld]  description=[%s]\n", hash_groupname (active[i].name), 
				(active[i].description ? active[i].description : ""));
			fprintf (fp, "read=[%d] show=[%d] thread=[%d] sort=[%d] author=[%d] auto=[%d] process=[%d]\n",
				active[i].attribute.read,    active[i].attribute.showall,
				active[i].attribute.thread,  active[i].attribute.sortby,
				active[i].attribute.author,  active[i].attribute.autosave,
				active[i].attribute.process);
			fprintf (fp, "server=[%s] ", (active[i].attribute.server  == (char *) 0 ? "" : active[i].attribute.server));
			fprintf (fp, "maildir=[%s] ",(active[i].attribute.maildir == (char *) 0 ? "" : active[i].attribute.maildir));			
			fprintf (fp, "savedir=[%s] ",(active[i].attribute.savedir == (char *) 0 ? "" : active[i].attribute.savedir));
			fprintf (fp, "sigfile=[%s]\n\n",(active[i].attribute.sigfile == (char *) 0 ? "" : active[i].attribute.sigfile));
		}
		fflush (fp);
		fclose (fp);
		chmod ("/tmp/ACTIVE", 0666);
	}
#endif
}
