/*
    UIT pattern match file
    Copyright (c) 1993, 1994 Tudor Hulubei & Andrei Pitis

This file is part of UIT (UNIX Interactive Tools)

UIT is free software; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free Software
Foundation; either version 2, or (at your option) any later version.

UIT is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
details .

You should have received a copy of the GNU General Public License along with
UIT; see the file COPYING.  If not, write to the Free Software Foundation,
675 Mass Ave, Cambridge, MA 02139, USA.  */


#include <stdio.h>

#include "fnmatch.h"


char *program;


int usage(void)
{
    fprintf(stderr, "%s: UIT internal program.\n", program);
    exit(255);
}


/*
 * argv[1] = string
 * argv[2], argv[3], ... = patterns
 * return value = no of pattern that matches.
 */
 
int main(int argc, char *argv[])
{
    int i, flags = FNM_PERIOD | FNM_PATHNAME;

    program = argv[0];

    if (argc < 3)
	usage();

    for (i = 0; i < argc - 2; i++)
	if (fnmatch(argv[i + 2], argv[1], flags) != FNM_NOMATCH)
	    return i + 1;

    return 0;
}
