/*
    Misc header file
    Copyright (c) 1993, 1994 Tudor Hulubei & Andrei Pitis

This file is part of UIT (UNIX Interactive Tools)

UIT is free software; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free Software
Foundation; either version 2, or (at your option) any later version.

UIT is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
details .

You should have received a copy of the GNU General Public License along with
UIT; see the file COPYING.  If not, write to the Free Software Foundation,
675 Mass Ave, Cambridge, MA 02139, USA.  */


#ifndef _MISC_H
#define _MISC_H


extern char *home;
extern char *program;
extern char *tty_type;

extern char *tty_name;
extern int  tty_name_len;
extern char *login_name;
extern int  login_name_len;

extern int SCREEN_X;
extern int SCREEN_Y;

extern char cSection[];
extern char bwSection[];


#define max(a, b) (((a) >= (b)) ? (a) : (b))
#define min(a, b) (((a) <= (b)) ? (a) : (b))


void  configuration_help(char *configfile);
void  configuration_check(void);
void  use_section(char *section);
int   get_int_var(char *var_name, char *options[],
		  int options_no, int default_val);
int   get_flag_var(char *var_name, int def_val);
char *get_string_var(char *var_name, char *def_val);
void  get_colorset_var(int *charset, char *colorset_name[], int fields_no);
char *clear_path(char *);
int  my_readlink(char *filename);
void get_tty_name(void);
void get_login_name(void);


#endif	/* _MISC_H */
