/*
    Edit line management header file
    Copyright (c) Tudor Hulubei & Andrei Pitis, May 1994

This file is part of UIT (UNIX Interactive Tools)

UIT is free software; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free Software
Foundation; either version 2, or (at your option) any later version.

UIT is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
details .

You should have received a copy of the GNU General Public License along with
UIT; see the file COPYING.  If not, write to the Free Software Foundation,
675 Mass Ave, Cambridge, MA 02139, USA.  */


#ifndef __EDIT_H
#define __EDIT_H


#include "config.h"


#define EDIT_BUFLEN	0xFF
#define EDIT_HISTBUFLEN	0x2000
#define EDIT_RECLEN	0x100
#define EDIT_HISTRECS   (EDIT_HISTBUFLEN / EDIT_RECLEN)
#define EDIT_RECORD	0
#define EDIT_PREVIOUS	1
#define EDIT_NEXT	2


typedef struct
{
    window *win;
    unsigned index, columns;
    unsigned static_size, records, current_record;
    char *buf, *history_buf;
} edit;


edit *edit_init(int columns, int begin_y, configuration *config);
void  edit_end(edit *this);
void  edit_putch(edit *this, int key);
void  edit_puts(edit *this, char *str);
char *edit_gets(edit *this, char *static_text, char *dest, char *default_str);
char *edit_gettext(edit *this, char *dest);
void  edit_reset(edit *this);
void  edit_del(edit *this);
void  edit_setcursor(edit *this);
void  edit_update(edit *this);
void  edit_eos(edit *this);
void  edit_history(edit *this, int action);


#endif
