/*
    Terminal capabilities interface header file
    Copyright (c) Tudor Hulubei & Andrei Pitis, April 1994

This file is part of UIT (UNIX Interactive Tools)

UIT is free software; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free Software
Foundation; either version 2, or (at your option) any later version.

UIT is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
details .

You should have received a copy of the GNU General Public License along with
UIT; see the file COPYING.  If not, write to the Free Software Foundation,
675 Mass Ave, Cambridge, MA 02139, USA.  */


#ifndef __TERMCAP_H
#define __TERMCAP_H


#define TTY_DESCRIPTION_END	 0
#define TTY_BACKSPACE		 1
#define TTY_CURSOR_LEFT		 2
#define TTY_CURSOR_RIGHT	 3
#define TTY_CURSOR_UP		 4
#define TTY_CURSOR_DOWN		 5
#define TTY_HOME		 6
#define TTY_END			 7
#define TTY_INS			 8
#define TTY_DEL			 9
#define TTY_PGUP		10
#define TTY_PGDN		11
#define TTY_F1			12
#define TTY_F2			13
#define TTY_F3			14
#define TTY_F4			15
#define TTY_F5			16
#define TTY_F6			17
#define TTY_F7			18
#define TTY_F8			19
#define TTY_F9			20
#define TTY_F10			21
#define TTY_TAB			22

#define TTY_CURSOR_MOVE		23
#define TTY_UNDERLINE_ON	24	
#define TTY_UNDERLINE_OFF	25
#define TTY_REVERSE_ON		26
#define TTY_REVERSE_OFF		27
#define TTY_CLRSCR		28
#define TTY_BRIGHT_ON		29
#define TTY_BRIGHT_OFF		30


#define TTY_MAXCAP		(1+30)


void termcap_init(void);


#endif
