------------------------------------------------------------------------------
--                                                                          --
--                 GNU ADA RUNTIME LIBRARY (GNARL) COMPONENTS               --
--                                                                          --
--                   R T S _ T i m e r _ S e r v i c e                      --
--                                                                          --
--                                  S p e c                                 --
--                                                                          --
--                             $Revision: 1.2 $                            --
--                                                                          --
--           Copyright (c) 1991,1992,1993, FSU, All Rights Reserved         --
--                                                                          --
--  GNARL is free software; you can redistribute it and/or modify it  under --
--  terms  of  the  GNU  Library General Public License as published by the --
--  Free Software Foundation; either version 2, or  (at  your  option)  any --
--  later  version.   GNARL is distributed in the hope that it will be use- --
--  ful, but but WITHOUT ANY WARRANTY; without even the implied warranty of --
--  MERCHANTABILITY  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Gen- --
--  eral Library Public License for more details.  You should have received --
--  a  copy of the GNU Library General Public License along with GNARL; see --
--  file COPYING. If not, write to the Free Software Foundation,  675  Mass --
--  Ave, Cambridge, MA 02139, USA.                                          --
--                                                                          --
------------------------------------------------------------------------------

with System.Real_Time; use System.Real_Time;

with System.Task_Protected_Objects; use System.Task_Protected_Objects;

with Ada.Calendar; use Ada.Calendar;
package System.Task_Timer_Service is

--  implementing a proteced type using a single package

   package Signal_Object is
      type O_Type is record
         Object : Protection (Num_Entries => 1);
         Open : boolean := false;
      end record;
      procedure Signal (PO : in out O_Type);

--  9X code : function Wait_Count return integer;
      --  This is a general purpose function.
      --  This can not be implemented using function in Ada83 because
      --  passing object has to be 'in out' mode (for read_lock in the
      --  body of the function). Therefore we use a procedure instead.
      procedure Wait_Count (PO : in out O_Type; W : out Integer);

      procedure Service_Entries
        (PO : in out O_Type;
         Pending_Serviced : out Boolean);
   end Signal_Object;

   package Timer is
      Object : Protection (Num_Entries => 4);

      --  Relative Delays --
      type Time_Span_Params is record
         Param : Time_Span;
      end record;
      type Duration_Params is record
         Param : Duration;
      end record;
      --  Absolute Delays --
      type Real_Time_Time_Params is record
         Param : Real_Time.Time;
      end record;
      type Calendar_Time_Params is record

         Param : Calendar.Time;

      end record;
      procedure Service (T : out Real_Time.Time);
      procedure Service_Entries (Pending_Serviced : out Boolean);
   end Timer;

end System.Task_Timer_Service;
