------------------------------------------------------------------------------
--                                                                          --
--                 GNU ADA RUNTIME LIBRARY (GNARL) COMPONENTS               --
--                                                                          --
--                       R T S _ T a s k _ S t a g e s                      --
--                                                                          --
--                                  S p e c                                 --
--                                                                          --
--                             $Revision: 1.6 $                            --
--                                                                          --
--           Copyright (c) 1991,1992,1993, FSU, All Rights Reserved         --
--                                                                          --
--  GNARL is free software; you can redistribute it and/or modify it  under --
--  terms  of  the  GNU  Library General Public License as published by the --
--  Free Software Foundation; either version 2, or (at  your  option)  any --
--  later  version.   GNARL is distributed in the hope that it will be use- --
--  ful, but but WITHOUT ANY WARRANTY; without even the implied warranty of --
--  MERCHANTABILITY  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Gen- --
--  eral Library Public License for more details.  You should have received --
--  a  copy of the GNU Library General Public License along with GNARL; see --
--  file COPYING. If not, write to the Free Software Foundation,  675  Mass --
--  Ave, Cambridge, MA 02139, USA.                                          --
--                                                                          --
------------------------------------------------------------------------------

with System.Machine_Specifics;
with System.Task_Rendezvous;
with System.Task_IDs; use System.Task_IDs;

package System.Task_Stages is

   type Master_ID is new Integer;

   function Self return Task_ID;
   pragma Inline (Self);

   type Activations_Status is (

         Good_Activations,
         --  All tasks successfully activated.

         Task_Error,
         --  One of the tasks raised an exception during activation.

         Prog_Error);
         --  The body of one or more of the tasks being activated had not
         --  been elaborated.

   procedure Init_RTS (Main_Task_Priority : System.Priority);

   procedure  Make_Independent;

   --  RTS Internal Declarations---Not part of the GNARLI.

   function  Current_Master return Master_ID;

   procedure Enter_Master;

   procedure Complete_Master;

   type Access_Boolean is access Boolean;
   type Size_Type is new Machine_Specifics.Task_Storage_Size;
   Unspecified_Size : constant Size_Type := Size_Type'First;

   type Activation_Chain is new Task_ID;

   Unspecified_Priority : constant Integer := System.Priority'First - 1;

   procedure Create_Task (Size : Size_Type;
         Priority : Integer;
         Num_Entries : Task_Rendezvous.Task_Entry_Index;
         Master : Master_ID;
         State : Machine_Specifics.Init_State;
         Discriminants : System.Address;
         Elaborated : Access_Boolean;
         Chain : in out Activation_Chain;
         Created_Task : out Task_ID);

   procedure Activate_Tasks (Chain : in out Activation_Chain);

   procedure Expunge_Unactivated_Tasks (Chain : in out Activation_Chain);

   procedure Complete_Activation;

   procedure Complete_Task;

   function Terminated (T : Task_ID) return Boolean;

   --  RTS Internal Declarations---Not part of the GNARLI.

   procedure Leave_Task;

   --  RTS Internal Declarations---Not part of the GNARLI.

   procedure Terminate_Alternative;

   procedure Complete (Target : Task_ID);
   --  export for abortion

   procedure Init_Master (M : out Master_ID);
   pragma Inline (Init_Master);

   function Increment_Master (M : Master_ID) return Master_ID;
   pragma Inline (Increment_Master);

   function Decrement_Master (M : Master_ID) return Master_ID;
   pragma Inline (Decrement_Master);

end System.Task_Stages;
