------------------------------------------------------------------------------
--                                                                          --
--                 GNU ADA RUNTIME LIBRARY (GNARL) COMPONENTS               --
--                                                                          --
--                             R T S _ A b o r t                            --
--                                                                          --
--                                  S p e c                                 --
--                                                                          --
--                             $Revision: 1.2 $                             --
--                                                                          --
--           Copyright (c) 1991,1992,1993, FSU, All Rights Reserved         --
--                                                                          --
--  GNARL is free software; you can redistribute it and/or modify it  under --
--  terms  of  the  GNU  Library General Public License as published by the --
--  Free Software Foundation; either version 2, or (at  your  option)  any  --
--  later  version.   GNARL is distributed in the hope that it will be use- --
--  ful, but but WITHOUT ANY WARRANTY; without even the implied warranty of --
--  MERCHANTABILITY  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Gen- --
--  eral Library Public License for more details.  You should have received --
--  a  copy of the GNU Library General Public License along with GNARL; see --
--  file COPYING. If not, write to the Free Software Foundation,  675  Mass --
--  Ave, Cambridge, MA 02139, USA.                                          --
--                                                                          --
------------------------------------------------------------------------------

with System.Task_IDs; use System.Task_IDs;
with System.Machine_Specifics;

package System.Task_Abortion is

   Max_ATC_Nesting : constant Natural := 20;
   subtype ATC_Level_Base is Integer range 0 .. Max_ATC_Nesting;
   ATC_Level_Infinity : constant ATC_Level_Base :=
         ATC_Level_Base'LAST;
   subtype ATC_Level is ATC_Level_Base range
         ATC_Level_Base'FIRST .. ATC_Level_Base'Last - 1;
   subtype ATC_Level_Index is ATC_Level
         range ATC_Level'First + 1 .. ATC_Level'Last;

   Abort_Signal : exception; --   pseudo exception ;
   --  This is a special signal; it should not be caught by
   --  a "when others =>" clause.

   type Task_List is array (Positive range <>) of Task_ID;

   procedure Abort_Tasks (Tasks : Task_List);

   --   is called to initiate abortion, however, the actual abortion
   --   is done by abortee by means of Abort_Handler
   procedure Defer_Abortion;

--    pragma Inline (Defer_Abortion);

   procedure Undefer_Abortion;

--    pragma Inline (Undefer_Abortion);

   --   RTS Internal Declarations---Not part of the GNARLI.

   procedure Abort_To_Level (Target : Task_ID; L : ATC_Level);

   procedure Abort_Handler (Context : Machine_Specifics.Pre_Call_State);

   procedure Abort_Dependents (Abortee : Task_ID);

end System.Task_Abortion;
