------------------------------------------------------------------------------
--                                                                          --
--                 GNU ADA RUNTIME LIBRARY (GNARL) COMPONENTS               --
--                                                                          --
--                   R T S _ R e a l _ T i m e - D e l a y s                --
--                                                                          --
--                                  B o d y                                 --
--                                                                          --
--                             $Revision: 1.2 $                            --
--                                                                          --
--           Copyright (c) 1991,1992,1993, FSU, All Rights Reserved         --
--                                                                          --
--  GNARL is free software; you can redistribute it and/or modify it  under --
--  terms  of  the  GNU  Library General Public License as published by the --
--  Free Software Foundation; either version 2, or  (at  your  option)  any --
--  later  version.   GNARL is distributed in the hope that it will be use- --
--  ful, but but WITHOUT ANY WARRANTY; without even the implied warranty of --
--  MERCHANTABILITY  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Gen- --
--  eral Library Public License for more details.  You should have received --
--  a  copy of the GNU Library General Public License along with GNARL; see --
--  file COPYING. If not, write to the Free Software Foundation,  675  Mass --
--  Ave, Cambridge, MA 02139, USA.                                          --
--                                                                          --
------------------------------------------------------------------------------

with System.Task_Timer_Service; use System.Task_Timer_Service;

with System; use System;
with System.Compiler_Exceptions; use System.Compiler_Exceptions;
with System.Task_Stages;

with Unchecked_Conversion;

package body System.Real_Time.Delays is

   function To_Access is new Unchecked_Conversion (
         System.Address,
         Protection_Access);

   package body Delay_Until_Object is
      procedure Service_Entries (Pending_Serviced : out Boolean) is
         P : System.Address;
         subtype PO_Entry_Index is Protected_Entry_Index
              range Null_Protected_Entry .. 1;
         Barriers : Barrier_Vector (1 .. 1)  :=  (others => true);
         --  no barriers. always true barrier
         E : PO_Entry_Index;
         PS : Boolean;
         Cumulative_PS : Boolean := False;
      begin
         loop
            Next_Entry_Call (To_Access (Object'Address), Barriers, P, E);
            --  get the next queued entry
            --  or the pending call  (if no barriers are true)
            begin
               case E is
                  when Null_Protected_Entry =>  --  no pending call to serve
                     exit;
                  when 1 =>
                     Lock (To_Access (
                           Task_Timer_Service.Timer.Object'Address));
                     --  lock the object before requeueing
                     begin
                        Requeue_Protected_Entry (
                              Object => To_Access (Object'Address),
                              New_Object =>
                                 To_Access (
                                 Task_Timer_Service.Timer.Object'Address),
                                 E => 3,
                                 With_Abort => true);
                        Task_Timer_Service.Timer.Service_Entries (PS);
                        Unlock (To_Access (
                              Task_Timer_Service.Timer.Object'Address));
                        --  Requeue on the timer for the service.
                        --  Parameter is passed along as
                        --  Object.Call_In_Progress.Param
--                   exception
--                      when others =>
--                         Task_Timer_Service.Timer.Service_Entries;
--                         raise;
                     --  Neither Requeue nor Service_Entries should raise
                     --  an exception; the exception should be saved.
                     end;
               end case;
            exception
               when others =>
                  Exceptional_Complete_Entry_Body (
                        Object => To_Access (Object'Address),
                        Ex => Current_Exception,
                        Pending_Serviced => PS);
            end;
            Cumulative_PS := Cumulative_PS or PS;
         end loop;
         Pending_Serviced := Cumulative_PS;
      end Service_Entries;

   begin
      Initialize_Protection (
            To_Access (Object'Address),
            Task_Stages.Unspecified_Priority);
   end Delay_Until_Object;

end System.Real_Time.Delays;
