------------------------------------------------------------------------------
--                                                                          --
--                 GNU ADA RUNTIME LIBRARY (GNARL) COMPONENTS               --
--                                                                          --
--                               M a c h i n e                              --
--                                                                          --
--                                  B o d y                                 --
--                                                                          --
--                             $Revision: 1.2 $                            --
--                                                                          --
--           Copyright (c) 1991,1992,1993, FSU, All Rights Reserved         --
--                                                                          --
--  GNARL is free software; you can redistribute it and/or modify it  under --
--  terms  of  the  GNU  Library General Public License as published by the --
--  Free Software Foundation; either version 2, or (at  your  option)  any  --
--  later  version.   GNARL is distributed in the hope that it will be use- --
--  ful, but but WITHOUT ANY WARRANTY; without even the implied warranty of --
--  MERCHANTABILITY  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Gen- --
--  eral Library Public License for more details.  You should have received --
--  a  copy of the GNU Library General Public License along with GNARL; see --
--  file COPYING. If not, write to the Free Software Foundation,  675  Mass --
--  Ave, Cambridge, MA 02139, USA.                                          --
--                                                                          --
------------------------------------------------------------------------------

with Unchecked_Conversion;
with System.Task_Stages;

with System.Task_Abortion; use System.Task_Abortion;
with System.Task_Primitives; use System.Task_Primitives;
with System.Task_ATCB;

package body System.Machine is

   type Access_Boolean is access Boolean;
   function Address_To_Pointer is new
         Unchecked_Conversion (System.Address, Access_Boolean);

   Test_And_Set_Mutex : Lock;
   --  Use a mutex to simulate test-and-set.  This is ridiculously inefficient;
   --  it is just here so that I can fix the syntax errors without having to
   --  worry about how to get machine code into the system in the absense
   --  of machine code inserts.

   procedure Test_And_Set (
         Flag_Add : System.Address;
         Result : out Boolean) is
   --  Flag has to be a variable of type Boolean

   begin
      Write_Lock (Test_And_Set_Mutex);
      if not Address_To_Pointer (Flag_Add).all then
         Address_To_Pointer (Flag_Add).all := True;
         Unlock (Test_And_Set_Mutex);
         Result :=  True;
      else
         Unlock (Test_And_Set_Mutex);
         Result := False;
      end if;
   end Test_And_Set;

   procedure Wait_For_Activation (Target : Task_IDs.Task_ID) is
      T : Task_ATCB.ATCB_Ptr := Task_ATCB.ID_To_ATCB (Target);
   begin

      --  Abortion is deferred at this point as a result
      --  of ATCB initialization.

      Read_Lock (T.L);
      while Task_ATCB."/=" (T.Stage, Task_ATCB.Can_Activate) and then
            T.Pending_ATC_Level >= T.ATC_Nesting_Level loop
         Cond_Wait (T.Cond, T.L);
      end loop;
      Unlock (T.L);

      Undefer_Abortion;
   end Wait_For_Activation;
   pragma Inline (Wait_For_Activation);

   procedure Task_Wrapper (Arg : System.Address) is
      function Address_To_Task_ID is new
            Unchecked_Conversion (System.Address, Task_ATCB.ATCB_Ptr);
      T : Task_ATCB.ATCB_Ptr := Address_To_Task_ID (Arg);
   begin
      Wait_For_Activation (Task_ATCB.ATCB_To_ID (T));

      T.Task_Entry_Point (T.Task_Arg);
      --  Call the task body procedure.

      --  Return here after task finalization
      Defer_Abortion;

      Task_Stages.Leave_Task;
      --  This call won't be returned. Therefor no need for Undefer_Abortion
   end Task_Wrapper;

end System.Machine;
