------------------------------------------------------------------------------
--                                                                          --
--                GNU ADA RUNTIME LIBRARY (GNARL) COMPONENTS                --
--                                                                          --
--                   S Y S T E M . P O S I X _ E R R O R                    --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.3 $                              --
--                    (corresponds to FSU revision 1.13)                    --
--                                                                          --
--           Copyright (c) 1992,1993,1994 FSU, All Rights Reserved          --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------

--  This package contains those parts of the package POSIX defined in
--  P1003.5 (Ada binding to POSIX.1) needed to interface to Pthreads.

package System.POSIX_Error is

   type Return_Code is new Integer;

   Failure : constant Return_Code := -1;

   type Error_Code is new Integer;

   function errno return Error_Code;
   pragma Interface (C, errno);
   --  An interface to the error number of the current thread. This is
   --  updated by Pthreads at each context switch.

   --  Error number definitions.  These definitions are derived from
   --  /usr/include/errno.h and /usr/include/sys/errno.h.  These are SunOS
   --  errors; they have not yet been checked for POSIX complience.

   subtype EC is Error_Code;

   EPERM           : constant EC := 1;  -- Not owner
   ENOENT          : constant EC := 2;  -- No such file or directory
   ESRCH           : constant EC := 3;  -- No such process
   EINTR           : constant EC := 4;  -- Interrupted system call
   EIO             : constant EC := 5;  -- I/O error
   ENXIO           : constant EC := 6;  -- No such device or address
   E2BIG           : constant EC := 7;  -- Arg list too long
   ENOEXEC         : constant EC := 8;  -- Exec format error
   EBADF           : constant EC := 9;  -- Bad file number
   ECHILD          : constant EC := 10; -- No children
   EAGAIN          : constant EC := 11; -- No more processes
   ENOMEM          : constant EC := 12; -- Not enough core
   EACCES          : constant EC := 13; -- Permission denied
   EFAULT          : constant EC := 14; -- Bad address
   ENOTBLK         : constant EC := 15; -- Block device required
   EBUSY           : constant EC := 16; -- Mount device busy
   EEXIST          : constant EC := 17; -- File exists
   EXDEV           : constant EC := 18; -- Cross-device link
   ENODEV          : constant EC := 19; -- No such device
   ENOTDIR         : constant EC := 20; -- Not a directory
   EISDIR          : constant EC := 21; -- Is a directory
   EINVAL          : constant EC := 22; -- Invalid argument
   ENFILE          : constant EC := 23; -- File table overflow
   EMFILE          : constant EC := 24; -- Too many open files
   ENOTTY          : constant EC := 25; -- Not a typewriter
   ETXTBSY         : constant EC := 26; -- Text file busy
   EFBIG           : constant EC := 27; -- File too large
   ENOSPC          : constant EC := 28; -- No space left on device
   ESPIPE          : constant EC := 29; -- Illegal seek
   EROFS           : constant EC := 30; -- Read-only file system
   EMLINK          : constant EC := 31; -- Too many links
   EPIPE           : constant EC := 32; -- Broken pipe
   EDOM            : constant EC := 33; -- Argument too large
   ERANGE          : constant EC := 34; -- Result too large
   EWOULDBLOCK     : constant EC := 35; -- Operation would block
   EINPROGRESS     : constant EC := 36; -- Operation now in progress
   EALREADY        : constant EC := 37; -- Operation already in progress
   ENOTSOCK        : constant EC := 38; -- Socket operation on non-socket
   EDESTADDRREQ    : constant EC := 39; -- Destination address required
   EMSGSIZE        : constant EC := 40; -- Message too long
   EPROTOTYPE      : constant EC := 41; -- Protocol wrong type for socket
   ENOPROTOOPT     : constant EC := 42; -- Protocol not available
   EPROTONOSUPPORT : constant EC := 43; -- Protocol not supported
   ESOCKTNOSUPPORT : constant EC := 44; -- Socket type not supported
   EOPNOTSUPP      : constant EC := 45; -- Operation not supported on socket
   EPFNOSUPPORT    : constant EC := 46; -- Protocol family not supported
   EAFNOSUPPORT    : constant EC := 47; -- Addr family unsupported by protocol
   EADDRINUSE      : constant EC := 48; -- Address already in use
   EADDRNOTAVAIL   : constant EC := 49; -- Can't assign requested address
   ENETDOWN        : constant EC := 50; -- Network is down
   ENETUNREACH     : constant EC := 51; -- Network is unreachable
   ENETRESET       : constant EC := 52; -- Network dropped connection on reset
   ECONNABORTED    : constant EC := 53; -- Software caused connection abort
   ECONNRESET      : constant EC := 54; -- Connection reset by peer
   ENOBUFS         : constant EC := 55; -- No buffer space available
   EISCONN         : constant EC := 56; -- Socket is already connected
   ENOTCONN        : constant EC := 57; -- Socket is not connected
   ESHUTDOWN       : constant EC := 58; -- Can't send after socket shutdown
   ETOOMANYREFS    : constant EC := 59; -- Too many references: can't splice
   ETIMEDOUT       : constant EC := 60; -- Connection timed out
   ECONNREFUSED    : constant EC := 61; -- Connection refused
   ELOOP           : constant EC := 62; -- Too many levels of symbolic links
   ENAMETOOLONG    : constant EC := 63; -- File name too long
   EHOSTDOWN       : constant EC := 64; -- Host is down
   EHOSTUNREACH    : constant EC := 65; -- No route to host
   ENOTEMPTY       : constant EC := 66; -- Directory not empty
   EPROCLIM        : constant EC := 67; -- Too many processes
   EUSERS          : constant EC := 68; -- Too many users
   EDQUOT          : constant EC := 69; -- Disc quota exceeded
   ESTALE          : constant EC := 70; -- Stale NFS file handle
   EREMOTE         : constant EC := 71; -- Too many levels of remote in path
   ENOSTR          : constant EC := 72; -- Device is not a stream
   ETIME           : constant EC := 73; -- Timer expired
   ENOSR           : constant EC := 74; -- Out of streams resources
   ENOMSG          : constant EC := 75; -- No message of desired type
   EBADMSG         : constant EC := 76; -- Trying to read unreadable message
   EIDRM           : constant EC := 77; -- Identifier removed
   EDEADLK         : constant EC := 78; -- Deadlock condition.
   ENOLCK          : constant EC := 79; -- No record locks available.
   ENONET          : constant EC := 80; -- Machine is not on thenetwork
   ERREMOTE        : constant EC := 81; -- Object is remote
   ENOLINK         : constant EC := 82; -- the link has been severed
   EADV            : constant EC := 83; -- advertise error
   ESRMNT          : constant EC := 84; -- srmount error
   ECOMM           : constant EC := 85; -- Communication error on send
   EPROTO          : constant EC := 86; -- Protocol error
   EMULTIHOP       : constant EC := 87; -- multihop attempted
   EDOTDOT         : constant EC := 88; -- Cross mount point (not an error)
   EREMCHG         : constant EC := 89; -- Remote address changed
   ENOSYS          : constant EC := 90; -- function not implemented

   ENOTSUP : constant EC := ENOSYS + 1;
   --  Generic value for unsupported error code

end System.POSIX_Error;
