------------------------------------------------------------------------------
--                                                                          --
--                GNU ADA RUNTIME LIBRARY (GNARL) COMPONENTS                --
--                                                                          --
--                      S Y S T E M . A B O R T I O N                       --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.3 $                              --
--                    (corresponds to FSU revision 1.6)                     --
--                                                                          --
--           Copyright (c) 1992,1993,1994 FSU, All Rights Reserved          --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------

with System.Task_IDs;   use System.Task_IDs;
with System.Primitives; use System.Primitives;
with System.Machine_Specifics;

package System.Abortion is

   Max_ATC_Nesting : constant Natural := 20;

   subtype ATC_Level_Base is Integer range 0 .. Max_ATC_Nesting;

   ATC_Level_Infinity : constant ATC_Level_Base := ATC_Level_Base'LAST;

   subtype ATC_Level is ATC_Level_Base range
     ATC_Level_Base'FIRST .. ATC_Level_Base'Last - 1;

   subtype ATC_Level_Index is ATC_Level range
     ATC_Level'First + 1 .. ATC_Level'Last;

   Abort_Signal : exception;

   type Task_List is array (Positive range <>) of Task_ID;

   procedure Abort_Tasks (Tasks : Task_List);
   --  Abort_Tasks is called to initiate abortion, however, the actual
   --  abortion is done by abortee by means of Abort_Handler

   -------------------------------
   -- RTS Internal Declarations --
   -------------------------------

   procedure Defer_Abortion;
   pragma Inline (Defer_Abortion);

   procedure Undefer_Abortion;
   pragma Inline (Undefer_Abortion);

   procedure Abort_To_Level (Target : Task_ID; L : ATC_Level);

   procedure Abort_Handler (Context : Machine_Specifics.Pre_Call_State);

   procedure Abort_Dependents (Abortee : Task_ID);

end System.Abortion;
