------------------------------------------------------------------------------
--                                                                          --
--                         GNAT COMPILER COMPONENTS                         --
--                                                                          --
--                         I N T E R F A C E S . C                          --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.2 $                              --
--                                                                          --
--           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------

package Interfaces.C is

   pragma Pure;

   --  Declaration's based on C's <limits.h>

   CHAR_BIT  : constant := 8;
   SCHAR_MIN : constant := -128;
   SCHAR_MAX : constant := 127;
   UCHAR_MAX : constant := 255;

   --  Signed and Unsigned Integers. Note that in GNAT, we have ensured that
   --  the standard predefined Ada types correspond to the standard C types

   type Int   is new Integer;
   type Short is new Short_Integer;
   type Long  is new Long_Integer;

   type Signed_Char is range SCHAR_MIN .. SCHAR_MAX;
   for Signed_Char'Size use CHAR_BIT;

   type Unsigned       is mod 2 ** Integer'Size;
   type Unsigned_Short is mod 2 ** Short_Integer'Size;
   type Unsigned_Long  is mod 2 ** Long_Integer'Size;

   type Unsigned_Char is mod (UCHAR_MAX + 1);
   for Unsigned_Char'Size use CHAR_BIT;

   subtype Plain_Char is Unsigned_Char; -- ??? should be parametrized

   type Ptrdiff_T is new Integer;       -- ??? should be parametrized

   type Size_T is mod 2 ** 32;          -- ??? should be parametrized

   --  Floating-Point

   type Float       is new Standard.Float;
   subtype C_Float  is Float;

   type Double      is new Standard.Long_Float;

   type Long_Double is new Standard.Long_Long_Float;

   --  Characters and Strings

   type Char is new Character;

   Nul : constant Char := Char'First;

   Ada_To_C : constant array (Character) of Char := (
     Char'Val (000), Char'Val (001), Char'Val (002), Char'Val (003),
     Char'Val (004), Char'Val (005), Char'Val (006), Char'Val (007),
     Char'Val (008), Char'Val (009), Char'Val (010), Char'Val (011),
     Char'Val (012), Char'Val (013), Char'Val (014), Char'Val (015),
     Char'Val (016), Char'Val (017), Char'Val (018), Char'Val (019),
     Char'Val (020), Char'Val (021), Char'Val (022), Char'Val (023),
     Char'Val (024), Char'Val (025), Char'Val (026), Char'Val (027),
     Char'Val (028), Char'Val (029), Char'Val (030), Char'Val (031),
     Char'Val (032), Char'Val (033), Char'Val (034), Char'Val (035),
     Char'Val (036), Char'Val (037), Char'Val (038), Char'Val (039),
     Char'Val (040), Char'Val (041), Char'Val (042), Char'Val (043),
     Char'Val (044), Char'Val (045), Char'Val (046), Char'Val (047),
     Char'Val (048), Char'Val (049), Char'Val (050), Char'Val (051),
     Char'Val (052), Char'Val (053), Char'Val (054), Char'Val (055),
     Char'Val (056), Char'Val (057), Char'Val (058), Char'Val (059),
     Char'Val (060), Char'Val (061), Char'Val (062), Char'Val (063),
     Char'Val (064), Char'Val (065), Char'Val (066), Char'Val (067),
     Char'Val (068), Char'Val (069), Char'Val (070), Char'Val (071),
     Char'Val (072), Char'Val (073), Char'Val (074), Char'Val (075),
     Char'Val (076), Char'Val (077), Char'Val (078), Char'Val (079),
     Char'Val (080), Char'Val (081), Char'Val (082), Char'Val (083),
     Char'Val (084), Char'Val (085), Char'Val (086), Char'Val (087),
     Char'Val (088), Char'Val (089), Char'Val (090), Char'Val (091),
     Char'Val (092), Char'Val (093), Char'Val (094), Char'Val (095),
     Char'Val (096), Char'Val (097), Char'Val (098), Char'Val (099),
     Char'Val (100), Char'Val (101), Char'Val (102), Char'Val (103),
     Char'Val (104), Char'Val (105), Char'Val (106), Char'Val (107),
     Char'Val (108), Char'Val (109), Char'Val (110), Char'Val (111),
     Char'Val (112), Char'Val (113), Char'Val (114), Char'Val (115),
     Char'Val (116), Char'Val (117), Char'Val (118), Char'Val (119),
     Char'Val (120), Char'Val (121), Char'Val (122), Char'Val (123),
     Char'Val (124), Char'Val (125), Char'Val (126), Char'Val (127),
     Char'Val (128), Char'Val (129), Char'Val (130), Char'Val (131),
     Char'Val (132), Char'Val (133), Char'Val (134), Char'Val (135),
     Char'Val (136), Char'Val (137), Char'Val (138), Char'Val (139),
     Char'Val (140), Char'Val (141), Char'Val (142), Char'Val (143),
     Char'Val (144), Char'Val (145), Char'Val (146), Char'Val (147),
     Char'Val (148), Char'Val (149), Char'Val (150), Char'Val (151),
     Char'Val (152), Char'Val (153), Char'Val (154), Char'Val (155),
     Char'Val (156), Char'Val (157), Char'Val (158), Char'Val (159),
     Char'Val (160), Char'Val (161), Char'Val (162), Char'Val (163),
     Char'Val (164), Char'Val (165), Char'Val (166), Char'Val (167),
     Char'Val (168), Char'Val (169), Char'Val (170), Char'Val (171),
     Char'Val (172), Char'Val (173), Char'Val (174), Char'Val (175),
     Char'Val (176), Char'Val (177), Char'Val (178), Char'Val (179),
     Char'Val (180), Char'Val (181), Char'Val (182), Char'Val (183),
     Char'Val (184), Char'Val (185), Char'Val (186), Char'Val (187),
     Char'Val (188), Char'Val (189), Char'Val (190), Char'Val (191),
     Char'Val (192), Char'Val (193), Char'Val (194), Char'Val (195),
     Char'Val (196), Char'Val (197), Char'Val (198), Char'Val (199),
     Char'Val (200), Char'Val (201), Char'Val (202), Char'Val (203),
     Char'Val (204), Char'Val (205), Char'Val (206), Char'Val (207),
     Char'Val (208), Char'Val (209), Char'Val (210), Char'Val (211),
     Char'Val (212), Char'Val (213), Char'Val (214), Char'Val (215),
     Char'Val (216), Char'Val (217), Char'Val (218), Char'Val (219),
     Char'Val (220), Char'Val (221), Char'Val (222), Char'Val (223),
     Char'Val (224), Char'Val (225), Char'Val (226), Char'Val (227),
     Char'Val (228), Char'Val (229), Char'Val (230), Char'Val (231),
     Char'Val (232), Char'Val (233), Char'Val (234), Char'Val (235),
     Char'Val (236), Char'Val (237), Char'Val (238), Char'Val (239),
     Char'Val (240), Char'Val (241), Char'Val (242), Char'Val (243),
     Char'Val (244), Char'Val (245), Char'Val (246), Char'Val (247),
     Char'Val (248), Char'Val (249), Char'Val (250), Char'Val (251),
     Char'Val (252), Char'Val (253), Char'Val (254), Char'Val (255));

   C_To_Ada : array (Char) of Character := (
     Character'Val (000), Character'Val (001), Character'Val (002),
     Character'Val (003), Character'Val (004), Character'Val (005),
     Character'Val (006), Character'Val (007), Character'Val (008),
     Character'Val (009), Character'Val (010), Character'Val (011),
     Character'Val (012), Character'Val (013), Character'Val (014),
     Character'Val (015), Character'Val (016), Character'Val (017),
     Character'Val (018), Character'Val (019), Character'Val (020),
     Character'Val (021), Character'Val (022), Character'Val (023),
     Character'Val (024), Character'Val (025), Character'Val (026),
     Character'Val (027), Character'Val (028), Character'Val (029),
     Character'Val (030), Character'Val (031), Character'Val (032),
     Character'Val (033), Character'Val (034), Character'Val (035),
     Character'Val (036), Character'Val (037), Character'Val (038),
     Character'Val (039), Character'Val (040), Character'Val (041),
     Character'Val (042), Character'Val (043), Character'Val (044),
     Character'Val (045), Character'Val (046), Character'Val (047),
     Character'Val (048), Character'Val (049), Character'Val (050),
     Character'Val (051), Character'Val (052), Character'Val (053),
     Character'Val (054), Character'Val (055), Character'Val (056),
     Character'Val (057), Character'Val (058), Character'Val (059),
     Character'Val (060), Character'Val (061), Character'Val (062),
     Character'Val (063), Character'Val (064), Character'Val (065),
     Character'Val (066), Character'Val (067), Character'Val (068),
     Character'Val (069), Character'Val (070), Character'Val (071),
     Character'Val (072), Character'Val (073), Character'Val (074),
     Character'Val (075), Character'Val (076), Character'Val (077),
     Character'Val (078), Character'Val (079), Character'Val (080),
     Character'Val (081), Character'Val (082), Character'Val (083),
     Character'Val (084), Character'Val (085), Character'Val (086),
     Character'Val (087), Character'Val (088), Character'Val (089),
     Character'Val (090), Character'Val (091), Character'Val (092),
     Character'Val (093), Character'Val (094), Character'Val (095),
     Character'Val (096), Character'Val (097), Character'Val (098),
     Character'Val (099), Character'Val (100), Character'Val (101),
     Character'Val (102), Character'Val (103), Character'Val (104),
     Character'Val (105), Character'Val (106), Character'Val (107),
     Character'Val (108), Character'Val (109), Character'Val (110),
     Character'Val (111), Character'Val (112), Character'Val (113),
     Character'Val (114), Character'Val (115), Character'Val (116),
     Character'Val (117), Character'Val (118), Character'Val (119),
     Character'Val (120), Character'Val (121), Character'Val (122),
     Character'Val (123), Character'Val (124), Character'Val (125),
     Character'Val (126), Character'Val (127), Character'Val (128),
     Character'Val (129), Character'Val (130), Character'Val (131),
     Character'Val (132), Character'Val (133), Character'Val (134),
     Character'Val (135), Character'Val (136), Character'Val (137),
     Character'Val (138), Character'Val (139), Character'Val (140),
     Character'Val (141), Character'Val (142), Character'Val (143),
     Character'Val (144), Character'Val (145), Character'Val (146),
     Character'Val (147), Character'Val (148), Character'Val (149),
     Character'Val (150), Character'Val (151), Character'Val (152),
     Character'Val (153), Character'Val (154), Character'Val (155),
     Character'Val (156), Character'Val (157), Character'Val (158),
     Character'Val (159), Character'Val (160), Character'Val (161),
     Character'Val (162), Character'Val (163), Character'Val (164),
     Character'Val (165), Character'Val (166), Character'Val (167),
     Character'Val (168), Character'Val (169), Character'Val (170),
     Character'Val (171), Character'Val (172), Character'Val (173),
     Character'Val (174), Character'Val (175), Character'Val (176),
     Character'Val (177), Character'Val (178), Character'Val (179),
     Character'Val (180), Character'Val (181), Character'Val (182),
     Character'Val (183), Character'Val (184), Character'Val (185),
     Character'Val (186), Character'Val (187), Character'Val (188),
     Character'Val (189), Character'Val (190), Character'Val (191),
     Character'Val (192), Character'Val (193), Character'Val (194),
     Character'Val (195), Character'Val (196), Character'Val (197),
     Character'Val (198), Character'Val (199), Character'Val (200),
     Character'Val (201), Character'Val (202), Character'Val (203),
     Character'Val (204), Character'Val (205), Character'Val (206),
     Character'Val (207), Character'Val (208), Character'Val (209),
     Character'Val (210), Character'Val (211), Character'Val (212),
     Character'Val (213), Character'Val (214), Character'Val (215),
     Character'Val (216), Character'Val (217), Character'Val (218),
     Character'Val (219), Character'Val (220), Character'Val (221),
     Character'Val (222), Character'Val (223), Character'Val (224),
     Character'Val (225), Character'Val (226), Character'Val (227),
     Character'Val (228), Character'Val (229), Character'Val (230),
     Character'Val (231), Character'Val (232), Character'Val (233),
     Character'Val (234), Character'Val (235), Character'Val (236),
     Character'Val (237), Character'Val (238), Character'Val (239),
     Character'Val (240), Character'Val (241), Character'Val (242),
     Character'Val (243), Character'Val (244), Character'Val (245),
     Character'Val (246), Character'Val (247), Character'Val (248),
     Character'Val (249), Character'Val (250), Character'Val (251),
     Character'Val (252), Character'Val (253), Character'Val (254),
     Character'Val (255));

   type Char_Array is array (Natural range <>) of Char;
   pragma Pack (Char_Array);

   for Char_Array'Component_Size use CHAR_BIT;

   function To_C (Item       : in String;
                  Append_Nul : in Boolean := True)
      return Char_Array;

   function To_Ada (Item     : in Char_Array;
                    Trim_Nul : in Boolean := True)
      return String;

   procedure To_C (Item       : in String;
                   Target     : out Char_Array;
                   Last       : out Integer;
                   Append_Nul : in Boolean := True);

   procedure To_Ada (Item     : in Char_Array;
                     Target   : out String;
                     Last     : out Natural;
                     Trim_Nul : in Boolean := True);

   --  Wide Character and Wide String

   type WChar_T is new Wide_Character;

   Wide_Nul : constant WChar_T := WChar_T'First;

   function To_C (Item : in Wide_Character) return WChar_T;

   function To_Ada (Item : in WChar_T) return Wide_Character;

   type Wide_Char_Array is array (Natural range <>)  of WChar_T;

   pragma Pack (Wide_Char_Array);

   function To_C   (Item       : in Wide_String;
                    Append_Nul : in Boolean := True)
     return Wide_Char_Array;

   function To_Ada (Item     : in Wide_Char_Array;
                    Trim_Nul : in Boolean := True)
     return Wide_String;

   procedure To_C (Item       : in Wide_String;
                   Target     : out Wide_Char_Array;
                   Last       : out Integer;
                   Append_Nul : in Boolean := True);

   procedure To_Ada (Item     : in Wide_Char_Array;
                     Target   : out Wide_String;
                     Last     : out Natural;
                     Trim_Nul : in Boolean := True);

   Unterminated : exception;

end Interfaces.C;
