with Instr; use Instr;
with Instr.Child; use Instr.Child;
with Io; use Io;
with Gen_List;
procedure Demo2 is 

   type Acc is access Instrument'Class;
    
   package Dash_Board is new Gen_List (Acc);
   use Dash_Board;
   
   procedure Print_Dash_Board (L : List) is
      L1 : List := L;
   begin

      while L1 /= Nil loop
         Display_Value (Element (L1).all);
         L1 := Tail (L1);
      end loop;
      New_Line;
      
   end Print_Dash_Board;


   Speed : aliased Speedometer;
   Fuel : aliased Gauge;
   Oil, Water : aliased Graphic_Gauge;
   Time : aliased Clock;
   Chrono : aliased Chronometer;
   Time2 : Accurate_Clock;

   DB : List := Nil;
   
   Inc, Sec : Integer;
   
begin
   Speed.Name    := "Speed               ";
   Fuel.Name     := "Fuel                ";   
   Water.Name    := "Water               ";
   Oil.Name      := "Oil                 ";
   Time.Name     := "Time in NY          ";
   Chrono.Name   := "Chronometer         ";
   Time2.Name    := "Time in Paris       ";

   Speed.Value := 45; --  mph
   Fuel.Value := 60; --  %   
   Water.Value := 80; -- %
   Oil.Value := 40; --  %   
   Init (Time, 12, 15, 00);
   Init (Chrono, 0, 0, 0);
   Init (Time2,  6, 15, 0);
   
   DB := Append   (Acc (Speed'Access), 
           Append (Acc (Fuel'Access), 
           Append (Acc (Water'Access),
           Append (Acc (Oil'Access),
           Append (Acc (Time'Access), 
           Append (Acc (Time2'Access), Acc (Chrono'Access)))))));

   loop
      Print_Dash_board (DB);
      
      if Water.Value < 60 then 
         Put_Line ("There is a leak in the radiator."); 
      end if;
      if Speed.Value > 50 then 
         Put_Line (" Speed limit is 50 ... "); 
      end if;
      
      if Time.Seconds /= Time2.Seconds then
         Put_Line (" Your first clock is not very accurate ");       
      end if;
      
      Put ("Give a time increment in milliseconds (0 to terminate) :");
      Get (Inc);
      exit when Inc <= 0;
      Sec := Inc / 1000;
      Increment (Time, Sec);
      Increment (Chrono, Sec);
      Increment (Time2, Inc);
      Fuel.Value := Integer 
        (Float (Fuel.Value) * (1.0 - Float (Sec) / 3600.0));
      Water.Value := Integer 
        (Float (Water.Value) * (1.0 - Float (Sec) / 600.0));
      Speed.Value := Speed.Value + 1;
   end loop;
end Demo2;

