/*****************************************************************
 * uunet2fbm.c: FBM Release 1.0 25-Feb-90 Michael Mauldin
 *
 * uunet2fbm.c: convert a bitmap to Targa format
 *
 * USAGE
 *      % uunet2fbm [ image ] > image.fbm
 *
 * EDITLOG
 *	LastEditDate = Mon Jun 25 00:09:49 1990 - Michael Mauldin
 *	LastFileName = /usr2/mlm/src/misc/fbm/flgifc.c
 *
 * HISTORY
 * 25-Jun-90  Michael Mauldin (mlm@cs.cmu.edu) Carnegie Mellon
 *	Package for Release 1.0
 *
 * 16-Aug-89  Anders (klemets@sics.se)
 *	Bug fix (width not mult of 8) by 
 *
 * 05-Jul-89 Dan Sahlin (dan@sics.se) at SICS
 *	Created from a copy of pic2fbm
 *****************************************************************/

# include <stdio.h>
# include "fbm.h"

#ifndef lint
static char *fbmid =
"$FBM fluun.c <1.0> written by Dan Sahlin, source code available \
free from MLM@CS.CMU.EDU and from UUNET archives$";
#endif

/*
 * read_uunet(image, rfile, mstr, mlen)
 */

#define FROMHEX(x) ((x>='a')?(x-'a'+10):((x>='A')?(x-'A'+10):(x-'0')))

read_uunet(image, rfile, mstr, mlen)
FBM *image;
FILE *rfile;
char *mstr;
int mlen;
{
unsigned int		Width, Height, Bits;
unsigned int		Imwidth, Imheight, Imbits;
int			i,j;
unsigned char           *Red;
int                     ch,ch2;
char			buf[80],credits[80],title[160];


	/* parse the header lines */
	buf[0] = credits[0] = title[0] = '\0';
	do {
		fgets(buf, 80, rfile);
		if (!strncmp("PicData:", buf, 8))
			sscanf(&buf[8],"%d%d%d", &Width, &Height, &Bits);
		if (!strncmp("Image:", buf, 6))
			sscanf(&buf[6], "%d%d%d", &Imwidth, &Imheight, &Imbits);
		if (!strncmp("FirstName:", buf, 10)) {
			sscanf(&buf[10],"%s", title);
			strcat(title," ");
		}
		if (!strncmp("LastName:", buf, 9))
			sscanf(&buf[9],"%s", &title[strlen(title)]);
		if (!strncmp("E-Mail:", buf, 7))
			sscanf(&buf[7],"%s", credits);
		
	} while(strlen(buf) && buf[0] != '\n');

/* Create output image header */
	image->hdr.rows = Height;
	image->hdr.cols = Width;
	/* If this is odd number of bytes, add one */
	if ((image->hdr.cols & 1) != 0) image->hdr.cols++;
	image->hdr.planes = 1;
	image->hdr.bits = Bits;
	image->hdr.physbits = Bits;
	image->hdr.rowlen = image->hdr.cols;
	image->hdr.plnlen = (image->hdr.rows/8+1)*8 * image->hdr.cols;
	image->hdr.clrlen = 0;
	image->hdr.aspect = Width / Imwidth;
	strcpy(image->hdr.title,title);
	strcpy(image->hdr.credits,credits);

/* Get the Image */
	alloc_fbm(image);

	Red = image->bm;
	for (i=Height-1; i>=0; i--)
	{
		for (j=0; j< Width; j++)
		{
			while((ch = getc(rfile))=='\n')
				;
			ch2 = getc(rfile);
			*(Red+j+Width*i) = (FROMHEX(ch)*16)+FROMHEX(ch2);
		}
	}
	return 1;
}
