/*

  General Include-File for GRAV 1.0                 (C) Michael Knigge, 1994

*/

#ifdef MAIN
#define EXTERN
#else
#define EXTERN extern
#endif

#ifdef KEY_ENTER                                       /* Aus der NCurses.h */
#undef KEY_ENTER                 /* In der NCurses.h ist ne andere Belegung */
#endif

#define CURSOR_INVISIBLE    0                                /* Cursor aus */
#define CURSOR_NORMAL       1                           /* Normaler Cursor */
#define CURSOR_BOLD         2                           /* "Dicker" Cursor */
#define DIRSIZE          1000       /* Maximal 1000 Eintraege je Directory */
#define FILE                0 
#define DIRECTORY           1
#define RECHTS             29            /* Rechte Position im File-Window */
#define LINKS               6             /* Linke Position im File-Window */
#define KEY_ENTER          10                               /* ENTER-Taste */
#define MAX_MODES          11                     /* Anzahl der Videomodes */
#define MAX_CARDS           7                   /* Anzahl der Grafikkarten */
#define NO_ERROR            0               /* Kein Fehler ist aufgetreten */
#define ERROR_TYP           1                /* Fehler beim Lesen des Typs */
#define ERROR_OPEN          2                          /* Fehler beim OPEN */
#define ERROR_HEADER        3             /* Fehler beim Lesen des Headers */
#define ERROR_PALETTE       5             /* Fehler beim Lesen der Palette */
#define ERROR_ALLOC         6                      /* Fehler beim malloc() */
#define ERROR_READ          7               /* Fehler beim Lesen der Daten */
#define ERROR_SUPPORT       8             /* Grafikmode nicht unterstuetzt */
#define BLANK60             "                                                           "

WINDOW *StdScr;           /* Der gesamte Bildschirm (Rueckgabe v. initscr) */     

struct GDIR                            /* Struktur fuer Directoryeintraege */
{
   char DirEintrag [256];                 /* Name des Files bzw. Directory */
   char DirOrFile;                                 /* 0=Datei, 1=Directory */
   char Tagged;                                    /* Ist Datei getagged ? */
}  GRAVDIR [DIRSIZE];

struct GRAVCARDS              /* Struktuer fuer unterstuetzte Grafikkarten */
{
   char Adapter[15];                                     /* Name der Karte */
}  GCARD [8];   

struct GRAVMODES                /* Struktur fuer unterstuetzte Grafikmodes */
{
   char Mode[15];
   int  ModeIndex;                             /* Index (define aus vga.h) */
   int  Width;                                   /* Horizontale Aufloesung */
   int  Heigh;                                     /* Vertikale Aufloesung */
}  GMODE [12];

EXTERN int GRAVDIREintraege;         /* Anzahl der Eintraege in der GARVDIR */
EXTERN int Farbe;                        /* Koennen Farben verwendet werden */
EXTERN int Quit;                                       /* Quit ja oder nein */
EXTERN int MaxRechts; /* Anzahl der Eintraege im rechten Teil des Directory */
EXTERN int MaxLinks;   /* Anzahl der Eintraege im linken Teil des Directory */
EXTERN int CardRC;                               /* Grafikkarte aus .gravrc */
EXTERN int ModeRC;                                 /* Videomode aus .gravrc */
EXTERN int SecondWin;                /* Ist zweites Fenster auf dem Screen? */
EXTERN int GBM_RC;                                    /* Returncode vom GBM */
EXTERN int DirEntry;         /* Eintrag, ab dem das akt. Dir angezeigt wird */
EXTERN int GBM_RC;                                    /* Returncode vom GBM */
EXTERN int GBM_Typ;                                             /* File-Typ */
EXTERN int GBM_File;                           /* Geoeffnete Datei fuer GBM */

EXTERN long BitmapSize;                              /* Groesse des Bitmaps */

EXTERN char *Bitmap;                                   /* Zeiger auf Bitmap */
EXTERN char *ScreenLine;                  /* Zeiger auf einzelne Pixelzeile */

EXTERN GBM gbm;                                                /* GBM-Daten */
EXTERN GBMRGB gbmrgb [0x100];                                /* RGB-Palette */
EXTERN GBMFT gbmft;                                        /* GBM-Filetypes */