/*****************************************************************************/
/*									     */
/*									     */
/*	X patience - buttons.c						     */
/*									     */
/*	written by Heiko Eissfeldt and Michael Bischoff			     */
/*									     */
/*	24-Feb-1993: First release (0.1)				     */
/*									     */
/*									     */
/*****************************************************************************/
#include "xpat.h"
#include "xpatx11.h"


static void do_confirm(void)
{   confirm.result = YES;
}

static void do_cancel(void)
{   confirm.result = NO;
}

static void do_save_game(void)
{   save_game(NULL);
}

#ifdef DEBUG
static void debugout(void)
{   int i, j;
    static const char *vis[2] = { "hidden ", "" };

    printf("Debugging output:\ngame.ind[] = \n{");
    for (i = 0; i <= game.numpiles; ++i)
	printf(" %d", game.ind[i]);
    printf(" }\n");
    for (i = 0; i < game.numpiles; ++i) {
	printf((i < rules.numstacks ? "Stack %d: " : "Slot %d: "),
	       (i < rules.numstacks ? i : i - rules.numstacks));
	for (j = game.ind[i]; j < game.ind[i+1]; ++j)
	    if (IS_JOKER(game.cards[j]))
		printf("Joker!");
	    else
		printf("%s%s %s at %d  ", vis[game.visible[j]],
		rank_name(RANK(game.cards[j])),
		suit_name(SUIT(game.cards[j])),
		graphic.cardy[j]);
	printf("\n");
    }
}
#endif

struct buttons button = {
    0,
    4, 4,
    3, 3,
    0, 0, 0,
    {
	{ 0, 0, 0, 0, "quit",	  	leave_pat, leave_pat, leave_pat },
	{ 0, 0, 0, 0, "cards",	  	try_give_cards,   try_give_cards,   try_give_cards },
	{ 0, 0, 0, 0, "undo",	  	try_undo_move,    try_undo_move,    try_undo_move },
	{ 0, 0, 0, 0, "redo",	  	try_redo_move,    try_redo_move,    try_redo_move },
	{ 0, 0, 0, 0, "restart",  	do_restart_game,  NULL, NULL },
	{ 0, 0, 0, 0, "new game", 	do_another_game,  NULL, NULL },
	{ 0, 0, 0, 0, "score",	        show_score,       show_score,       show_score },
	{ 0, 0, 0, 0, "hint",      	do_give_hints,    do_last_hint,     do_give_prev_hint },
	{ 0, 0, 0, 0, "move to stack", 	do_move_to_stack, do_move_to_stack, do_move_to_stack },
	{ 0, 0, 0, 0, "replay",		do_replay_game,	  NULL, NULL },
	{ 0, 0, 0, 0, "save",		do_save_game,	  NULL, NULL },
#ifdef DEBUG
	{ 0, 0, 0, 0, "debug",		debugout,	  NULL, NULL },
#endif
	{ 0, 0, 0, 0, NULL, NULL, NULL, NULL }
    }
};

struct singlebutton confirmbuttons[3] = {
	{ 0, 0, 0, 0, "confirm",  do_confirm, NULL, NULL },
	{ 0, 0, 0, 0, "cancel",	  do_cancel, NULL, NULL },
	{ 0, 0, 0, 0, NULL, NULL, NULL, NULL }
};

struct confirm confirm = { 0 };


void leave_pat(void)
{   if (confirm.request != NONE)      /* request pending? */
	return;
    confirm.request = QUIT_GAME;
    XMapWindow(dpy, confirm.win);
    confirm.result = UNDEFINED;
}

void do_another_game(void)
{   if (confirm.request != NONE)      /* request pending? */
	return;
    confirm.request = ANOTHER_GAME;
    XMapWindow(dpy, confirm.win);
    confirm.result = UNDEFINED;
}

void do_restart_game(void)
{   int moves;

    if (confirm.request != NONE)	/* request pending? */
	return;
    confirm.request = RESTART_GAME;
    confirm.result = YES;		/* no confirm, since undo possible */
					/* must mark it, for event_loop to */
					/* generate expose-events. */
    moves = game.n_moves;
    newgame(game.seed);
    game.stored_moves = moves; 
}

void do_layout(void)
{   int i;
    init_layout();
    for (i = FIRST_SLOT; i <= LAST_SLOT; ++i)
	if (pile_resize(i))
	    draw_pileupdate(i, 0);
}

void show_score(void)
{   char buf[512];
    sprintf(buf, "Seed is %ld, cheat count %d, moves = %d",
	game.seed, game.cheat_count, game.n_moves);
    if (rules.maxscore)
	sprintf(buf+strlen(buf), ", score %d of %d",
	(*rules.score)(), rules.maxscore);
    else
	sprintf(buf+strlen(buf), ", (no score in these rules)");
    if (CARDS_ON_DECK)
	sprintf(buf+strlen(buf), "   %d cards left on deck", CARDS_ON_DECK);
    show_message(buf);
}

void try_give_cards(void)
{
    hint(RESET_HINTS);
    if (game.srcind >= 0) {
	show_mark(False);
	game.srcind = -1;
    }

    if (EMPTY(IDECK) && (rules.variant & DECK_SOURCE)) {
	/* try a flip */
	if (game.flipnum == rules.numflips)
	    show_message("no flip left");
	else {
	    store_move(give_new_cards());
	    show_message("flipping");
	}
    } else {
	if ((*rules.new_cards)()) {
	    show_message("new cards");
	    store_move(give_new_cards());
	} else
	    show_message("no new cards!");
    }
}


