/*  save.c

    Copyright (C) 1994	Lambert Klasen & Detlef Steuer
			klasen@asterix.uni-muenster.de
			steuer@amadeus.statistik.uni-dortmund.de

    This file is free source code; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
    COPYING for more details.
 */



/*$Id: save.c,v 1.1 1994/08/01 20:14:29 gammon Exp gammon $*/

#include <stdio.h>
#include <X11/Intrinsic.h>

#include "xgammon.h"
#include "gammon.h"

typedef long XawTextPosition;

extern int test_move();
extern void AppendDialogText();
extern char *DialogText;
extern XawTextPosition TextGetLastPos();
extern Widget text_display;
extern void print_dialog_text();
extern void load_position();
extern void PopupInfoShell();

extern Widget text_display;
extern int done_yet;

void save(w, e, vector, count)
    Widget      w;
    XEvent      *e;
    String      *vector;
    Cardinal    *count;
{
FILE *save_file;
char *filename = "xgammon.save";
int i;
char kind;

if (done_yet) {
	PopupInfoShell("Please don't move before saving");
	return;
}

if      (*vector[0] == 'p') kind = 'p';
else if (*vector[0] == 'g') kind = 'g';
else if (*vector[0] == 'm') {
	kind = 'g';
	filename = vector[1];
}
else if (*vector[0] == 'r') {
	kind = 'g';
	filename = vector[1];
	fprintf(stderr," filename: %s\n", filename);
}

save_file = fopen(filename, "w");

if (!save_file) {
	AppendDialogText (text_display, "couldn't open save file!\nsorry!\n");
	return;
	}

if (kind == 'g') {

	print_dialog_text(save_file);

	if      (gammon_resource.moneygame) fprintf(save_file, "tournament: money-game\n");
	else if (gammon_resource.bestof)    fprintf(save_file, "tournament: best of %d\n", gammon_resource.bestof);
	else if (gammon_resource.winat)     fprintf(save_file, "tournament: win at %d points\n", gammon_resource.winat);

	fprintf(save_file, "white has %d points, black has %d points\n", tournament.points[WHITE], tournament.points[BLACK]);
	fprintf(save_file, "current game number %d\n", tournament.game_number);

	}

fprintf(save_file,"turn: ");

if (turn==BLACK) fprintf(save_file,"black\n");
else fprintf(save_file,"white\n");


fprintf(save_file,"dice values: %d %d\n", roll[0], roll[1]);
fprintf(save_file,"doubler value: %d\n", doubler_value);
fprintf(save_file,"last doubler: ");

if (last_doubler) {
	if (last_doubler == BLACK) fprintf(save_file,"black\n");
	else fprintf(save_file,"white\n");
	}
else {
	fprintf(save_file,"none\n");
	}

fprintf(save_file,"on bar: black: %d white: %d\n", Pin[0].count, Pin[25].count);

for (i=1; i<25; i++) {
	if (Pin[i].color == WHITE) fprintf(save_file,"pin %d: %d white men\n", i, Pin[i].count);
	if (Pin[i].color == BLACK) fprintf(save_file,"pin %d: %d black men\n", i, Pin[i].count);
	}

fclose(save_file);

}

void sig_save(w, e, vector, count)
    Widget      w;
    XEvent      *e;
    String      *vector;
    Cardinal    *count;
{
FILE *save_file;
int i;

save_file = fopen("xgammon.sig_save", "w");

if (!save_file) return;

fprintf(save_file,"turn: ");

if (turn==BLACK) fprintf(save_file,"black\n");
else fprintf(save_file,"white\n");


fprintf(save_file,"dice values: %d %d\n", roll[0], roll[1]);
fprintf(save_file,"doubler value: %d\n", doubler_value);
fprintf(save_file,"last doubler: ");

if (last_doubler) {
	if (last_doubler == BLACK) fprintf(save_file,"black\n");
	else fprintf(save_file,"white\n");
	}
else {
	fprintf(save_file,"none\n");
	}

fprintf(save_file,"on bar: black: %d white: %d\n", Pin[0].count, Pin[25].count);

for (i=1; i<25; i++) {
	if (Pin[i].color == WHITE) fprintf(save_file,"pin %d: %d white men\n", i, Pin[i].count);
	if (Pin[i].color == BLACK) fprintf(save_file,"pin %d: %d black men\n", i, Pin[i].count);
	}

fclose(save_file);

}
