/////////////////////////////////////////////////////////////////////////////// 
// $Id: Text.cxx,v 1.1 1995/01/08 06:51:50 bmott Exp $
///////////////////////////////////////////////////////////////////////////////
//
// Text.hxx - Simple text widget
//
//
// Bradford W. Mott
// Copyright (C) 1994
// December 12,1994
//
///////////////////////////////////////////////////////////////////////////////
// $Log: Text.cxx,v $
// Revision 1.1  1995/01/08  06:51:50  bmott
// Initial revision
//
///////////////////////////////////////////////////////////////////////////////

#include <string.h>
#include "Text.hxx"
#include "UIApplication.hxx"
#include "ContainerWidget.hxx"

///////////////////////////////////////////////////////////////////////////////
// Constructor
///////////////////////////////////////////////////////////////////////////////
Text::Text(ContainerWidget *const parent, const char *const widgetName,
    int x, int y, int width, int height, 
    const char* text)
    : BasicWidget(parent, widgetName, x, y, width, height),
      myText(text)
{
  // Create window for widget
  myWindow = XCreateSimpleWindow(application->display(), myParent->window(),
      x, y, width, height, 0, 0, 0);

  // Text widgets have to respond to Exposure events
  XSelectInput(application->display(), myWindow, ExposureMask);
}

///////////////////////////////////////////////////////////////////////////////
// Destructor
///////////////////////////////////////////////////////////////////////////////
Text::~Text()
{
}

///////////////////////////////////////////////////////////////////////////////
// Update the graphical view of the push button
///////////////////////////////////////////////////////////////////////////////
void Text::updateView()
{
  // Setup GC and Font
  XFontStruct* fontInfo = application->font();

  XGCValues gcValues;
  gcValues.foreground = foreground();
  gcValues.background = background();
  gcValues.font = fontInfo->fid;
  GC gc = XCreateGC(application->display(), myWindow,
      GCForeground | GCBackground | GCFont, &gcValues); 

  // Determine the height of each line of text
  int fontHeight = fontInfo->ascent+fontInfo->descent;

  // Scan through myText and display it
  int y = fontHeight;
  const char* current = myText;
  while(current < myText + strlen(myText))
  {
    // Find the end of the line
    const char* eol = index(current, '\n');
    if(eol == NULL)
      eol = myText + strlen(myText);

    // Determine the x coordinate
    // Center label in widget
    int x = (width() - XTextWidth(fontInfo, current, eol - current) ) / 2;
    
    // Display the line of text
    XDrawString(application->display(), myWindow, gc,
      x, y, current, eol - current);

    y += fontHeight;
    current = eol + 1;
  }

  // Free the GC
  XFreeGC(application->display(), gc); 
}

/////////////////////////////////////////////////////////////////////////////// // Called whenever an event arrives for me (I override the default)
///////////////////////////////////////////////////////////////////////////////
void Text::handleEvent(XEvent* event)
{
  // Handle the event
  if (event->type == Expose)
  {
    updateView();
  }
}

