///////////////////////////////////////////////////////////////////////////////
// $Id: About.cxx,v 1.1 1995/01/08 06:42:42 bmott Exp $
///////////////////////////////////////////////////////////////////////////////
//
// About.cxx - About Oonsoo class
//
//
// Bradford W. Mott
// Copyright (C) 1994
// December 13,1994
//
///////////////////////////////////////////////////////////////////////////////
// $Log: About.cxx,v $
// Revision 1.1  1995/01/08  06:42:42  bmott
// Initial revision
//
///////////////////////////////////////////////////////////////////////////////

#include "About.hxx"
#include "AboutOkOrCloseCommand.hxx"

#include "UIApplication.hxx"
#include "Frame.hxx"
#include "PushButton.hxx"
#include "DrawingArea.hxx"
#include "Text.hxx"
#include "Sprite.hxx"

///////////////////////////////////////////////////////////////////////////////
// Constructor 
///////////////////////////////////////////////////////////////////////////////
About::About(SpriteCollection* spriteCollection)
    : mySpriteCollection(spriteCollection)
{
  // Find the Oonsoo and B_Logo sprites
  Sprite* oonsoo = mySpriteCollection->getByName("Oonsoo");
  Sprite* b_logo = mySpriteCollection->getByName("B_Logo");

  // Determine width and height of the about window
  int height = 20+oonsoo->height()+20+55+10+b_logo->height()+10+70+10+30+20;
  int width = 60+oonsoo->width();

  // Build the about oonsoo window
  myToplevel = new TopLevel("About", 200, 200, width, height,
      new AboutOkOrCloseCommand(this));
  myToplevel->background("Gray65");

    // Put a frame in the window to make it look neat!
    Frame* frame = new Frame(myToplevel, "frame", 0, 0,
        width, height, Raised);
    frame->background("Gray65");

    // Build drawing area for Oonsoo title
    DrawingArea* drawingArea = new DrawingArea(myToplevel, "oonsoo",
        (width - oonsoo->width()) / 2, 20, oonsoo->width(), oonsoo->height());
    drawingArea->background(oonsoo);

    // Build Text widget for programmer information
    Text* text = new Text(myToplevel, "information",
        10, 20 + oonsoo->height() + 20, width-20, 55,
        "A Bradford W. Mott Production\nin association with\nSeunghee Lee");
    text->background("Gray65");

    // Build drawing area for B_Logo
    drawingArea = new DrawingArea(myToplevel, "b_logo",
        (width - b_logo->width()) / 2, height-20-30-10-70-10-b_logo->height(), 
        b_logo->width(), b_logo->height());
    drawingArea->background(b_logo);

    // Build Text widget for copyright information
    text = new Text(myToplevel, "copyright",
        10, height-20-30-10-70, width-20, 70,
        "Version 1.0\nCopyright (C) 1994, 1995\n\nbwmott@eos.ncsu.edu");
    text->background("Gray65");

    // Build ok push button
    PushButton* pushButton = new PushButton(myToplevel, "ok",
         (width - 64) / 2, height-20-30,
         64, 30, "Ok", new AboutOkOrCloseCommand(this));
    pushButton->background("Gray65");

  // Manage the about window
  myToplevel->manage();
}

///////////////////////////////////////////////////////////////////////////////
// Destructor 
///////////////////////////////////////////////////////////////////////////////
About::~About()
{
  // Destroy the toplevel widget
  delete myToplevel;
}

