/*
**                      Softwarepraktikum iMaze
**                              1993/94
**                Joerg Czeranski    Hans-Ulrich Kiel
**
** Datei: ninja.c
**
** Kommentar:
**  Der Ninja
*/


#include <stdio.h>
#include <signal.h>

#include "global.h"
#include "speicher.h"
#include "labyrinth.h"
#include "farben.h"
#include "spieler.h"
#include "signale.h"
#include "ereignisse.h"
#include "netzwerk.h"
#include "spiel.h"
#include "system.h"

static char sccsid[] = "@(#)ninja.c	1.38 23 Nov 1994";


u_int feldbreite, feldlaenge;
block **spielfeld;


static int lebenszeit = 2 * 60 * 60 * 1000; /* in ms */

static int schussdichte;

static int spieler_aktiv, gegneranz, schuss_aktiv;
static struct spieler spieler, gegner[SPIELERANZ];


static void laufen(signale)
char signale[SIGNALANZ];
{
	int *dist, i, j;

	speicher_belegen((void **)&dist, feldlaenge * feldbreite * sizeof(int));

	for (i = feldlaenge * feldbreite; i--; dist[i] = 0);

	dist[spieler.pos.ygrob * feldbreite + spieler.pos.xgrob] = 1;
	for (j = 0, i = 0; i < gegneranz; i++)
	{
		int k;

		k = gegner[i].pos.ygrob * feldbreite + gegner[i].pos.xgrob;
		if (!dist[k])
			j++, dist[k] = -1;
	}
	if (!j)
	{
		speicher_freigeben((void **)&dist);
		return;
	}

	for (;;)
	{
		int weiter;

		weiter = 0;

		for (i = feldlaenge * feldbreite; i--;)
		{
			if (dist[i] > 0)
			{
				int x, y;

				x = i % feldbreite;
				y = i / feldbreite;
				if (!spielfeld[x][y][NORD].unbegehbar &&
					dist[j = i - feldbreite] <= 0)
				{
					if (dist[j])
						break;
					dist[j] = i + 2;
					weiter = 1;
				}
				if (!spielfeld[x][y][WEST].unbegehbar &&
					dist[j = i - 1] <= 0)
				{
					if (dist[j])
						break;
					dist[j] = i + 2;
					weiter = 1;
				}
				if (!spielfeld[x][y][SUED].unbegehbar &&
					dist[j = i + feldbreite] <= 0)
				{
					if (dist[j])
						break;
					dist[j] = i + 2;
					weiter = 1;
				}
				if (!spielfeld[x][y][OST].unbegehbar &&
					dist[j = i + 1] <= 0)
				{
					if (dist[j])
						break;
					dist[j] = i + 2;
					weiter = 1;
				}
			}
			j = -1;
		}

		if (j >= 0)
			break;
		if (!weiter)
		{
			speicher_freigeben((void **)&dist);
			return;
		}
	}

	while (dist[i] > 1)
		j = i, i = dist[i] - 2;

	speicher_freigeben((void **)&dist);

	switch (j -= i)
	{
		case -1:
			i = WINKANZ / 4;
			break;
		case 1:
			i = WINKANZ * 3 / 4;
			break;
		default:
			if (j < 0)
				i = 0;
			else
				i = WINKANZ / 2;
	}

	if (spieler.pos.ygrob > 0 && (int)spieler.pos.yfein < KUGELRAD &&
		spielfeld[spieler.pos.xgrob][spieler.pos.ygrob - 1][SUED].unbegehbar)
		i = 0;
	else if (spieler.pos.xgrob > 0 && (int)spieler.pos.xfein < KUGELRAD &&
		spielfeld[spieler.pos.xgrob - 1][spieler.pos.ygrob][OST].unbegehbar)
		i = WINKANZ / 4;
	else if ((int)spieler.pos.ygrob < feldlaenge - 1 &&
		(int)spieler.pos.yfein > RASPT - KUGELRAD &&
		spielfeld[spieler.pos.xgrob][spieler.pos.ygrob + 1][NORD].unbegehbar)
		i = WINKANZ / 2;
	else if ((int)spieler.pos.xgrob < feldbreite - 1 &&
		(int)spieler.pos.xfein > RASPT - KUGELRAD &&
		spielfeld[spieler.pos.xgrob + 1][spieler.pos.ygrob][WEST].unbegehbar)
		i = WINKANZ * 3 / 4;

	i = (i - spieler.blick + WINKANZ) % WINKANZ;
	if (i)
		if (i < WINKANZ / 2)
			signale[LINKSSIGNAL] = 1;
		else
			signale[RECHTSSIGNAL] = 1;

	if (i < WINKANZ / 4 || i > WINKANZ * 3 / 4)
		signale[VORSIGNAL] = 1;

	if (!schuss_aktiv && zufall() % 100 < schussdichte)
		signale[SCHUSSSIGNAL] = 1;
}


static void abbruch_signal_handler(signum)
int signum;
{
	spiel_verlassen();
	exit(0);
}


void uebler_fehler(meldung, knopf)
char **meldung, *knopf;
{
	int i;

	for (i = 0; meldung[i] != NULL; i++)
		fprintf(stderr, "ninja: %s\n", meldung[i]);

	exit(1);
}


void milder_fehler(meldung, knopf)
char **meldung, *knopf;
{
	uebler_fehler(meldung, knopf);
}


void spiel_puffer_anlegen(spieler_aktiv_var, spieler_var, gegneranz_var,
	gegner_feld, schuss_aktiv_var, schuss_var, schussanz_var,
	schuesse_feld, abgeschossen_durch_var, abschuss_spruch_var,
	ereignisse_feld, punkte_feld)
int **spieler_aktiv_var, **gegneranz_var;
int **schuss_aktiv_var, **schussanz_var;
int **abgeschossen_durch_var;
struct spieler **spieler_var, **gegner_feld;
struct schuss **schuss_var, **schuesse_feld;
char ***abschuss_spruch_var, **ereignisse_feld;
int **punkte_feld;
{
	*spieler_aktiv_var = &spieler_aktiv;
	*spieler_var = &spieler;
	*gegneranz_var = &gegneranz;
	*gegner_feld = gegner;

	*schuss_aktiv_var = &schuss_aktiv;
	*schuss_var = NULL;
	*schussanz_var = NULL;
	*schuesse_feld = NULL;

	*abgeschossen_durch_var = NULL;
	*abschuss_spruch_var = NULL;

	*ereignisse_feld = NULL;

	*punkte_feld = NULL;

	lebenszeit -= 300 * 1000 - timer_restzeit();
	timer_starten(300 * 1000);

	if (lebenszeit < 0)
	{
		spiel_verlassen();
		exit(0);
	}
}


void netzwerk_spielende()
{
	exit(0);
}


void signale_abfragen(signale)
char signale[SIGNALANZ];
{
	int i;

	for (i = 0; i < SIGNALANZ; i++)
		signale[i] = 0;

	if (spieler_aktiv)
		laufen(signale);
}


/*
** main
**  die Hauptroutine
**
** Parameter:
**  argc: Anzahl der Argumente inklusive Programmname
**  argv: Argumentliste
*/
void main(argc, argv)
int argc;
char **argv;
{
	char tmp[100], *programm, *spruch;

	programm = argv[0];

	/* zur Sicherheit ein Timeout */
	signal(SIGALRM, SIG_DFL);
	timer_starten(300 * 1000);

	/* Netzwerkroutinen initialisieren */
	netzwerk_init(&argc, argv);

	if (argc > 2 && !strcmp(argv[1], "-m"))
	{
		spruch = argv[2];
		argv += 2;
		argc -= 2;
	}
	else
	{
		strcpy(tmp, "Ninja of ");
		strncpy(tmp + 9, benutzer_name(), sizeof tmp - 9);
		tmp[sizeof tmp - 1] = 0;

		spruch = tmp;
	}

	if (argc < 1 || argc > 3)
	{
		fprintf(stderr,
			"usage: %s [network-options] [-m message] [server-host [shot-percentage]]\n",
			programm);
		exit(1);
	}

	if (argc > 2)
		schussdichte = atoi(argv[2]);
	else
		schussdichte = 100;

	timer_starten(300 * 1000);

	verbindung_aufbauen(argv[1]);

	timer_starten(300 * 1000);

	if (spielparameter_empfangen("iMaze ninja JC/HUK 1.2",
		"Ninja", spruch, &feldbreite, &feldlaenge, &spielfeld))
		exit(1);

	{
		int x, y, i;

		for (x = 0; x < feldbreite; x++)
			for (y = 0; y < feldlaenge; y++)
				for (i = 0; i < 4; i++)
				{
					struct wand *wand;

					wand = &spielfeld[x][y][i];
					wand->unbegehbar = !IST_TUER(wand->farbe) &&
						wand->farbe != TRANSPARENT;
				}
	}

	timer_starten(300 * 1000);

	if (verbindung_auf_spiel())
		exit(1);

	signal(SIGHUP, abbruch_signal_handler);
	signal(SIGINT, abbruch_signal_handler);
	signal(SIGTERM, abbruch_signal_handler);

	timer_starten(300 * 1000);

	/* Hauptschleife, ein Ninja stirbt nicht */
	for (;;)
		if (spiel_paket_erwarten(-1))
			exit(1); /* ausser bei Fehlern */
}
