/*
**                      Softwarepraktikum iMaze
**                              1993/94
**                Joerg Czeranski    Hans-Ulrich Kiel
**
** Datei: speicher.c
**
** Kommentar:
**  Stellt Funktionen zum Anfordern und Freigeben von Speicher zur
**  Verfuegung
*/


#include <stdio.h>
#include <malloc.h>
#include <memory.h>

#include "global.h"
#include "fehler.h"
#include "speicher.h"

static char sccsid[] = "@(#)speicher.c	1.9 5/17/94";


#ifdef DEBUG_SPEICHER
static u_long anfrage_nr = 0;
#endif


/*
** keinspeicher
**  wird aufgerufen, falls malloc/realloc fehlschlaegt
**
** Seiteneffekte:
**  Abbruch des Programms
*/
static void keinspeicher()
{
	static char *meldung[] = { "iMaze - Fatal Error", "",
		"Out of memory.", NULL };

	uebler_fehler(meldung, "I'll buy some RAM");
}


/* bis hier lokaler Teil                       */
/***********************************************/
/* ab hier globaler Teil                       */


/*
** speicher_belegen
**  fordert Speicher mit malloc an
**
** Parameter:
**  zeiger: Zeiger auf Zeiger auf neuen Speicherbereich
**  groesse: Groesse des Speicherbereichs
**
** Seiteneffekte:
**  *zeiger wird gesetzt
*/
void speicher_belegen(zeiger, groesse)
int groesse;
void **zeiger;
{
	if ((*zeiger = malloc(groesse)) == NULL)
		keinspeicher();

#ifdef DEBUG_SPEICHER
	printf("%lu m %p\n", anfrage_nr++, *zeiger);
	fflush(stdout);
#endif
}


/*
** speicher_vergroessern
**  fordert weiteren Speicher mit realloc an
**
** Parameter:
**  zeiger: Zeiger auf Zeiger auf Speicherbereich
**  groesse: neue Groesse des Speicherbereichs
**
** Seiteneffekte:
**  *zeiger wird veraendert
*/
void speicher_vergroessern(zeiger, groesse)
int groesse;
void **zeiger;
{
#ifdef DEBUG_SPEICHER
	printf("%lu F %p\n", anfrage_nr++, *zeiger);
	fflush(stdout);
#endif

	if ((*zeiger = realloc(*zeiger, groesse)) == NULL)
		keinspeicher();

#ifdef DEBUG_SPEICHER
	printf("%lu M %p\n", anfrage_nr++, *zeiger);
	fflush(stdout);
#endif
}


/*
** speicher_freigeben
**  gibt Speicherbereich frei
**
** Parameter:
**  zeiger: Zeiger auf Zeiger auf alten Speicherbereich
*/
void speicher_freigeben(zeiger)
void **zeiger;
{
#ifdef DEBUG_SPEICHER
	printf("%lu f %p\n", anfrage_nr++, *zeiger);
	fflush(stdout);
#endif

	free(*zeiger);
}


/*
** liste_initialisieren
**  setzt Parameter einer Liste auf definierte Anfangswerte
**
** Parameter:
**  anzahl: Zeiger auf Anzahl der Listenelemente
**  liste: Zeiger auf Liste
**
** Seiteneffekte:
**  *anzahl wird gesetzt
*/
void liste_initialisieren(anzahl, liste)
int *anzahl;
void **liste;
{
	*anzahl = 0;
}


/*
** liste_verlaengern
**  verlaengert Liste um ein Element
**
** Parameter:
**  anzahl: Zeiger auf Anzahl der Listenelemente
**  liste: Zeiger auf Liste
**  element_groesse: Groesse eines Elementes
**
** Seiteneffekte:
**  *anzahl und *liste werden veraendert
*/
void liste_verlaengern(anzahl, liste, element_groesse)
int *anzahl, element_groesse;
void **liste;
{
	if ((*anzahl)++)
		speicher_vergroessern(liste, *anzahl * element_groesse);
	else
		speicher_belegen(liste, element_groesse);
}


/*
** liste_kopieren
**  legt eine Kopie einer Liste mit memcpy an
**
** Parameter:
**  anzahl_neu: Zeiger auf Anzahl der Listenelemente (Kopie)
**  liste_neu: Zeiger auf Kopie der Liste
**  anzahl: Zeiger auf Anzahl der Listenelemente (Original)
**  liste: Zeiger auf Liste
**  element_groesse: Groesse eines Elementes
**
** Seiteneffekte:
**  *anzahl_neu und *liste_neu werden gesetzt
*/
void liste_kopieren(anzahl_neu, liste_neu, anzahl, liste, element_groesse)
int *anzahl_neu, *anzahl, element_groesse;
void **liste_neu, **liste;
{
	/* nur kopieren, wenn *anzahl !=0 */
	if (*anzahl_neu = *anzahl)
	{
		speicher_belegen(liste_neu, *anzahl_neu * element_groesse);
		memcpy(*liste_neu, *liste, *anzahl_neu * element_groesse);
	}
}


/*
** liste_freigeben
**  gibt den Speicherbereich der Liste frei
**
** Parameter:
**  anzahl: Zeiger auf alte Anzahl der Listenelemente
**  liste: Zeiger auf Liste
*/
void liste_freigeben(anzahl, liste)
int *anzahl;
void **liste;
{
	if (*anzahl)
		speicher_freigeben(liste);
}
