#include "xbill.h"
#include "widgets.h"
#include "text.h"

Widget toplevel, base, menubar, field, info;
Widget aboutbox, rulesbox, thanksbox, storybox, freebox;
Widget warpbox, quitbox, newgamebox, pausebox;
Widget scorebox, highscorebox;
Widget endgamebox, enternamebox;

static menutype menu = {2, 
	{
		{"Game", 5, 
			{
				{"New game", (XtCallbackProc)popup, &newgamebox},
				{"Pause game", (XtCallbackProc)popup, &pausebox},
				{"Warp to level...", (XtCallbackProc)popup, &warpbox},
				{"View high scores", (XtCallbackProc)popup, &highscorebox},
				{"Quit game", (XtCallbackProc)popup, &quitbox},
			}
		},
		{"Info", 5,  
			{
				{"Story of xBill", (XtCallbackProc)popup, &storybox},
				{"Rules", (XtCallbackProc)popup, &rulesbox},
				{"About xBill", (XtCallbackProc)popup, &aboutbox},
				{"Special thanks", (XtCallbackProc)popup, &thanksbox},
				{"Understanding freeware", (XtCallbackProc)popup, &freebox},
			}
		}
	}
};

static char *warpstr = "Warp to level?";
static char *quitstr = "Quit Game?";
static char *newgamestr = "New Game?";
static char *pausestr = "Game paused.  Press OK to continue.";
static char *enternamestr = "You have gotten a high score.  Enter your name.";

extern XtAppContext app;
extern horde bill;
extern library systems;
extern Pixmap icon, logo;

/****************************/
/*  Create main game board  */
/****************************/
void setup_main_widgets () {
	base = wCreateRowColumnWidget ("base", toplevel);

	menubar=wCreateMenuBar("menubar", base, menu);
	
	wCreateSeparatorWidget ("bar1", base);
	
	field = wCreateDrawingArea ("field", base, 400, 400);
	XtAddEventHandler (field, ButtonPressMask, FALSE, (XtEventHandler)hit_monster, &bill);
	XtAddEventHandler (field, ButtonReleaseMask, FALSE, (XtEventHandler)drop_os, &systems);
	XtAddEventHandler (field, LeaveWindowMask, FALSE, (XtEventHandler)leave_window, NULL);
	XtAddEventHandler (field, EnterWindowMask, FALSE, (XtEventHandler)enter_window, NULL);
	XtAddEventHandler (field, ExposureMask, FALSE, (XtEventHandler)redraw_window, NULL);
	wCreateSeparatorWidget ("bar2", base);
	
	info = wCreateLabelWidget ("info", base);
}

void setup_other_widgets(Pixmap about, Pixmap rules, Pixmap thanks,
	Pixmap story, Pixmap freeware)
{
	newgamebox = wCreateDialog ("New Game", base, OK|CANCEL, (Pixmap)NULL, newgamestr, (char *)NULL, new_game);
	pausebox = wCreateDialog ("Pause Game", base, OK, icon, pausestr, "Unpause", NULL);
	quitbox = wCreateDialog ("Quit", base, OK|CANCEL, (Pixmap)NULL, quitstr, (char *)NULL, quit_game); 
	warpbox = wCreateEnterText ("Warp To Level", base, OK|CANCEL, warpstr, (XtCallbackProc) warp_apply);
	DPRINTF("loaded Game menu dialogs...\n");

	aboutbox = wCreatePixmapBox ("About", base, about, (char *)NULL);
	rulesbox = wCreatePixmapBox ("Rules", base, rules, rules_txt);
	thanksbox = wCreatePixmapBox ("Help", base, thanks, thanks_txt);
	storybox = wCreatePixmapBox ("Story", base, story, story_txt);
	freebox = wCreatePixmapBox ("Freeware", base, freeware, freeware_txt);
	DPRINTF("loaded Help menu dialogs...\n");

	scorebox = wCreateDialog ("Score", base, OK, (Pixmap)NULL, "", (char *)NULL, NULL);
	endgamebox = wCreateDialog ("Endgame", base, OK, (Pixmap)NULL, endgame_txt, "Nuts!", NULL);
	highscorebox = wCreateDialog ("HighScore", base, OK, (Pixmap)NULL, "", (char *)NULL, NULL);
	enternamebox = wCreateEnterText("Enter Name", base, OK, enternamestr, (XtCallbackProc) enter_name);
	DPRINTF("loaded End of Game dialogs...\n");
}	

Widget motif_CreateMenuBar(char *name, Widget parent, menutype menu) {
	int i, j;
	Widget menubar, temp;
	menubar = XmCreateMenuBar(parent, name, NULL, 0);
	XtManageChild(menubar);
	for (j=0; j<menu.size; j++) {
		temp = XtCreateManagedWidget(menu.submenu[j].name,
			xmCascadeButtonWidgetClass, menubar, NULL, 0);
		menu.submenu[j].pulldown = XmCreatePulldownMenu(menubar,
			"submenu", NULL, 0);
		XtVaSetValues (temp, XmNsubMenuId, menu.submenu[j].pulldown, NULL);
		for (i=0; i<menu.submenu[j].size; i++) {
			temp = XtCreateManagedWidget(
				menu.submenu[j].button[i].name,
				xmPushButtonWidgetClass,
				menu.submenu[j].pulldown, NULL, 0);
			XtAddCallback (temp, XmNactivateCallback,
				menu.submenu[j].button[i].callback,
				menu.submenu[j].button[i].arg);
			if (i != menu.submenu[j].size-1)
				XtCreateManagedWidget("sep",
					xmSeparatorGadgetClass,
					menu.submenu[j].pulldown, NULL, 0);
		}
	}
	return menubar;
}

Widget motif_CreatePixmapBox(char *name, Widget parent, Pixmap pixmap,
	char *text)
{
	Arg wargs[2];
	Widget dialog, base;
	XmString mstr;
DPRINTF ("start create pixmap box\n");
	dialog = XmCreateMessageDialog(parent, name, NULL, 0);
	XtVaSetValues(dialog, XmNdialogStyle, XmDIALOG_APPLICATION_MODAL, NULL);

	base = XmCreateRowColumn(dialog, "", NULL, 0);
	XtManageChild(base);

	XtSetArg(wargs[0], XmNlabelType, XmPIXMAP);
	XtSetArg(wargs[1], XmNlabelPixmap, logo);
	XtCreateManagedWidget("", xmLabelWidgetClass, base, wargs, 2);
DPRINTF ("make a logo pixmap\n");

	wCreateSeparatorWidget ("bar", base);
DPRINTF ("make a sep\n");

	XtSetArg(wargs[0], XmNlabelType, XmPIXMAP);
	XtSetArg(wargs[1], XmNlabelPixmap, pixmap);
	XtCreateManagedWidget("", xmLabelWidgetClass, base, wargs, 2);
DPRINTF ("make a pixmap\n");

	if (text) {
		mstr=XmStringCreateLtoR(text, XmSTRING_DEFAULT_CHARSET);
		XtSetArg(wargs[0], XmNlabelString, mstr);
		XtCreateManagedWidget("", xmLabelWidgetClass, base, wargs, 1);
		XmStringFree(mstr);
DPRINTF ("make a text label\n");
	}

	XtUnmanageChild(XmMessageBoxGetChild(dialog, XmDIALOG_CANCEL_BUTTON));
	XtUnmanageChild(XmMessageBoxGetChild(dialog, XmDIALOG_HELP_BUTTON));
	XtAddCallback(XtParent(dialog), XmNpopdownCallback, (XtCallbackProc) popdown, NULL);
	return dialog;
}

void warp_apply (Widget w, Widget text, XtPointer client_data) {
	char *str;
	int i;
	str = XmTextGetString(text);
	i=atoi(str);
	XtFree(str);
	warp_to_level(i);
}

void enter_name (Widget w, Widget text, XtPointer client_data) {
	char *str;
	str = XmTextGetString(text);
	if (!strcmp(str,"")) strcpy(str, "Anonymous");
	str[20] = 0;  /* truncate string if too long */
	recalc_high_scores(str);
	XtFree(str);
}

Widget CreateEnterText
	(char *name, Widget parent, int buttonmask, char *text, XtCallbackProc callback)
{
	Widget dialog;
	XmString mstr;
	dialog = XmCreatePromptDialog(parent, name, NULL, 0);
	XtVaSetValues(dialog, XmNdialogStyle, XmDIALOG_APPLICATION_MODAL, NULL);
	mstr=XmStringCreateLtoR(text, XmSTRING_DEFAULT_CHARSET);
	XtVaSetValues(dialog, XmNselectionLabelString, mstr, NULL);
	if (!(buttonmask&OK))
		XtUnmanageChild(XmSelectionBoxGetChild(dialog, XmDIALOG_OK_BUTTON));
	if (!(buttonmask&CANCEL))
		XtUnmanageChild(XmSelectionBoxGetChild(dialog, XmDIALOG_CANCEL_BUTTON));
	XtUnmanageChild(XmSelectionBoxGetChild(dialog, XmDIALOG_HELP_BUTTON));
	XtAddCallback(dialog, XmNokCallback, callback,
		XmSelectionBoxGetChild(dialog, XmDIALOG_TEXT));
	XtAddCallback(XtParent(dialog), XmNpopdownCallback, popdown, NULL);
	return dialog;
}

Widget CreateDialog (char *name, Widget parent, int buttonmask, Pixmap icon,
	char *text, char *button, XtCallbackProc callback)
{
	Widget dialog;
	XmString mstr;
	dialog = XmCreateMessageDialog(parent, "dialog", NULL, 0);
	XtVaSetValues(dialog, XmNdialogStyle, XmDIALOG_APPLICATION_MODAL, NULL);
	if (!(buttonmask&OK))
		XtUnmanageChild(XmMessageBoxGetChild(dialog, XmDIALOG_OK_BUTTON));
	if (!(buttonmask&CANCEL))
		XtUnmanageChild(XmMessageBoxGetChild(dialog, XmDIALOG_CANCEL_BUTTON));
	XtUnmanageChild(XmMessageBoxGetChild(dialog, XmDIALOG_HELP_BUTTON));
	if (!(buttonmask&(OK|CANCEL)))
		XtUnmanageChild(XmMessageBoxGetChild(dialog, XmDIALOG_SEPARATOR));
	if (button) {
		mstr=XmStringCreateLtoR(button, XmSTRING_DEFAULT_CHARSET);
		XtVaSetValues(XmMessageBoxGetChild(dialog, XmDIALOG_OK_BUTTON),
			XmNlabelString, mstr, NULL);
		XmStringFree(mstr);
	}
	if (icon) XtVaSetValues(dialog, XmNsymbolPixmap, icon, NULL);
	if (callback) XtAddCallback(dialog, XmNokCallback, callback, NULL);
	mstr = XmStringCreateLtoR(text, XmSTRING_DEFAULT_CHARSET);
	XtVaSetValues(dialog, XmNmessageString, mstr, NULL);
	XmStringFree(mstr);
	XtAddCallback(XtParent(dialog), XmNpopdownCallback, popdown, NULL);
	return dialog;
}

Widget motif_CreateDrawingArea(char *name, Widget parent, int width, int height) {
	Widget area;
        area = XtCreateManagedWidget(name, xmDrawingAreaWidgetClass, parent, NULL, 0);
	XtVaSetValues(area, XtNwidth, width, XtNheight, height, XmNresizePolicy, FALSE, XtNbackground, 0, NULL);
	return area;
}

void motif_print_to_widget(Widget w, char *str) {
	XmString mstr = XmStringCreateLtoR(str, XmSTRING_DEFAULT_CHARSET);
	XtVaSetValues(w, XmNlabelString, mstr, NULL);
	XmStringFree(mstr);
}
