
#include "Obj.h"

// ship bitmaps rotated in different position, with/without thrust flame
Bitmap	Ship::ship[SHIPTURNS];
Bitmap  Ship::shipThr[SHIPTURNS];

void Ship::init()
	{
	// use the rotate function of the bitmap object to create
	// ship bitmaps for each of the SHIPTURNS rotated positions.
	int 	i,j,k,angle;

	
	k = SHIPTURNS>>2;	// must be multiple of 4
	
	for(j=0; j<k; j++)
		{
		ship[j]    = ship0;
		shipThr[j] = ship1;

		angle = (int)( (double)j*90.0/(double)k );

		if (angle!=0)
			{
			ship[j].rot( angle );
			shipThr[j].rot( angle );
			}
		
		for(i=1; i<4; i++)
			{
			ship[j+i*k].copy(ship[j+(i-1)*k]);
			ship[j+i*k].rotc90();
			
			shipThr[j+i*k].copy(shipThr[j+(i-1)*k]);
			shipThr[j+i*k].rotc90();

			}
		}
				
	}
