/*********************************************************************/
/* file: tintin.h - the include file for tintin++                    */
/*                             TINTIN ++                             */
/*          (T)he K(I)cki(N) (T)ickin D(I)kumud Clie(N)t             */
/*                    modified by Bill Reiss 1993                    */
/*                     coded by peter unold 1992                     */
/*********************************************************************/
#include <stdio.h>

/************************/
/* The meaning of life: */
/************************/
#define TRUE 1
#define FALSE 0

/******************************/
/* Type of system declaration */
/******************************/
/***********************************************/
/* Some default values you might wanna change: */
/***********************************************/
#define SCREEN_WIDTH 80
#define DEFAULT_OPEN '{' /*character that starts an argument */
#define DEFAULT_CLOSE '}' /*character that ends an argument */
#define SYSTEM_COMMAND_DEFAULT "system"   /* name of the system command */
#define HISTORY_SIZE 15                   /* history size */
#define MAX_PATH_LENGHT 50                /* max path lenght */
#define DEFAULT_TINTIN_CHAR '#'           /* tintin char */
#define DEFAULT_VERBATIM_CHAR '\\'         /* if an input starts with this
                                             char, it will be sent 'as is'
                                             to the MUD */
#define DEFAULT_ECHO FALSE                /* echo */         
#define DEFAULT_IGNORE FALSE              /* ignore */
#define DEFAULT_SPEEDWALK TRUE            /* speedwalk */
#define DEFAULT_PRESUB TRUE               /* presub before actions */
#define DEFAULT_TOGGLESUBS FALSE          /* turn subs on and off FALSE=ON*/

#define DEFAULT_ALIAS_MESS TRUE           /* messages for responses */
#define DEFAULT_ACTION_MESS TRUE          /* when setting/deleting aliases, */
#define DEFAULT_SUB_MESS TRUE             /* actions, etc. may be set to */
#define DEFAULT_ANTISUB_MESS TRUE         /* default either on or off */
#define DEFAULT_HIGHLIGHT_MESS TRUE       /* TRUE=ON FALSE=OFF */
#define DEFAULT_VARIABLE_MESS TRUE        /* might want to turn off these */
#define DEFAULT_REDRAW FALSE
/**************************************************************************/
/* Whenever TINTIN has written something to the screen, the program sends */
/* a CR/LF to the diku to force a new prompt to appear. You can have      */
/* TINTIN print it's own pseudo prompt instead.                           */
/**************************************************************************/
#define PSEUDO_PROMPT TRUE 
/**************************************************************************/
/* the codes below are used for highlighting text, and is set for the     */
/* codes for VT-100 terminal emulation. If you are using a different      */
/* teminal type, replace the codes below with the correct codes           */
/**************************************************************************/
#define REVERSE_START_STRING "[7m"
#define BOLD_START_STRING "[1m"
#define BLINK_START_STRING "[5m"
#define ITALIC_START_STRING "[3m"
#define FAINT_START_STRING "[2m"
#define COLOR1_START_STRING "[30m"
#define COLOR2_START_STRING "[31m"
#define COLOR3_START_STRING "[32m"
#define COLOR4_START_STRING "[33m"
#define COLOR5_START_STRING "[34m"
#define COLOR6_START_STRING "[35m"
#define COLOR7_START_STRING "[36m"
#define COLOR8_START_STRING "[37m"
#define REVERSE_END_STRING "[m"
#define BOLD_END_STRING "[m"
#define FAINT_END_STRING "[m"
#define BLINK_END_STRING "[m"
#define ITALIC_END_STRING "[m"
#define COLOR1_END_STRING "[m"
#define COLOR2_END_STRING "[m"
#define COLOR3_END_STRING "[m"
#define COLOR4_END_STRING "[m"
#define COLOR5_END_STRING "[m"
#define COLOR6_END_STRING "[m"
#define COLOR7_END_STRING "[m"
#define COLOR8_END_STRING "[m"
/*************************************************************************/
/* The text below is checked for. If it trickers then echo is turned off */
/* echo is turned back on the next time the user types a return          */
/*************************************************************************/
#define PROMPT_FOR_PW_TEXT "^Password:"

/**************************************************************************/ 
/* The stuff below here shouldn't be modified unless you know what you're */
/* doing........                                                          */
/**************************************************************************/ 
#define BUFFER_SIZE 1024

/************************ structures *********************/
struct listnode {
  struct listnode *next;
  char *left, *right;
};
struct completenode {
  struct completenode *next;
  char *strng;
};

struct session {
  struct session *next;
  char *name;
  char *address;
  int tickstatus;
  int snoopstatus;
  FILE *logfile;
  struct listnode *aliases, *actions, *subs, *myvars, *highs, *antisubs;  
  char *history[HISTORY_SIZE];
  char path[MAX_PATH_LENGHT];
  int path_mark, path_now, path_lenght;
  int socket, socketbit;
  int old_more_coming,more_coming;
  char last_line[BUFFER_SIZE];
};

