#!/bin/sh
#	Dungeon wrapper
#  Written by A.M. Kuchling, fnord@binkley.cs.mcgill.ca
#  Creates a temporary directory in /tmp, cd's to it,
#  creates symlinks 

#  Location where the Dungeon executable and *.DAT files will be
DUNGEONDIR=/usr/lib/games/dungeon
#  Name of the binary to execute
DUNGEONPROG=dungeon.static
#  Directory to place the temporary directory in
TMPDIR=/tmp

#
#  Make a temporary directory
	curdir=`pwd`
	dir=`whoami`$$	# Build temp. directory name like fnord1538
	cd $TMPDIR
if [ ! -d $dir ]; then
  mkdir $dir
else
  echo The temporary directory $TMPDIR/$dir appears to already exist.
  exit
fi  
cd $dir

# Create symlinks

ln -s $DUNGEONDIR/DINDX.DAT ./DINDX.DAT
ln -s $DUNGEONDIR/DTEXT.DAT ./DTEXT.DAT

# Copy a saved game file from the former working directory, if one exists

if [ -f $curdir/DSAVE.DAT ]; then 
 cp $curdir/DSAVE.DAT .
fi

# Run the dungeon program

$DUNGEONDIR/$DUNGEONPROG

# Keep a saved game file, if one exists.

if [ -f DSAVE.DAT ]; then
 mv DSAVE.DAT $curdir
fi

# Delete the temporary directory

rm DINDX.DAT DTEXT.DAT
cd ..
rmdir $dir

# Change back to original directory

cd $curdir

# End of script
	

