# status-text.tcl --
#
#	Associate a help string with a given widget, and display that
#	string when the mouse enters the widget. The help text is
#	displayed in a label.
#

namespace eval NSStatusText {

# NSStatusText:: --
#
#	Description.
#
# Arguments:
#	arg1					about arg1
#
# Results:
#	What happened.

proc StatusText {widget label string} {

	variable StatusTextPriv

	set StatusTextPriv($widget,label) $label
	set StatusTextPriv($widget,text) $string

	bindtags $widget [concat [bindtags $widget] StatusText_BindTag]
}

# NSStatusText:: --
#
#	Description.
#
# Arguments:
#	arg1					about arg1
#
# Results:
#	What happened.

proc SetText widget {

	variable StatusTextPriv

	set label $StatusTextPriv($widget,label)
	set StatusTextPriv($widget,oldText) [$label cget -text]
	set helpText $StatusTextPriv($widget,text)
	$label configure -text $helpText
}

# NSStatusText:: --
#
#	Description.
#
# Arguments:
#	arg1					about arg1
#
# Results:
#	What happened.

proc ResetText widget {

	variable StatusTextPriv

	set label $StatusTextPriv($widget,label)
	set oldText $StatusTextPriv($widget,oldText)
	$label configure -text $oldText
}

bind StatusText_BindTag <Any-Enter> {
	NSStatusText::SetText %W
}

bind StatusText_BindTag <Any-Leave> {
	NSStatusText::ResetText %W
}

bind StatusText_BindTag <Destroy> {
	unset NSStatusText::StatusTextPriv(%W,label)
	unset NSStatusText::StatusTextPriv(%W,text)
}

# namespace eval NSStatusText
}
