# color-picker.tcl --
#
#

namespace eval NSColorPicker {

# NSColorPicker::InitModule --
#
#	One-time-only-ever initialization.
#
# Arguments:
#	arg1					about arg1
#
# Results:
#	What happened.

proc InitModule {} {
}

# NSColorPicker::NSColorPicker --
#
#	Object constructor called by NSObject::New(). Creates a new
#	color picker in the given parent. Afterwards you should call
#	SetColors() with a list of colors to display, and then set
#	NSColorPicker(OOP,command) to the command to call whenever
#	SetCursor() changes the cursor position. 
#
# Arguments:
#	arg1					about arg1
#
# Results:
#	What happened.

proc NSColorPicker {oop parent cols rows size} {

	global NSColorPicker

	set canvas $parent.picker$oop

	canvas $canvas \
		-width [expr $size * $cols + 1] \
		-height [expr $size * $rows + 1] \
		-relief flat -borderwidth 0 -highlightthickness 0

	bind $canvas <ButtonPress-1> "
		NSColorPicker::SetCursor $oop \[NSColorPicker::GetIndex $oop %x %y] 1
	"
	bind $canvas <Button1-Motion> "
		NSColorPicker::SetCursor $oop \[NSColorPicker::GetIndex $oop %x %y] 1
	"

	set NSColorPicker($oop,cols) $cols
	set NSColorPicker($oop,rows) $rows
	set NSColorPicker($oop,size) $size
	set NSColorPicker($oop,canvas) $canvas
	set NSColorPicker($oop,index) 0
	set NSColorPicker($oop,command) ""

	bind $canvas <Destroy> "NSObject::Delete NSColorPicker $oop"
}

# NSColorPicker::SetColors --
#
#	Description
#
# Arguments:
#	arg1					about arg1
#
# Results:
#	What happened.

proc SetColors {oop colors} {

	global NSColorPicker

	set canvas $NSColorPicker($oop,canvas)
	set size $NSColorPicker($oop,size)
	set cols $NSColorPicker($oop,cols)
	set rows $NSColorPicker($oop,rows)

	set count [llength $colors]
	if {$count % $cols} {
		set rows [expr $count / $cols + 1]
		set fudgeCol [expr $count % $cols]
	} else {
		set rows [expr $count / $cols]
		set fudgeCol $cols
	}

	$canvas delete all

	set i 0
	foreach color $colors {
		set y [expr $i / $cols]
		set x [expr $i % $cols]
		set n 1
		if {($x == $cols - 1) || ($y == $rows - 1) ||
			(($y == $rows - 2) && ($x >= $fudgeCol))} {set n 0}
		$canvas create rectangle [expr $x * $size] \
			[expr $y * $size] [expr ($x + 1) * $size + $n] \
			[expr ($y + 1) * $size + $n] -fill $color \
			-tags $i
		incr i
	}

	$canvas create rectangle 0 0 $size \
		$size -outline White -tags cursor

	# Cursor starts out not visible
	ShowHideCursor $oop 0
}

# NSColorPicker::SetCursor --
#
#	Description
#
# Arguments:
#	arg1					about arg1
#
# Results:
#	What happened.

proc SetCursor {oop index callCmd} {

	global NSColorPicker

	if !$NSColorPicker($oop,active) return
	if {$index < 0 || $index > 255} return
	if {$index == $NSColorPicker($oop,index)} return

	set canvas $NSColorPicker($oop,canvas)

	set size $NSColorPicker($oop,size)
	set cols $NSColorPicker($oop,cols)

	set bbox [$canvas bbox cursor]
	set oldX [lindex $bbox 0]
	set oldY [lindex $bbox 1]

	set row [expr $index / $cols]
	set col [expr $index % $cols]
	set x [expr $col * $size - 1]
	set y [expr $row * $size - 1]

	$canvas move cursor [expr $x - $oldX] [expr $y - $oldY]

	set NSColorPicker($oop,index) $index

	if $callCmd {
		set command $NSColorPicker($oop,command)
		if {[string compare $command ""]} {
			uplevel #0 eval $command $oop $index
		}
	}
}

# NSColorPicker::ShowHideCursor --
#
#	Makes the cursor visible or not visible, by changing its color.
#
# Arguments:
#	arg1					about arg1
#
# Results:
#	What happened.

proc ShowHideCursor {oop visible} {

	global NSColorPicker

	set canvas $NSColorPicker($oop,canvas)

	if $visible {
		$canvas itemconfigure cursor -outline White
	} else {
		$canvas itemconfigure cursor -outline Black
	}

	set NSColorPicker($oop,active) $visible
}

# NSColorPicker::GetIndex --
#
#	Description
#
# Arguments:
#	arg1					about arg1
#
# Results:
#	What happened.

proc GetIndex {oop x y} {

	global NSColorPicker

	set canvas $NSColorPicker($oop,canvas)
	set itemId [$canvas find closest $x $y 1.0 cursor]
	if {$itemId == ""} {return -1}
	foreach tag [$canvas gettags $itemId] {
		if {$tag >= 0 && $tag < 256} {
			return $tag
		}
	}
	return -1
}

# namespace eval NSColorPicker
}
