/* File: tables.c */

/* Purpose: store/attack/RNG/etc tables and variables */

/*
 * Copyright (c) 1989 James E. Wilson, Robert A. Koeneke
 *
 * This software may be copied and distributed for educational, research, and
 * not for profit purposes provided that this copyright and statement are
 * included in all such copies.
 */

#include "angband.h"




/*
 * Global array for looping through the legal "keypad directions"
 */
int ddd[9] =  {2, 8, 6, 4, 3, 1, 9, 7, 5};

/*
 * Global arrays for converting "keypad direction" into offsets
 */
int ddx[10] = {0, -1, 0, 1, -1, 0, 1, -1, 0, 1};
int ddy[10] = {0, 1, 1, 1, 0, 0, 0, -1, -1, -1};




#if 0

/*
 * Stat Table -- Empty
 */
s16b adj_xxx[] = {
    /* 3 */,
    /* 4 */,
    /* 5 */,
    /* 6 */,
    /* 7 */,
    /* 8 */,
    /* 9 */,
    /* 10 */,
    /* 11 */,
    /* 12 */,
    /* 13 */,
    /* 14 */,
    /* 15 */,
    /* 16 */,
    /* 17 */,
    /* 18 */,
    /* 18/01-18/09 */,
    /* 18/10-18/19 */,
    /* 18/20-18/29 */,
    /* 18/30-18/39 */,
    /* 18/40-18/49 */,
    /* 18/50-18/59 */,
    /* 18/60-18/69 */,
    /* 18/70-18/79 */,
    /* 18/80-18/89 */,
    /* 18/90-18/99 */,
    /* 18/100 */,
    /* 18/101-18/109 */,
    /* 18/110-18/119 */,
    /* 18/120-18/129 */,
    /* 18/130-18/139 */,
    /* 18/140-18/149 */,
    /* 18/150-18/159 */,
    /* 18/160-18/169 */,
    /* 18/170-18/179 */,
    /* 18/180-18/189 */,
    /* 18/190-18/199 */,
    /* 18/200-18/209 */,
    /* 18/210-18/219 */,
    /* 18/220+ */
};

#endif


/*
 * Stat Table -- lowest stat in each stat index range
 */
s16b adj_val_min[] = {
    3		/* 3 */,
    4		/* 4 */,
    5		/* 5 */,
    6		/* 6 */,
    7		/* 7 */,
    8		/* 8 */,
    9		/* 9 */,
    10		/* 10 */,
    11		/* 11 */,
    12		/* 12 */,
    13		/* 13 */,
    14		/* 14 */,
    15		/* 15 */,
    16		/* 16 */,
    17		/* 17 */,
    18		/* 18 */,
    18+1	/* 18/01-18/09 */,
    18+10	/* 18/10-18/19 */,
    18+20	/* 18/20-18/29 */,
    18+30	/* 18/30-18/39 */,
    18+40	/* 18/40-18/49 */,
    18+50	/* 18/50-18/59 */,
    18+60	/* 18/60-18/69 */,
    18+70	/* 18/70-18/79 */,
    18+80	/* 18/80-18/89 */,
    18+90	/* 18/90-18/99 */,
    18+100	/* 18/100 */,
    18+101	/* 18/101-18/109 */,
    18+110	/* 18/110-18/119 */,
    18+120	/* 18/120-18/129 */,
    18+130	/* 18/130-18/139 */,
    18+140	/* 18/140-18/149 */,
    18+150	/* 18/150-18/159 */,
    18+160	/* 18/160-18/169 */,
    18+170	/* 18/170-18/179 */,
    18+180	/* 18/180-18/189 */,
    18+190	/* 18/190-18/199 */,
    18+200	/* 18/200-18/209 */,
    18+210	/* 18/210-18/219 */,
    18+220	/* 18/220+ */
};


/*
 * Stat Table -- highest stat in each stat index range
 */
s16b adj_val_max[] = {
    3		/* 3 */,
    4		/* 4 */,
    5		/* 5 */,
    6		/* 6 */,
    7		/* 7 */,
    8		/* 8 */,
    9		/* 9 */,
    10		/* 10 */,
    11		/* 11 */,
    12		/* 12 */,
    13		/* 13 */,
    14		/* 14 */,
    15		/* 15 */,
    16		/* 16 */,
    17		/* 17 */,
    18		/* 18 */,
    18+9	/* 18/01-18/09 */,
    18+19	/* 18/10-18/19 */,
    18+29	/* 18/20-18/29 */,
    18+39	/* 18/30-18/39 */,
    18+49	/* 18/40-18/49 */,
    18+59	/* 18/50-18/59 */,
    18+69	/* 18/60-18/69 */,
    18+79	/* 18/70-18/79 */,
    18+89	/* 18/80-18/89 */,
    18+99	/* 18/90-18/99 */,
    18+100	/* 18/100 */,
    18+109	/* 18/101-18/109 */,
    18+119	/* 18/110-18/119 */,
    18+129	/* 18/120-18/129 */,
    18+139	/* 18/130-18/139 */,
    18+149	/* 18/140-18/149 */,
    18+159	/* 18/150-18/159 */,
    18+169	/* 18/160-18/169 */,
    18+179	/* 18/170-18/179 */,
    18+189	/* 18/180-18/189 */,
    18+199	/* 18/190-18/199 */,
    18+209	/* 18/200-18/209 */,
    18+219	/* 18/210-18/219 */,
    18+999	/* 18/220+ */
};





/*
 * Stat Table (INT/WIS) -- Number of half-spells per level
 */
s16b adj_mag_study[] = {
    0	/* 3 */,
    0	/* 4 */,
    0	/* 5 */,
    0	/* 6 */,
    0	/* 7 */,
    1	/* 8 */,
    1	/* 9 */,
    1	/* 10 */,
    1	/* 11 */,
    2	/* 12 */,
    2	/* 13 */,
    2	/* 14 */,
    2	/* 15 */,
    2	/* 16 */,
    2	/* 17 */,
    2	/* 18 */,
    2	/* 18/01-18/09 */,
    2	/* 18/10-18/19 */,
    2	/* 18/20-18/29 */,
    2	/* 18/30-18/39 */,
    2	/* 18/40-18/49 */,
    3	/* 18/50-18/59 */,
    3	/* 18/60-18/69 */,
    3	/* 18/70-18/79 */,
    3	/* 18/80-18/89 */,
    4	/* 18/90-18/99 */,
    4	/* 18/100 */,
    5	/* 18/101-18/109 */,
    5	/* 18/110-18/119 */,
    5	/* 18/120-18/129 */,
    5	/* 18/130-18/139 */,
    5	/* 18/140-18/149 */,
    5	/* 18/150-18/159 */,
    5	/* 18/160-18/169 */,
    5	/* 18/170-18/179 */,
    5	/* 18/180-18/189 */,
    5	/* 18/190-18/199 */,
    5	/* 18/200-18/209 */,
    5	/* 18/210-18/219 */,
    5	/* 18/220+ */
};


/*
 * Stat Table (INT/WIS) -- extra half-mana-points per level
 */
s16b adj_mag_mana[] = {
    0	/* 3 */,
    0	/* 4 */,
    0	/* 5 */,
    0	/* 6 */,
    0	/* 7 */,
    1	/* 8 */,
    2	/* 9 */,
    2	/* 10 */,
    2	/* 11 */,
    2	/* 12 */,
    2	/* 13 */,
    2	/* 14 */,
    2	/* 15 */,
    2	/* 16 */,
    2	/* 17 */,
    3	/* 18 */,
    3	/* 18/01-18/09 */,
    3	/* 18/10-18/19 */,
    3	/* 18/20-18/29 */,
    3	/* 18/30-18/39 */,
    3	/* 18/40-18/49 */,
    4	/* 18/50-18/59 */,
    4	/* 18/60-18/69 */,
    5	/* 18/70-18/79 */,
    5	/* 18/80-18/89 */,
    6	/* 18/90-18/99 */,
    7	/* 18/100 */,
    8	/* 18/101-18/109 */,
    9	/* 18/110-18/119 */,
    10	/* 18/120-18/129 */,
    11	/* 18/130-18/139 */,
    12	/* 18/140-18/149 */,
    13	/* 18/150-18/159 */,
    14	/* 18/160-18/169 */,
    15	/* 18/170-18/179 */,
    16	/* 18/180-18/189 */,
    16	/* 18/190-18/199 */,
    16	/* 18/200-18/209 */,
    16	/* 18/210-18/219 */,
    16	/* 18/220+ */
};


/*
 * Stat Table (INT/WIS) -- Minimum failure rate (percentage)
 */
s16b adj_mag_fail[] = {
    99	/* 3 */,
    99	/* 4 */,
    99	/* 5 */,
    99	/* 6 */,
    99	/* 7 */,
    50	/* 8 */,
    30	/* 9 */,
    20	/* 10 */,
    15	/* 11 */,
    12	/* 12 */,
    11	/* 13 */,
    10	/* 14 */,
    9	/* 15 */,
    8	/* 16 */,
    7	/* 17 */,
    6	/* 18 */,
    5	/* 18/01-18/09 */,
    5	/* 18/10-18/19 */,
    5	/* 18/20-18/29 */,
    5	/* 18/30-18/39 */,
    5	/* 18/40-18/49 */,
    4	/* 18/50-18/59 */,
    4	/* 18/60-18/69 */,
    4	/* 18/70-18/79 */,
    4	/* 18/80-18/89 */,
    3	/* 18/90-18/99 */,
    3	/* 18/100 */,
    2	/* 18/101-18/109 */,
    2	/* 18/110-18/119 */,
    2	/* 18/120-18/129 */,
    2	/* 18/130-18/139 */,
    2	/* 18/140-18/149 */,
    1	/* 18/150-18/159 */,
    1	/* 18/160-18/169 */,
    1	/* 18/170-18/179 */,
    1	/* 18/180-18/189 */,
    1	/* 18/190-18/199 */,
    0	/* 18/200-18/209 */,
    0	/* 18/210-18/219 */,
    0	/* 18/220+ */
};


/*
 * Stat Table (INT/WIS) -- Various things
 */
s16b adj_mag_stat[] = {
    0	/* 3 */,
    0	/* 4 */,
    0	/* 5 */,
    0	/* 6 */,
    0	/* 7 */,
    1	/* 8 */,
    1	/* 9 */,
    1	/* 10 */,
    1	/* 11 */,
    1	/* 12 */,
    1	/* 13 */,
    1	/* 14 */,
    2	/* 15 */,
    2	/* 16 */,
    2	/* 17 */,
    3	/* 18 */,
    3	/* 18/01-18/09 */,
    3	/* 18/10-18/19 */,
    3	/* 18/20-18/29 */,
    3	/* 18/30-18/39 */,
    3	/* 18/40-18/49 */,
    4	/* 18/50-18/59 */,
    4	/* 18/60-18/69 */,
    5	/* 18/70-18/79 */,
    5	/* 18/80-18/89 */,
    6	/* 18/90-18/99 */,
    7	/* 18/100 */,
    8	/* 18/101-18/109 */,
    9	/* 18/110-18/119 */,
    10	/* 18/120-18/129 */,
    11	/* 18/130-18/139 */,
    12	/* 18/140-18/149 */,
    13	/* 18/150-18/159 */,
    14	/* 18/160-18/169 */,
    15	/* 18/170-18/179 */,
    16	/* 18/180-18/189 */,
    17	/* 18/190-18/199 */,
    18	/* 18/200-18/209 */,
    19	/* 18/210-18/219 */,
    20	/* 18/220+ */
};


/*
 * Stat Table (INT) -- Magic devices
 */
s16b adj_int_dev[] = {
    0	/* 3 */,
    0	/* 4 */,
    0	/* 5 */,
    0	/* 6 */,
    0	/* 7 */,
    1	/* 8 */,
    1	/* 9 */,
    1	/* 10 */,
    1	/* 11 */,
    1	/* 12 */,
    1	/* 13 */,
    1	/* 14 */,
    2	/* 15 */,
    2	/* 16 */,
    2	/* 17 */,
    3	/* 18 */,
    3	/* 18/01-18/09 */,
    3	/* 18/10-18/19 */,
    3	/* 18/20-18/29 */,
    3	/* 18/30-18/39 */,
    3	/* 18/40-18/49 */,
    4	/* 18/50-18/59 */,
    4	/* 18/60-18/69 */,
    5	/* 18/70-18/79 */,
    5	/* 18/80-18/89 */,
    6	/* 18/90-18/99 */,
    7	/* 18/100 */,
    8	/* 18/101-18/109 */,
    9	/* 18/110-18/119 */,
    10	/* 18/120-18/129 */,
    11	/* 18/130-18/139 */,
    12	/* 18/140-18/149 */,
    13	/* 18/150-18/159 */,
    14	/* 18/160-18/169 */,
    15	/* 18/170-18/179 */,
    16	/* 18/180-18/189 */,
    17	/* 18/190-18/199 */,
    18	/* 18/200-18/209 */,
    19	/* 18/210-18/219 */,
    20	/* 18/220+ */
};


/*
 * Stat Table (WIS) -- Saving throw
 */
s16b adj_wis_sav[] = {
    0	/* 3 */,
    0	/* 4 */,
    0	/* 5 */,
    0	/* 6 */,
    0	/* 7 */,
    1	/* 8 */,
    1	/* 9 */,
    1	/* 10 */,
    1	/* 11 */,
    1	/* 12 */,
    1	/* 13 */,
    1	/* 14 */,
    2	/* 15 */,
    2	/* 16 */,
    2	/* 17 */,
    3	/* 18 */,
    3	/* 18/01-18/09 */,
    3	/* 18/10-18/19 */,
    3	/* 18/20-18/29 */,
    3	/* 18/30-18/39 */,
    3	/* 18/40-18/49 */,
    4	/* 18/50-18/59 */,
    4	/* 18/60-18/69 */,
    5	/* 18/70-18/79 */,
    5	/* 18/80-18/89 */,
    6	/* 18/90-18/99 */,
    7	/* 18/100 */,
    8	/* 18/101-18/109 */,
    9	/* 18/110-18/119 */,
    10	/* 18/120-18/129 */,
    11	/* 18/130-18/139 */,
    12	/* 18/140-18/149 */,
    13	/* 18/150-18/159 */,
    14	/* 18/160-18/169 */,
    15	/* 18/170-18/179 */,
    16	/* 18/180-18/189 */,
    17	/* 18/190-18/199 */,
    18	/* 18/200-18/209 */,
    19	/* 18/210-18/219 */,
    20	/* 18/220+ */
};



/*
 * Stat Table (DEX) -- disarming
 */
s16b adj_dex_dis[] = {
    -12	/* 3 */,
    -8	/* 4 */,
    -4	/* 5 */,
    -2	/* 6 */,
    -1	/* 7 */,
    0	/* 8 */,
    0	/* 9 */,
    0	/* 10 */,
    0	/* 11 */,
    0	/* 12 */,
    1	/* 13 */,
    1	/* 14 */,
    1	/* 15 */,
    2	/* 16 */,
    2	/* 17 */,
    4	/* 18 */,
    4	/* 18/01-18/09 */,
    4	/* 18/10-18/19 */,
    4	/* 18/20-18/29 */,
    4	/* 18/30-18/39 */,
    5	/* 18/40-18/49 */,
    5	/* 18/50-18/59 */,
    5	/* 18/60-18/69 */,
    6	/* 18/70-18/79 */,
    6	/* 18/80-18/89 */,
    7	/* 18/90-18/99 */,
    8	/* 18/100 */,
    8	/* 18/101-18/109 */,
    8	/* 18/110-18/119 */,
    8	/* 18/120-18/129 */,
    8	/* 18/130-18/139 */,
    8	/* 18/140-18/149 */,
    9	/* 18/150-18/159 */,
    9	/* 18/160-18/169 */,
    9	/* 18/170-18/179 */,
    9	/* 18/180-18/189 */,
    9	/* 18/190-18/199 */,
    10	/* 18/200-18/209 */,
    10	/* 18/210-18/219 */,
    10	/* 18/220+ */
};


/*
 * Stat Table (INT) -- disarming
 */
s16b adj_int_dis[] = {
    0	/* 3 */,
    0	/* 4 */,
    0	/* 5 */,
    0	/* 6 */,
    0	/* 7 */,
    1	/* 8 */,
    1	/* 9 */,
    1	/* 10 */,
    1	/* 11 */,
    1	/* 12 */,
    1	/* 13 */,
    1	/* 14 */,
    2	/* 15 */,
    2	/* 16 */,
    2	/* 17 */,
    3	/* 18 */,
    3	/* 18/01-18/09 */,
    3	/* 18/10-18/19 */,
    3	/* 18/20-18/29 */,
    3	/* 18/30-18/39 */,
    3	/* 18/40-18/49 */,
    4	/* 18/50-18/59 */,
    4	/* 18/60-18/69 */,
    5	/* 18/70-18/79 */,
    5	/* 18/80-18/89 */,
    6	/* 18/90-18/99 */,
    7	/* 18/100 */,
    8	/* 18/101-18/109 */,
    9	/* 18/110-18/119 */,
    10	/* 18/120-18/129 */,
    11	/* 18/130-18/139 */,
    12	/* 18/140-18/149 */,
    13	/* 18/150-18/159 */,
    14	/* 18/160-18/169 */,
    15	/* 18/170-18/179 */,
    16	/* 18/180-18/189 */,
    17	/* 18/190-18/199 */,
    18	/* 18/200-18/209 */,
    19	/* 18/210-18/219 */,
    20	/* 18/220+ */
};


/*
 * Stat Table (DEX) -- bonus to ac
 */
s16b adj_dex_ta[] = {
    -4	/* 3 */,
    -3	/* 4 */,
    -2	/* 5 */,
    -1	/* 6 */,
    0	/* 7 */,
    0	/* 8 */,
    0	/* 9 */,
    0	/* 10 */,
    0	/* 11 */,
    0	/* 12 */,
    0	/* 13 */,
    0	/* 14 */,
    1	/* 15 */,
    1	/* 16 */,
    1	/* 17 */,
    2	/* 18 */,
    2	/* 18/01-18/09 */,
    2	/* 18/10-18/19 */,
    2	/* 18/20-18/29 */,
    2	/* 18/30-18/39 */,
    2	/* 18/40-18/49 */,
    3	/* 18/50-18/59 */,
    3	/* 18/60-18/69 */,
    3	/* 18/70-18/79 */,
    4	/* 18/80-18/89 */,
    5	/* 18/90-18/99 */,
    6	/* 18/100 */,
    6	/* 18/101-18/109 */,
    7	/* 18/110-18/119 */,
    8	/* 18/120-18/129 */,
    9	/* 18/130-18/139 */,
    9	/* 18/140-18/149 */,
    10	/* 18/150-18/159 */,
    11	/* 18/160-18/169 */,
    12	/* 18/170-18/179 */,
    13	/* 18/180-18/189 */,
    14	/* 18/190-18/199 */,
    15	/* 18/200-18/209 */,
    15	/* 18/210-18/219 */,
    15	/* 18/220+ */
};


/*
 * Stat Table (STR) -- bonus to dam
 */
s16b adj_str_td[] = {
    -2	/* 3 */,
    -2	/* 4 */,
    -1	/* 5 */,
    -1	/* 6 */,
    0	/* 7 */,
    0	/* 8 */,
    0	/* 9 */,
    0	/* 10 */,
    0	/* 11 */,
    0	/* 12 */,
    0	/* 13 */,
    0	/* 14 */,
    0	/* 15 */,
    1	/* 16 */,
    2	/* 17 */,
    2	/* 18 */,
    3	/* 18/01-18/09 */,
    3	/* 18/10-18/19 */,
    3	/* 18/20-18/29 */,
    3	/* 18/30-18/39 */,
    3	/* 18/40-18/49 */,
    3	/* 18/50-18/59 */,
    3	/* 18/60-18/69 */,
    4	/* 18/70-18/79 */,
    5	/* 18/80-18/89 */,
    5	/* 18/90-18/99 */,
    6	/* 18/100 */,
    6	/* 18/101-18/109 */,
    7	/* 18/110-18/119 */,
    8	/* 18/120-18/129 */,
    9	/* 18/130-18/139 */,
    10	/* 18/140-18/149 */,
    11	/* 18/150-18/159 */,
    12	/* 18/160-18/169 */,
    13	/* 18/170-18/179 */,
    14	/* 18/180-18/189 */,
    15	/* 18/190-18/199 */,
    16	/* 18/200-18/209 */,
    18	/* 18/210-18/219 */,
    20	/* 18/220+ */
};


/*
 * Stat Table (DEX) -- bonus to hit
 */
s16b adj_dex_th[] = {
    -3	/* 3 */,
    -2	/* 4 */,
    -2	/* 5 */,
    -1	/* 6 */,
    -1	/* 7 */,
    0	/* 8 */,
    0	/* 9 */,
    0	/* 10 */,
    0	/* 11 */,
    0	/* 12 */,
    0	/* 13 */,
    0	/* 14 */,
    0	/* 15 */,
    1	/* 16 */,
    2	/* 17 */,
    3	/* 18 */,
    3	/* 18/01-18/09 */,
    3	/* 18/10-18/19 */,
    3	/* 18/20-18/29 */,
    3	/* 18/30-18/39 */,
    3	/* 18/40-18/49 */,
    4	/* 18/50-18/59 */,
    4	/* 18/60-18/69 */,
    4	/* 18/70-18/79 */,
    4	/* 18/80-18/89 */,
    5	/* 18/90-18/99 */,
    6	/* 18/100 */,
    6	/* 18/101-18/109 */,
    7	/* 18/110-18/119 */,
    8	/* 18/120-18/129 */,
    9	/* 18/130-18/139 */,
    9	/* 18/140-18/149 */,
    10	/* 18/150-18/159 */,
    11	/* 18/160-18/169 */,
    12	/* 18/170-18/179 */,
    13	/* 18/180-18/189 */,
    14	/* 18/190-18/199 */,
    15	/* 18/200-18/209 */,
    15	/* 18/210-18/219 */,
    15	/* 18/220+ */
};


/*
 * Stat Table (STR) -- bonus to hit
 */
s16b adj_str_th[] = {
    -3	/* 3 */,
    -2	/* 4 */,
    -1	/* 5 */,
    -1	/* 6 */,
    0	/* 7 */,
    0	/* 8 */,
    0	/* 9 */,
    0	/* 10 */,
    0	/* 11 */,
    0	/* 12 */,
    0	/* 13 */,
    0	/* 14 */,
    0	/* 15 */,
    0	/* 16 */,
    0	/* 17 */,
    1	/* 18 */,
    1	/* 18/01-18/09 */,
    1	/* 18/10-18/19 */,
    1	/* 18/20-18/29 */,
    1	/* 18/30-18/39 */,
    1	/* 18/40-18/49 */,
    1	/* 18/50-18/59 */,
    1	/* 18/60-18/69 */,
    2	/* 18/70-18/79 */,
    3	/* 18/80-18/89 */,
    4	/* 18/90-18/99 */,
    5	/* 18/100 */,
    5	/* 18/101-18/109 */,
    6	/* 18/110-18/119 */,
    7	/* 18/120-18/129 */,
    8	/* 18/130-18/139 */,
    9	/* 18/140-18/149 */,
    10	/* 18/150-18/159 */,
    11	/* 18/160-18/169 */,
    12	/* 18/170-18/179 */,
    13	/* 18/180-18/189 */,
    14	/* 18/190-18/199 */,
    15	/* 18/200-18/209 */,
    15	/* 18/210-18/219 */,
    15	/* 18/220+ */
};



/*
 * Stat Table (STR) -- weight limit in pounds
 */
s16b adj_str_wgt[] = {
     50	/* 3 */,
     60	/* 4 */,
     70	/* 5 */,
     80	/* 6 */,
     90	/* 7 */,
    100	/* 8 */,
    110	/* 9 */,
    120	/* 10 */,
    130	/* 11 */,
    140	/* 12 */,
    150	/* 13 */,
    160	/* 14 */,
    170	/* 15 */,
    180	/* 16 */,
    190	/* 17 */,
    200	/* 18 */,
    300	/* 18/01-18/09 */,
    300	/* 18/10-18/19 */,
    300	/* 18/20-18/29 */,
    300	/* 18/30-18/39 */,
    300	/* 18/40-18/49 */,
    300	/* 18/50-18/59 */,
    300	/* 18/60-18/69 */,
    300	/* 18/70-18/79 */,
    300	/* 18/80-18/89 */,
    300	/* 18/90-18/99 */,
    300	/* 18/100 */,
    300	/* 18/101-18/109 */,
    300	/* 18/110-18/119 */,
    300	/* 18/120-18/129 */,
    300	/* 18/130-18/139 */,
    300	/* 18/140-18/149 */,
    300	/* 18/150-18/159 */,
    300	/* 18/160-18/169 */,
    300	/* 18/170-18/179 */,
    300	/* 18/180-18/189 */,
    300	/* 18/190-18/199 */,
    300	/* 18/200-18/209 */,
    300	/* 18/210-18/219 */,
    300	/* 18/220+ */
};


/*
 * Stat Table (STR) -- weapon weight limit in tenth-pounds
 */
s16b adj_str_hold[] = {
     50	/* 3 */,
     60	/* 4 */,
     75	/* 5 */,
     90	/* 6 */,
    105	/* 7 */,
    120	/* 8 */,
    135	/* 9 */,
    150	/* 10 */,
    165	/* 11 */,
    180	/* 12 */,
    195	/* 13 */,
    210	/* 14 */,
    225	/* 15 */,
    240	/* 16 */,
    260	/* 17 */,
    280	/* 18 */,
    300	/* 18/01-18/09 */,
    300	/* 18/10-18/19 */,
    350	/* 18/20-18/29 */,
    400	/* 18/30-18/39 */,
    450	/* 18/40-18/49 */,
    500	/* 18/50-18/59 */,
    550	/* 18/60-18/69 */,
    600	/* 18/70-18/79 */,
    650	/* 18/80-18/89 */,
    700	/* 18/90-18/99 */,
    800	/* 18/100 */,
    800	/* 18/101-18/109 */,
    800	/* 18/110-18/119 */,
    800	/* 18/120-18/129 */,
    800	/* 18/130-18/139 */,
    800	/* 18/140-18/149 */,
    900	/* 18/150-18/159 */,
    900	/* 18/160-18/169 */,
    900	/* 18/170-18/179 */,
    900	/* 18/180-18/189 */,
    900	/* 18/190-18/199 */,
   1000	/* 18/200-18/209 */,
   1000	/* 18/210-18/219 */,
   1000	/* 18/220+ */
};


/*
 * Stat Table (STR) -- help index into the "blow" table
 */
s16b adj_str_blow[] = {
      3	/* 3 */,
      4	/* 4 */,
      5	/* 5 */,
      6	/* 6 */,
      7	/* 7 */,
      8	/* 8 */,
      9	/* 9 */,
     10	/* 10 */,
     11	/* 11 */,
     12	/* 12 */,
     13	/* 13 */,
     14	/* 14 */,
     15	/* 15 */,
     16	/* 16 */,
     17	/* 17 */,
     20	/* 18 */,
     25	/* 18/01-18/09 */,
     30	/* 18/10-18/19 */,
     35	/* 18/20-18/29 */,
     40	/* 18/30-18/39 */,
     45	/* 18/40-18/49 */,
     50	/* 18/50-18/59 */,
     60	/* 18/60-18/69 */,
     70	/* 18/70-18/79 */,
     80	/* 18/80-18/89 */,
     90	/* 18/90-18/99 */,
    100	/* 18/100 */,
    100	/* 18/101-18/109 */,
    110	/* 18/110-18/119 */,
    120	/* 18/120-18/129 */,
    130	/* 18/130-18/139 */,
    140	/* 18/140-18/149 */,
    150	/* 18/150-18/159 */,
    160	/* 18/160-18/169 */,
    170	/* 18/170-18/179 */,
    180	/* 18/180-18/189 */,
    190	/* 18/190-18/199 */,
    200	/* 18/200-18/209 */,
    200	/* 18/210-18/219 */,
    200	/* 18/220+ */
};


/*
 * Stat Table (DEX) -- index into the "blow" table
 */
s16b adj_dex_blow[] = {
    0	/* 3 */,
    0	/* 4 */,
    0	/* 5 */,
    0	/* 6 */,
    0	/* 7 */,
    0	/* 8 */,
    0	/* 9 */,
    1	/* 10 */,
    1	/* 11 */,
    1	/* 12 */,
    1	/* 13 */,
    1	/* 14 */,
    1	/* 15 */,
    1	/* 16 */,
    1	/* 17 */,
    1	/* 18 */,
    2	/* 18/01-18/09 */,
    2	/* 18/10-18/19 */,
    2	/* 18/20-18/29 */,
    2	/* 18/30-18/39 */,
    2	/* 18/40-18/49 */,
    3	/* 18/50-18/59 */,
    3	/* 18/60-18/69 */,
    3	/* 18/70-18/79 */,
    3	/* 18/80-18/89 */,
    4	/* 18/90-18/99 */,
    5	/* 18/100 */,
    6	/* 18/101-18/109 */,
    7	/* 18/110-18/119 */,
    8	/* 18/120-18/129 */,
    9	/* 18/130-18/139 */,
    10	/* 18/140-18/149 */,
    11	/* 18/150-18/159 */,
    12	/* 18/160-18/169 */,
    14	/* 18/170-18/179 */,
    16	/* 18/180-18/189 */,
    18	/* 18/190-18/199 */,
    20	/* 18/200-18/209 */,
    20	/* 18/210-18/219 */,
    20	/* 18/220+ */
};


/*
 * Stat Table (DEX) -- chance of avoiding "theft" and "falling"
 */
s16b adj_dex_safe[] = {
    0	/* 3 */,
    1	/* 4 */,
    2	/* 5 */,
    3	/* 6 */,
    4	/* 7 */,
    5	/* 8 */,
    5	/* 9 */,
    6	/* 10 */,
    6	/* 11 */,
    7	/* 12 */,
    7	/* 13 */,
    8	/* 14 */,
    8	/* 15 */,
    9	/* 16 */,
    9	/* 17 */,
    10	/* 18 */,
    15	/* 18/01-18/09 */,
    20	/* 18/10-18/19 */,
    25	/* 18/20-18/29 */,
    30	/* 18/30-18/39 */,
    35	/* 18/40-18/49 */,
    40	/* 18/50-18/59 */,
    45	/* 18/60-18/69 */,
    50	/* 18/70-18/79 */,
    55	/* 18/80-18/89 */,
    60	/* 18/90-18/99 */,
    65	/* 18/100 */,
    65	/* 18/101-18/109 */,
    70	/* 18/110-18/119 */,
    75	/* 18/120-18/129 */,
    80	/* 18/130-18/139 */,
    90	/* 18/140-18/149 */,
    100	/* 18/150-18/159 */,
    100	/* 18/160-18/169 */,
    100	/* 18/170-18/179 */,
    100	/* 18/180-18/189 */,
    100	/* 18/190-18/199 */,
    100	/* 18/200-18/209 */,
    100	/* 18/210-18/219 */,
    100	/* 18/220+ */
};


/*
 * Stat Table (CON) -- base regeneration rate
 */
s16b adj_con_fix[] = {
    0	/* 3 */,
    0	/* 4 */,
    0	/* 5 */,
    0	/* 6 */,
    0	/* 7 */,
    0	/* 8 */,
    0	/* 9 */,
    0	/* 10 */,
    0	/* 11 */,
    0	/* 12 */,
    0	/* 13 */,
    1	/* 14 */,
    1	/* 15 */,
    1	/* 16 */,
    1	/* 17 */,
    2	/* 18 */,
    2	/* 18/01-18/09 */,
    2	/* 18/10-18/19 */,
    2	/* 18/20-18/29 */,
    2	/* 18/30-18/39 */,
    2	/* 18/40-18/49 */,
    3	/* 18/50-18/59 */,
    3	/* 18/60-18/69 */,
    3	/* 18/70-18/79 */,
    3	/* 18/80-18/89 */,
    3	/* 18/90-18/99 */,
    4	/* 18/100 */,
    4	/* 18/101-18/109 */,
    5	/* 18/110-18/119 */,
    6	/* 18/120-18/129 */,
    7	/* 18/130-18/139 */,
    8	/* 18/140-18/149 */,
    9	/* 18/150-18/159 */,
    10	/* 18/160-18/169 */,
    11	/* 18/170-18/179 */,
    12	/* 18/180-18/189 */,
    13	/* 18/190-18/199 */,
    13	/* 18/200-18/209 */,
    14	/* 18/210-18/219 */,
    15	/* 18/220+ */
};


/*
 * Stat Table (CON) -- extra half-hitpoints per level
 */
s16b adj_con_mhp[] = {
    -8	/* 3 */,
    -4	/* 4 */,
    -2	/* 5 */,
    -1	/* 6 */,
    0	/* 7 */,
    0	/* 8 */,
    0	/* 9 */,
    0	/* 10 */,
    0	/* 11 */,
    0	/* 12 */,
    0	/* 13 */,
    0	/* 14 */,
    1	/* 15 */,
    1	/* 16 */,
    2	/* 17 */,
    3	/* 18 */,
    4	/* 18/01-18/09 */,
    4	/* 18/10-18/19 */,
    4	/* 18/20-18/29 */,
    4	/* 18/30-18/39 */,
    4	/* 18/40-18/49 */,
    5	/* 18/50-18/59 */,
    5	/* 18/60-18/69 */,
    6	/* 18/70-18/79 */,
    7	/* 18/80-18/89 */,
    8	/* 18/90-18/99 */,
    9	/* 18/100 */,
    10	/* 18/101-18/109 */,
    11	/* 18/110-18/119 */,
    12	/* 18/120-18/129 */,
    13	/* 18/130-18/139 */,
    14	/* 18/140-18/149 */,
    15	/* 18/150-18/159 */,
    16	/* 18/160-18/169 */,
    18	/* 18/170-18/179 */,
    20	/* 18/180-18/189 */,
    22	/* 18/190-18/199 */,
    25	/* 18/200-18/209 */,
    25	/* 18/210-18/219 */,
    25	/* 18/220+ */
};


/*
 * Stat Table (CHR) -- payment percentages
 */
s16b adj_chr[] = {
    130	/* 3 */,
    125	/* 4 */,
    122	/* 5 */,
    120	/* 6 */,
    118	/* 7 */,
    116	/* 8 */,
    114	/* 9 */,
    112	/* 10 */,
    110	/* 11 */,
    108	/* 12 */,
    106	/* 13 */,
    104	/* 14 */,
    103	/* 15 */,
    102	/* 16 */,
    101	/* 17 */,
    100	/* 18 */,
    99	/* 18/01-18/09 */,
    98	/* 18/10-18/19 */,
    97	/* 18/20-18/29 */,
    96	/* 18/30-18/39 */,
    96	/* 18/40-18/49 */,
    95	/* 18/50-18/59 */,
    94	/* 18/60-18/69 */,
    93	/* 18/70-18/79 */,
    92	/* 18/80-18/89 */,
    91	/* 18/90-18/99 */,
    90	/* 18/100 */,
    90	/* 18/101-18/109 */,
    89	/* 18/110-18/119 */,
    88	/* 18/120-18/129 */,
    87	/* 18/130-18/139 */,
    86	/* 18/140-18/149 */,
    85	/* 18/150-18/159 */,
    84	/* 18/160-18/169 */,
    83	/* 18/170-18/179 */,
    82	/* 18/180-18/189 */,
    81	/* 18/190-18/199 */,
    80	/* 18/200-18/209 */,
    80	/* 18/210-18/219 */,
    80	/* 18/220+ */
};



/*
 * This table is used to help calculate the number of blows the player can
 * make in a single round of attacks (one player turn) with a normal weapon.
 *
 * This number ranges from a single blow/round for weak players to up to six
 * blows/round for powerful warriors.
 *
 * Note that certain artifacts and ego-items give "bonus" blows/round.
 *
 * First, from the player class, we extract some values:
 *
 *    Warrior --> num = 6; mul = 5; div = MAX(30, weapon_weight);
 *    Mage    --> num = 4; mul = 2; div = MAX(40, weapon_weight);
 *    Priest  --> num = 5; mul = 3; div = MAX(35, weapon_weight);
 *    Rogue   --> num = 5; mul = 3; div = MAX(30, weapon_weight);
 *    Ranger  --> num = 5; mul = 4; div = MAX(35, weapon_weight);
 *    Paladin --> num = 5; mul = 4; div = MAX(30, weapon_weight);
 *
 * To get "P", we look up the relevant "adj_str_blow[]" (see above),
 * multiply it by "mul", and then divide it by "div", rounding down.
 *
 * To get "D", we look up the relevant "adj_dex_blow[]" (see above),
 * note especially column 6 (DEX 18/101) and 11 (DEX 18/150).
 *
 * The player gets "blows_table[P][D]" blows/round, as shown below,
 * up to a maximum of "num" blows/round, plus any "bonus" blows/round.
 */
byte blows_table[12][12] = {

/* P/D		   0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11+ */

/* 0  */	{  1,   1,   1,   1,   1,   1,   2,   2,   2,   2,   2,   3 },
/* 1  */	{  1,   1,   1,   1,   2,   2,   3,   3,   3,   4,   4,   4 },
/* 2  */	{  1,   1,   1,   2,   3,   3,   4,   4,   4,   5,   5,   5 },
/* 3  */	{  1,   2,   2,   3,   3,   4,   4,   4,   5,   5,   5,   5 },
/* 4  */	{  1,   2,   2,   3,   3,   4,   4,   5,   5,   5,   5,   5 },
/* 5  */	{  2,   2,   3,   3,   4,   4,   5,   5,   5,   5,   5,   6 },
/* 6  */	{  2,   2,   3,   3,   4,   4,   5,   5,   5,   5,   5,   6 },
/* 7  */	{  2,   3,   3,   4,   4,   4,   5,   5,   5,   5,   5,   6 },
/* 8  */	{  3,   3,   3,   4,   4,   4,   5,   5,   5,   5,   6,   6 },
/* 9  */	{  3,   3,   4,   4,   4,   4,   5,   5,   5,   5,   6,   6 },
/* 10 */	{  3,   3,   4,   4,   4,   4,   5,   5,   5,   6,   6,   6 },
/* 11+ */	{  3,   3,   4,   4,   4,   4,   5,   5,   6,   6,   6,   6 },

};


#if 0

byte old_blows_table[11][12] = {

/* P/D		   3,  10, /01, /50, /90,/100,/101,/110,/120,/130,/140,/150 */

/* 0+ */	{  1,   1,   1,   1,   1,   1,   2,   2,   2,   2,   2,   3},
/* 2+ */	{  1,   1,   1,   1,   2,   2,   3,   3,   3,   3,   3,   4},
/* 3+ */	{  1,   1,   1,   2,   2,   3,   4,   4,   4,   4,   4,   5},
/* 4+ */	{  1,   1,   2,   2,   3,   3,   4,   4,   4,   5,   5,   5},
/* 6+ */	{  1,   2,   2,   3,   3,   4,   4,   4,   5,   5,   5,   5},
/* 8+ */	{  1,   2,   2,   3,   4,   4,   4,   5,   5,   5,   5,   5},
/* 10+ */	{  2,   2,   3,   3,   4,   4,   5,   5,   5,   5,   5,   6},
/* 13+ */	{  2,   3,   3,   3,   4,   4,   5,   5,   5,   5,   5,   6},
/* 15+ */	{  3,   3,   3,   4,   4,   4,   5,   5,   5,   5,   6,   6},
/* 18+ */	{  3,   3,   3,   4,   4,   4,   5,   5,   5,   5,   6,   6},
/* 20+ */	{  3,   3,   4,   4,   4,   4,   5,   5,   5,   6,   6,   6}

};

#endif



/*
 * Store owners (several possible owners per store)
 * { name, purse, max greed, min greed, haggle_per, race, tolerance }
 */
owner_type owners[MAX_STORES][MAX_OWNERS] = {

  {
    /* General store */
    { "Bilbo the Friendly",	200,	170,  108,    5,  3, 15},
    { "Rincewind the Chicken",	200,	175,  108,    4,  0, 12},
    { "Sultan the Midget",	300,	170,  107,    5,  4, 15},
    { "Lyar-el the Comely",	300,	165,  107,    6,  2, 18},
  },
  {
    /* Armoury */
    { "Kon-Dar the Ugly",	5000,	210,  115,    5,  6,  7},
    { "Darg-Low the Grim",	10000,	190,  111,    4,  0,  9},
    { "Decado the Handsome",	25000,  200,  112,    4,  8, 10},
    { "Mauglin the Grumpy",	30000,	200,  112,    4,  5,  5},
  },
  {
    /* Weapon Smith */
    { "Ithyl-Mak the Beastly",	5000,	210,  115,    6,  7,  8},
    { "Arndal Beast-Slayer",	10000,	185,  110,    5,  1,  8},
    { "Tarl Beast-Master",	25000,	190,  115,    5,  3,  8},
    { "Oglign Dragon-Slayer",	30000,	195,  112,    4,  5,  8},
  },
  {
    /* Temple */
    { "Ludwig the Humble",	5000,	175,  109,    6,  0, 15},
    { "Gunnar the Paladin",	10000,	185,  110,    5,  0, 23},
    { "Delilah the Pure",	25000,	180,  107,    6,  2, 20},
    { "Bosk the Wise",		30000,	185,  109,    5,  5, 15},
  },
  {
    { "Mauser the Chemist",	10000,	190,  111,    5,  1,  8},
    { "Wizzle the Chaotic",	10000,	190,  110,    6,  3,  8},
    { "Ga-nat the Greedy",	15000,	200,  116,    6,  4,  9},
    { "Sasha the Slender",	15000,	220,  111,    4,  2,  9},
  },
  {
    /* Magic Shop */
    { "Ariel the Sorceress",	20000,	200,  110,    7,  1, 8},
    { "Buggerby the Great",	20000,	215,  113,    6,  4, 10},
    { "Inglorian the Mage",	30000,	200,  110,    7,  0, 10},
    { "Luthien Starshine",	30000,	175,  110,    5,  9, 11},
  },
  {
    /* Black Market */
    { "Lo-Hak the Awful",	20000,	250,  150,   10,  7,  5},
    { "Histor the Goblin",	20000,	250,  150,   10,  6,  5},
    { "Durwin the Shifty",	30000,	250,  150,   10,  0,  5},
    { "Drago the Fair",		30000,	250,  150,   10,  2,  5},
  },
  {
    /* Home */
    { "Your home",		0,  100,  100,    0, 99, 99},
    { "Your home",		0,  100,  100,    0, 99, 99},
    { "Your home",		0,  100,  100,    0, 99, 99},
    { "Your home",		0,  100,  100,    0, 99, 99}
  }
};


/*
 * Buying and selling adjustments for race combinations.
 * Entry[owner][player] gives the basic "cost inflation".
 */
byte rgold_adj[MAX_RACES][MAX_RACES] = {

                        /*Hum, HfE, Elf,  Hal, Gno, Dwa, HfO, HfT, Dun, HiE*/

/*Human		 */	 { 100, 105, 105, 110, 113, 115, 120, 125, 100, 105},
/*Half-Elf	 */	 { 110, 100, 100, 105, 110, 120, 125, 130, 110, 100},
/*Elf		 */	 { 110, 105, 100, 105, 110, 120, 125, 130, 110, 100},
/*Halfling	 */	 { 115, 110, 105,  95, 105, 110, 115, 130, 115, 105},
/*Gnome		 */	 { 115, 115, 110, 105,  95, 110, 115, 130, 115, 110},
/*Dwarf		 */	 { 115, 120, 120, 110, 110,  95, 125, 135, 115, 120},
/*Half-Orc	 */	 { 115, 120, 125, 115, 115, 130, 110, 115, 115, 125},
/*Half-Troll	 */	 { 110, 115, 115, 110, 110, 130, 110, 110, 110, 115},
/*Dunedain 	 */	 { 100, 105, 105, 110, 113, 115, 120, 125, 100, 105},
/*High_Elf	 */	 { 110, 105, 100, 105, 110, 120, 125, 130, 110, 100}

};




/*
 * This table allows quick conversion from "speed" to "energy"
 * The basic function WAS ((S>=110) ? (S-110) : (100 / (120-S)))
 * Note that table access is *much* quicker than computation.
 *
 * Note that the table has been changed at high speeds.  From
 * "Slow (-40)" to "Fast (+30)" is pretty much unchanged, but
 * at speeds above "Fast (+30)", one approaches an asymptotic
 * effective limit of 50 energy per turn.  This means that it
 * is relatively easy to reach "Fast (+30)" and get about 40
 * energy per turn, but then speed becomes very "expensive",
 * and you must get all the way to "Fast (+50)" to reach the
 * point of getting 45 energy per turn.  After that point,
 * furthur increases in speed are more or less pointless,
 * except to balance out heavy inventory.
 *
 * Note that currently the fastest monster is "Fast (+30)".
 *
 * It should be possible to lower the energy threshhold from
 * 100 units to 50 units, though this may interact badly with
 * the (compiled out) small random energy boost code.  It may
 * also tend to cause more "clumping" at high speeds.
 */
byte extract_energy[200] = {
/* Slow */     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
/* Slow */     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
/* Slow */     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
/* Slow */     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
/* Slow */     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
/* Slow */     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
/* S-50 */     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
/* S-40 */     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
/* S-30 */     2,  2,  2,  2,  2,  2,  2,  3,  3,  3,
/* S-20 */     3,  3,  3,  3,  3,  4,  4,  4,  4,  4,
/* S-10 */     5,  5,  5,  5,  6,  6,  7,  7,  8,  9,
/* Norm */    10, 11, 12, 13, 14, 15, 16, 17, 18, 19,
/* F+10 */    20, 21, 22, 23, 24, 25, 26, 27, 28, 29,
/* F+20 */    30, 31, 32, 33, 34, 35, 36, 36, 37, 37,
/* F+30 */    38, 38, 39, 39, 40, 40, 40, 41, 41, 41,
/* F+40 */    42, 42, 42, 43, 43, 43, 44, 44, 44, 44,
/* F+50 */    45, 45, 45, 45, 45, 46, 46, 46, 46, 46,
/* F+60 */    47, 47, 47, 47, 47, 48, 48, 48, 48, 48,
/* F+70 */    49, 49, 49, 49, 49, 49, 49, 49, 49, 49,
/* Fast */    49, 49, 49, 49, 49, 49, 49, 49, 49, 49,
};



/*
 * This table is used to generate a psuedo-normal distribution.
 * See the function randnor() in misc1.c, this is much faster than calling
 * transcendental function to calculate a true normal distribution
 */
u16b normal_table[NORMAL_TABLE_SIZE] = {
     206,     613,    1022,    1430,	1838,	 2245,	  2652,	   3058,
    3463,    3867,    4271,    4673,	5075,	 5475,	  5874,	   6271,
    6667,    7061,    7454,    7845,	8234,	 8621,	  9006,	   9389,
    9770,   10148,   10524,   10898,   11269,	11638,	 12004,	  12367,
   12727,   13085,   13440,   13792,   14140,	14486,	 14828,	  15168,
   15504,   15836,   16166,   16492,   16814,	17133,	 17449,	  17761,
   18069,   18374,   18675,   18972,   19266,	19556,	 19842,	  20124,
   20403,   20678,   20949,   21216,   21479,	21738,	 21994,	  22245,
   22493,   22737,   22977,   23213,   23446,	23674,	 23899,	  24120,
   24336,   24550,   24759,   24965,   25166,	25365,	 25559,	  25750,
   25937,   26120,   26300,   26476,   26649,	26818,	 26983,	  27146,
   27304,   27460,   27612,   27760,   27906,	28048,	 28187,	  28323,
   28455,   28585,   28711,   28835,   28955,	29073,	 29188,	  29299,
   29409,   29515,   29619,   29720,   29818,	29914,	 30007,	  30098,
   30186,   30272,   30356,   30437,   30516,	30593,	 30668,	  30740,
   30810,   30879,   30945,   31010,   31072,	31133,	 31192,	  31249,
   31304,   31358,   31410,   31460,   31509,	31556,	 31601,	  31646,
   31688,   31730,   31770,   31808,   31846,	31882,	 31917,	  31950,
   31983,   32014,   32044,   32074,   32102,	32129,	 32155,	  32180,
   32205,   32228,   32251,   32273,   32294,	32314,	 32333,	  32352,
   32370,   32387,   32404,   32420,   32435,	32450,	 32464,	  32477,
   32490,   32503,   32515,   32526,   32537,	32548,	 32558,	  32568,
   32577,   32586,   32595,   32603,   32611,	32618,	 32625,	  32632,
   32639,   32645,   32651,   32657,   32662,	32667,	 32672,	  32677,
   32682,   32686,   32690,   32694,   32698,	32702,	 32705,	  32708,
   32711,   32714,   32717,   32720,   32722,	32725,	 32727,	  32729,
   32731,   32733,   32735,   32737,   32739,	32740,	 32742,	  32743,
   32745,   32746,   32747,   32748,   32749,	32750,	 32751,	  32752,
   32753,   32754,   32755,   32756,   32757,	32757,	 32758,	  32758,
   32759,   32760,   32760,   32761,   32761,	32761,	 32762,	  32762,
   32763,   32763,   32763,   32764,   32764,	32764,	 32764,	  32765,
   32765,   32765,   32765,   32766,   32766,	32766,	 32766,	  32766,
};





/*
 * Special name table
 */

cptr ego_item_names[EGO_MAX] = {

    NULL,			/* 0 */
    "of Resistance",
    "of Resist Acid",
    "of Resist Fire",
    "of Resist Cold",
    "of Resist Lightning",
    "(Holy Avenger)",
    "(Defender)",
    "of Animal Slaying",			/* weapon */
    "of Dragon Slaying",			/* weapon */
    "of Slay Evil",		/* 10 */	/* weapon */
    "of Slay Undead",				/* weapon */
    "of Flame",
    "of Frost",
    "of Free Action",
    "of Slaying",		/* 15 */
NULL,
NULL,
    "of Slow Descent",
    "of Speed",
    "of Stealth",		/* 20 */
NULL,
NULL,
NULL,
    "of Intelligence",
    "of Wisdom",		/* 25 */
    "of Infra-Vision",
    "of Might",
    "of Lordliness",
    "of the Magi",
    "of Beauty",		/* 30 */
    "of Seeing",
    "of Regeneration",
NULL,
NULL,
NULL,				/* 35 */
NULL,
NULL,
    "of the Magi",				/* robe (new) */
    "of Protection",				/* cloak */
NULL,				/* 40 */
NULL,
NULL,
    "of Fire",
    "of Slay Evil",				/* ammo */
    "of Slay Dragon",		/* 45 */	/* ammo */
NULL,
NULL,
NULL,
NULL,
    "of Fire",			/* 50 */	/* ammo (new) */
NULL,
    "of Slaying",				/* ammo (new) */
NULL,
NULL,
    "of Slay Animal",		/* 55 */	/* ammo */
NULL,
NULL,
NULL,
NULL,
    "of Extra Might",		/* 60 */	/* launcher */
    "of Extra Shots",				/* launcher */
NULL,
NULL,
    "of Velocity",				/* launcher (new) */
    "of Accuracy",		/* 65 */	/* launcher */
NULL,
    "of Orc Slaying",				/* weapon */
    "of Power",					/* gloves */
NULL,
NULL,				/* 70 */
    "of Westernesse",
    "(Blessed)",
    "of Demon Slaying",				/* weapon */
    "of Troll Slaying",		/* 74 */	/* weapon */
NULL,				/* 75 */
NULL,
    "of Wounding",				/* ammo */
NULL,
NULL,
NULL,				/* 80 */
    "of Light",
    "of Agility",
NULL,
NULL,
    "of Giant Slaying",		/* 85 */	/* weapon */
    "of Telepathy",
    "of Elvenkind",
NULL,
NULL,
    "of Extra Attacks",		/* 90 (was 179) */
    "of Aman",			/* 91 */
NULL,				/* 92 */
NULL,				/* 93 */
NULL,				/* 94 */
NULL,				/* 95 */
NULL,				/* 96 -- first "bad" item */
NULL,				/* 97 */
NULL,				/* 98 */
NULL,				/* 99 */
NULL,				/* 100 */
NULL,				/* 101 */
NULL,				/* 102 */
NULL,				/* 103 */
    "of Weakness",		/* 104 */
    "of Stupidity",		/* 105 */
    "of Dullness",		/* 106 */
    "of Clumsiness",		/* 107 */
    "of Sickliness",		/* 108 */
    "of Ugliness",		/* 109 */
    "of Teleportation",		/* 110 */
NULL,				/* 111 */
    "of Irritation",		/* 112 */
    "of Vulnerability",		/* 113 */
    "of Enveloping",		/* 114 */
NULL,				/* 115 */
    "of Slowness",		/* 116 */
    "of Noise",			/* 117 */
    "of Great Mass",		/* 118 */
NULL,				/* 119 */
    "of Backbiting",		/* 120 */
NULL,				/* 121 */
NULL,				/* 122 */
NULL,				/* 123 */
    "of Morgul",		/* 124 */
NULL,				/* 125 */
    "(Shattered)",		/* 126 */
    "(Blasted)",		/* 127 */
};


/*
 * Bonus "cost" of ego-items
 */
s32b ego_item_value[EGO_MAX] = {

    0L		/* NULL */,
    12500L	/* "of Resistance" */,
    1000L	/* "of Resist Acid" */,
    600L	/* "of Resist Fire" */,
    600L	/* "of Resist Cold" */,
    500L	/* "of Resist Lightning" */,
    20000L	/* "(Holy Avenger)" */,
    15000L	/* "(Defender)" */,
    2000L	/* "of Animal Slaying" */,	/* weapon */
    4000L	/* "of Dragon Slaying" */,	/* weapon */
    4000L	/* "of Slay Evil" */,		/* XXX - weapon */
    3000L	/* "of Slay Undead" */,		/* XXX - weapon */
    3000L	/* "of Flame" */,
    2500L	/* "of Frost" */,
    1000L	/* "of Free Action" */,
    1500L	/* "of Slaying" */,
    0L		/* NULL */,
    0L		/* NULL */,
    250L	/* "of Slow Descent" */,
    200000L	/* "of Speed" */,		/* XXX */
    500L	/* "of Stealth" */,
    0L		/* NULL */,
    0L		/* NULL */,
    0L		/* NULL */,
    500L	/* "of Intelligence" */,
    500L	/* "of Wisdom" */,
    500L	/* "of Infra-Vision" */,
    2000L	/* "of Might" */,
    2000L	/* "of Lordliness" */,
    7500L	/* "of the Magi" */,
    1000L	/* "of Beauty" */,
    1000L	/* "of Seeing" */,		/* XXX */
    1500L	/* "of Regeneration" */,
    0L		/* NULL */,
    0L		/* NULL */,
    0L		/* NULL */,
    0L		/* NULL */,
    0L		/* NULL */,
    30000L	/* "of the Magi" */,		/* robe (new) */
    250L	/* "of Protection" */,		/* cloak */
    0L		/* NULL */,
    0L		/* NULL */,
    0L		/* NULL */,
    2000L	/* "of Fire" */,
    25L		/* "of Slay Evil" */,		/* ammo */
    35L		/* "of Slay Dragon" */,		/* ammo */
    0L		/* NULL */,
    0L		/* NULL */,
    0L		/* NULL */,
    0L		/* NULL */,
    25L		/* "of Fire" */,		/* ammo (new) */
    0L		/* NULL */,
    45L		/* "of Slaying" */,		/* ammo (new) */
    0L		/* NULL */,
    0L		/* NULL */,
    30L		/* "of Slay Animal" */,		/* ammo */
    0L		/* NULL */,
    0L		/* NULL */,
    0L		/* NULL */,
    0L		/* NULL */,
    10000L	/* "of Extra Might" */,		/* launcher */
    10000L	/* "of Extra Shots" */,		/* launcher */
    0L		/* NULL */,
    0L		/* NULL */,
    1000L	/* "of Velocity" */,		/* launcher (new) */
    1000L	/* "of Accuracy" */,		/* launcher */
    0L		/* NULL */,
    1200L	/* "of Orc Slaying" */,		/* weapon */
    2500L	/* "of Power" */,		/* gloves */
    0L		/* NULL */,
    0L		/* NULL */,			
    20000L	/* "of Westernesse" */,		/* XXX */
    5000L	/* "(Blessed)" */,
    1200L	/* "of Demon Slaying" */,	/* weapon */
    1200L	/* "of Troll Slaying" */,	/* weapon */
    0L		/* NULL */,			
    0L		/* NULL */,
    30L		/* "of Wounding" */,		/* ammo */
    0L		/* NULL */,
    0L		/* NULL */,
    0L		/* NULL */,
    500L	/* "of Light" */,
    1000L	/* "of Agility" */,
    0L		/* NULL */,
    0L		/* NULL */,
    1200L	/* "of Giant Slaying" */,	/* weapon */
    50000L	/* "of Telepathy" */,
    15000L	/* "of Elvenkind" */,
    0L		/* NULL */,
    0L		/* NULL */,
    10000L	/* "of Extra Attacks" */,
    4000L	/* "of Aman" */,
    0L		/* NULL */,
    0L		/* NULL */,
    0L		/* NULL */,
    0L		/* NULL */,
    -999999L,
    -999999L,
    -999999L,
    -999999L,
    -999999L,
    -999999L,
    -999999L,
    -999999L,
    -999999L,
    -999999L,
    -999999L,
    -999999L,
    -999999L,
    -999999L,
    -999999L,
    -999999L,
    -999999L,
    -999999L,
    -999999L,
    -999999L,
    -999999L,
    -999999L,
    -999999L,
    -999999L,
    -999999L,
    -999999L,
    -999999L,
    -999999L,
    -999999L,
    -999999L,
    -999999L,
    -999999L
};






/*
 * Base experience levels, may be adjusted up for race and/or class
 */
s32b player_exp[PY_MAX_LEVEL] = {
        10,		25,		45,		70,
        100,		140,		200,		280,
        380,		500,		650,		850,
        1100,		1400,		1800,		2300,
        2900,		3600,		4400,		5400,
        6800,		8400,		10200,		12500,
        17500,		25000,		35000L,		50000L,
        75000L,		100000L,	150000L,	200000L,
        275000L,	350000L,	450000L,	550000L,
        700000L,	850000L,	1000000L,	1250000L,
        1500000L,	1800000L,	2100000L,	2400000L,
        2700000L,	3000000L,	3500000L,	4000000L,
        4500000L,	5000000L
};


/*
 * Player Race Information:
 *    Title,
 *    {STR,INT,WIS,DEX,CON,CHR},
 *    Age (Base, Max), Male (Hgt, Wgt), Female (Hgt, Wgt)
 *    r_dis, r_dev, r_sav, r_stl, r_srh, r_fos, r_thn, r_thb,
 *    hitdie, infra, exp base, class-choices
 */
player_race race_info[MAX_RACES] = {

    {
      "Human",
      {  0,  0,  0,  0,  0,  0 },
      14,  6, 72,  6,180, 25, 66,  4,150, 20,
      0,  0,  0,  0,  0,  10,  0,  0,
      10,  0, 100, 0x3F,
    },
    
    {
      "Half-Elf",
      { -1,  1,  0,  1, -1,  1 },
      24, 16, 66,  6,130, 15, 62,  6,100, 10,
      2,  3,  3,  1, 6,  11, -1,  5,
      9,  2, 110, 0x3F,
    },
    
    {
      "Elf",
      { -1,  2,  1,  1, -2,  1 },
      75, 75, 60,  4,100,  6, 54,  4, 80,  6,
      5,  6,  6,  1, 8,  12, -5, 15,
      8,  3, 120, 0x1F,
    },
    
    {
      "Hobbit",
      { -2,  2,  1,  3,  2,  1 },
      21, 12, 36,  3, 60,  3, 33,  3, 50,  3,
      15, 18, 18, 4, 12,  15,-10, 20,
      7,  4, 110, 0x0B,
    },
    
    {
      "Gnome",
      { -1,  2,  0,  2,  1, -2 },
      50, 40, 42,  3, 90,  6, 39,  3, 75,  3,
      10, 12, 12,  3, 6,  13, -8, 12,
      8,  4, 125, 0x0F,
    },
    
    {
      "Dwarf",
      {  2, -3,  2, -2,  2, -3 },
      35, 15, 48,  3,150, 10, 46,  3,120, 10,
      2,  9,  9,  -1,  7,  10, 15,  0,
      11,  5, 120, 0x05,
    },
    
    {
      "Half-Orc",
      {  2, -1,  0,  0,  1, -4 },
      11,  4, 66,  1,150,  5, 62,  1,120,  5,
      -3, -3, -3,  -1,  0, 7, 12, -5,
      10,  3, 110, 0x0D,
    },

    {
      "Half-Troll",
      { 4, -4, -2, -4,  3, -6 },
      20, 10, 96, 10,250, 50, 84,  8,225, 40,
      -5, -8, -8, -2,  -1, 5, 20,-10,
      12,  3, 120, 0x05,
    },

    {
      "Dunadan",
      {  1,  2,  2,  2,  3,  2 },
      50, 20, 82, 5, 190, 20, 78,  6, 180, 15,
      4,  5,  5,  2, 3, 13, 15, 10,
      10,  0, 180, 0x3F,
    },

    {
      "High-Elf",
      {  1,  3, -1,  3,  1,  5 },
      100, 30, 90,10, 190, 20, 82, 10, 180, 15,
      4,  20, 20,  3,  3, 14, 10, 25,
      10,  4, 200, 0x1F,
    }
};


/*
 * Player Classes.
 *
 *   Title,
 *   {STR,INT,WIS,DEX,CON,CHR},
 *   c_dis, c_dev, c_sav, c_stl, c_srh, c_fos, c_thn, c_thb,
 *   x_dis, x_dev, x_sav, x_stl, x_srh, x_fos, x_thn, x_thb,
 *   HD, Exp
 */
player_class class_info[MAX_CLASS] = {

    {
      "Warrior",
      { 5,-2,-2, 2, 2,-1},
      25, 18, 18, 1,  14, 2, 70, 55,
      10, 7,  10, 0,  0,  0,  45, 45,
      9,  0
    },

    {
      "Mage",
      {-5, 3, 0, 1,-2, 1},
      30, 36, 30, 2,  16, 20, 34, 20,
      7,  13, 9,  0,  0,  0,  15, 15,
      0, 30
    },

    {
      "Priest",
      {-1,-3, 3,-1, 0, 2},
      25, 30, 32, 2,  16, 8, 48, 35,
      7,  10, 12, 0,  0,  0, 20, 20,
      2, 20
    },

    {
      "Rogue",
      { 2, 1,-2, 3, 1,-1},
      45, 32, 28, 5, 32, 24, 60, 66,
      15, 10, 10, 0,  0,  0, 40, 30,
      6, 25
    },

    {
      "Ranger",
      { 2, 2, 0, 1, 1, 1},
      30, 32, 28, 3,  24, 16, 56, 72,
      8,  10, 10, 0,  0,  0,  30, 45,
      4, 30
    },

    {
      "Paladin",
      { 3,-3, 1, 0, 2, 2},
      20, 24, 25, 1,  12, 2, 68, 40,
      7,  10, 11, 0,  0,  0,  35, 30,
      6, 35
    }
};






/*
 * Hack -- the spell information table.
 *
 *   Class Name
 *
 *   Spell Book
 *   Spell Xtra
 *
 *   Spell Stat,
 *   Spell Type,
 *
 *   Spell Level,
 *   Spell Encumbrance,
 *
 *   Array of { Lev, Mana, Fail, Exp/Lev }
 */
player_magic magic_info[MAX_CLASS] = {

    {
        /*** Warrior ***/

        0,
        0,
        
        A_STR,
        0,

        99,
        0,

        {
            { 99,  0,  0,   0},
            { 99,  0,  0,   0},
            { 99,  0,  0,   0},
            { 99,  0,  0,   0},
            { 99,  0,  0,   0},
            { 99,  0,  0,   0},
            { 99,  0,  0,   0},
            { 99,  0,  0,   0},
            { 99,  0,  0,   0},

            { 99,  0,  0,   0},
            { 99,  0,  0,   0},
            { 99,  0,  0,   0},
            { 99,  0,  0,   0},
            { 99,  0,  0,   0},
            { 99,  0,  0,   0},
            { 99,  0,  0,   0},
            { 99,  0,  0,   0},
            { 99,  0,  0,   0},

            { 99,  0,  0,   0},
            { 99,  0,  0,   0},
            { 99,  0,  0,   0},
            { 99,  0,  0,   0},
            { 99,  0,  0,   0},
            { 99,  0,  0,   0},
            { 99,  0,  0,   0},
            { 99,  0,  0,   0},

            { 99,  0,  0,   0},
            { 99,  0,  0,   0},
            { 99,  0,  0,   0},
            { 99,  0,  0,   0},
            { 99,  0,  0,   0},
            { 99,  0,  0,   0},
            { 99,  0,  0,   0},

            { 99,  0,  0,   0},
            { 99,  0,  0,   0},
            { 99,  0,  0,   0},
            { 99,  0,  0,   0},
            { 99,  0,  0,   0},

            { 99,  0,  0,   0},
            { 99,  0,  0,   0},
            { 99,  0,  0,   0},
            { 99,  0,  0,   0},
            { 99,  0,  0,   0},
            { 99,  0,  0,   0},

            { 99,  0,  0,   0},
            { 99,  0,  0,   0},
            { 99,  0,  0,   0},
            { 99,  0,  0,   0},
            { 99,  0,  0,   0},

            { 99,  0,  0,   0},
            { 99,  0,  0,   0},
            { 99,  0,  0,   0},
            { 99,  0,  0,   0},
            { 99,  0,  0,   0},

            { 99,  0,  0,   0},
            { 99,  0,  0,   0},
            { 99,  0,  0,   0},
            { 99,  0,  0,   0},
            { 99,  0,  0,   0},

            { 99,  0,  0,   0},
            { 99,  0,  0,   0},
            { 99,  0,  0,   0},
            { 99,  0,  0,   0},
            { 99,  0,  0,   0}
        }
    },

   {
       /*** Mage ***/

       TV_MAGIC_BOOK,
       0,
       
       A_INT,
       0,

       1,
       300,
       
       {
            {  1,  1, 22,   4},
            {  1,  1, 23,   4},
            {  1,  2, 24,   4},
            {  1,  2, 26,   4},
            { 99,  0,  0,   0},
            {  3,  3, 25,   3},
            { 99,  0,  0,   0},
            {  3,  3, 25,   1},
            {  3,  3, 27,   3},

            {  3,  4, 30,   1},
            {  5,  4, 30,   4},
            {  5,  5, 30,   6},
            {  5,  5, 30,   4},
            {  5,  5, 35,   4},
            {  7,  6, 35,   5},
            {  7,  6, 30,   5},
            {  7,  6, 40,   6},
            {  9,  7, 44,   8},

            {  9,  7, 45,   8},
            {  9,  7, 75,   9},
            {  9,  7, 45,   8},
            { 11,  7, 45,   9},
            { 11,  7, 75,   6},
            { 13,  7, 50,   6},
            { 15,  9, 50,   6},
            { 17,  9, 50,   7},

            { 19, 12, 55,   8},
            { 21, 12, 90,   8},
            { 23, 12, 60,   8},
            { 25, 12, 65,  10},
            { 29, 18, 65,  12},
            { 33, 21, 80,  15},
            { 37, 25, 95,  21},

            {  7,  7, 20,  28},
            {  9, 12, 40,  44},
            { 15, 17, 60,  29},
            { 20, 18, 60,  24},
            { 25, 25, 75,  19},

            { 10,  6, 50,  12},
            { 12,  9, 60,  16},
            { 20, 15, 70,  20},
            { 27, 25, 75,  29},
            { 35, 35, 85,  34},
            { 42, 45, 95, 200},

            { 5,  5,  50,   8},
            { 10, 10, 70,  40},
            { 25, 30, 95, 160},
            { 30, 50, 70,  40},
            { 40, 75, 80, 100},

            {  4,  5, 50, 100},
            {  4,  5, 50, 100},
            {  4,  5, 50, 100},
            {  8, 10, 75, 100},
            { 15, 20, 85, 250},

            {  5,  5, 50,  80},
            { 10, 12, 75, 120},
            { 15, 20, 80, 200},
            { 22, 30, 50, 250},	/* 350 */
            { 45, 70, 75, 250},	/* 450 */

            { 99,  0,  0,   0},
            { 99,  0,  0,   0},
            { 99,  0,  0,   0},
            { 99,  0,  0,   0},
            { 99,  0,  0,   0}
        }
    },

    {
        /*** Priest ***/

        TV_PRAYER_BOOK,
        0,
       
        A_WIS,
        1,

        1,
        350,
        
        {
            {  1,  1, 10,   4},
            {  1,  2, 15,   4},
            {  1,  2, 20,   4},
            {  1,  2, 25,   4},
            {  3,  2, 25,   1},
            {  3,  3, 27,   2},
            {  3,  3, 27,   2},
            {  3,  3, 28,   4},

            {  5,  4, 29,   3},
            {  5,  4, 30,   4},
            {  5,  4, 32,   4},
            {  5,  5, 34,   4},
            {  7,  5, 36,   3},
            {  7,  5, 38,   4},
            {  7,  6, 38,   5},
            {  7,  7, 38,   5},

            {  9,  6, 38,   4},
            {  9,  7, 38,   4},
            {  9,  7, 40,   4},
            { 11,  8, 42,   4},
            { 11,  8, 42,   4},
            { 11,  9, 55,   5},
            { 13, 10, 45,   4},
            { 13, 11, 45,   4},
            { 15, 12, 50,   5},

            { 15, 14, 50,   5},
            { 17, 14, 55,   7},
            { 21, 16, 60,   7},
            { 25, 20, 70,  12},
            { 33, 55, 90,  15},
            { 39, 32, 95,  20},

            {  3,  3, 50,   2},
            { 10, 10, 80,  20},
            { 20, 20, 80,  20},
            { 25, 10, 80, 150},
            { 35, 50, 80, 230},

            { 15,  5, 50,  25},
            { 17,  7, 60,  45},
            { 30, 50, 80, 130},
            { 35, 70, 90, 230},
            { 35, 70, 90, 250},	/* 350 */

            { 15,  7, 70,  25},
            { 20, 10, 75,  60},
            { 25, 25, 80, 250},
            { 35, 35, 80, 115},
            { 45, 60, 75, 250},	/* 350 */

            {  5,  6, 50,  40},
            { 15, 20, 80,  25},
            { 25, 40, 80, 160},
            { 35, 50, 80, 230},
            { 37, 60, 85, 250},	/* 325 */
            { 45, 95, 85, 250},	/* 530 */

            {  3,  3, 50,   6},
            { 10, 10, 50,   8},
            { 20, 20, 80,  16},
            { 30, 40, 75, 133},
            { 35, 50, 75,  11},
            { 40, 60, 75, 250},	/* 300 */

            { 99,  0,  0,    0},
            { 99,  0,  0,    0},
            { 99,  0,  0,    0},
            { 99,  0,  0,    0},
            { 99,  0,  0,    0},
            { 99,  0,  0,    0}
        }
    },

    {
        /*** Rogue ***/

        TV_MAGIC_BOOK,
        0,
       
        A_INT,
        0,

        5,
        350,
        
        {
            { 99,  0,  0,   0},
            {  5,  1, 50,   1},
            {  7,  2, 55,   1},
            {  9,  3, 60,   1},
            { 10,  3, 60,   1},
            { 11,  4, 65,   1},
            { 12,  4, 65,   1},
            { 13,  5, 70,   1},
            { 99,  0,  0,   0},

            { 15,  6, 75,   1},
            { 99,  0,  0,   0},
            { 17,  7, 80,   1},
            { 19,  8, 85,   1},
            { 21,  9, 90,   1},
            { 22,  9, 50,   1},
            { 23, 10, 95,   1},
            { 99,  0,  0,   0},
            { 24, 11, 70,   1},

            { 25, 12, 95,   1},
            { 27, 15, 99,   1},
            { 99,  0,  0,   0},
            { 99,  0,  0,   0},
            { 28, 18, 50,   2},
            { 99,  0,  0,   0},
            { 99,  0,  0,   0},
            { 99,  0,  0,   0},

            { 99,  0,  0,   0},
            { 30, 20, 99,   6},
            { 99,  0,  0,   0},
            { 32, 25, 70,   6},
            { 99,  0,  0,   0},
            { 99,  0,  0,   0},
            { 99,  0,  0,   0},

            {  7,  7, 20,  25},
            {  9, 12, 40,  45},
            { 15, 17, 60,  30},
            { 99,  0,  0,   0},
            { 30, 35, 75,  15},

            { 13, 16, 50,  10},
            { 18, 20, 60,  10},
            { 99,  0,  0,   0},
            { 99,  0,  0,   0},
            { 99,  0,  0,   0},
            { 99,  0,  0,   0},

            {  5,  5, 50,  10},
            { 10, 10, 70,  40},
            { 35, 40, 95, 100},
            { 99,  0,  0,   0},
            { 99,  0,  0,   0},

            { 10, 12, 50,  40},
            { 10, 12, 50,  40},
            { 10, 12, 50,  40},
            { 15, 20, 75,  50},
            { 25, 30, 85, 150},

            { 10, 11, 50,  40},
            { 15, 20, 75,  80},
            { 20, 25, 80, 160},
            { 26, 30, 50, 250},
            { 99,  0,  0,   0},

            { 99,  0,  0,   0},
            { 99,  0,  0,   0},
            { 99,  0,  0,   0},
            { 99,  0,  0,   0},
            { 99,  0,  0,   0}
        }
    },

    {
        /*** Ranger ***/

        TV_MAGIC_BOOK,
        0,
       
        A_INT,
        0,

        3,
        400,
        
        {
            {  3,  1, 30,   1},
            {  3,  2, 35,   2},
            {  3,  2, 35,   2},
            {  5,  3, 35,   1},
            { 99,  0,  0,   0},
            {  5,  3, 40,   1},
            { 99,  0,  0,   0},
            {  5,  4, 45,   2},
            {  7,  5, 40,   3},

            {  7,  6, 40,   2},
            {  9,  7, 40,   3},
            {  9,  8, 45,   3},
            { 11,  8, 40,   3},
            { 11,  9, 45,   3},
            { 13, 10, 45,   3},
            { 13, 11, 55,   4},
            { 15, 12, 50,   4},
            { 15, 13, 50,   4},

            { 17, 17, 55,   3},
            { 17, 17, 90,   4},
            { 21, 17, 55,   3},
            { 21, 19, 60,   3},
            { 23, 25, 90,   3},
            { 23, 20, 60,   3},
            { 25, 20, 60,   3},
            { 25, 21, 65,   3},

            { 27, 21, 65,   3},
            { 29, 23, 95,   3},
            { 31, 25, 70,   3},
            { 33, 25, 75,   4},
            { 35, 25, 80,   5},
            { 37, 30, 95,  10},
            { 99,  0,  0,   0},

            { 8,  17, 20,  25},
            { 19, 22, 40,  21},
            { 25, 27, 60,  17},
            { 30, 28, 60,  16},
            { 35, 35, 75,  13},

            { 20, 16, 50,   6},
            { 22, 19, 60,   9},
            { 30, 25, 70,  13},
            { 33, 35, 75,  25},
            { 35, 45, 85,  35},
            { 99,  0, 0,    0},

            { 10, 15, 50,   4},
            { 15, 20, 70,  25},
            { 35, 60, 95, 115},
            { 99,  0, 0,    0},
            { 99,  0, 0,    0},

            { 8, 15,  50,  50},
            { 8, 15,  50,  50},
            { 8, 15,  50,  50},
            { 16, 25, 75,  50},
            { 25, 40, 85, 150},

            { 10, 15, 50,  40},
            { 15, 20, 75,  80},
            { 25, 30, 80, 125},
            { 32, 50, 50, 250},
            { 99,  0,  0,   0},

            { 99,  0,  0,   0},
            { 99,  0,  0,   0},
            { 99,  0,  0,   0},
            { 99,  0,  0,   0},
            { 99,  0,  0,   0}
        }
    },

    {
        /*** Paladin ***/

        TV_PRAYER_BOOK,
        0,
       
        A_WIS,
        1,

        1,
        400,

        {
            {  1,  1, 30,   4},
            {  2,  2, 35,   4},
            {  3,  3, 35,   4},
            {  5,  3, 35,   4},
            {  5,  4, 35,   4},
            {  7,  5, 40,   3},
            {  7,  5, 40,   3},
            {  9,  7, 40,   3},
            {  9,  7, 40,   3},
            {  9,  8, 40,   3},
            { 11,  9, 40,   3},
            { 11, 10, 45,   3},
            { 11, 10, 45,   3},
            { 13, 10, 45,   3},
            { 13, 11, 45,   4},
            { 15, 13, 45,   4},
            { 15, 15, 50,   4},
            { 17, 15, 50,   4},
            { 17, 15, 50,   4},
            { 19, 15, 50,   4},
            { 19, 15, 50,   4},
            { 21, 17, 50,   3},
            { 23, 17, 50,   3},
            { 25, 20, 50,   3},
            { 27, 21, 50,   3},
            { 29, 22, 50,   3},
            { 31, 24, 60,   3},
            { 33, 28, 60,   3},
            { 35, 32, 70,   4},
            { 37, 70, 90,   5},
            { 39, 38, 95,  10},

            { 5,  5,  50,   1},
            { 15, 15, 80,  12},
            { 25, 25, 80,  16},
            { 30, 15, 80, 135},
            { 37, 55, 80, 215},

            { 17, 15, 50,  25},
            { 23, 25, 60,  35},
            { 35, 60, 80, 115},
            { 40, 80, 90, 200},
            { 40, 80, 90, 250},	/* 300 */

            { 20, 13, 70,  20},
            { 30, 20, 75,  40},
            { 30, 35, 80, 200},
            { 40, 40, 80, 100},
            { 47, 70, 75, 250},	/* 350 */

            { 10, 16, 50,  20},
            { 25, 30, 80,  15},
            { 30, 50, 80, 130},
            { 40, 70, 80, 200},
            { 42, 80, 85, 250},	/* 285 */
            { 47, 95, 85, 250},	/* 500 */

            {  7,  7, 50,   2},
            { 20, 20, 50,   4},
            { 25, 25, 80,  12},
            { 35, 50, 75, 115},
            { 40, 60, 75,  10},
            { 45, 70, 75, 250},

            { 99,  0,  0,   0},
            { 99,  0,  0,   0},
            { 99,  0,  0,   0},
            { 99,  0,  0,   0},
            { 99,  0,  0,   0},
            { 99,  0,  0,   0}
        }
    }
};


/*
 * Spells in each book (mage spells then priest spells)
 */
u32b spell_flags[2][9][2] = {

  {
    /*** Mage spell books ***/
    { 0x000001ff, 0x00000000 },
    { 0x0003fe00, 0x00000000 },
    { 0x03fc0000, 0x00000000 },
    { 0xfc000000, 0x00000001 },
    { 0x00000000, 0x003e0000 },
    { 0x00000000, 0x0000003e },
    { 0x00000000, 0x0001f000 },
    { 0x00000000, 0x07c00000 },
    { 0x00000000, 0x00000fc0 }
  },
  
  {
    /*** Priest spell books ***/
    { 0x000000ff, 0x00000000 },
    { 0x0000ff00, 0x00000000 },
    { 0x01ff0000, 0x00000000 },
    { 0x7e000000, 0x00000000 },
    { 0x00000000, 0x03f00000 },
    { 0x80000000, 0x0000000f },
    { 0x00000000, 0x000001f0 },
    { 0x00000000, 0x000fc000 },
    { 0x00000000, 0x00003e00 }
  }
};


/*
 * Names of the spells (mage spells then priest spells)
 */
cptr spell_names[2][64] = {

  {
    /*** Mage Spells ***/

    "Magic Missile",
    "Detect Monsters",
    "Phase Door",
    "Light Area",
    "Treasure Detection",
    "Cure Light Wounds",
    "Object Detection",
    "Find Hidden Traps/Doors",
    "Stinking Cloud",

    "Confusion",
    "Lightning Bolt",
    "Trap/Door Destruction",
    "Sleep I",
    "Cure Poison",
    "Teleport Self",
    "Spear of Light",
    "Frost Bolt",
    "Turn Stone to Mud",

    "Satisfy Hunger",
    "Recharge Item I",
    "Sleep II",
    "Polymorph Other",
    "Identify",
    "Sleep III",
    "Fire Bolt",
    "Slow Monster",

    "Frost Ball",
    "Recharge Item II",
    "Teleport Other",
    "Haste Self",
    "Fire Ball",
    "Word of Destruction",
    "Genocide",

      /* Mordenkainen's Escapes */
    "Door Creation",
    "Stair Creation",
    "Teleport Level",
    "Earthquake",
    "Word of Recall",

      /* Raal's Tome of Destruction */
    "Acid Bolt",
    "Cloud Kill",
    "Acid Ball",
    "Ice Storm",
    "Meteor Swarm",
    "Mana Storm",

      /* Kelek's Grimoire of Power */
    "Detect Evil",
    "Detect Enchantment",
    "Recharge Item III",
    "Genocide",
    "Mass Genocide",

      /* Resistance of Scarabtarices */
    "Resist Fire",
    "Resist Cold",
    "Resist Acid",
    "Resist Poison",
    "Resistance",

      /* Tenser's transformations... */
    "Heroism",
    "Shield",
    "Berserker",
    "Essence of Speed",
    "Globe of Invulnerability",

    "(blank)",
    "(blank)",
    "(blank)",
    "(blank)",
    "(blank)"
  },


  {
    /*** Priest Spells ***/

    "Detect Evil",
    "Cure Light Wounds",
    "Bless",
    "Remove Fear",
    "Call Light",
    "Find Traps",
    "Detect Doors/Stairs",
    "Slow Poison",

    "Confuse Creature",
    "Portal",
    "Cure Serious Wounds",
    "Chant",
    "Sanctuary",
    "Satisfy Hunger",
    "Remove Curse",
    "Resist Heat and Cold",

    "Neutralize Poison",
    "Orb of Draining",
    "Cure Critical Wounds",
    "Sense Invisible",
    "Protection from Evil",
    "Earthquake",
    "Sense Surroundings",
    "Cure Mortal Wounds",
    "Turn Undead",

    "Prayer",
    "Dispel Undead",
    "Heal",
    "Dispel Evil",
    "Glyph of Warding",
    "Holy Word",

      /* Godly Insights... */
    "Detect Monsters",
    "Detection",
    "Perception",
    "Probing",
    "Clairvoyance",

      /* Purifications and Healing */
    "Cure Serious Wounds",
    "Cure Mortal Wounds",
    "Healing",
    "Restoration",
    "Remembrance",

      /* Wrath of God */
    "Dispel Undead",
    "Dispel Evil",
    "Banishment",
    "Word of Destruction",
    "Annihilation",

      /* Holy Infusions */
    "Unbarring Ways",
    "Recharging",
    "Dispel Curse",
    "Enchant Weapon",
    "Enchant Armour",
    "Elemental Brand",

      /* Ethereal openings */
    "Blink",
    "Teleport",
    "Teleport Away",
    "Teleport Level",
    "Word of Recall",
    "Alter Reality",

    "(blank)",
    "(blank)",
    "(blank)",
    "(blank)",
    "(blank)"
  }
};



/* 
 * Each chest has a certain set of traps, determined by pval
 * Each chest has a "pval" from 1 to the chest level (max 55)
 * If the "pval" is negative then the trap has been disarmed
 * The "pval" of a chest determines the quality of its treasure
 * Note that disarming a trap on a chest also removes the lock.
 */
byte chest_traps[64] = {
    0,					/* 0 == empty */
    (CHEST_POISON),
    (CHEST_LOSE_STR),
    (CHEST_LOSE_CON),
    (CHEST_LOSE_STR),
    (CHEST_LOSE_CON),			/* 5 == best small wooden */
    0,
    (CHEST_POISON),
    (CHEST_POISON),
    (CHEST_LOSE_STR),
    (CHEST_LOSE_CON),
    (CHEST_POISON),
    (CHEST_LOSE_STR | CHEST_LOSE_CON),
    (CHEST_LOSE_STR | CHEST_LOSE_CON),
    (CHEST_LOSE_STR | CHEST_LOSE_CON),
    (CHEST_SUMMON),			/* 15 == best large wooden */
    0,
    (CHEST_LOSE_STR),
    (CHEST_LOSE_CON),
    (CHEST_PARALYZE),
    (CHEST_LOSE_STR | CHEST_LOSE_CON),
    (CHEST_SUMMON),
    (CHEST_PARALYZE),
    (CHEST_LOSE_STR),
    (CHEST_LOSE_CON),
    (CHEST_EXPLODE),			/* 25 == best small iron */
    0,
    (CHEST_POISON | CHEST_LOSE_STR),
    (CHEST_POISON | CHEST_LOSE_CON),
    (CHEST_LOSE_STR | CHEST_LOSE_CON),
    (CHEST_EXPLODE | CHEST_SUMMON),
    (CHEST_PARALYZE),
    (CHEST_POISON | CHEST_SUMMON),
    (CHEST_SUMMON),
    (CHEST_EXPLODE),
    (CHEST_EXPLODE | CHEST_SUMMON),	/* 35 == best large iron */
    0,
    (CHEST_SUMMON),
    (CHEST_EXPLODE),
    (CHEST_EXPLODE | CHEST_SUMMON),
    (CHEST_EXPLODE | CHEST_SUMMON),
    (CHEST_POISON | CHEST_PARALYZE),
    (CHEST_EXPLODE),
    (CHEST_EXPLODE | CHEST_SUMMON),
    (CHEST_EXPLODE | CHEST_SUMMON),
    (CHEST_POISON | CHEST_PARALYZE),	/* 45 == best small steel */
    0,
    (CHEST_LOSE_STR | CHEST_LOSE_CON),
    (CHEST_LOSE_STR | CHEST_LOSE_CON),
    (CHEST_POISON | CHEST_PARALYZE | CHEST_LOSE_STR),
    (CHEST_POISON | CHEST_PARALYZE | CHEST_LOSE_CON),
    (CHEST_POISON | CHEST_LOSE_STR | CHEST_LOSE_CON),
    (CHEST_POISON | CHEST_LOSE_STR | CHEST_LOSE_CON),
    (CHEST_POISON | CHEST_PARALYZE | CHEST_LOSE_STR | CHEST_LOSE_CON),
    (CHEST_POISON | CHEST_PARALYZE),	
    (CHEST_POISON | CHEST_PARALYZE),	/* 55 == best large steel */
    (CHEST_EXPLODE | CHEST_SUMMON),
    (CHEST_EXPLODE | CHEST_SUMMON),
    (CHEST_EXPLODE | CHEST_SUMMON),
    (CHEST_EXPLODE | CHEST_SUMMON),
    (CHEST_EXPLODE | CHEST_SUMMON),
    (CHEST_EXPLODE | CHEST_SUMMON),
    (CHEST_EXPLODE | CHEST_SUMMON),
    (CHEST_EXPLODE | CHEST_SUMMON),
};






/*
 * Each player starts out with a few items, given as tval/sval pairs.
 * In addition, he always has some food and a few torches.
 */

byte player_init[MAX_CLASS][3][2] = {

    {
      /* Warrior */
      { TV_POTION, SV_POTION_BESERK_STRENGTH },
      { TV_SWORD, SV_BROAD_SWORD },
      { TV_HARD_ARMOR, SV_CHAIN_MAIL }
    },
    
    {
      /* Mage */
      { TV_MAGIC_BOOK, 0 },
      { TV_SWORD, SV_DAGGER },
      { TV_SCROLL, SV_SCROLL_WORD_OF_RECALL }
    },
    
    {
      /* Priest */
      { TV_PRAYER_BOOK, 0 },
      { TV_HAFTED, SV_MACE },
      { TV_POTION, SV_POTION_HEALING }
    },

    {
      /* Rogue */
      { TV_MAGIC_BOOK, 0 },
      { TV_SWORD, SV_SMALL_SWORD },
      { TV_SOFT_ARMOR, SV_SOFT_LEATHER_ARMOR }
    },

    {
      /* Ranger */
      { TV_MAGIC_BOOK, 0 },
      { TV_SWORD, SV_BROAD_SWORD },
      { TV_BOW, SV_LONG_BOW }
    },
    
    {
      /* Paladin */
      { TV_PRAYER_BOOK, 0 },
      { TV_SWORD, SV_BROAD_SWORD },
      { TV_SCROLL, SV_SCROLL_PROTECTION_FROM_EVIL }
    }
};





/*
 * Class titles for different levels
 */
cptr player_title[MAX_CLASS][PY_MAX_LEVEL] = {

        /* Warrior */
{"Rookie","Private","Soldier","Mercenary","Veteran(1st)","Veteran(2nd)",
"Veteran(3rd)","Warrior(1st)","Warrior(2nd)","Warrior(3rd)","Warrior(4th)",
"Swordsman-1","Swordsman-2","Swordsman-3","Hero","Swashbuckler","Myrmidon",
"Champion-1","Champion-2","Champion-3","Superhero","Knight","Superior Knt",
"Gallant Knt","Knt Errant","Guardian Knt","Baron","Duke","Lord (1st)",
"Lord (2nd)","Lord (3rd)","Lord (4th)","Lord (5th)","Lord (6th)","Lord (7th)",
"Lord (8th)","Lord (9th)","Lord (10th)","Lord (11th)","Lord (12th)",
"Lord (13th)","Lord (14th)","Lord (15th)","Lord (16th)","Lord (17th)",
"Lord (18th)","Lord (19th)","Lord Gallant","Lord Keeper","Lord Noble"},

        /* Mage */
{"Novice","Apprentice","Trickster-1","Trickster-2","Trickster-3","Cabalist-1",
"Cabalist-2","Cabalist-3","Visionist","Phantasmist","Shadowist","Spellbinder",
"Illusionist","Evoker (1st)","Evoker (2nd)","Evoker (3rd)","Evoker (4th)",
"Conjurer","Theurgist","Thaumaturge","Magician","Enchanter","Warlock",
"Sorcerer","Necromancer","Mage (1st)","Mage (2nd)","Mage (3rd)","Mage (4th)",
"Mage (5th)","Wizard (1st)","Wizard (2nd)","Wizard (3rd)","Wizard (4th)",
"Wizard (5th)","Wizard (6th)","Wizard (7th)","Wizard (8th)","Wizard (9th)",
"Wizard (10th)","Wizard (11th)","Wizard (12th)","Wizard (13th)",
"Wizard (14th)","Wizard (15th)","Wizard (16th)","Wizard (17th)",
"Wizard (18th)","Wizard (19th)","Wizard Lord"},

        /* Priests */
{"Believer","Acolyte(1st)","Acolyte(2nd)","Acolyte(3rd)","Adept (1st)",
"Adept (2nd)","Adept (3rd)","Priest (1st)","Priest (2nd)","Priest (3rd)",
"Priest (4th)","Priest (5th)","Priest (6th)","Priest (7th)","Priest (8th)",
"Priest (9th)","Curate (1st)","Curate (2nd)","Curate (3rd)","Curate (4th)",
"Curate (5th)","Curate (6th)","Curate (7th)","Curate (8th)","Curate (9th)",
"Canon (1st)","Canon (2nd)","Canon (3rd)","Canon (4th)","Canon (5th)",
"Canon (6th)","Canon (7th)","Canon (8th)","Canon (9th)",
"Low Lama","Lama-1","Lama-2","Lama-3","Lama-4","Lama-5","Lama-6","Lama-7",
"Lama-8","Lama-9","High Lama","Great Lama","Patriarch",
"High Priest","Great Priest","Noble Priest"},

        /* Rogues */
{"Vagabond","Footpad","Cutpurse","Robber","Burglar","Filcher","Sharper",
"Magsman","Common Rogue","Rogue (1st)","Rogue (2nd)","Rogue (3rd)",
"Rogue (4th)","Rogue (5th)","Rogue (6th)","Rogue (7th)","Rogue (8th)",
"Rogue (9th)","Master Rogue","Expert Rogue","Senior Rogue","Chief Rogue",
"Prime Rogue","Low Thief","Thief (1st)","Thief (2nd)","Thief (3rd)",
"Thief (4th)","Thief (5th)","Thief (6th)","Thief (7th)","Thief (8th)",
"Thief (9th)","Thief (10th)","Thief (11th)","Thief (12th)","Thief (13th)",
"Thief (14th)","Thief (15th)","Thief (16th)","Thief (17th)","Thief (18th)",
"Thief (19th)","High Thief","Master Thief","Executioner","Low Assassin",
"Assassin","High Assassin","Guildsmaster"},

        /* Rangers */
{"Runner (1st)","Runner (2nd)","Runner (3rd)","Strider (1st)","Strider (2nd)",
"Strider (3rd)","Scout (1st)","Scout (2nd)","Scout (3rd)","Scout (4th)",
"Scout (5th)","Courser (1st)","Courser (2nd)","Courser (3rd)","Courser (4th)",
"Courser (5th)","Tracker (1st)","Tracker (2nd)","Tracker (3rd)",
"Tracker (4th)","Tracker (5th)","Tracker (6th)","Tracker (7th)",
"Tracker (8th)","Tracker (9th)","Guide (1st)","Guide (2nd)","Guide (3rd)",
"Guide (4th)","Guide (5th)","Guide (6th)","Guide (7th)","Guide (8th)",
"Guide (9th)","Guide (10th)","Guide (11th)","Guide (12th)","Guide (13th)",
"Guide (14th)","Guide (15th)",
"Pathfinder-1","Pathfinder-2","Pathfinder-3","Pathfinder-4","Pathfinder-5",
"Pathfinder-6","Pathfinder-7","Ranger","High Ranger","Ranger Lord"},

        /* Paladins */
{"Gallant","Keeper (1st)","Keeper (2nd)","Keeper (3rd)","Keeper (4th)",
"Keeper (5th)","Keeper (6th)","Keeper (7th)","Keeper (8th)","Keeper (9th)",
"Protector-1","Protector-2","Protector-3","Protector-4","Protector-5",
"Protector-6","Protector-7","Protector-8","Defender-1","Defender-2",
"Defender-3","Defender-4","Defender-5","Defender-6","Defender-7","Defender-8",
"Warder (1st)","Warder (2nd)","Warder (3rd)","Warder (4th)","Warder (5th)",
"Warder (6th)","Warder (7th)","Warder (8th)","Warder (9th)","Warder (10th)",
"Warder (11th)","Warder (12th)","Warder (13th)","Warder (14th)",
"Warder (15th)","Warder (16th)","Warder (17th)","Warder (18th)",
"Warder (19th)","Guardian","Chevalier","Justiciar","Paladin","High Lord"}

};


