%{
#ifndef __TURBOC__
#  ifndef LINT
static char parser_module[] = "@(#)parser.y     1.1 10/30/90";
#  endif
#else
#pragma warn -def
#pragma warn -sig
#endif
#include <stdio.h>
#ifdef __TURBOC__
#include "conio.h"
#endif
#include "inmos.h"
#include "globals.h"
#include "keytab.h"
#include "parser.h"

int yyerror P((char *));
int yylex P((void));



static Key *key_point,*top_level;
%}

%token Constant
%%


keys
        : /* */
        | keys Constant '=' '[' values ']'
        {
                if (set_key_code ($2,key_point)) {
                        printf ("duplicate key sequence %d and %d.\n",$2,
                                        key_point->code);
                        exit (1);
                }
                key_point = top_level;
        }

values
        : Constant
        {
                if ((key_point = add_key ($1,key_point)) == 0)
                        exit (1);
        }
        | values ',' Constant
        {
                if ((key_point = add_key ($3,key_point)) == 0)
                        exit (1);
        }
%%

Key *parse_init ()
{
        if ((key_point = (Key *)calloc (sizeof(Key),1)) == 0)
                return (0);
        top_level = key_point;
        return (key_point);
}

void parse_end ()
{
        set_key_top (top_level);
}

yyerror (s)
char *s;
{
extern int yylineno;
extern int yyleng;
extern char yytext[];

        yytext[yyleng] = '\0';

        printf ("%s: line %d, near %s.\n",s,yylineno,yytext);
        return (0);
}

yywrap ()
{
        return (1);

}

