#ifndef __TURBOC__
#ifndef LINT
static char misc_module[] = "@(#)misc.c 1.2 12/2/90";
#endif
#endif
#include <stdio.h>
#include <ctype.h>
#include <signal.h>
#ifdef __TURBOC__
#include <conio.h>
#endif
#include "inmos.h"
#include "globals.h"
#include "keyboard.h"
#include "keytab.h"
#include "parser.h"
#include "screen.h"
#include "edtutil.h"
#include "misc.h"

/*{{{F misc.h*/
/*:::F misc.h*/
/*}}}  */

/*{{{  int HostBegin(void)*/
int HostBegin()
{
char keyfile[256];
char * homedir, * term;
extern FILE *yyin;
extern int yyparse();
        /* J.Sunter 2 Feb 1992 */
        if ((homedir = getenv ("ORIGAMIHOME")) == 0) {
                printf ("Environment variable ORIGAMIHOME not set\n");
                return (1);
        }
        if ((term = getenv ("ORIGAMITERM")) == 0 &&
            (term = getenv ("TERM")) == 0) {
          printf ("Environment variable ORIGAMITERM or TERM not set\n");
          return (1);
        }
        strcpy(keyfile, homedir);
        if (strcmp(&(keyfile[strlen(keyfile)-1]), FILE_SEPARATOR) != 0)
          strcat(keyfile, FILE_SEPARATOR);
        strcat(keyfile, term);
        strcat(keyfile, ".key");

        if ((yyin = fopen (keyfile,"r")) == 0) {
                printf ("warning: unable to open %s, using vt100\n",keyfile);
                strcpy(keyfile, homedir);
                if (strcmp(&(keyfile[strlen(keyfile)-1]), FILE_SEPARATOR) != 0)
                  strcat(keyfile, FILE_SEPARATOR);
                strcat(keyfile, "vt100.key");
                if ((yyin = fopen(keyfile, "r")) == 0) {
                  printf("error: unable to open %s\n", keyfile);
                  return 1;
                }
        }

        parse_init();
        if (yyparse())
                return (1);
        parse_end();

        fclose (yyin);

        /* signal (SIGINT,die_a_quick_death); */
#ifndef  __DEBUGGING__
         signal (SIGSEGV,die_a_quick_death);
#endif
        if (get_terminal_capability())
                return (1);
        load_macros();
        init_keyboard ();
        return (0);
}
/*}}}  */
/*{{{  int die_a_quick_death(sig,code)*/
void die_a_quick_death(sig,code)
int sig,code;
{
        code = code;
        reset_keyboard();
        if (sig == SIGSEGV)
                printf ("Segmentation violation!\n");
        exit (1);
}
/*}}}  */
/*{{{  void strinsert(char *src,char *dst,int pos)*/
void strinsert(src, dst, pos)
char *src, *dst;
int pos;
{
  int slen, dlen;

  if (--pos < 0)
    return;
  dlen = strlen(dst);
  dst += dlen;
  dlen -= pos;
  if (dlen <= 0) {
    strcpy(dst, src);
    return;
  }
  slen = strlen(src);
  do {
    dst[slen] = *dst;
    --dst;
  } while (--dlen >= 0);
  dst++;
  while (--slen >= 0)
    *dst++ = *src++;
}
/*}}}  */
/*{{{  int strpos2(char *s,char *pat,int pos)*/
int strpos2(s, pat, pos)
char *s, *pat;
int pos;
{
  char *cp, ch;
  int slen;

  if (--pos < 0)
    return 0;
  slen = strlen(s) - pos;
  cp = s + pos;
  if (!(ch = *pat++))
    return 0;
  pos = strlen(pat);
  slen -= pos;
  while (--slen >= 0) {
    if (*cp++ == ch && (!strncmp(cp, pat, pos) || pos == 0))
      return (int)(cp - s);
  }
  return 0;
}
/*}}}  */
/*{{{  char *strsub(char *ret,char *s,int pos,int len)*/
char *strsub(ret, s, pos, len)
char *ret, *s;
int pos, len;
{
  char *s2;

  if (--pos < 0 || len <= 0) {
    *ret = 0;
    return ret;
  }
  while (pos > 0) {
    if (!*s++) {
      *ret = 0;
      return ret;
    }
    pos--;
  }
  s2 = ret;
  while (--len >= 0) {
    if (!(*s2++ = *s++))
      return ret;
  }
  *s2 = 0;
  return ret;
}
/*}}}  */
/*{{{  char *skip_spaces(char *s)*/
char *skip_spaces(s)
char *s;
{
    while (*s && isspace(*s))
      s++;

    return s;
}
/*}}}  */
/*{{{  char *skip_controls(char *s)*/
char *skip_controls(s)
char *s;
{
    int i = strlen(s) - 1;

    while (i >= 0 &&  iscntrl(s[i]))
      i--;
    s[i+1] = '\0';

    return s;
}
/*}}}  */
