#ifndef __TURBOC__
#ifndef LINT
static char keytab_module[] = "@(#)keytab.c     1.1 10/30/90";
#endif
#endif
/*{{{  includes*/
#include <stdio.h>
#ifdef __TURBOC__
#include <conio.h>
#endif
#include "inmos.h"
#include "globals.h"
#include "keytab.h"
/*}}}  */
/*{{{F keytab.h*/
/*:::F keytab.h*/
/*}}}  */

/*{{{  Key *add_key (key,current)*/
Key *add_key (key,current)
int key;
Key *current;
{
Key *k,*a;
static int add_count = 0;

/* search key values at next level */
        for (k = current->n_level;k;k = k->next) {
                if (k->key == key) {
                        add_count++;
                        /* found key at next level, go to next level */
                        return (k);
                }
                if (k->next == 0)
                        break;
        }

/* create a key slot along this next level */

        if ((a = (Key *)calloc (sizeof(Key),1)) == 0) {
                perror ("calloc");
                return (0);
        }
        a->key = key;

        if (k == 0)
                current->n_level = a;
        else
                k->next = a;

        return (a);
}
/*}}}  */
/*{{{  int set_key_code (code,current)*/
int set_key_code (code,current)
int code;
Key *current;
{
        if (current->code)
                return (1);
        if (current->n_level)
                printf ("Warning: Key %d masks other keys.\n",code);
        current->code = code;
        return (0);
}
/*}}}  */
static Key *toplevel,*find_current;
/*{{{  int find_key (key)*/
int find_key (key)
int key;
{
Key *find;

        for (find = find_current->n_level;find;find = find->next)
                if (key == find->key)
                        break;


/* sequence not found, end search */
        if (find == 0) {
                find_current = toplevel;
                return (0);
        }

/* an encoded sequence is found, end search */
        if (find->code) {
                find_current = toplevel;
                return (find->code);
        }

/* the search continues */
        if (find->n_level) {
                find_current = find;
                return (1);
        }
/* no level below this, the search ends */
        find_current = toplevel;
        return (0);
}
/*}}}  */
/*{{{  void set_key_top (top)*/
void set_key_top (top)
Key *top;
{
        toplevel = top;
        find_current = top;
}
/*}}}  */
