#ifndef __TURBOC__
#ifndef LINT
static char keyboard_module[] = "@(#)keyboard.c 1.2 12/3/90";
#endif
#endif
/*{{{  includes*/
#include <stdio.h>
#include <sys/types.h>
#ifndef __TURBOC__
#include <termio.h>
#else
#include <conio.h>
#endif
#include <fcntl.h>
#include "inmos.h"
#include "globals.h"
#include "screen.h"
#include "keytab.h"
#include "keyboard.h"
/*}}}  */
/*{{{  statics*/
#ifndef __TURBOC__
static struct termio new,old;
#endif
static int keybuff[40];
static int *pointer,*buffered;
/*}}}  */
/*{{{  prototypes*/
PRIVATE void clr_keybuf P((void));
/*}}}  */
/*{{{F keyboard.h*/
/*:::F keyboard.h*/
/*}}}  */

/*{{{  void init_keyboard()*/
void init_keyboard()
{
#ifndef __TURBOC__
        if (ioctl (0,TCGETA,&new) == -1) {
                perror ("ioctl:TCGETA");
                exit (1);
        }
        if (ioctl (0,TCGETA,&old) == -1) {
                perror ("ioctl:TCGETA");
                exit (1);
        }

        new.c_lflag &= ~ (ICANON | ECHO);
        new.c_cc[VMIN] = 1;
        new.c_cc[VTIME] = 0;

        if (ioctl (0,TCSETAF,&new) == -1) {
                perror ("ioctl:TCSETS");
                exit (1);
        }
#endif
        /* J.Sunter 25 Feb 1992 */
        InitTerminal();
}
/*}}}  */
/*{{{  void reset_keyboard()*/
void reset_keyboard()
{
        /* J.Sunter 25 Feb 1992 */
        EndTerminal();
#ifndef __TURBOC__
        (void) ioctl (0,TCSETAF,&old);
#endif
}
/*}}}  */
/*{{{  clr_keybuf()*/
PRIVATE void clr_keybuf()
{
#ifndef __TURBOC__
    struct termio tmp, current;
    char ch;

    /*{{{  get current status*/
    if (ioctl (0,TCGETA, &current) == -1) {
            perror ("ioctl:TCGETA");
            die_a_quick_death();
    }
    /*}}}  */
    /*{{{  get status to change*/
    if (ioctl (0,TCGETA, &tmp) == -1) {
            perror ("ioctl:TCGETA");
            die_a_quick_death();
    }
    /*}}}  */
    tmp.c_cc[VMIN] = 0;
    /*{{{  set nonblocking status*/
    if (ioctl (0,TCSETAF,&tmp) == -1) {
            perror ("ioctl:TCSETAF");
            die_a_quick_death();
    }
    /*}}}  */
    while (read(0, &ch, 1) == 1);
    /*{{{  reset current status*/
    if (ioctl (0,TCSETAF,&current) == -1) {
            perror ("ioctl:TCSETAF");
            die_a_quick_death();
    }
    /*}}}  */
#endif
}
/*}}}  */
/*{{{  int get_key ()*/
int get_key ()
{
int result;
#ifndef __TURBOC__
char ch;
#else
int ch;
#endif


        fflush (stdout);

        if (buffered > pointer)
                return (*pointer++);

        pointer = buffered = keybuff;

        for (result = 1;result == 1;) {
#ifndef __TURBOC__
                read (0,&ch,1);
#else
                ch = getch();
#endif
                *buffered = ch;
                result = find_key (*buffered++);
        }

        if (result) {
                buffered = keybuff;
                return (result);
        }
        else if (*pointer == 0x1b) {
            pointer = buffered = keybuff;
            /* sleep(1); */
            clr_keybuf();
            return get_key();
        }
        return (*pointer++);
}
/*}}}  */
