#ifndef __TURBOC__
#ifndef LINT
static char fieldedt_module[] = "@(#)fieldedt.c 1.2 12/2/90";
#endif
#endif

/*{{{  includes*/
#include <stdio.h>
#include <ctype.h>
#include "inmos.h"
#include "globals.h"
#include "misc.h"
#include "screen.h"
#include "oriedt.h"
#include "edtutil.h"
#include "macros.h"
#include "keys.h"
#include "fieldedt.h"
/*}}}  */
/*{{{  defines*/
#define WORD_WRAP 65

#define change_edit_pos(by)     {first_edit_pos += (by); pre_edit_pos += (by);}

#define are_we_past_end(LINK)   \
                        if (*(LINK)->field_pos > strlen((LINK)->field_str) + 1)\
                           pad_((LINK)->field_str, ' ', *(LINK)->field_pos - 1)

/*}}}  */
/*{{{F fieldedt.h*/
/*:::F fieldedt.h*/
/*}}}  */

int wordwrap_mode = FALSE;

/*{{{  prototypes*/
PRIVATE void restore_cursor P((LOC_field *));
PRIVATE void refresh_field P((int, int, LOC_field *));
PRIVATE void move_cursor P((int, LOC_field *));
PRIVATE void insert_ P((int, LOC_field *));
PRIVATE void delete__ P((LOC_field *));
PRIVATE void delete_under P((LOC_field *));
PRIVATE uchar char_type P((int));
PRIVATE BOOL symbol_start P((LOC_field *));
/*}}}  */
/*{{{  PRIVATE void restore_cursor(LOC_field *LINK)*/
PRIVATE void restore_cursor(LINK)
LOC_field *LINK;
{
  LINK->sect = (*LINK->field_pos - 1) / LEN + 1;
  if (LINK->sect <= 2) {
    int x;

    x = str_length(START + (*LINK->field_pos-1) % LEN, LINK->field_str);
    Gotoxy(x, dsp_fields[LINK->sect - 1]);
  }
  else
    Gotoxy(START + LEN, OVERFLOW_LINE);
  /* p2c: edtline.pas, line 357:
   * Note: Using % for possibly-negative arguments [317]
   */
}
/*}}}  */
/*{{{  PRIVATE void refresh_field(int froms,int tos,LOC_field *LINK)*/
PRIVATE void refresh_field(from, to, LINK)
int from, to;
LOC_field *LINK;
{
  char f_str[MAX_FIELD_SIZE + 1];
  int sect, left_pos, right_pos;
  int froms, tos;
  char STR1[256];

  if (from < 1) from = 1;
  if (to > LINK->full_len) to = LINK->full_len;   /* len*2 */
  if (to < from) return;
  froms = str_length(from, LINK->field_str);
  tos = str_length(to, LINK->field_str);
  expand_tabs(f_str, LINK->field_str);
  if (tos > strlen(f_str)) pad_(f_str, ' ', tos);
  for (sect = 1; sect <= 2; sect++) {
    if (froms <= sect * LEN && tos > (sect - 1) * LEN) {
      if (froms > (sect - 1) * LEN) left_pos = froms;
      else left_pos = (sect - 1) * LEN + 1;
      if (tos <= sect * LEN) right_pos = tos;
      else right_pos = sect * LEN;
      Gotoxy(START + (left_pos - 1) % LEN, dsp_fields[sect - 1]);
      /* p2c: edtline.pas, line 380:
       * Note: Using % for possibly-negative arguments [317]
       */
      wrline(strsub(STR1, f_str, left_pos, right_pos - left_pos + 1));
    }
  }
}
/*}}}  */
/*{{{  PRIVATE void move_cursor(int dist,LOC_field *LINK)*/
PRIVATE void move_cursor(dist, LINK)
int dist;
LOC_field *LINK;
{
  if (*LINK->field_pos + dist <= 0 || *LINK->field_pos + dist > LINK->full_len + 1)
    return;
  *LINK->field_pos += dist;
  if (*LINK->field_pos > strlen(LINK->field_str) + 1)
    strcat(LINK->field_str, " ");
  if (*LINK->field_pos == strlen(LINK->field_str)) {
    if (LINK->field_str[strlen(LINK->field_str) - 1] == ' ')
      LINK->field_str[strlen(LINK->field_str) - 1] = '\0';
  }
}
/*}}}  */
/*{{{  PRIVATE void insert_(char ch,LOC_field *LINK)*/
PRIVATE void insert_(ch, LINK)
int ch;
LOC_field *LINK;
{
  char STR1[MAX_FIELD_SIZE + 1];
  char STR3[256];

  if (*LINK->field_pos > LINK->full_len)
    return;
  if ((*LINK->field_pos > pre_edit_pos || ch != ' ' ||
       *LINK->field_pos <= LINK->ind) && *LINK->field_pos < first_edit_pos)
    return;
  if (strlen(LINK->field_str) == LINK->full_len) {
    LINK->field_str[LINK->full_len - 1] = '\0';
    /* p2c: edtline.pas, line 408:
     * Note: Modification of string length may translate incorrectly [146]
     */
  }
  sprintf(STR3, "%.*s%c%s",
          *LINK->field_pos - 1, LINK->field_str, ch,
          copy_to_end(STR1, LINK->field_str, *LINK->field_pos));
  strcpy(LINK->field_str, STR3);
  if (*LINK->field_pos <= pre_edit_pos)
    change_edit_pos(1);
  (*LINK->field_pos)++;
  refresh_field(*LINK->field_pos - ch_length(ch),
                strlen(LINK->field_str), LINK);
}
/*}}}  */
/*{{{  PRIVATE void delete__(LOC_field *LINK)*/
PRIVATE void delete__(LINK)
LOC_field *LINK;
{
  char STR2[MAX_FIELD_SIZE + 1];
  char STR3[256];


  if (*LINK->field_pos <= LINK->ind + 1) {
    LINK->field_key = FALSE;
    return;
  }
  if (*LINK->field_pos <= first_edit_pos && *LINK->field_pos > pre_edit_pos)
    return;
  deleted_ch = LINK->field_str[*LINK->field_pos - 2];
  sprintf(STR3, "%.*s%s",
          *LINK->field_pos - 2, LINK->field_str,
          copy_to_end(STR2, LINK->field_str, *LINK->field_pos));
  strcpy(LINK->field_str, STR3);
  if (*LINK->field_pos <= pre_edit_pos)
    change_edit_pos(-1);
  (*LINK->field_pos)--;
  refresh_field(*LINK->field_pos,
          (int)(strlen(LINK->field_str) + ch_length('\t')), LINK);
}
/*}}}  */
/*{{{  PRIVATE void delete_under(LOC_field *LINK)*/
PRIVATE void delete_under(LINK)
LOC_field *LINK;
{
  char STR2[MAX_FIELD_SIZE + 1];
  char STR3[256];

  if (*LINK->field_pos > LINK->full_len || *LINK->field_pos <= LINK->ind)
    return;
  if (*LINK->field_pos < first_edit_pos && *LINK->field_pos >= pre_edit_pos)
    return;
  deleted_ch = LINK->field_str[*LINK->field_pos - 1];
  sprintf(STR3, "%.*s%s",
          *LINK->field_pos - 1, LINK->field_str,
          copy_to_end(STR2, LINK->field_str, *LINK->field_pos + 1));
  strcpy(LINK->field_str, STR3);
  if (strlen(LINK->field_str) < *LINK->field_pos)
    strcat(LINK->field_str, " ");
  if (*LINK->field_pos < pre_edit_pos)
    change_edit_pos(-1);
  refresh_field(*LINK->field_pos, strlen(LINK->field_str)+1, LINK);
}
/*}}}  */
/*{{{  PRIVATE uchar char_type(char ch)*/
PRIVATE uchar char_type(ch)
int ch;
{
  if (ch != ' ') {
    if (isdigit(ch) || isalpha(ch))
      return 1;
    else
      return 2;
  } else
    return 0;
}
/*}}}  */
/*{{{  PRIVATE BOOL symbol_start(LOC_field *LINK)*/
PRIVATE BOOL symbol_start(LINK)
LOC_field *LINK;
{
  BOOL b;

  b = (*LINK->field_pos > 1 && *LINK->field_pos <= strlen(LINK->field_str));
  if (b) {
    if (LINK->field_str[*LINK->field_pos - 1] == ' ')
      return FALSE;
    else
      return (char_type(LINK->field_str[*LINK->field_pos - 2]) !=
              char_type(LINK->field_str[*LINK->field_pos - 1]));
  }
  else
    return TRUE;
}
/*}}}  */
/*{{{  int field_edit(BOOL *keypad,int *field_pos_,char *field_str_)*/
int field_edit(keypad, field_pos_, field_str_)
BOOL *keypad;
int *field_pos_;
char *field_str_;
{
  LOC_field V;
  int Result, ch, i = 0;
  int temp, tempf;
  char STR1[256];
  char STR2[256];
  element *WITH;
  char STR3[MAX_FIELD_SIZE + 1];
  char STR4[MAX_FIELD_SIZE + 1];

  V.field_pos = field_pos_;
  V.field_str = field_str_;
  V.ind = current->UU.U1.indent;
  V.full_len = LEN * 2;
  while (str_length(i, V.field_str) < *V.field_pos)
    i++;
  *V.field_pos = i;
  trailing_spaces(V.field_str);
  if (strlen(V.field_str) < V.ind) {
    V.field_str[V.ind] = '\0';
    /* p2c: edtline.pas, line 476:
     * Note: Modification of string length may translate incorrectly [146]
     */
  }
  if (strlen(V.field_str) > V.full_len) {
    V.field_str[V.full_len] = '\0';
    /* p2c: edtline.pas, line 477:
     * Note: Modification of string length may translate incorrectly [146]
     */
  }
  if (*V.field_pos <= V.ind) *V.field_pos = V.ind + 1;
  are_we_past_end(&V);   /* full_len */
  refresh_field(LEN, strlen(V.field_str), &V);
  do {
    V.field_key = FALSE;
    do {
      restore_cursor(&V);
      ch = edit_key(keypad);
    } while (!valid_key(keypad, &ch));
    V.field_key = valid_field_key(keypad, &ch);
    if (V.field_key) {
      no_message();
      if (wordwrap_mode && ch == ' ' && *V.field_pos > WORD_WRAP) {
        ch = O_RETURN;
        *keypad = TRUE;
      }
      if (*keypad) {
        switch (ch) {   /* if and case */
        /*{{{  case O_UNDEL_CHAR:*/
        case O_UNDEL_CHAR:
          insert_(deleted_ch, &V);
          break;
        /*}}}  */
        /*{{{  case O_START_OF_LINE:*/
        case O_START_OF_LINE:
          *V.field_pos = V.ind + 1;
          trailing_spaces(V.field_str);
          are_we_past_end(&V);
          if (*V.field_pos < strlen(V.field_str)) {
            while (isspace(V.field_str[*V.field_pos - 1]))
              (*V.field_pos)++;
          }
          break;
        /*}}}  */
        /*{{{  case O_END_OF_LINE:*/
        case O_END_OF_LINE:  /*eol*/
          trailing_spaces(V.field_str);
          *V.field_pos = strlen(V.field_str) + 1;

          /* Following 2 lines are added, Vedat Demiralp, 10 March 1993 */
          WITH = current;                                     /* added */ 
          if (WITH->foldline == END_FOLD ) *V.field_pos += 2; /*added*/

          if (*V.field_pos <= V.ind) {
              *V.field_pos = V.ind + 1;
              are_we_past_end(&V);
          } else {       /* checking the value of first_edit_pos is added */
              if (*V.field_pos < first_edit_pos && first_edit_pos != 255) {
                  *V.field_pos = first_edit_pos;
                  are_we_past_end(&V);
              }
          }
          break;
        /*}}}  */
        /*{{{  case O_WORD_RIGHT:*/
        case O_WORD_RIGHT:   /*word right*/
          if (*V.field_pos < last_char(V.field_str)) {   /*=*/
            do {
              move_cursor(1, &V);
            } while (!symbol_start(&V));
          }
          else move_cursor(1, &V);
          break;
        /*}}}  */
        /*{{{  case O_WORD_LEFT:*/
        case O_WORD_LEFT:   /*word left*/
          if (*V.field_pos > first_char(V.field_str)) {
            do {
              move_cursor(-1, &V);
            } while (!(symbol_start(&V) && *V.field_pos <= strlen(V.field_str)));
          }
          else {
            *V.field_pos = V.ind + 1;
            are_we_past_end(&V);
          }
          break;
        /*}}}  */
        /*{{{  case O_LITERAL:*/
        case O_LITERAL:
          message("char ? ");
          ch = getchar();
          no_message();
          insert_(ch, &V);
          break;
        /*}}}  */
        /*{{{  case O_DELTO_EOL:*/
        case O_DELTO_EOL:
          if (*V.field_pos >= first_edit_pos) {
            temp = strlen(V.field_str);
            sprintf(V.field_str, "%.*s",
                    *V.field_pos - 1, strcpy(STR2, V.field_str));
            refresh_field(*V.field_pos, temp, &V);
          }
          break;
        /*}}}  */
        /*{{{  case O_DEL_WORDL:*/
        case O_DEL_WORDL:
          if (*V.field_pos >= first_edit_pos) {
            int begin, end;
        
            temp = strlen(V.field_str);
            end = *V.field_pos;
            do {
              move_cursor(-1, &V);
            } while (!(symbol_start(&V) && *V.field_pos <= strlen(V.field_str)));
            begin = *V.field_pos;
            sprintf(V.field_str + begin - 1, "%s",
                    strcpy(STR2, V.field_str + end));
            refresh_field(*V.field_pos, temp, &V);
          }
          break;
        /*}}}  */
        /*{{{  case O_DEL_WORDR:*/
        case O_DEL_WORDR:
          if (*V.field_pos >= first_edit_pos) {
            int begin, end;
        
            temp = strlen(V.field_str);
            begin = *V.field_pos;
            do {
              move_cursor(1, &V);
            } while (!symbol_start(&V));
            end = *V.field_pos;
            *V.field_pos = begin;
            sprintf(V.field_str + begin - 1, "%s",
                    strcpy(STR2, V.field_str + end - 1));
            refresh_field(*V.field_pos, temp, &V);
          }
          break;
        /*}}}  */
        /*{{{  case O_LEFT:*/
        case O_LEFT:
          move_cursor(-1, &V);
          break;
        /*}}}  */
        /*{{{  case O_RIGHT:*/
        case O_RIGHT:
          move_cursor(1, &V);
          break;
        /*}}}  */
        /*{{{  case O_DEL_CHAR_R:*/
        case O_DEL_CHAR_R:
          delete_under(&V);
          break;
        /*}}}  */
        /*{{{  case O_BROWSE:*/
        case O_BROWSE:
          browse_mode = !browse_mode;
          break;
        /*}}}  */
        /*{{{  case O_DELETE:*/
        case O_DELETE:
          delete__(&V);
          break;
        /*}}}  */
        /*{{{  case O_RETURN:*/
        case O_RETURN:   /* cr */
          if (available(1)) {
            tempf = first_char(V.field_str);
            temp = strlen(V.field_str);
            if (!select_on) {   /* makefold */
              WITH = current;
              if (current != tail || *V.field_pos == 1) {
                if (!entered(current) || current != head->next ||
                    *V.field_pos > temp) {
                  if (WITH->foldline == NOT_FOLD || *V.field_pos <= tempf ||
                      *V.field_pos > temp) {
                    split_line = (*V.field_pos > tempf);
                    proc_new(&part_line);
                    part_line->UU.U1.indent = V.ind;
                    if (split_line) {
                      copy_line_to_parts(copy_to_end(STR3, V.field_str,
                                                     *V.field_pos),
                                         &part_line);
                      sprintf(V.field_str, "%.*s",
                              *V.field_pos - 1, strcpy(STR2, V.field_str));
                      refresh_field(*V.field_pos, temp, &V);
                    }
                    *V.field_pos = first_char(V.field_str);
                    sprintf(STR1, "%s%s",
                            spaces(STR3, *V.field_pos - V.ind - 1),
                            line_of(STR4, part_line));
                    copy_line_to_parts(STR1, &part_line);
                    V.field_key = FALSE;
                  }
                }
              }
            }
          }
          break;
        }
        /*}}}  */
      }
      if (!*keypad)
        insert_(ch, &V);
    }
  } while (V.field_key != FALSE);
  Result = ch;
  trailing_spaces(V.field_str);
  *V.field_pos = str_length(*V.field_pos, V.field_str);
  if (strlen(V.field_str) < LEN) return Result;
  Gotoxy(LEN, dsp_fields[0]);
  wrline(DIAMOND);
  Gotoxy(START, OVERFLOW_LINE);
  Clreol();
  return Result;
}
/*}}}  */
