#ifndef __TURBOC__
#ifndef LINT
static char editor_module[] = "@(#)editor.c     1.2 12/2/90";
#endif
#endif

/*{{{  includes*/
#include <stdio.h>
#include <ctype.h>
#ifdef __TURBOC__
#include <conio.h>
#endif
#include "inmos.h"
#include "globals.h"
#include "misc.h"
#include "screen.h"
#include "macros.h"
#include "oriedt.h"
#include "edtutil.h"
#include "filer.h"
#include "procexit.h"
#include "editor.h"
/*}}}  */
/*{{{  defines*/
#define left_cursor(y);         Gotoxy(1, TITLE_LINE + (y));

#define delete_dsp_line(level)  {left_cursor((level)); Clreol();}

#define left_scroll_region(y);  W_oy=TITLE_LINE+(y); W_dy=TITLE_LINE+SCREEN_LEN;


#define up_a_bit(from)    {left_scroll_region((from));\
                        Gotoxy(1,W_oy); DelLine();full_window();}

#define down_a_bit(from) {left_scroll_region((from));\
                        Gotoxy(1,W_oy);insLine();full_window();}

#define sub_title()     {Gotoxy(1, TITLE_LINE); colour(3); \
                                printf("Origami  \n"); no_message();}

#define pre_pre_open_fold(q)    {check_fold(q); \
                                  Line_after_fold->prec = End_of_fold; \
                                  Start_of_fold->next = Start_of_fold->fold; \
                                  Start_of_fold->foldline = START_OPEN_FOLD;}
/*}}}  */
/*{{{  private prototypes*/
PRIVATE int line_no P((element *));
PRIVATE BOOL on_screen P((element *));
PRIVATE BOOL select_forward P((void));
PRIVATE BOOL select_backward P((void));
PRIVATE void write_select P((int, element *));
PRIVATE void line_refresh P((int, element *));
PRIVATE void whole_screen_up P((void));
PRIVATE void whole_screen_down P((void));
PRIVATE void sub_move_up P((void));
PRIVATE void sub_move_down P((void));
PRIVATE void restore_to_end P((int));
PRIVATE int to_start P((int));
PRIVATE void restore_or_restore_to_end P((void));
PRIVATE void pre_enter_fold P((element *));
PRIVATE void enter_folds_to P((element *));
PRIVATE void close_and_open_folds P((element *));
PRIVATE element *pre_find_element P((int));
PRIVATE int right_index P((char *, char *));
PRIVATE void insert_link_before P((element *));
PRIVATE void erase_current_link P((void));
PRIVATE void pre_remove_line P((element **));
PRIVATE void pre_exit_fold P((void));
/*}}}  */
/*{{{F editor.h*/
/*:::F editor.h*/
/*}}}  */

/*{{{  void            proc_dispose(element * p)*/
void            proc_dispose(p)
    element        *p;
{
    dispose_size += lines_within(p);
    join_links(dispose_tail, p);
    dispose_tail = p;
}
/*}}}  */

/*{{{  void create_list(void)*/
void create_list()
{
  element *p;

  proc_new(&head);
  head->prec = NULL;
  proc_new(&p);
  proc_new(&tail);
  tail->next = NULL;
  join_links(head, p);
  join_links(p, tail);
  p->foldline = START_ENTER_FILED;
  p->other_end = tail;
  tail->other_end = p;
  tail->foldline = END_FOLD;
  insert_file((element *)NULL, p, tail, TRUE);
  current = p->next;
  real_head = head;
  real_tail = tail;
}
/*}}}  */
/*{{{  PRIVATE int line_no(element *q)*/
PRIVATE int line_no(q)
element *q;
{
  int i;
  element *p;

  i = 0;
  p = real_head;
  while (p != q) {
    i++;   /*_full*/
    move_on(&p);
  }
  return i;
}
/*}}}  */
PRIVATE uchar on_screen_line;
/*{{{  PRIVATE BOOL on_screen(element *p)*/
PRIVATE BOOL on_screen(p)
element *p;
{
  element *q, *old_q;
  BOOL on_scr;
  uchar line;

  line = 0;   /*TITLE_LINE*/
  q = screen_start;
  on_scr = FALSE;
  do {
    line++;
    old_q = q;
    if (q == p) {
      on_screen_line = line;
      on_scr = TRUE;
    }
    q = q->next;
  } while (old_q != screen_end);
  on_scr = (on_scr && on_screen_line > 1 && on_screen_line < SCREEN_LEN);
  return on_scr;
}
/*}}}  */
/*{{{  PRIVATE BOOL select_forward(void)*/
PRIVATE BOOL select_forward()
{
  if (current == tail)
    return FALSE;
  else
    return (current->next->selected);
}
/*}}}  */
/*{{{  PRIVATE BOOL select_backward(void)*/
PRIVATE BOOL select_backward()
{
  if (current == head->next)
    return FALSE;
  else
    return (current->prec->selected);
}
/*}}}  */
/*{{{  PRIVATE void write_select(int height,element *ptr)*/
PRIVATE void write_select(height, ptr)
int height;
element *ptr;
{
  Gotoxy(SELECT_X, TITLE_LINE + height);
  if (ptr->selected)
    printf("s");
  else
    printf(" "); /* < ?? */
  P_ioresult=0;
}
/*}}}  */
/*{{{  PRIVATE void line_refresh(int level,element *ptr)*/
PRIVATE void line_refresh(level, ptr)
int level;
element *ptr;
{
  char dsp_line[MAX_FIELD_SIZE + 1],
       tmp_line[MAX_FIELD_SIZE + 1];

  copyin(dsp_line, ptr, FALSE);
  expand_tabs(tmp_line, dsp_line);
  Gotoxy(1, level);
  if (strlen(tmp_line) >= LEN) {
      sprintf(dsp_line, "%.*s%s", (int)(LEN - 1), tmp_line, DIAMOND);
      wrline(dsp_line);
  }
  else
      wrline(tmp_line);
  Clreol();
}
/*}}}  */
/*{{{  void write_dsp_line(element *ptr,int level)*/
void write_dsp_line(ptr, level)
element *ptr;
int level;
{
  line_refresh(level + TITLE_LINE, ptr);
  write_select(level, ptr);
}
/*}}}  */
/*{{{  PRIVATE void whole_screen_up(void)*/
PRIVATE void whole_screen_up()
{
  if (screen_start == tail)
    return;
  up_a_bit(1);
  screen_start = screen_start->next;
  cursor_level--;
  if (screen_end != tail) {
    screen_end = screen_end->next;
    write_dsp_line(screen_end, SCREEN_LEN);
  }
  else
    screen_end_level--;
}
/*}}}  */
/*{{{  PRIVATE void whole_screen_down(void)*/
PRIVATE void whole_screen_down()
{
  if (screen_start == head->next)
    return;
  down_a_bit(1);
  screen_start = screen_start->prec;
  cursor_level++;
  write_dsp_line(screen_start, 1);
  if (screen_end_level == SCREEN_LEN)
    screen_end = screen_end->prec;
  else
    screen_end_level++;
}
/*}}}  */
/*{{{  void dummy_cursor(BOOL display)*/
void dummy_cursor(display)
BOOL display;
{
  Gotoxy(SELECT_X-1, TITLE_LINE + cursor_level);
  colour(4);   /*yellow*/
  if (display) {
    printf("<");
    P_ioresult=0;
  }
  else
    printf(" ");
    P_ioresult=0;
  colour(1);
}
/*}}}  */
/*{{{  void title(void)*/
void title()
{
  char filename[33];
  char STR1[98];
  char STR2[86];
  extern BOOL file_changed;

  if (real_tail == real_head)
    *filename = '\0';
  else
    (void) line_of(filename, real_tail);

  sub_title();
  if (dialect == NO_LANGUAGES - 1) {
    sprintf(STR1, "Help: %s     V%s %s %c | %s %s %s",
	    (strcmp(getenv("TERM"), "pc")) ? "[Do]h" : "F1",
	    version, filename,
	    (file_changed) ? '*' : ' ',
	    language_string[dialect],
	    dialect_start[dialect], dialect_end[dialect]);
    message(STR1);
  }
  else {
    sprintf(STR2, "Help: %s  V%s %s %c | %s",
	    (strcmp(getenv("TERM"), "pc")) ? "[Do]h" : "F1",
	    version, filename,
	    (file_changed) ? '*' : ' ',
	    language_string[dialect]);
    message(STR2);
  }
}
/*}}}  */
/*{{{  void restore(int from)*/
void restore(from)
int from;
{
  element *p;
  int h, FORLIM;

  colour(1);
  p = screen_start;
  FORLIM = screen_end_level;
  for (h = 1; h <= FORLIM; h++) {
    if (h >= from) write_dsp_line(p, h);
    p = p->next;
  }
  if (screen_end_level < SCREEN_LEN) {
    left_scroll_region(screen_end_level + 1);
    for (h = FORLIM + 1; h <= SCREEN_LEN; h++) {
	Gotoxy(1, h + TITLE_LINE);
        Clreol();
    }
    full_window();
  }
  dummy_cursor(TRUE);
}
/*}}}  */
/*{{{  void line_or_move_up(int to_line)*/
void line_or_move_up(to_line)
int to_line;
{
  if (current->prec == head) {
     message("TOP of LIST");
    return;
  }
  if (select_on && select_backward()) {
    current->selected = FALSE;
    write_select(cursor_level, current);
  }
  current = current->prec;
  if (screen_start->prec != head && cursor_level < to_line) whole_screen_down();
  cursor_level--;
  if (select_on) {
    current->selected = TRUE;
    write_select(cursor_level, current);
  }
}
/*}}}  */
/*{{{  PRIVATE void sub_move_up(void)*/
PRIVATE void sub_move_up()
{
  if (current->prec == head)
    return;
  if (select_on && select_backward())
    current->selected = FALSE;
  current = current->prec;
  current->selected = select_on;
}
/*}}}  */
/*{{{  PRIVATE void sub_move_down(void)*/
PRIVATE void sub_move_down()
{
  if (current == tail)
    return;
  if (select_on && select_forward())
    current->selected = FALSE;
  current = current->next;
  current->selected = select_on;
}
/*}}}  */
/*{{{  void move_or_line_down(int from_line)*/
void move_or_line_down(from_line)
int from_line;
{
  if (current == tail) {
    message("BOTTOM of LIST.");
    return;
  }
  if (select_on && select_forward()) {
    current->selected = FALSE;
    write_select(cursor_level, current);
  }
  current = current->next;
  if (cursor_level > from_line && screen_end != tail) whole_screen_up();
  cursor_level++;
  if (select_on) {
    current->selected = TRUE;
    write_select(cursor_level, current);
  }
}
/*}}}  */
/*{{{  PRIVATE void restore_to_end(int from)*/
PRIVATE void restore_to_end(from)
int from;
{  /*if select_on then set select separately*/
  screen_end = current;
  screen_end_level = cursor_level;
  while (screen_end_level < SCREEN_LEN && screen_end != tail) {
    screen_end_level++;
    screen_end = screen_end->next;
  }
  restore(from);
}
/*}}}  */
/*{{{  PRIVATE int to_start(int m)*/
PRIVATE int to_start(m)
int m;
{
  int dist_to_start;
  element *p;

  dist_to_start = 1;
  p = current;
  while (p != head->next && dist_to_start <= m) {
    dist_to_start++;
    p = p->prec;
  }
  return dist_to_start;
}
/*}}}  */
/*{{{  int to_bottom(int m)*/
int to_bottom(m)
int m;
{
  int dist_to_end;
  element *p;

  dist_to_end = 0;
  p = current;
  while (p != tail && dist_to_end <= m) {
    dist_to_end++;
    p = p->next;
  }
  return dist_to_end;
}
/*}}}  */
/*{{{  void restore_element(uchar close_line)*/
void restore_element(close_line)
int close_line;
{  /*if select_on then set select separately*/
  int level, dist_to_end;
  int dist_to_start;

  dist_to_start = to_start((int)(SCREEN_LEN - 1));
  dist_to_end = to_bottom((int)(SCREEN_LEN - 2));
  cursor_level = close_line;
  if (cursor_level < 2)
    cursor_level = 2;
  if (cursor_level >= SCREEN_LEN)
    cursor_level = SCREEN_LEN - 1;
  if (dist_to_start < cursor_level)
    cursor_level = dist_to_start;
  while (cursor_level + dist_to_end < SCREEN_LEN && dist_to_start > cursor_level)
    cursor_level++;
  screen_start = current;
  for (level = cursor_level - 1; level >= 1; level--)
    screen_start = screen_start->prec;
  restore_to_end(1);
}
/*}}}  */
/*{{{  PRIVATE void restore_or_restore_to_end(void)*/
PRIVATE void restore_or_restore_to_end()
{
  element *p;

  if (screen_start != head->next) {
    restore_element(4);
    return;
  }
  p = head->next;
  cursor_level = 1;
  while (p != current) {
    cursor_level++;
    p = p->next;
  }
  restore_to_end(cursor_level);
}
/*}}}  */
/*{{{  void pre_open_fold(element *q)*/
void pre_open_fold(q)
element *q;
{
  element *p;
  int i;

  pre_pre_open_fold(q);
  p = Start_of_fold;
  i = total_indent(p);
  p->UU.U1.indent = i;
  do {
    p = p->next;
    p->UU.U1.indent += i;
  } while (p != End_of_fold);
}
/*}}}  */
/*{{{  PRIVATE void pre_enter_fold(element *cur)*/
PRIVATE void pre_enter_fold(cur)
element *cur;
{   /*rent*/
  element *WITH;

  check_fold(cur);
  Line_after_fold->prec = End_of_fold;
  enter_depth++;
  WITH = Start_of_fold;
  enter_depth_spaces += total_indent(Start_of_fold);
  WITH->next = WITH->fold;
  WITH->foldline = START_ENTER_FOLD;
  WITH->fold = head;
  head = WITH->prec;
  End_of_fold->fold = tail;
  tail = End_of_fold;
  /*save indent*/
  End_of_fold->UU.U1.fold_indent = Start_of_fold->UU.U1.indent;
  Start_of_fold->UU.U1.indent = 0;
}
/*}}}  */
/*{{{  PRIVATE void enter_folds_to(element *qq)*/
PRIVATE void enter_folds_to(qq)
element *qq;
{
  element *q, *old_q, *save_q;

  do {
    save_q = NULL;
    q = qq;
    while (q != head) {
      old_q = q;
      q = q->prec;
      if (q->foldline == START_FOLD && q->fold == old_q)
        save_q = q;
    }
    if (save_q != NULL)
      pre_enter_fold(save_q);
  } while (save_q != NULL);
}
/*}}}  */
/*{{{  PRIVATE void close_and_open_folds(element *qq)*/
PRIVATE void close_and_open_folds(qq)
element *qq;
{
  element *q, *old_q;

  q = qq;
  while (q != head) {
    old_q = q;
    q = q->prec;
    if (q->foldline == START_FOLD && q->fold == old_q) pre_open_fold(q);
    if (q->foldline == END_FOLD) {
      if (q->other_end->foldline == START_OPEN_FOLD) {
        q = q->other_end;
        close_fold_at(q);
      }
    }
  }
  q = qq;
  while (q != tail) {
    q = q->next;
    if (q->foldline == START_OPEN_FOLD)
      close_fold_at(q);
  }
}
/*}}}  */
/*{{{  PRIVATE element *pre_find_element(int new_line_no)*/
PRIVATE element *pre_find_element(new_line_no)
int new_line_no;
{
  int current_line_no;
  element *p;

  current_line_no = 0;
  p = head->next;
  while (current_line_no < new_line_no && p != tail) {
    current_line_no++;
    move_on(&p);
  }
  return p;
}
/*}}}  */
/*{{{  void find_element(int new_line_no,uchar close_line)*/
void find_element(new_line_no, close_line)
int new_line_no;
int close_line;
{
  element *p;

  p = pre_find_element(new_line_no);
  close_and_open_folds(p);
  current = p;
  restore_element(close_line);
}
/*}}}  */
/*{{{  void get_search(void)*/
void get_search()
{
  char temp_str[33];

  (void) readprompt(temp_str, "Search for", 31);
  if (*temp_str != '\0')
    (void) upper_case(item_to_look_for, temp_str);
}
/*}}}  */
/*{{{  PRIVATE int right_index(char *large_str_,char *small_str)*/
PRIVATE int right_index(large_str_, small_str)
char *large_str_, *small_str;
{
  int Result;
  char large_str[MAX_FIELD_SIZE + 1];
  int item_pos;

  strcpy(large_str, large_str_);
  Result = 0;
  do {
    item_pos = strpos2(large_str, small_str, 1);
    if (item_pos > 0) {
      Result = item_pos;
      large_str[item_pos - 1] = '_';
    }
  } while (item_pos != 0);
  return Result;
}
/*}}}  */
/*{{{  void find_item(int *cursor_x_pos)*/
void find_item(cursor_x_pos)
int *cursor_x_pos;
{
  int position, i;
  element *p, *q;
  BOOL found, on_scr;
  char this_line[MAX_FIELD_SIZE + 1];
  int FORLIM;
  char STR1[MAX_FIELD_SIZE + 1];
  char STR3[46];

  if (*item_to_look_for == '\0') get_search();
  p = current;
  found = FALSE;
  if (backup) {
    while (p != head && !found) {
      copyin(this_line, p, FALSE);
      if (p == current) {
        for (i = *cursor_x_pos - 1; i < MAX_FIELD_SIZE; i++) this_line[i] = '_';
      }
      position = right_index(upper_case(STR1, this_line), item_to_look_for);
      if (position != 0) {
        found = TRUE;
        break;
      }
      if (p->prec->foldline == START_FOLD && p->prec->next == p) p = p->prec->other_end;
      else p = p->prec;
    }
  }
  else {
    while (p != tail && !found) {
      copyin(this_line, p, FALSE);
      if (p == current) {
        FORLIM = *cursor_x_pos;
        for (i = 0; i < FORLIM; i++) this_line[i] = '_';
      }
      position = strpos2(upper_case(STR1, this_line), item_to_look_for, 1);
      if (position == 0) move_on(&p);
      else found = TRUE;
    }
  }
  if (!found) {
    sprintf(STR3, "%s Not found\007", item_to_look_for);
    message(STR3);
    return;
  }
  on_scr = on_screen(p);
  q = current;
  close_and_open_folds(p);
  current = p;
  if (on_scr)
    cursor_level = on_screen_line;   /*restore_element(on_screen_line)*/
  else
    restore_element(4);
  if (p != q) {
    copyin(this_line, p, FALSE);
    if (backup)
      *cursor_x_pos = right_index(upper_case(STR1, this_line),
                                  item_to_look_for);
    else
      *cursor_x_pos = strpos2(upper_case(STR1, this_line), item_to_look_for, 1);
  }
  else
    *cursor_x_pos = position;
  if (*cursor_x_pos < 1)
    *cursor_x_pos = 1;
  message("Replace with ");
  fputs(replace_item, stdout);
}
/*}}}  */
/*{{{  void proc_replace(char *search,char *replace,char *line,int position)*/
void proc_replace(search, replace, line, position)
char *search, *replace, *line;
int position;
{
  int ls, ll, i;
  BOOL rep;
  char STR1[MAX_FIELD_SIZE + 1];
  char STR3[256];

  ls = strlen(search);
  ll = strlen(line);
  if (ll < position + ls - 1)
    return;
  rep = TRUE;
  for (i = 1; i <= ls; i++)
    rep = (rep && upper(line[position + i - 2]) == search[i - 1]);
  if (rep) {
    sprintf(STR3, "%.*s%s%s",
            position - 1, line, replace,
            copy_to_end(STR1, line, position + ls));
    strcpy(line, STR3);
  }
}
/*}}}  */
/*{{{  void top(void)*/
void top()
{
  int dist_to_top, far_;

  far_ = cursor_level + 4;
  dist_to_top = to_start(far_);
  if (dist_to_top < far_) {
    while (current != head->next)
      move_up();
    return;
  }
  if (select_on) {
    while (current != head->next)
      sub_move_up();
  } else
    current = head->next;
  restore_element(4);
}
/*}}}  */
/*{{{  void bottom(void)*/
void bottom()
{
  int dist_to_bottom, far_;

  far_ = SCREEN_LEN - cursor_level + 4;
  dist_to_bottom = to_bottom(far_);
  if (dist_to_bottom < far_) {
    while (current != tail)
      move_down();
    return;
  }
  if (select_on) {
    while (current != tail)
      sub_move_down();
  }
  else
    current = tail;
  restore_element(4);
}
/*}}}  */
/*{{{  BOOL copy_a_line(element **to_ptr)*/
BOOL copy_a_line(to_ptr)
element **to_ptr;
{
  element *p, *q, *last, *fold_ptr;
  BOOL filed;

  filed = FALSE;
  p = current;
  while (!filed && p != current->next) {
    if (p->foldline == START_FILED) filed = TRUE;
    move_on(&p);
  }
  if (filed) {
    message("cannot copy filed folds");
    return (!filed);
  }
  p = current;
  last = NULL;
  fold_ptr = NULL;
  while (p != current->next) {
    proc_new(&q);
    if (p == current) *to_ptr = q;
    *q = *p;
    q->prec = last;
    if (last != NULL) {
      last->next = q;
      if (last->foldline == START_FOLD) last->fold = q;
      if (last->foldline == END_FOLD) {
        q->prec = last->other_end;
        q->prec->next = q;
      }
    }
    if (q->foldline == START_FOLD) {
      q->other_end = fold_ptr;
      fold_ptr = q;
    }
    move_on(&p);
    if (q->foldline == END_FOLD) {
      q->other_end = fold_ptr;
      fold_ptr = fold_ptr->other_end;
      q->other_end->other_end = q;
    }
    last = q;
  }
  return (!filed);
}
/*}}}  */
/*{{{  PRIVATE void insert_link_before(element *ptr_to_new)*/
PRIVATE void insert_link_before(ptr_to_new)
element *ptr_to_new;
{
  element *ptr_to_prec;

  ptr_to_new->UU.U1.indent = insert_indent_of(current);
  ptr_to_prec = current->prec;
  if (screen_start == current)
    screen_start = ptr_to_new;
  join_links(ptr_to_prec, ptr_to_new);
  join_links(ptr_to_new, current);
  current = ptr_to_new;
}
/*}}}  */
/*{{{  void undelete_before(element *ptr_to_new)*/
void undelete_before(ptr_to_new)
element *ptr_to_new;
{
  insert_link_before(ptr_to_new);
  if (cursor_level < SCREEN_LEN) {
    colour(1);
    down_a_bit(cursor_level);
  }
  else {
    delete_dsp_line(SCREEN_LEN);
  }
  write_dsp_line(current, cursor_level);
  if (screen_end_level == SCREEN_LEN)
    screen_end = screen_end->prec;
  else
    screen_end_level++;
  if (cursor_level > SCREEN_LEN - 2 && screen_end != tail)
    whole_screen_up();
}
/*}}}  */
/*{{{  void undelete_pick_before(void)*/
void undelete_pick_before()
{
  element *p, *sf, *ef;

  proc_new(&ef);
  join_links(pick_tail, ef);
  p = pick_head->next;
  proc_new(&sf);
  join_links(pick_head, sf);
  join_links(sf, p);
  sf->foldline = START_FOLD;
  sf->fold = sf->next;
  sf->other_end = ef;
  ef->foldline = END_FOLD;
  ef->other_end = sf;
  undelete_before(sf);
  pick_tail = pick_head;
}
/*}}}  */
/*{{{  void undelete_after(element *ptr_to_new)*/
void undelete_after(ptr_to_new)
element *ptr_to_new;
{
  element *ptr_to_next;


  /*note current<>tail*/
  ptr_to_next = current->next;
  join_links(current, ptr_to_new);
  join_links(ptr_to_new, ptr_to_next);
  if (cursor_level == SCREEN_LEN) {
    screen_end = screen_end->prec;
    whole_screen_up();
  }
  else {
    if (cursor_level == SCREEN_LEN - 1) {
      delete_dsp_line(SCREEN_LEN);
      write_dsp_line(ptr_to_new, SCREEN_LEN);
      if (screen_end_level == SCREEN_LEN) {
        screen_end = screen_end->prec;
        whole_screen_up();
      }
      else screen_end_level++;
    }
    else {
      if (screen_end_level == SCREEN_LEN) screen_end = screen_end->prec;
      else screen_end_level++;
      down_a_bit(cursor_level + 1);
      write_dsp_line(ptr_to_new, cursor_level + 1);
    }
  }
  move_down();
}
/*}}}  */
/*{{{  PRIVATE void erase_current_link(void)*/
PRIVATE void erase_current_link()
{
  element *prec_ptr, *p;

  if (current == tail)
    return;
  p = current;
  prec_ptr = p->prec;
  current = p->next;
  proc_dispose(p);
  join_links(prec_ptr, current);
}
/*}}}  */
/*{{{  PRIVATE void pre_remove_line(element **p)*/
PRIVATE void pre_remove_line(p)
element **p;
{
  element *prec_ptr;

  *p = current;
  prec_ptr = current->prec;
  if (screen_start == current)
    screen_start = current->next;
  current = current->next;
  join_links(prec_ptr, current);
}
/*}}}  */
/*{{{  void remove_line(element **p)*/
void remove_line(p)
element **p;
{
  if (!(current->foldline == NOT_FOLD || filed_or_fold(current)))
    return;
  if (current == tail)
    return;
  if (*p != NULL)
    proc_dispose(*p);
  pre_remove_line(p);
  if (cursor_level < SCREEN_LEN) {
    up_a_bit(cursor_level);
  }
  else {
    delete_dsp_line(SCREEN_LEN);
  }
  if (screen_end != tail) {
    screen_end = screen_end->next;
    write_dsp_line(screen_end, SCREEN_LEN);
  }
  else {
    screen_end_level--;
    whole_screen_down();
  }
}
/*}}}  */
/*{{{  void start_make_fold(int ind)*/
void start_make_fold(ind)
int ind;
{
  element *p;
  char STR1[MAX_FIELD_SIZE + 1];
  char STR2[162];

  if (entered(current))
    return;
  proc_new(&p);
  p->fold_close_line = cursor_level;
  makefold_indent = ind - 1;
  if (makefold_indent < current->UU.U1.indent)
    makefold_indent = current->UU.U1.indent;
  sprintf(STR2, "%s%s",
          spaces(STR1, (int)(makefold_indent - current->UU.U1.indent)),
          fold_open_str);
  copy_line_to_parts(STR2, &p);
  undelete_before(p);
  select_on = TRUE;
  select_ptr = current;
  current->selected = TRUE;
  write_select(cursor_level, current);
  move_down();
}
/*}}}  */
/*{{{  void make_fold(int *cursor_x_pos)*/
void make_fold(cursor_x_pos)
int *cursor_x_pos;
{
  element *p;
  int open_count, ind, i;
  BOOL indented_enough;
  int FORLIM;
  element *WITH;
  char STR1[MAX_FIELD_SIZE + 1];
  char STR2[MAX_FIELD_SIZE + 1];

  if (!select_backward()) {
    message("cannot fold backwards");
    return;
  }
  p = select_ptr->next;
  indented_enough = TRUE;
  open_count = 0;
  while (p != current && open_count >= 0 && indented_enough) {
    if (open_count == 0) {   /*check indentation >= makefold_indent*/
      if (p->foldline == START_OPEN_FOLD) indented_enough = (makefold_indent <= p->UU.U1.indent);
      if (filed_or_fold(p)) indented_enough = (makefold_indent <= total_indent(p));
      if (p->foldline == NOT_FOLD) {
        copy_parts_to_line(p, current_dsp_line);
        FORLIM = makefold_indent - p->UU.U1.indent;
        for (i = 0; i < FORLIM; i++) {
                if(current_dsp_line[i] == '\0')
                        break; /* blank lines are ok */
         indented_enough = (indented_enough && current_dsp_line[i] == ' ');
        }
      }
    }
    /* check not across open fold boundaries,
     * ie no of open folds=no of end folds
     */
    if (p->foldline == START_OPEN_FOLD) open_count++;
    if (p->foldline == END_FOLD) open_count--;
    p = p->next;
  }
  if (!(indented_enough && open_count == 0)) {
    message("cannot fold");
    return;
  }
  p = select_ptr->next;
  ind = makefold_indent - select_ptr->UU.U1.indent;
  while (p != current) {
    WITH = p;
    if (WITH->foldline == START_OPEN_FOLD) close_fold_at(p);
    if (filed_or_fold(p)) WITH->UU.U1.fold_indent -= ind;
    if (WITH->foldline == NOT_FOLD) copy_line_to_parts(copy_to_end(STR1, line_of(STR2, p), ind + 1), &p);
    WITH->UU.U1.indent = 0;
    p = p->next;
  }
  current->selected = FALSE;
  proc_new(&p);
  insert_link_before(p);
  p = select_ptr;
  while (p->selected) {
    p->selected = FALSE;
    p = p->next;
  }
  End_of_fold = current;
  Line_after_fold = End_of_fold->next;
  Start_of_fold = select_ptr;
  Start_of_fold->fold = Start_of_fold->next;
  Start_of_fold->other_end = End_of_fold;
  End_of_fold->other_end = Start_of_fold;
  Line_after_fold->prec = Start_of_fold;
  Start_of_fold->next = Line_after_fold;
  Start_of_fold->foldline = START_FOLD;
  Start_of_fold->UU.U1.indent = makefold_indent - ind;
  Start_of_fold->UU.U1.fold_indent = ind;
  End_of_fold->foldline = END_FOLD;
  End_of_fold->UU.U1.indent = 0;
  current = Start_of_fold;
  select_on = FALSE;
  copy_line_to_parts(null_dsp_line, &End_of_fold);
  copy_line_to_parts(null_dsp_line, &Start_of_fold);
  *cursor_x_pos = total_indent(current) + 6;
  if (on_screen(current))
    current->fold_close_line = on_screen_line;
  restore_element(current->fold_close_line);
  /* if on_screen and enough lines to fill screen
   * then restore_from(on_screen_line);
   */
}
/*}}}  */
/*{{{  void open_fold(void)*/
void open_fold()
{
  if (current->foldline != START_FOLD) {
    proc_error(0);
    return;
  }
  current->fold_close_line = cursor_level;
  pre_open_fold(current);
  restore_to_end(cursor_level);
}
/*}}}  */
/*{{{  void close_fold(void)*/
void close_fold()
{
  element *p;

  p = current;
  if (p->foldline == END_FOLD)
    p = p->other_end;
  while (p != head && p->foldline != START_OPEN_FOLD) {
    if (p->foldline == END_FOLD)
      p = p->other_end->prec;
    else
      p = p->prec;
  }
  if (p != head) {
    current = p;
    close_fold_at(p);
    restore_or_restore_to_end();
    return;
  }
  if (tail != real_tail)
    message("use exit fold !");
  else
    message("at top");
}
/*}}}  */
/*{{{  void comment_fold(void)*/
void comment_fold()
{
    char buf[MAX_FIELD_SIZE+1];

    if (current->foldline != START_FOLD) {
      proc_error(0);
      return;
    }
    if (strncmp(current->strng, COMMENT_MSG, strlen(COMMENT_MSG)) != 0) {
        strcpy(buf, current->strng);
        strcpy(current->strng, COMMENT_MSG);
        strcat(current->strng, " ");
        strcat(current->strng, buf);
    }
    else {
        char *rest = buf + strlen(COMMENT_MSG);

        strcpy(buf, current->strng);
        for (; rest != '\0' && *rest == ' '; rest++);
        strcpy(current->strng, rest);
    }
    restore_to_end(cursor_level);
}
/*}}}  */
/*{{{  PRIVATE void pre_exit_fold(void)*/
PRIVATE void pre_exit_fold()
{
  element *p, *WITH;

  enter_depth--;
  Start_of_fold = head->next;
  End_of_fold = tail;
  Line_after_fold = tail->next;
  tail = End_of_fold->fold;
  WITH = Start_of_fold;
  WITH->foldline = START_FOLD;
  head = WITH->fold;
  WITH->fold = WITH->next;
  WITH->next = Line_after_fold;
  Line_after_fold->prec = Start_of_fold;
  /*restore indent*/
  WITH->UU.U1.indent = End_of_fold->UU.U1.fold_indent;
  enter_depth_spaces -= total_indent(Start_of_fold);
  current = Start_of_fold;
  check_fold(current);
  p = Start_of_fold->fold;
  while (p->foldline != END_FOLD) {
    if (p->foldline == START_OPEN_FOLD)
      close_fold_at(p);
    p = p->next;
  }
}
/*}}}  */
/*{{{  void delete_list(element *from_ptr,element *to_ptr)*/
void delete_list(from_ptr, to_ptr)
element *from_ptr, *to_ptr;
{
  element *p, *q;

  q = from_ptr;   /*head^.next^.next*/
  while (q != to_ptr) {   /*tail*/
    p = q;
    q = q->next;
    proc_dispose(p);
  }
  proc_dispose(to_ptr);
}
/*}}}  */
/*{{{  void total_save(void)*/
void total_save()
{
  while (tail != real_tail)
    pre_exit_fold();
  if (file_changed) {
    proc_exit(real_tail, real_head->next);
    file_changed = FALSE;
  }
}
/*}}}  */
PRIVATE int head_line_no, cur_line_no;
/*{{{  void enter_fold(void));*/
void enter_fold()
{
  element *p;
  char filename[256];
  char *full_name;

  if (current->foldline == START_FOLD) {
    current->fold_close_line = cursor_level;
    pre_enter_fold(current);
    current = current->next;
    restore_element(4);
    return;
  }
  if (current->foldline != START_FILED) {
    proc_error(0);
    return;
  }
  if (!normal_att(current)) {
    message("not text fold");
    return;
  }
  if (current->fold != current->other_end) {
    message("cannot enter listing of filed fold");
    return;
  }
  (void) line_of(filename, current->other_end);
  skip_controls(filename);
  full_name = file_info(filename);
  if (!(file_exists && can_open)) {
    char line[MAX_FIELD_SIZE + 1];

    sprintf(line, "file '%s' not found", full_name);
    message(line);
    return;
  }
  head_line_no = line_no(head->next);
  cur_line_no = line_no(current);
  p = current;
  total_save();
  real_tail->UU.U0.int1 = head_line_no;
  real_tail->UU.U0.int2 = cur_line_no;
  real_tail->fold_close_line = cursor_level;
  current = p;
  current->foldline = START_FOLD;   /*to allow copy*/
  /*always TRUE*/
  if (copy_a_line(&p)) current = p;
  delete_list(head->next->next, tail->prec);   /*except for tail/head*/
  current->foldline = START_ENTER_FILED;
  real_tail = current->fold;
  current->next = real_tail;
  head = real_head->next;
  join_links(head, current);
  real_head = head;
  join_links(real_tail, tail);
  tail = real_tail;   /*ie file_ptr*/
  insert_file(tail, current, tail, TRUE);
  push_basepath(filename);
  current = current->next;
  restore_element(4);
  title();
}
/*}}}  */
/*{{{  void exit_fold(void)*/
void exit_fold()
{
  element *WITH;

  if (tail != real_tail) {
    pre_exit_fold();
    restore_element(current->fold_close_line);
    return;
  }
  if (real_tail->next == NULL) {
    if (file_changed)
      total_save();
    else
      message("at top level already!");
    return;
  }
  total_save();
  real_tail = tail->next;
  delete_list(head->next, tail);
  real_head = head->prec;
  WITH = real_tail;
  head_line_no = WITH->UU.U0.int1;
  WITH->UU.U0.int1 = 0;
  cur_line_no = WITH->UU.U0.int2 - head_line_no;
  WITH->UU.U0.int2 = 0;
  tail = real_tail;
  head = real_head;
  current = head->next;   /*ie file_ptr*/
  pop_basepath();
  insert_file(tail, current, tail, TRUE);
  current = pre_find_element(head_line_no);
  enter_folds_to(current);
  find_element(cur_line_no, real_tail->fold_close_line);
  title();
}
/*}}}  */
/*{{{  void remove_fold(void)*/
void remove_fold()
{
  element *new_, *p;
  int ind, f_ind;
  element *WITH;
  char STR1[MAX_FIELD_SIZE + 1];
  char STR2[MAX_FIELD_SIZE + 1];
  char STR3[256];

  if (current->foldline != START_FOLD) {
    proc_error(0);
    return;
  }
  ind = current->UU.U1.indent;
  f_ind = current->UU.U1.fold_indent;
  pre_pre_open_fold(current);
  new_ = Start_of_fold->next;
  p = new_;
  while (p != End_of_fold) {
    WITH = p;
    WITH->UU.U1.indent = ind;
    if (WITH->foldline == NOT_FOLD) {
      sprintf(STR3, "%s%s", spaces(STR1, f_ind), line_of(STR2, p));
      copy_line_to_parts(STR3, &p);
    }
    else WITH->UU.U1.fold_indent += f_ind;
    p = p->next;
  }
  if (new_ == End_of_fold) new_ = Line_after_fold;
  current = End_of_fold;
  erase_current_link();
  current = Start_of_fold;
  erase_current_link();
  current = new_;
  if (screen_start == Start_of_fold) {
    restore_element(4);
    return;
  }
  if (new_ == Line_after_fold)
    restore_or_restore_to_end();
  else
    restore_to_end(cursor_level);
}
/*}}}  */
/*{{{  void help(void)*/
void help()
{
  FILE * f;
  int y = 1;
  char helpfile[256];

  colour(1);
  ClrScr();
  strcpy(helpfile, getenv("ORIGAMIHOME"));
  if (helpfile[strlen(helpfile)-1] != FILE_SEPARATOR[0])
    strcat(helpfile, FILE_SEPARATOR);
  if (getenv("ORIGAMITERM"))
      strcat(helpfile, getenv("ORIGAMITERM"));
  else
      strcat(helpfile, getenv("TERM"));
  strcat(helpfile, ".hlp");
  if ((f = fopen(helpfile, "r")) == NULL) {
    printf("\nno helpfile found");
  }
  else {
    char line [MAX_FIELD_SIZE];

    while (fgets(line, 256, f) != NULL) {

      Gotoxy(1, y++);
      printf("%s", line);
    }
  }
  colour(2);
  Gotoxy(1, ++y);
  printf("Press any key to return");
  single_key();
  colour(1);
  ClrScr();
}
/*}}}  */
