#include <stdio.h>
#include <stdlib.h>
#ifdef __TURBOC__
#include <conio.h>
#endif
#include "stddef.h"
#include "keynames.h"

/*{{{F keynames.h*/
/*:::F keynames.h*/
/*}}}  */

/*{{{  defines*/
#define MAX_KEYS 20
#define MAX_LINE 512
#define KEY_OFFSET 256


#ifndef __TURBOC__
#  define GETKEY()      fgetc(stdin)    /* getchar() */
#  define RETURN_KEY    '\n'
#  define SCAN          scanf
#else
#  define GETKEY()      getch()
#  define RETURN_KEY    13
#  define SCAN          cscanf
#endif
/*}}}  */
/*{{{  prototypes*/
local void print_names P((void));
local void scan_params P((FILE **, int, char **));
local void scan_until P((FILE *, int));
local void read_key_file P((FILE *, int [NO_NAMES][MAX_KEYS]));
local void get_key_def P((int [MAX_KEYS]));
local void edit_keys P((int [NO_NAMES][MAX_KEYS]));
local void print_keys P((FILE *, int [NO_NAMES][MAX_KEYS]));
local void print_key_def P((FILE *, int, int [MAX_KEYS]));
/*}}}  */

/*{{{  local void print_names()*/
local void print_names()
{
        int j, i;

        for(i = 0; i < NO_NAMES;) {
                for (j = 0; j < 3 && i < NO_NAMES; j++, i++)
                        printf("%2d: %-22s", i+1, key_names[i]);
                printf("\n");
        }
}
/*}}}  */
/*{{{  local void scan_params(inp, argc, argv)*/
local void scan_params(inp, argc, argv)
FILE ** inp;
int argc;
char * argv[];
{
        if (argc == 2 && (*inp = fopen(argv[1], "r")) == NULL) {
                fprintf(stderr, "error reading keyfile '%s'\n", argv[1]);
                exit(1);
        }
        if (argc > 2) {
                fprintf(stderr, "usage: editkeys [keyfile]\n");
                exit(1);
        }
}
/*}}}  */
/*{{{  local void scan_until(f, end)*/
local void scan_until(f, end)
FILE * f;
int end;
{
        int c;

        while((c = fgetc(f)) != end && c != EOF);
}
/*}}}  */
/*{{{  local void read_key_file(f, keys)*/
local void read_key_file(f, keys)
FILE * f;
int keys[NO_NAMES][MAX_KEYS];
{
        int index;

        for (index = 0; index < NO_NAMES; index++)
                keys[index][0] = -1;
        while (fscanf(f, "%d", &index) == 1) {
                int key = 0;

                index -= KEY_OFFSET;
                scan_until(f, '[');
                do
                        fscanf(f, "%i", &(keys[index][key++]));
                while (fgetc(f) == ',' && key < MAX_KEYS);
                if (key < MAX_KEYS)
                        keys[index][key] = -1;
                scan_until(f, '\n');
        }
}
/*}}}  */
/*{{{  local void get_key_def(keys)*/
local void get_key_def(keys)
int keys[MAX_KEYS];
{
        int c, index = 0,
            first_time = 0;

        printf("\n>");
        while ((c = GETKEY()) != RETURN_KEY && c != EOF) {
                if (first_time == 0)
                    first_time++;
                else
                    printf(", ");
                printf("0x%x", keys[index++] = c);
        }
        printf("\n");
        if (index > 0 && index < MAX_KEYS)
                keys[index] = -1;
}
/*}}}  */
/*{{{  void local print_key_def(f, index, keys)*/
void local print_key_def(f, index, keys)
FILE * f;
int index;
int keys[MAX_KEYS];
{
        int key = 0;

        fprintf(f, "%d = [", index + KEY_OFFSET);
        if (keys[key] >= 0)
                fprintf(f, "0x%x", keys[key++]);
        while (keys[key] >= 0)
                fprintf(f, ", 0x%x", keys[key++]);
        fprintf(f, "]\t\t// %s\n", key_names[index]);
}
/*}}}  */
/*{{{  local void edit_keys(keys)*/
local void edit_keys(keys)
int keys[NO_NAMES][MAX_KEYS];
{
        int index;

        print_names();
        printf("\nkey (0 to stop):");
        scanf("%d", &index);
#ifndef __TURBOC__
        getchar();
#endif
        while (index != 0)
                if (index > 0 && index <= NO_NAMES) {
                        print_key_def(stdout, index-1, keys[index-1]);
                        get_key_def(keys[index-1]);
                        print_names();
                        printf("\nkey (0 to stop):");
                        scanf("%d", &index);
#ifndef __TURBOC__
                        getchar();
#endif
                }
}
/*}}}  */
/*{{{  local void print_keys(f, keys)*/
local void print_keys(f, keys)
FILE * f;
int keys[NO_NAMES][MAX_KEYS];
{
        int i;

        for (i = 0; i < NO_NAMES; i++)
                if (keys[i][0] >= 0)
                        print_key_def(f, i, keys[i]);
}
/*}}}  */

/*{{{  int main(argc, argv)*/
int main(argc, argv)
int argc;
char * argv[];
{
        FILE * keyf = NULL, * inp;
        int keys[NO_NAMES][MAX_KEYS];
        char fname[MAX_LINE];

        scan_params(&inp, argc, argv);
        if (inp != NULL)
                read_key_file(inp, keys);
        else {
                int i;

                for (i = 0; i < NO_NAMES; i++)
                        keys[i][0] = -1;
        }
        edit_keys(keys);
        *fname = ' ';           /* *fname != '\0' */
        getchar();
        while (*fname && keyf == NULL) {
                printf("\noutput file (return for none): ");
                gets(fname);
                if (*fname && (keyf = fopen(fname, "w")) == NULL)
                        printf("\nerror opening output file");
        }
        if (*fname)
                print_keys(keyf, keys);
        printf("\n");
        exit(0);

        return 0;
}
/*}}}  */

