
/****/
/*	version: $Id: read_menu.c,v 5.47 1994/10/05 00:59:22 hitman Exp $ */
/* 	purpose: Read the binary menu file and print it to the screen */
/*	updates: All updates are handled by RCS */
/* 	Author: The Hitman 1994	*/
/****/

#include <stdio.h>
#include <stdlib.h>
#include "bbs_director.h"
#include "menu_info.h"

int read_menu (menu_struct * menu_ptr, const char *menu_filename);

int
read_menu (menu_struct * menu_ptr, const char *menu_filename)
{
  FILE *outputfile;		/* I am the binary file for the BBS */
  char filename[MAXLENGTH];	/* I am the binary filename */
  long spot;			/* I keep track of the file position */
  int n,			/* I simply get the results of the fread */
    line;			/* I keep track of what line we are on */

  menu_struct menu[MAXLINES];	/* I am the variable the program uses */
  menu_struct menu_one;		/* I am the variable from the file */

  /** External functions **/
  extern char *menu_data_filename (const char *);

#if DEBUG
  fprintf (stderr, "** %s: menu_filename = %s **\n", __FILE__, menu_filename);
#endif

  /** Get the argument and give it to a variable, point to it */
  /*	then add the rest of the items needed. **/
  strcpy (filename, menu_data_filename (menu_filename));	/* Set down the filename */

  /** This file is a binary file, that will be written from the */
  /*	beginning each time.  No appending **/
#if DEBUG
  fprintf (stderr, "** %s: filename = %s, menu_filename = %s **\n", __FILE__, filename, menu_filename);
#endif
  if ((outputfile = fopen (filename, "r+b")) == NULL)
    {
      /** one day put in some error handleing. **/
      fprintf (stderr, "%s: %s: Need read permission\n", "FIX THIS", filename);
      exit (EXIT_FAILURE);
    }				/* if */

  /** Make sure that both files are at the beginning **/
  fseek (outputfile, 0, SEEK_SET);

  /** Get some information out of the file **/
  line = 0;
  do
    {
#if DEBUG
      fprintf (stderr, "** %s: read the data from the file **\n", __FILE__);
#endif
      spot = ftell (outputfile);
      /** Read one record and record it. **/
      n = fread (&menu_one, sizeof (menu_struct), 1, outputfile);
#if DEBUG
      fprintf (stderr, "** %s: just read from the file **\n", __FILE__);
      fprintf (stderr, "** %s: sizeof (menu_struct) = %d **\n", __FILE__, sizeof (menu_struct));
#endif
      /** Assign the value from the file to the menu **/
      menu[line] = menu_one;
#if DEBUG
      fprintf (stderr, "** %s: line = %d **\n", __FILE__, line);
      fprintf (stderr, "** %s: menu[%d].index = %c **\n", __FILE__, line, menu[line].index);
#endif

      line++;			/* Increment to the next line */
    }
  while (n == 1);
#if DEBUG
  fprintf (stderr, "** %s: print back the variables **\n", __FILE__);
  /** I am just useing the variable n here because I don't want */
  /*	to introduce anymore variables for something more than a */
  /*	debuging statement **/
  for (n = 0; n < MAXLINES; n++)
    {
      fprintf (stderr, "** %s: n = %d, MAXLINES = %d **\n", __FILE__, n, MAXLINES);
      fprintf (stderr, "** %s: index = %c, keyword = %s, description = %s,\n\tinformation = %s, other = %s **\n", \
	       __FILE__, menu[n].index, menu[n].keyword, menu[n].description, menu[n].information, menu[n].other);
    }
  fprintf (stderr, "** %s: I have made it past the display of menu variable **\n", __FILE__);
#endif

  /** Point to the menu information **/
  menu_ptr = menu;
#if DEBUG
  fprintf (stderr, "** %s: Just pointed to the menu information **\n", __FILE__);
  fprintf (stderr, "** %s: menu_ptr[0].index = %c **\n", __FILE__, menu_ptr[0].index);
#endif
  return (0);
}				/* read_menu */
