/****/
/*	version: $Id: is_bbs_running.c,v 5.47 1994/10/05 00:59:22 hitman Exp $ */
/* 	purpose: checks to see if bbs is running already, only one bbs */
/*		session per user. */
/*	updates: All updates are handled by RCS */
/* 	Author: The Hitman 1994	*/
/****/

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include "version.h"

#ifndef __MSDOS__
#	include <strings.h>
#	include "bbs_director.h"
#else /* not_MSDOS */
#	include <string.h>
#	include "..\src\bbs_dire.h"
#endif /* MSDOS */

/**	Check if BBS is running already. **/
int
is_bbs_running (void)
{
  char *value = NULL;

  /* clean up warnings about implicit declarations. (putenv) this is in the stdlib.h header but still comes up implicitly defined */
extern int putenv (const char *);

  /* look in the enviroment and see if the bbs switch has been set to yes or no */
#if DEBUG
  fprintf (stderr, "** %s: Check the environment for the variable BBS **\n", __FILE__);
#endif
  value = getenv ("BBS");

  /* Check the value for a null */
  if (value == NULL)
    {
#if DEBUG
      fprintf (stderr, "** %s: The variable BBS is not set yet, but that is ok **\n", __FILE__);
#endif
    }
  else
    /* if_value_null */
    {
      /* Go ahead and check the variable because it exists */

#if DEBUG
      fprintf (stderr, "** %s: Just picked up the BBS variable out of the environment. **\n", __FILE__);
#endif
#ifdef OSF1
      /* if (! strcmp ((const char *)"yes", (const char *)value)) */
      /** This is a nasty fix for the above problem on the OSF1 */
      /*	I just want to get something started. If this is not in */
      /*	here the null pointer causes a segmentation fault (OSF1, mips) **/
      /* Jul 10 1994: Try this now I check for a null value */
      /* for bbs and this will allow the program to continue if the BBS variable */
      /* doesn't exist */
      if (0)
#else /* OSF1 */
      if (!(strncmp ("yes", value, strlen ("yes"))))
#endif /* Any_Other_System: Linux, HP_UX */
	{
#if DEBUG
	  fprintf (stderr, "** %s: The user already has a BBS shell running. **\n", __FILE__);
#endif /* DEBUG */
	  fprintf (stdout, "Type 'exit' to return to the BBS...\n");
	  exit (EXIT_SUCCESS);
	}			/* if */
    }				/* else_value_null */

#if DEBUG
  fprintf (stderr, "** %s: The BBS is not already running. **\n", __FILE__);
#endif
  /* Set the enviroment variables so that the system knows */
  /* 	that it has a copy of the bbs running. */
  putenv ("BBS=yes");

  /* Display the system name and type etc... */
  system ("uname -a");

  /* done, please return good */
  return (0);
}				/* is_bbs_running */
