/****/
/*
version:	$Id: dis_screen.c,v 5.47 1994/10/05 00:59:22 hitman Exp $
purpose:	Displays the opening screen for welcomeing the user.
updates:	All updates are handled by RCS
Author:	The Hitman 1994
*/
/****/

#include <stdio.h>
#include <stdlib.h>
#include <strings.h>
#include <time.h>

#ifndef __MSDOS__
#	include <strings.h>
#	include "bbs_director.h"
#else /* not_MSDOS */
#	include <string.h>
#	include "..\src\bbs_dire.h"
#endif /* MSDOS */
#include "version.h"

/**	Display this seconds welcome screen.  This will be used again so it is */
/*	set up in a function. **/
int
display_screen (void)
{

  FILE *welcome;

#ifndef ULTRIX
  char filename[50] =
  {0};
#else /* ULTRIX */
  char filename[50];
#endif /* ULTRIX */
  int ch = 0;


  /** clean up warnings about implicit declarations **/
  extern int my_random (void);


#if DEBUG
  fprintf (stderr, "** %s: **\n", __FILE__);

#endif /* DEBUG */
  /** produce a filename for a welcome */
  /*	Put the directory name and all in there */
  strcpy (filename, WELCOMES);

  strcat (filename, "ad.");


  /** This is my fix for the random number, could be better **/
  switch (my_random ())

    {

    case 0:

      strcat (filename, "0");

      break;

    case 1:

      strcat (filename, "1");

      break;

    case 2:

      strcat (filename, "2");

      break;

    case 3:

      strcat (filename, "3");

      break;

    case 4:

      strcat (filename, "4");

      break;

    case 5:

      strcat (filename, "5");

      break;

    case 6:

      strcat (filename, "6");

      break;

    case 7:

      strcat (filename, "7");

      break;

    case 8:

      strcat (filename, "8");

      break;

    case 9:

      strcat (filename, "9");

      break;

    }

  /* Due to the limitations of the ''8 dot 3'' file nameing convention under MSDOS I can't add the following extention. */
#ifndef __MSDOS__
  /* add the last part */
  strcat (filename, ".screen");
#endif /* not_MSDOS */

#if DEBUG
  fprintf (stderr, "** %s: filename = %s **\n", __FILE__, filename);
#endif /* DEBUG */

  /** check if file exists and open it for reading as a binary file */
  /*	because some files will contain ANSI graphics and that is */
  /*	considered binary (the ESC codes) to most systems **/
  if ((welcome = fopen (filename, "rb")) == NULL)
    {
      fprintf (stderr, "%s(%d): Error opening: %s\n", __FILE__, __LINE__, filename);
      exit (EXIT_FAILURE);
    }


  /** display the file one character at a time on the stdout **/
  ch = getc (welcome);
  while (ch != EOF)
    {

      /** this loop leaves room for hotkeys, use the ioctrl trick */
      /*	to allow input during output. **/
      putchar (ch);

      ch = getc (welcome);

    }

  fclose (welcome);

#if DEBUG
  fprintf (stderr, "** %s: Done printing welcome. **\n", __FILE__);

#endif /*  DEBUG */

  return (EXIT_SUCCESS);
}				/* display_screen */
