/*****************************************************************************/
/*									     */
/*									     */
/*	X patience - patx11.h						     */
/*	contains X-relevant stuff					     */
/*									     */
/*	is included in some source files of xpat.			     */
/*	by Heiko Eissfeldt and Michael Bischoff				     */
/*									     */
/*	24-Feb-1993: First release (0.1)				     */
/*									     */
/*									     */
/*****************************************************************************/

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>


#define	TABLE_BW	2

#define	MESSAGE_X	10


Display	*dpy;
int	screen;
Window	table;
Window	message_win;
XFontStruct *message_font;


unsigned long	blackpixel;
unsigned long	whitepixel;
unsigned long	borderpixel;


/* old statics from gfx.c */
int	message_y;
GC	textgc;

GC	redgc;
GC	blackgc;
GC	whitegc;


extern struct confirm {
    enum { NONE, QUIT_GAME, ANOTHER_GAME, RESTART_GAME } request;
    enum { UNDEFINED, YES, NO } result;
    int x, y;
    XSize_t w, h;
    Window win;
} confirm;

Window finished_win;
#define FINISHED_W	100
#define FINISHED_H	 50

extern struct buttons {
    int num;
    int rx;			/* radius of round corner, x */
    int ry;			/* radius of round corner, y */
    XSize_t bx;			/* border size, x */
    XSize_t by;			/* border size, y */
    XFontStruct *font;
    int fontheight;		/* ascend + descend */
    GC gc;
    struct singlebutton {
	int x;
	int y;
        XSize_t w;
        XSize_t h;
        const char *text;
        void (*left)(void);
        void (*middle)(void);
        void (*right)(void);
    } b[MAXBUTTONS];
} button;

extern struct singlebutton confirmbuttons[3];

#define B_ROUND_W	(button.rx)
#define B_ROUND_H	(button.ry)


void handle_expose_event(XExposeEvent *);
int arrange_buttons(struct singlebutton *, int *, int *, XSize_t, long *);
void redraw_buttons(int, int, int, int, Window, int, struct singlebutton *);
void do_music(XEvent *);
void write_pixmap(const char *, Pixmap, Pixmap);
int read_pixmap(const char *, Pixmap *);
