  global EvaluationWindows
  set n [Unique]
  set win .evaluation$n
  set EvaluationWindows [linsert $EvaluationWindows 0 $win]

  LinkWindow $head.evaluation $win
  LinkWindow $win.head $head

# catch "destroy $win"
  toplevel $win -screen $display

  SetHelp $win Window

  bind $win <Visibility> {EvaluationVisible %W [string compare %s FullyObscured]}
  bind $win <Map> {EvaluationVisible %W 1}
  bind $win <Unmap> {EvaluationVisible %W 0}

  wm title $win {SimCity Evaluation}
  wm iconname $win {SimCity Evaluation}
  wm group $win $head
  wm geometry $win 480x240+5-5
# wm withdraw $win
  wm maxsize $win 1152 900
  wm minsize $win 400 200
  wm protocol $win WM_DELETE_WINDOW\
     "DeleteWindow evaluation EvaluationWindows $win"


  frame $win.leftframe\
    -borderwidth 2\
    -relief raised

  label $win.leftframe.title\
    -font [Font $win Big]\
    -padx 0\
    -relief flat\
    -text {Public Opinion}\
    -width 5

  label $win.leftframe.isthe\
    -font [Font $win Large]\
    -text {Is the mayor doing a good job?}

  frame $win.leftframe.goodjobframe\
    -borderwidth 2

  message $win.leftframe.goodjobframe.yesno\
    -aspect 1500\
    -justify right\
    -padx 5\
    -pady 2\
    -font [Font $win Medium]\
    -text {YES
NO}

  message $win.leftframe.goodjobframe.percents\
    -aspect 1500\
    -justify left\
    -padx 5\
    -pady 2\
    -font [Font $win Medium]\
    -text {100%
0%}
  LinkWindow $win.goodjob $win.leftframe.goodjobframe.percents

  pack append $win.leftframe.goodjobframe\
    $win.leftframe.goodjobframe.percents	{right frame w expand} \
    $win.leftframe.goodjobframe.yesno		{right frame e expand} 

  label $win.leftframe.whatare\
    -font [Font $win Large]\
    -text {What are the worst problems?}

  frame $win.leftframe.worstproblems\
    -borderwidth 2

  message $win.leftframe.worstproblems.problemnames\
    -aspect 1500\
    -justify right\
    -padx 5\
    -pady 2\
    -font [Font $win Medium]\
    -text {        



}
  LinkWindow $win.problemnames $win.leftframe.worstproblems.problemnames

  message $win.leftframe.worstproblems.problempercents\
    -aspect 1500\
    -justify left\
    -padx 5\
    -pady 2\
    -font [Font $win Medium]\
    -text {        



}
  LinkWindow $win.problempercents $win.leftframe.worstproblems.problempercents

  pack append $win.leftframe.worstproblems\
    $win.leftframe.worstproblems.problempercents {right frame w expand} \
    $win.leftframe.worstproblems.problemnames    {right frame e expand}

  pack append $win.leftframe\
    $win.leftframe.title		{top frame center fillx expand} \
    $win.leftframe.isthe		{top frame center fillx expand} \
    $win.leftframe.goodjobframe		{top frame center fillx expand} \
    $win.leftframe.whatare		{top frame center fillx expand} \
    $win.leftframe.worstproblems	{top frame center fillx expand} 

  frame $win.rightframe\
    -borderwidth 2\
    -relief raised

  label $win.rightframe.title\
    -font [Font $win Big]\
    -padx 0\
    -relief flat\
    -text {Statistics}\
    -width 5

  frame $win.rightframe.statsframe\
    -borderwidth 2

  message $win.rightframe.statsframe.statlabels\
    -aspect 1500\
    -justify right\
    -padx 5\
    -pady 2\
    -font [Font $win Medium]\
    -text {Population:
Net Migration:
(last year) 
Assessed Value:
Category:
Game Level:}

  message $win.rightframe.statsframe.stats\
    -aspect 1500\
    -justify left\
    -padx 5\
    -pady 2\
    -font [Font $win Medium]\
    -text {                




}
  LinkWindow $win.stats $win.rightframe.statsframe.stats

  pack append $win.rightframe.statsframe\
    $win.rightframe.statsframe.statlabels	{left frame e expand} \
    $win.rightframe.statsframe.stats		{right frame w expand}

  message $win.rightframe.cityscore\
    -aspect 1500\
    -justify center\
    -padx 5\
    -pady 2\
    -font [Font $win Medium]\
    -text {Overall City Score
(0 - 1000)}

  frame $win.rightframe.scoreframe\
    -borderwidth 2

  message $win.rightframe.scoreframe.scorelabels\
    -aspect 1500\
    -justify right\
    -padx 5\
    -pady 2\
    -font [Font $win Medium]\
    -text {Current Score:
Annual Change:}

  message $win.rightframe.scoreframe.scores\
    -aspect 1500\
    -justify left\
    -padx 5\
    -pady 2\
    -font [Font $win Medium]\
    -text {        

}
  LinkWindow $win.score $win.rightframe.scoreframe.scores

  pack append $win.rightframe.scoreframe\
    $win.rightframe.scoreframe.scorelabels	{left frame e expand} \
    $win.rightframe.scoreframe.scores		{right frame w expand}

  pack append $win.rightframe\
    $win.rightframe.title	{top frame center fillx expand} \
    $win.rightframe.statsframe	{top frame center fillx expand} \
    $win.rightframe.cityscore	{top frame center fillx expand} \
    $win.rightframe.scoreframe	{top frame center fillx expand} 

  frame $win.bottomframe\
    -borderwidth 0

  button $win.bottomframe.button\
    -font [Font $win Large]\
    -text {Dismiss}\
    -command "wm withdraw $win"

  pack append $win.bottomframe\
    $win.bottomframe.button   {top frame center expand fillx}

  pack append $win\
    $win.bottomframe	{bottom frame center fillx}\
    $win.leftframe	{left frame center expand fill} \
    $win.rightframe	{right frame center expand fill}

  sim UpdateEvaluations

  update idletasks
  return $win
