/*
**                      Softwarepraktikum iMaze
**                              1993/94
**                Joerg Czeranski    Hans-Ulrich Kiel
**
** Datei: protokoll.h
**
** Kommentar:
**  Definition des Protokollformats
*/


static char sccsid_protokoll[] = "@(#)protokoll.h	1.11 03 Oct 1994";


/* Werte, die das ignoriert-Bit annehmen kann */
#define PAKET_NICHT_IGNORIERT 0
#define PAKET_IGNORIERT       1

/* das oberste Bit ist gesetzt, falls das letzte Paket ignoriert wurde */
#define PROL_PAKET_IGNORIERT(kennung) (((kennung) & 128) != 0)

/* die anderen Bits enthalten den Typ des Paketes selbst */
#define PROL_PAKET_TYP(kennung) ((kennung) & 127)

#define PROL_PAKET_KENNUNG(ignoriert, typ) ((ignoriert) << 7 | (typ))


/* Prolog-Pakete in beide Richtungen */
#define PT_LEER          0
#define PT_ABBRUCH       1
#define PT_PROGRAMM_NAME 2


/* Prolog-Pakete in Richtung Client -> Server */
#define PT_BEREIT_FUER_SPIEL 64
#define PT_WILL_LABYRINTH    65
#define PT_SPIELER_NAME      66
#define PT_SPIELER_SPRUCH    67


/* Prolog-Pakete in Richtung Server -> Client */
#define PT_SPIEL_BEGINNT 96
#define PT_LABYRINTH     97


/* bei Blockkennungen 0-127 ist die Datenlaenge 0, bei 128-255 variabel */
#define DATENLAENGE_VARIABEL(block_kennung) (((block_kennung) & 128) != 0)


/* Spiel-Pakete in Richtung Client -> Server */

/* Datenlaenge 0 */
#define BK_ENDE_SIGNAL 0

/* Datenlaenge variabel */
#define BK_SIGNALE 128 /* siehe signale.h */


/* Spiel-Pakete in Richtung Server -> Client */

/* Datenlaenge 0 */
#define BK_ENDE_DURCH_SERVER 0
#define BK_ENDE_DURCH_CLIENT 1

/* Datenlaenge variabel */
#define BK_SPIELER_POS        128
#define BK_GEGNER_POS         129
#define BK_SPIELER_SCHUSS_POS 130
#define BK_GEGNER_SCHUSS_POS  131
#define BK_ABGESCHOSSEN_DURCH 132
#define BK_EREIGNISSE         133 /* siehe ereignisse.h */
#define BK_ALTE_EREIGNISSE    134 /* noch nicht bestaetigte Ereignisse */
#define BK_PUNKTESTAND        135
