#ifndef UTILS_H
# define UTILS_H
# include <stdio.h>
# include <X11/Intrinsic.h>

extern void      InitUtils(Widget TopLevel);
extern FILE     *OpenWrite(const char *FileName, Boolean Overwrite);
extern XtPointer SaveWrite(const char *FileName, Boolean Overwrite,
                           Widget Bell, Widget Raize, const char *ErrorType,
                           void (*WriteFun(FILE *fp, XtPointer Closure)),
                           XtPointer Closure);
extern XtPointer SaveTextFun(FILE *fp, XtPointer Closure);
extern void      ChangeSgfFilename(Widget w,
                                   XtPointer clientdata, XtPointer calldata);
extern void      ChangePsFilename(Widget w,
                                  XtPointer clientdata, XtPointer calldata);
extern void      ChangeKibitzFilename(Widget w, XtPointer clientdata,
                                      XtPointer calldata);
extern void      IfBell(Widget w);
extern void      IfRaise(Widget w, Widget root);
extern void      SetWidgetTitles(Widget w, char *(*fun)(const char *Pattern,
                                                        XtPointer Closure),
                                 XtPointer closure);
extern void      SetWidgetProperty(Widget w,
				   const char *Name, const char *Class,
				   char *(*fun)(const char *Pattern,
						XtPointer Closure),
				   XtPointer Closure);
# ifndef   HAVE_NO_STDARG_H
extern char     *StringToFilename(const char *Filename, ...);
extern Widget    AskString(Widget toplevel, void (*Callback)(XtPointer),
                           XtPointer Closure, const char *title, ...);
extern Widget    ChangeFilename(Widget toplevel, const char *Type,
                                const char *Title, char **Filename, ...);
extern Widget    PopMessage(const char *Title, const char *Format, ...);
# else  /* HAVE_NO_STDARG_H */
extern char     *StringToFilename();
extern Widget    AskString();
extern Widget    ChangeFilename();
extern Widget    PopMessage();
# endif /* HAVE_NO_STDARG_H */
#endif /* UTILS_H */
