#include <string.h>
#include <stdio.h>
#include <ctype.h>

#include <X11/StringDefs.h>
#include <X11/IntrinsicP.h>
#include <X11/CoreP.h>
#include <X11/Xatom.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Toggle.h>
#include <X11/Xmu/CharSet.h>

#include "myxlib.h"
#include "mymalloc.h"
#include "except.h"
#include "widgettree.h"
#include "YShell.h"
#include "Tree.h"

#ifndef XtREdgeType
# define XtREdgeType    "EdgeType"
#endif /* XtREdgeType */

#define CHANGE    "change"
#define PRTPTR    "#%p"        /* Nice outputformat for a pointer          */
#define NULLNAME  "(null)"     /* How to print the null pointer            */
#define FUNPTR(x) x            /* Convert a functionpointer for printing   */

#define ClassName(x) (((CoreClassPart *)(x))->class_name)

void ShowTree(Widget w);

static Exception NoCallback = { "No calback called" };

extern XtCallbackList _XtGetCallbackList();

int FindCallback(Widget w, String CallbackName, XtCallbackProc callback,
                 XtPointer *client_data)
{
    XtCallbackList        calls;
    XtCallbackProc        fun;
    InternalCallbackList *callbacks;

    callbacks = FetchInternalList(w, CallbackName);
    if (callbacks) {
        for (calls = _XtGetCallbackList(callbacks);
             (fun = calls->callback) != 0; calls++)
                if (fun == callback) {
                    if (client_data) *client_data = calls->closure;
                    return 1;
                }
    } else Raise2(NoCallback, CallbackName, "exists");
    return 0;
}

#ifdef BLUB
#include <stdlib.h>
#include <errno.h>

#include <X11/ConstrainP.h>
#include <X11/Xaw/Toggle.h>
#include <X11/Xmu/Error.h>
#include <X11/Xmu/CharSet.h>
#include <X11/Xmu/Converters.h>

typedef struct _XtTypedArg {
    String      name;
    String      type;
    XtArgVal    value;
    int         size;
} XtTypedArg, *XtTypedArgList;

#include "reslang.h"

/* #define META   "Mod1"          The modifier you like as META or ALT key */
#define META      "Meta"       /* The modifier you like as META or ALT key */
#define INFO      "info"


#define SHELL    1

#ifdef HAVE_NO_STRERROR_PROTO
extern char *strerror(int err);
#endif /* HAVE_NO_STRERROR_PROTO */

/*****************************************************************************/

static void WMProtocol(Widget w, XEvent *event, String *str, Cardinal *n);
static void Info(), Change(), Beep(), WidgetAction(), WidgetTree();
static void Popup(), Popdown(), Map(), Unmap(), PopToggle(), Destroy(), Echo();
static void Manage(), Unmanage(), PopupMenu();
static void Exit(), Quit(), SetValues(), CreateWitchet(), System(), SetFocus();
static void Mallocstats();

#endif /* BLUB */
extern void CallFreeTemplate(Widget w,
                             XtPointer clientdata, XtPointer calldata);
/*************/
/* Callbacks */
/*************/

void CallToggleOn(Widget w, XtPointer clientdata, XtPointer calldata)
{
    XtVaSetValues((Widget) clientdata, XtNstate, (XtArgVal) True, NULL);
}
    
void CallToggleOff(Widget w, XtPointer clientdata, XtPointer calldata)
{
    XtVaSetValues((Widget) clientdata, XtNstate, (XtArgVal) False, NULL);
}

void CallToggleUpDown(Widget w, XtPointer clientdata, XtPointer calldata)
{
    Boolean state;

    XtVaGetValues(w, XtNstate, (XtArgVal) &state, NULL);
    if (state == True) XtPopup(  (Widget) clientdata, XtGrabNone);
    else               XtPopdown((Widget) clientdata);
}

void CallReadToggle(Widget w, XtPointer clientdata, XtPointer calldata)
{
    XtVaGetValues(w, XtNstate, (XtArgVal) clientdata, NULL);
}

void CallPopup(Widget w, XtPointer clientdata, XtPointer calldata)
{
    XtPopup((Widget) clientdata, XtGrabNone);
}

void CallPopdown(Widget w, XtPointer clientdata, XtPointer calldata)
{
    XtPopdown((Widget) clientdata);
}

void CallDestroyWidgetReference(Widget w, XtPointer clientdata,
                                XtPointer calldata)
{
    *(Widget *) clientdata = 0;
}

static void CallNoDestroyWidget(Widget w,
                                XtPointer clientdata, XtPointer calldata);

void CallDestroy(Widget w, XtPointer clientdata, XtPointer calldata)
{
    XtUnrealizeWidget((Widget) clientdata); 
    XtDestroyWidget((Widget) clientdata);
}

static void CallDestroyWidget(Widget w, XtPointer clientdata,
                              XtPointer calldata)
{
    XtRemoveCallback((Widget) clientdata, XtNdestroyCallback,
                     CallNoDestroyWidget, (XtPointer) w);
    XtUnrealizeWidget((Widget) clientdata); 
    XtDestroyWidget((Widget) clientdata);
}

static void CallNoDestroyWidget(Widget w,
                                XtPointer clientdata, XtPointer calldata)
{
    XtRemoveCallback((Widget) clientdata, XtNdestroyCallback,
                     CallDestroyWidget, (XtPointer) w);
}

/* Widget w1 should be removed if w2 goes */
void MyDependsOn(Widget w1, Widget w2)
{
    XtAddCallback(w2, XtNdestroyCallback, CallDestroyWidget,   (XtPointer) w1);
    XtAddCallback(w1, XtNdestroyCallback, CallNoDestroyWidget, (XtPointer) w2);
}

void CallFree(Widget w, XtPointer clientdata, XtPointer calldata)
{
    myfree(clientdata);
}

void CallFakeChildDestroy(Widget w, XtPointer clientdata, XtPointer calldata)
{
    XtWidgetProc delete_child;
    Widget Parent, old;

    Parent = (Widget) clientdata;
    if (Parent->core.being_destroyed != False) {
        delete_child = ((CompositeWidgetClass) Parent->core.widget_class)->
            composite_class.delete_child;
        if (delete_child) {
            old = w->core.parent;
            w->core.parent = Parent;
            delete_child(w);
            w->core.parent = old;
        } else WidgetWarning(Parent, "has nullProc as deleteChild");
    }
}

void CallPrint(Widget w, XtPointer clientdata, XtPointer calldata)
{
    fputs((char *) clientdata, stdout);
}

void CallCleanWidget(Widget w, XtPointer clientdata, XtPointer calldata)
{
    *(Widget *) clientdata = 0;
}

/*****************************************************************************/
/* widget with settable help                                                 */
/*****************************************************************************/

#define XtNtext "text"
#define XtCText "Text"

typedef struct {
    String Text;
} HelpData, *HelpDataPtr;

#define offset(field) XtOffset(HelpDataPtr, field)

static XtResource resources[] = {
    { XtNtext, XtCText, XtRString, sizeof(String),
      offset(Text), XtRString, NULL }, 
};
#undef offset

static void ShowHelp(Widget w, const char *data)
{
    /* We could add some textformatting stuff here -Ton */
    XtVaSetValues(w,
                  XtNlabel, (XtArgVal) data,
                  NULL);
}

Widget HelpOnWidget(Widget w, const char *Name)
{
    Widget    topwidget, Root, Text;
    XtPointer data;
    HelpData  helpdata;

    topwidget = w;
    while ((Root = XtParent(topwidget)) != NULL) topwidget = Root;
    if (FindCallback(topwidget, XtNdestroyCallback, CallFakeChildDestroy,
                     &data)) topwidget = (Widget) data;

    XtGetSubresources(topwidget, (XtPointer) &helpdata, (String) Name,
                      "HelpData", resources, XtNumber(resources), NULL, 0);
    if (helpdata.Text) {
        if ((Root = XtNameToWidget(topwidget, "*widgetHelp")) != 0&&
            (Text = XtNameToWidget(Root,      "*text"))       != 0) {
            ShowHelp(Text, helpdata.Text);
            return Root;
        } else WidgetWarning(w, "help(%.80s) failed, no subwidget called text",
                             Name);
    } else WidgetWarning(w, "help(%.80s) was not found", Name);
    return 0;
}

/*****************************************************************************/
/* Interactive widget research                                               */
/* WM_PROTOCOL must be initialized !                                         */
/* todo: autmatic delete action on root                                      */
/*****************************************************************************/

static void CallSetValues(Widget w, XtPointer clientdata, XtPointer calldata)
{
    String Name, Value;
    Widget *PassWidget;

    PassWidget = (Widget *) clientdata;
    Name = Value = "Fail";
    if (PassWidget[1]) XtVaGetValues(PassWidget[1], XtNstring, &Name , NULL);
    if (PassWidget[2]) XtVaGetValues(PassWidget[2], XtNstring, &Value, NULL);
    XtVaSetValues(PassWidget[0],
                  XtVaTypedArg, Name, XtRString, Value, strlen(Value)+1,
                  NULL);
}

void ChangeWidget(Widget widget)
{
    Widget    topwidget, Root, Name, Value, Ok, Cancel, *PassWidget;
    Window    Group;
    XtPointer Work;
    char   title[80], icon[80];

    topwidget = widget;
    while ((Root = XtParent(topwidget)) != 0) topwidget = Root;
    XtVaGetValues(topwidget, XtNwindowGroup, (XtArgVal) &Group, NULL);
    if (FindCallback(topwidget, XtNdestroyCallback, CallFakeChildDestroy,
                     &Work)) topwidget = (Widget) Work;

    sprintf(title, "Change widget %s", XtName(widget));
    strcpy(icon, title);
    PassWidget = mynews(Widget, 3);

    Root = MyVaCreateManagedWidget("widgetChange", topwidget,
                                   XtNtitle,       (XtArgVal) title,
                                   XtNiconName,    (XtArgVal) icon,
                                   XtNwindowGroup, (XtArgVal) Group,
                                   XtNeditType,    (XtArgVal) XawtextEdit,
                                   NULL);

    MyDependsOn(Root, widget);
    Name   = XtNameToWidget(Root, "*name");
    Value  = XtNameToWidget(Root, "*value");

    PassWidget[0] = widget;
    PassWidget[1] = Name;
    PassWidget[2] = Value;

    Ok = XtNameToWidget(Root, "*ok");
    if (Ok) {
        XtAddCallback(Ok, XtNcallback, CallSetValues, 
                      (XtPointer) PassWidget);
        XtAddCallback(Ok, XtNdestroyCallback, CallFree,
                      (XtPointer) PassWidget);
    } else myfree(PassWidget);
    Cancel = XtNameToWidget(Root, "*cancel");
    if (Cancel)
        XtAddCallback(Cancel, XtNcallback, CallDestroy, (XtPointer) Root);

    MyRealizeWidget(Root);
}

static void CallChangeWidget(Widget w,
                             XtPointer clientdata, XtPointer calldata)
{
    ChangeWidget((Widget) clientdata);
}

static void CallWidgetAction(Widget w, XtPointer clientdata,
                                       XtPointer calldata)
{
    char  *Calldata;
    Widget Clientdata;
    
    Clientdata = (Widget) clientdata;
    Calldata   = (char *) calldata;
    if (Calldata) {
        if (XmuCompareISOLatin1(Calldata, CHANGE) == 0)
            ChangeWidget(Clientdata);
        else InfoOfWidget(Clientdata);
    } else InfoOfWidget(Clientdata);
}

static void AddTree(Widget Tree, Widget Me, Widget Parent)
{
    Cardinal i, n;
    Widget   Brother, *Children;

    /* Hey, why isn't this an mycreate (also causes include <Command> ? -Ton */
    Brother = XtVaCreateManagedWidget("treeEntry", commandWidgetClass, Tree,
                                      XtNtreeParent, (XtArgVal) Parent,
                                      XtNlabel,      (XtArgVal) XtName(Me),
                                      NULL);
    MyDependsOn(Brother, Me);
    XtAddCallback(Brother, XtNcallback, CallWidgetAction, (XtPointer) Me);
    n        = 0;
    XtVaGetValues(Me, XtNchildren,    (XtArgVal) &Children,
                      XtNnumChildren, (XtArgVal) &n, NULL);
    for (i=0; i<n; i++)
        AddTree(Tree, Children[i], Brother);

    if (XtIsSubclass(Me, textWidgetClass) != False) {
        Widget Source, Sink;

        XtVaGetValues(Me, XtNtextSource, &Source, XtNtextSink, &Sink, NULL);
        if (Source) AddTree(Tree, Source, Brother);
        if (Sink)   AddTree(Tree, Sink,   Brother);
    }
}

static void CallInfoChildren(Widget w,
                             XtPointer clientdata, XtPointer calldata)
{
    ShowTree((Widget) clientdata);
}

static void CallInfoPopups(Widget w,
                           XtPointer clientdata, XtPointer calldata)
{
    Widget     Parent;
    WidgetList Popups;
    int        i;

    Parent = (Widget) clientdata;
    Popups = Parent->core.popup_list;
    for (i=Parent->core.num_popups; i>0; i--, Popups++)
        ShowTree(*Popups);
}

void ShowTree(Widget w)
{
    char   title[80], icon[80];
    Widget topwidget, Root, Port, quit, Tree, Collect;
    Window Group;
    Dimension CollectWidth, CollectHeight, PortWidth, PortHeight;
    Dimension TreeWidth, TreeHeight;
    XtPointer Work;

    topwidget = w;
    while ((Root = XtParent(topwidget)) != 0) topwidget = Root;
    XtVaGetValues(topwidget, XtNwindowGroup, (XtArgVal) &Group, NULL);
    if (FindCallback(topwidget, XtNdestroyCallback, CallFakeChildDestroy,
                     &Work)) topwidget = (Widget) Work;

    sprintf(title, "Widget tree of %s", XtName(w));
    strcpy(icon, title);

    Root = MyVaCreateManagedWidget("widgetTree", topwidget,
                                   XtNtitle,       (XtArgVal) title,
                                   XtNiconName,    (XtArgVal) icon,
                                   XtNwindowGroup, (XtArgVal) Group,
                                   NULL);

    Collect = XtNameToWidget(Root, "*collect");
    quit    = XtNameToWidget(Root, "*restreeQuit");
    Tree    = XtNameToWidget(Root, "*tree");
    Port    = XtNameToWidget(Root, "*viewport");
    AddTree(Tree, w, NULL);
    XawTreeForceLayout(Tree);

    XtAddCallback(quit, XtNcallback, CallDestroy, (XtPointer) Root);
    XtVaGetValues(Collect, XtNwidth,  (XtArgVal) &CollectWidth,
                           XtNheight, (XtArgVal) &CollectHeight, NULL);
    XtVaGetValues(Port,    XtNwidth,  (XtArgVal) &PortWidth,
                           XtNheight, (XtArgVal) &PortHeight, NULL);
    XtVaGetValues(Tree,    XtNwidth,  (XtArgVal) &TreeWidth,
                           XtNheight, (XtArgVal) &TreeHeight, NULL);
    XtRealizeWidget(Root);
    XtVaSetValues(Collect, 
                  XtNwidth,  (XtArgVal) (CollectWidth +TreeWidth -PortWidth),
                  XtNheight, (XtArgVal) (CollectHeight+TreeHeight-PortHeight),
                  NULL);
                              
    XtInstallAllAccelerators(Collect, Collect);
    DeleteProtocol(Root);
    XtPopup(Root, XtGrabNone);
}

Boolean MyIsSubclass(WidgetClass Here, WidgetClass Check)
{
    WidgetClass wc;

    for (wc = Here; wc; wc = MySuperclass(wc))
        if (wc == Check) return True;
    return False;
}

char *FullWidgetName(char *ptr, Widget w)
{
    String name;
    int    length;

    if (w) {
        ptr = FullWidgetName(ptr, XtParent(w));
        *ptr++ = '.';
        name = XtName(w);
        length = strlen(name);
        memcpy(ptr, name, length);
        ptr += length;
        *ptr++ = '(';
        name = ClassName(XtClass(w));
        length = strlen(name);
        memcpy(ptr, name, length);
        ptr += length;
        *ptr++ = ')';
    }
    return ptr;
}

static void NumToCursor(char **ptr, XtArgVal nr)
{
    switch(nr) {
      case   0: *ptr = "None"; break;
/* There seems to be no easy way to recover the char from the CursorId. Bummer
      case   2: *ptr = "arrow"; break;
      case   4: *ptr = "based_arrow_down"; break;
      case   6: *ptr = "based_arrow_up"; break;
      case   8: *ptr = "boat"; break;
      case  10: *ptr = "bogosity"; break;
      case  12: *ptr = "bottom_left_corner"; break;
      case  14: *ptr = "bottom_right_corner"; break;
      case  16: *ptr = "bottom_side"; break;
      case  18: *ptr = "bottom_tee"; break;
      case  20: *ptr = "box_spiral"; break;
      case  22: *ptr = "center_ptr"; break;
      case  24: *ptr = "circle"; break;
      case  26: *ptr = "clock"; break;
      case  28: *ptr = "coffee_mug"; break;
      case  30: *ptr = "cross"; break;
      case  32: *ptr = "cross_reverse"; break;
      case  34: *ptr = "crosshair"; break;
      case  36: *ptr = "diamond_cross"; break;
      case  38: *ptr = "dot"; break;
      case  40: *ptr = "dotbox"; break;
      case  42: *ptr = "double_arrow"; break;
      case  44: *ptr = "draft_large"; break;
      case  46: *ptr = "draft_small"; break;
      case  48: *ptr = "draped_box"; break;
      case  50: *ptr = "exchange"; break;
      case  52: *ptr = "fleur"; break;
      case  54: *ptr = "gobbler"; break;
      case  56: *ptr = "gumby"; break;
      case  58: *ptr = "hand1"; break;
      case  60: *ptr = "hand2"; break;
      case  62: *ptr = "heart"; break;
      case  64: *ptr = "icon"; break;
      case  66: *ptr = "iron_cross"; break;
      case  68: *ptr = "left_ptr"; break;
      case  70: *ptr = "left_side"; break;
      case  72: *ptr = "left_tee"; break;
      case  74: *ptr = "leftbutton"; break;
      case  76: *ptr = "ll_angle"; break;
      case  78: *ptr = "lr_angle"; break;
      case  80: *ptr = "man"; break;
      case  82: *ptr = "middlebutton"; break;
      case  84: *ptr = "mouse"; break;
      case  86: *ptr = "pencil"; break;
      case  88: *ptr = "pirate"; break;
      case  90: *ptr = "plus"; break;
      case  92: *ptr = "question_arrow"; break;
      case  94: *ptr = "right_ptr"; break;
      case  96: *ptr = "right_side"; break;
      case  98: *ptr = "right_tee"; break;
      case 100: *ptr = "rightbutton"; break;
      case 102: *ptr = "rtl_logo"; break;
      case 104: *ptr = "sailboat"; break;
      case 106: *ptr = "sb_down_arrow"; break;
      case 108: *ptr = "sb_h_double_arrow"; break;
      case 110: *ptr = "sb_left_arrow"; break;
      case 112: *ptr = "sb_right_arrow"; break;
      case 114: *ptr = "sb_up_arrow"; break;
      case 116: *ptr = "sb_v_double_arrow"; break;
      case 118: *ptr = "shuttle"; break;
      case 120: *ptr = "sizing"; break;
      case 122: *ptr = "spider"; break;
      case 124: *ptr = "spraycan"; break;
      case 126: *ptr = "star"; break;
      case 128: *ptr = "target"; break;
      case 130: *ptr = "tcross"; break;
      case 132: *ptr = "top_left_arrow"; break;
      case 134: *ptr = "top_left_corner"; break;
      case 136: *ptr = "top_right_corner"; break;
      case 138: *ptr = "top_side"; break;
      case 140: *ptr = "top_tee"; break;
      case 142: *ptr = "trek"; break;
      case 144: *ptr = "ul_angle"; break;
      case 146: *ptr = "umbrella"; break;
      case 148: *ptr = "ur_angle"; break;
      case 150: *ptr = "watch"; break;
      case 152: *ptr = "xterm"; break;
*/
      default: sprintf(*ptr, "#%08lx", (long) nr); break;
    }
}

#ifdef SHOW_CORES
#include <signal.h>
#ifndef RETSIGTYPE
# define RETSIGTYPE void
#endif /* RETSIGTYPE */
#include "except.h"

Exception Segmentation = { "Segmentation violation" };
RETSIGTYPE RaiseSeg(void)
{
    Raise(Segmentation);
}
#endif /* SHOW_CORES */

#define STARTTYPE()
#define STOPTYPE()
/*
#define STARTTYPE()  fprintf(stderr, "Starting on name %s, type %s\n",       \
                     Resources[j].resource_name, Type); fflush(stderr);
#define STOPTYPE()   fprintf(stderr, "Stopping on name %s type %s\n",        \
                     Resources[j].resource_name, Type); fflush(stderr);
*/

typedef void (*SomeFun)(void);

extern String MyPrintXlations(Widget w, XtTranslations xlations,
                               Widget accelWidget, int includeRHS);

void ShowTranslations(Widget w, int Indent, char *Trans)
{
    char  *ptr, *pos, **Lines, **Here, *Out, *OutPtr;
    int   NrLines, Length, Before, Temp, OldBefore;

    NrLines = 0;
    for (ptr = Trans; (ptr = strchr(ptr, '\n')) != NULL; ptr++) NrLines++;

    Lines = mynews(char *, NrLines+1);
    WITH_UNWIND {
        Here = Lines;
        *Here++ = ptr = Trans;
        while ((ptr = strchr(ptr, '\n')) != NULL) {
            *ptr++  = 0;
            *Here++ = ptr;
        }
        Here--;
        Length = *Here-Trans;
        *Here = NULL;
        Before = OldBefore = 0;
        for (Here = Lines; (ptr = *Here) != NULL; Here++) {
            pos = strchr(ptr+1, ':');
            if (pos) {
                Temp = pos-ptr;
                OldBefore += Temp;
                if (Temp > Before) Before = Temp;
            }
        }
        Length += NrLines*(Indent+Before)-OldBefore;
        Out = mynews(char, Length+1);

        OutPtr = Out;
        Before++;
        for (Here = Lines; (ptr = *Here) != NULL; Here++) {
            memset(OutPtr, ' ', Indent);
            OutPtr += Indent;
            pos = strchr(ptr+1, ':');
            if (pos) {
                pos++;
                Temp = pos-ptr;
                memcpy(OutPtr, ptr, Temp);
                OutPtr += Temp;
                Temp = Before-Temp;
                memset(OutPtr, ' ', Temp);
                OutPtr += Temp;
            } else pos = ptr;
            Temp = strlen(pos);
            memcpy(OutPtr, pos, Temp);
            OutPtr+= Temp;
            *OutPtr++ = '\n';
        }
        *OutPtr = 0;

        for (ptr = Out; OutPtr-ptr > 500; ptr += 500)
            AddText(w, "%.500s", ptr);
        AddText(w, "%s", ptr);
        myfree(Out);
    } ON_UNWIND {
        myfree(Lines);
    } END_UNWIND;
}

#define NAME(n) (0 == strcmp(n, Resources[j].resource_name))
#define TYPE(t) (0 == strcmp(t, Type))
#define VAL(t)  (* (t *) Val)

static void ShowVal(Widget Text, char *Temp, int TempLength, Widget w,
                    XtResourceList Resources, int m, int Mode,
                    Display *Cdisplay, Colormap Cmap,
                    Cardinal nrargs, Cardinal children)
{
    int       j, Length, NameLength, ClassLength, TypeLength;
    XColor    Colors[100], *Color;
    char     *ptr, *Item;
    String    Type, Trans;
    void     *Val;

    strcat(Temp, "  %-*s  %-*s  %-*s  %-s\n"
                 "  %-*s  %-*s  %-*s  %-s\n");
    Item = ((WidgetRec *) w)->core.constraints;

    NameLength = ClassLength = TypeLength = 0;
    Color = Colors;
    for (j=0; j<m; j++) {
        Length = strlen(Resources[j].resource_name);
        if (Length > NameLength)  NameLength = Length;
        Length = strlen(Resources[j].resource_class);
        if (Length > ClassLength) ClassLength = Length;
        if (Mode == 2) Type = Resources[j].default_type;
        else           Type = Resources[j].resource_type;
        if (TYPE(XtRPixel)) {
            if      (Mode == 0)
                Val = &((char *) w)[Resources[j].resource_offset];
            else if (Mode == 1)
                Val = &((char *) Item)[Resources[j].resource_offset];
            else { /* Mode == 2 */
                if (TYPE(XtRImmediate)) {
                    Val = &Resources[j].default_addr;
                    Type = Resources[j].resource_type;
                } else Val = Resources[j].default_addr;
            }
            Color++->pixel = VAL(Pixel);
        }
        Length = strlen(Type);
        if (Length > TypeLength)  TypeLength = Length;
    }
    if (Cmap) XQueryColors(Cdisplay, Cmap, Colors, Color-Colors);
    Color = Colors;

    AddText(Text, Temp, NameLength, "Name", ClassLength, "Class",
            TypeLength, "Type", Mode == 2 ? "Default" : "Value",
            NameLength, "----", ClassLength, "-----",
            TypeLength, "----", "-----");

    for (j=0; j<m; j++) {
        Trans = NULL;
        ptr   = Temp;

        if      (Mode == 0) {
            Type = Resources[j].resource_type;
            Val = &((char *) w)[Resources[j].resource_offset];
        } else if (Mode == 1) {
            Type = Resources[j].resource_type;
            Val = &((char *) Item)[Resources[j].resource_offset];
        } else { /* Mode == 2 */
            Type = Resources[j].default_type;
            if (TYPE(XtRImmediate)) {
                Val = &Resources[j].default_addr;
                Type = Resources[j].resource_type; 
            } else if (Resources[j].default_addr) {
                if (TYPE(XtRString)) Val = &Resources[j].default_addr;
                else                 Val = Resources[j].default_addr;
            } else {
                ptr = NULLNAME;
                Val = NULL; /* get rid of compiler warning */
            }
        }

        if (ptr == Temp) {
#ifdef SHOW_CORES
            RETSIGTYPE (*oldSeg)();
            STARTTYPE();
            oldSeg = signal(SIGSEGV, RaiseSeg);
            WITH_HANDLING {
#endif /* SHOW_CORES */
            if      (TYPE(XtRInt))
                sprintf(Temp, "%d", VAL(int));
            else if (TYPE(XtRCardinal))
                sprintf(Temp, "%d", (int) VAL(Cardinal));
            else if (TYPE(XtRDimension))
                sprintf(Temp, "%d", (int) VAL(Dimension));
            else if (TYPE(XtRPosition))
                sprintf(Temp, "%d", (int) VAL(Position));
            else if (TYPE(XtRPointer))
                sprintf(Temp, PRTPTR, (void *) VAL(XtPointer));
            else if (TYPE(XtRUnsignedChar)) {
                int ch;

                ch = VAL(unsigned char);
                if (isalpha(ch)) sprintf(Temp, "'%c'(0x%02x)", ch, (int) ch);
                else             sprintf(Temp, "'\\x%02x'", ch);
            }
            else if (TYPE(XtRShort)) sprintf(Temp, "%hd", VAL(short));
            else if (TYPE(XtRFloat)) sprintf(Temp, "%f",  (double) VAL(float));
            else if (TYPE(XtRFunction))
                if (VAL(SomeFun)) sprintf(Temp, PRTPTR,
                                          FUNPTR(VAL(SomeFun)));
                else ptr = NULLNAME;
            else if (TYPE(XtRCursor)) NumToCursor(&ptr, (XtArgVal) VAL(Cursor));
            else if (TYPE(XtRBitmap))
                switch(VAL(Pixmap)) {
                  case 0:  ptr = "None"; break;
                  default: sprintf(Temp, PRTPTR, (void *) VAL(Pixmap)); break;
                }
            else if (TYPE(XtRPixmap))
                switch(VAL(Pixmap)) {
                  case CopyFromParent:      ptr = "(default)"; break; /* also none */
                  case ParentRelative:      ptr = "ParentRelative"; break;
                  case XtUnspecifiedPixmap: ptr = "XtUnspecifiedPixmap"; break;
                  default: sprintf(Temp, PRTPTR, (void *) VAL(Pixmap)); break;
                }
            else if (TYPE(XtRPixel)) {
                if (Cmap) sprintf(Temp, "#%04x %04x %04x",
                                  Color->red, Color->green, Color->blue);
                else sprintf(Temp, "#%08lx in unknown colormap",
                             (long) Color->pixel);
                Color++;
            }
            else if (TYPE(XtRFontStruct)) {
                XFontStruct  *font;
                unsigned long Result;

                font = VAL(XFontStruct *);
                if (XGetFontProperty(font, XA_FONT, &Result) != False)
                    ptr = XGetAtomName(XtDisplayOfObject(w), (Atom) Result);
                else ptr = "...";
            }
            else if (TYPE(XtRCallback)) {
                InternalCallbackList *icl;
                XtCallbackList calls;
                XtCallbackProc fun;

                icl = &VAL(InternalCallbackList);
                if (icl) {
                    calls = _XtGetCallbackList(icl);
                    ptr[2] = ')';
                    ptr[3] = 0;
                    while ((fun = calls->callback) != 0) {
                        if (ptr-Temp-40 > TempLength) {
                            memcpy(ptr, ", ...", 5);
                            ptr += 5;
                            break;
                        }
                        if      (fun == CallNoDestroyWidget)
                            sprintf(ptr, ", (CallNoDestroyWidget, %s)",
                                    XtName((Widget) calls->closure));
                        else if (fun == CallDestroyWidget)
                            sprintf(ptr, ", (CallDestroyWidget, %s)",
                                    XtName((Widget) calls->closure));
                        else if (fun == CallFree)
                            sprintf(ptr, ", (CallFree, " PRTPTR ")",
                                    (void *) calls->closure);
                        else if (fun == CallFreeTemplate)
                            sprintf(ptr, ", (CallFreeTemplate, " PRTPTR ")",
                                    (void *) calls->closure);
                        else if (fun == CallDestroyWitchet)
                            sprintf(ptr, ", (CallDestroyWitchet, " PRTPTR ")",
                                    (void *) calls->closure);
                        else if (fun == CallFakeChildDestroy)
                            sprintf(ptr, ", (CallFakeChildDestroy, " PRTPTR
                                    ")", (void *) calls->closure);
                        else sprintf(ptr, ", (" PRTPTR ", " PRTPTR ")",
                                     FUNPTR(fun), (void *) calls->closure);
                        ptr += strlen(ptr);
                        calls++;
                    }
                    ptr[0] = ')';
                    ptr[1] = 0;
                    ptr = Temp+1;
                    *ptr = '(';
                } else ptr = NULLNAME;
            }
            else if (TYPE(XtRInitialState))
                switch(VAL(int)) {
                  case WithdrawnState: ptr = "WithdrawnState"; break;
                  case NormalState:    ptr = "NormalState"; break;
                  case ZoomState:      ptr = "ZoomState"; break;
                  case IconicState:    ptr = "IconicState"; break;
                  case InactiveState:  ptr = "InactiveState"; break;
                  default:             ptr = "Unknown initial state"; break;
                }
            else if (TYPE(XtROrientation))
                switch(VAL(XtOrientation)) {
                  case XtorientVertical:   ptr = XtEvertical;           break;
                  case XtorientHorizontal: ptr = XtEhorizontal;         break;
                  default:                 ptr = "unknown orientation"; break;
                }
            else if (TYPE(XtRJustify))
                switch(VAL(XtJustify)) {
                  case XtJustifyLeft:   ptr = "Left";  break;
                  case XtJustifyRight:  ptr = "Right"; break;
                  case XtJustifyCenter: ptr = "Center"; break;
                  default:              ptr = "unknown justify"; break;
                }
            else if (TYPE(XtRShapeStyle))
                switch(VAL(int)) {
                  case XmuShapeRectangle:        ptr = "Rectangle"; break;
                  case XmuShapeOval:             ptr = "Oval";  break;
                  case XmuShapeEllipse:          ptr = "Ellipse"; break;
                  case XmuShapeRoundedRectangle: ptr = "RoundedRectangle"; break;
                  default:                       ptr = "unknown shapestyle"; break;
                }
            else if (TYPE("ResizeMode"))
                switch(VAL(XawTextResizeMode)) {
                  case XawtextResizeNever:  ptr = "never";  break;
                  case XawtextResizeWidth:  ptr = "width";  break;
                  case XawtextResizeHeight: ptr = "height"; break;
                  case XawtextResizeBoth:   ptr = "both";   break;
                  default:                  ptr = "unknown resizemode"; break;
                }
            else if (TYPE("ScrollMode"))
                switch(VAL(XawTextScrollMode)) {
                  case XawtextScrollNever:      ptr = "Never"; break;
                  case XawtextScrollWhenNeeded: ptr = "WhenNeeded"; break;
                  case XawtextScrollAlways:     ptr = "Always";     break;
                  default:                      ptr = "unknown scrollmode"; break;
                }
            else if (TYPE("WrapMode"))
                switch(VAL(XawTextWrapMode)) {
                  case XawtextWrapNever: ptr = "Never"; break;
                  case XawtextWrapLine:  ptr = "Word";  break;
                  case XawtextWrapWord:  ptr = "Line";  break;
                  default:               ptr = "Unknown wrapmode"; break;
                }
            else if (TYPE(XtREdgeType))
                switch(VAL(XtEdgeType)) {
                  case XtChainTop:    ptr = "ChainTop";         break;
                  case XtChainBottom: ptr = "ChainBottom";      break;
                  case XtChainLeft:   ptr = "ChainLeft";        break;
                  case XtChainRight:  ptr = "ChainRight";       break;
                  case XtRubber:      ptr = "Rubber";           break;
                  default:            ptr = "Unknown edgetype"; break;
                }
            else if (TYPE(XtRGravity))
                switch(VAL(XtGravity)) {
                  case ForgetGravity:    ptr = XtEForget;    break;
                  case NorthWestGravity: ptr = XtENorthWest; break;
                  case NorthGravity:     ptr = XtENorth;     break;
                  case NorthEastGravity: ptr = XtENorthEast; break;
                  case WestGravity:      ptr = XtEWest;      break;
                  case CenterGravity:    ptr = XtECenter;    break;
                  case EastGravity:      ptr = XtEEast;      break;
                  case SouthWestGravity: ptr = XtESouthWest; break;
                  case SouthGravity:     ptr = XtESouth;     break;
                  case SouthEastGravity: ptr = XtESouthEast; break;
                  case StaticGravity:    ptr = XtEStatic;    break;
/*
                  case UnmapGravity:     ptr = XtEUnmap;     break;
*/
                  default: ptr = "Unknown gravity type";     break;
                }
            else if (TYPE(XtREditMode))
                switch(VAL(XawTextEditType)) {
                  case XawtextRead:   ptr = XtEtextRead;        break;
                  case XawtextAppend: ptr = XtEtextAppend;      break;
                  case XawtextEdit:   ptr = XtEtextEdit;        break;
                  default:            ptr = "Unknown editmode"; break;
                }
            else if (TYPE(XtRAsciiType))
                switch(VAL(XawAsciiType)) {
                  case XawAsciiString: ptr = XtEstring;           break;
                  case XawAsciiFile:   ptr = XtEfile;             break;
                  default:             ptr = "Unknown asciitype"; break;
                }
            else if (TYPE(XtRBackingStore))
                switch(VAL(int)) {
                  case NotUseful:  ptr = XtEnotUseful;           break;
                  case WhenMapped: ptr = XtEwhenMapped;          break;
                  case Always:     ptr = XtEalways;              break;
                  case Always + WhenMapped + NotUseful: 
                                   ptr = XtEdefault;             break;
                  default:         ptr = "Unknown backingstore"; break;
                }
            else if (TYPE(XtRVisual))
                if (VAL(Visual *))
                    switch(VAL(Visual *)->class) {
                      case StaticGray:  ptr = "StaticGray";  break;
                      case GrayScale:   ptr = "GrayScale";   break;
                      case StaticColor: ptr = "StaticColor"; break;
                      case PseudoColor: ptr = "PseudoColor"; break;
                      case TrueColor:   ptr = "TrueColor";   break;
                      case DirectColor: ptr = "DirectColor"; break;
                      default:          ptr = "Unknown visual"; break;
                    }
                else ptr = "CopyFromParent";
            else if (TYPE(XtRScreen)) {
                Screen  *scr;

                scr = VAL(Screen *);
                sprintf(Temp, "Screen %d of %s", XScreenNumberOfScreen(scr),
                        DisplayString(DisplayOfScreen(scr)));
            }
            else if (TYPE(XtRAtom)) {
                ptr = XGetAtomName(XtDisplayOfObject(w), VAL(Atom));
            } else if (TYPE(XtRWidget))
                if   (VAL(Widget)) ptr = XtName(VAL(Widget));
                else               ptr = NULLNAME;
            else if (TYPE(XtRWindow))
                sprintf(Temp, PRTPTR, (void *) VAL(Window));
            else if (TYPE(XtRString))
                if (VAL(String)) {
                    ptr = VAL(String);
                    if (strlen(ptr) >= TempLength) {
                        Length = TempLength - 5;
                        memcpy(Temp, ptr, Length);
                        memcpy(Temp+Length, " ...", 5);
                        ptr = Temp;
                    }
                } else ptr = NULLNAME;
            else if (TYPE(XtRStringList)) {
                StringList *strings;
                int         i, *Len;
                char      **Str;

                strings = VAL(StringList *);
                if (strings) {
                    Len = strings->Length;
                    Str = strings->String;
                    for (i=strings->Nr; i>0; i--, Str++, Len++) {
                        if (ptr-Temp+*Len+7 >= TempLength) {
                            strcpy(ptr, "\n ...");
                            break;
                        }
                        *ptr++ = '\n';
                        *ptr++ = '\t';
                        memcpy(ptr, *Str, *Len);
                        ptr += *Len;
                    }
                    if (ptr == Temp) ptr = "";
                    else ptr = Temp;
                } else ptr = NULLNAME;
            } else if (TYPE(XtRStringArray) && NAME(XtNargv)) {
                String *strings;
                Cardinal k;

                strings = VAL(String *);
                for (k=0; k<nrargs; k++) {
                    Length = strlen(strings[k]);
                    if (ptr-Temp+Length+7 >= TempLength) {
                        strcpy(ptr, ", ...");
                        break;
                    }
                    *ptr++ = ',';
                    *ptr++ = ' ';
                    memcpy(ptr, strings[k], Length);
                    ptr += Length;
                }
                if (ptr == Temp) ptr = "()";
                else {
                    *ptr++ = ')';
                    *ptr   = 0;
                    ptr = Temp+1;
                    *ptr = '(';
                }
            }
            else if (TYPE(XtRWidgetList) && NAME(XtNchildren)) {
                Widget   *widgets;
                char     *WidgetName;
                Cardinal  k;

                widgets = VAL(Widget *);
                for (k=0; k<children; k++) {
                    if (widgets[k]) WidgetName = XtName(widgets[k]);
                    else            WidgetName = NULLNAME;
                    Length = strlen(WidgetName);
                    if (ptr-Temp+Length+7 >= TempLength) {
                        strcpy(ptr, ", ...");
                        break;
                    }
                    *ptr++ = ',';
                    *ptr++ = ' ';
                    memcpy(ptr, WidgetName, Length);
                    ptr += Length;
                }
                if (ptr == Temp) ptr = "()";
                else {
                    *ptr++ = ')';
                    *ptr   = 0;
                    ptr = Temp+1;
                    *ptr = '(';
                }
            }
            else if (TYPE(XtRBoolean))
                if (VAL(Boolean) != False) ptr = XtEtrue;
                else                       ptr = XtEfalse;
            else if (TYPE(XtRBool))
                if (VAL(Boolean) != False) ptr = XtEtrue;
                else                       ptr = XtEfalse;
            else if (TYPE(XtRTranslationTable)) {
                Trans = MyPrintXlations(w, VAL(XtTranslations), NULL, True); 
                ptr = "";
            }
            else if (TYPE(XtRAcceleratorTable)) {
                Trans = MyPrintXlations(w, VAL(XtTranslations), NULL, True); 
                ptr = "";
            }
            else strcpy(Temp, "...");
#ifdef SHOW_CORES
            } ON_EXCEPTION {
                ptr = "(Illegal)";
            } END_HANDLING;
            signal(SIGSEGV, oldSeg);
            STOPTYPE();
#endif /* SHOW_CORES */
        }
        AddText(Text, "  %-*s  %-*s  %-*s  %s\n",
                NameLength,  Resources[j].resource_name,
                ClassLength, Resources[j].resource_class,
                TypeLength,  Type, ptr);
        if (Trans) {
            ShowTranslations(Text, 6, Trans);
            XtFree(Trans);
        }
    }
}
#undef VAL
#undef TYPE
#undef NAME

void InfoOfWidget(Widget w)
{
    Window         Group;
    Widget         Root, topwidget, quit, parent, Text;
    Widget         Parent, Children, Popups, ChangeW;
    WidgetClass    Wc;
    char           title[80], icon[80], Temp[1501];
    XtResourceList Resources;
    XtActionList   Actions, APtr;
    Cardinal       m, children, nrargs, NrActions;
    Display       *Cdisplay;
    Colormap       Cmap;
    XtPointer      Work;

    topwidget = w;
    while ((Root = XtParent(topwidget)) != 0) topwidget = Root;
    XtVaGetValues(topwidget, XtNwindowGroup, (XtArgVal) &Group, NULL);
    if (FindCallback(topwidget, XtNdestroyCallback, CallFakeChildDestroy,
                     &Work)) topwidget = (Widget) Work;

    children = nrargs = 0;
    Cmap     = 0;
    XtVaGetValues(w, XtNcolormap,    (XtArgVal) &Cmap,
                     XtNnumChildren, (XtArgVal) &children,
                     XtNargc,        (XtArgVal) &nrargs, NULL);
    for (Root = w; !Cmap && Root; Root = XtParent(Root))
        XtVaGetValues(Root, XtNcolormap, (XtArgVal) &Cmap, NULL);
    if (Cmap) Cdisplay = XtDisplayOfObject(Root);
    else      Cdisplay = NULL;
    Parent = XtParent(w);
    sprintf(title, "Info on widget %s", XtName(w)); 
    strcpy(icon, title);

    Root = MyVaCreateManagedWidget("widgetInfo", topwidget,
                                   XtNtitle,       (XtArgVal) title,
                                   XtNiconName,    (XtArgVal) icon ,
                                   XtNwindowGroup, (XtArgVal) Group,
                                   NULL);
    quit    = XtNameToWidget(Root, "*restreeQuit");
    ChangeW = XtNameToWidget(Root, "*change");
    Text    = XtNameToWidget(Root, "*info");
    if (Parent && 
        (parent = MyVaCreateManagedWidget("parent", Root, NULL)) != 0) {
        XtAddCallback(parent, XtNcallback, CallWidgetAction,
                      (XtPointer) Parent);
        MyDependsOn(parent, Parent);
    }

    if (ChangeW) {
        XtAddCallback(ChangeW, XtNcallback, CallChangeWidget, (XtPointer) w);
        MyDependsOn(ChangeW, w);
    }

    if (children &&
        (Children = MyVaCreateManagedWidget("children", Root, NULL)) != 0) {
        XtAddCallback(Children, XtNcallback, CallInfoChildren, (XtPointer) w);
        MyDependsOn(Children, w);
    }

    if (XtIsWidget(w) != False && w->core.num_popups &&
        (Popups = MyVaCreateManagedWidget("popups", Root, NULL)) != 0) {
        XtAddCallback(Popups, XtNcallback, CallInfoPopups, (XtPointer) w);
        MyDependsOn(Popups, w);
    }

    if (quit) XtAddCallback(quit, XtNcallback, CallDestroy, (XtPointer) Root);

    if (Text) {
        /* First get all normal resources */
        XtGetResourceList(XtClass(w), &Resources, &m);
        strcpy(FullWidgetName(Temp, w), "\n");
        ShowVal(Text, Temp+1, sizeof(Temp)-1, w, Resources, m, 0,
                Cdisplay, Cmap, nrargs, children);
        XtFree((char *) Resources);

        /* Next get constraintresources from parent */
        if (Parent) {
            XtGetConstraintResourceList(XtClass(Parent), &Resources, &m);
            if (Resources) {
                strcpy(Temp, "\nThis widget sets the folllowing resources "
                       "for its constraint parent:\n");
                ShowVal(Text, Temp, sizeof(Temp), w, Resources, m, 1,
                        Cdisplay, Cmap, nrargs, children);

                XtFree((char *) Resources);
            }
        }

        /* Get constraintresources we may define */
        XtGetConstraintResourceList(XtClass(w), &Resources, &m);
        if (Resources) {
            strcpy(Temp, "\nThis constraint class allows its children "
                         "to specify the following resources:\n");

            ShowVal(Text, Temp, sizeof(Temp), w, Resources, m, 2,
                    Cdisplay, Cmap, nrargs, children);
            XtFree((char *) Resources);
        }

        /* And get possible actions */
        for (Wc = XtClass(w); Wc; Wc = MySuperclass(Wc)) {
            XtGetActionList(Wc, &Actions, &NrActions);
            if (Actions) {
                APtr = Actions;
                AddText(Text, "\nClass %s contributes the following actions: %s",
                        ((CoreClassPart *) Wc)->class_name, APtr->string);
                for (APtr++, NrActions--; NrActions>0; NrActions--, APtr++)
                    AddText(Text, ", %s", APtr->string);
                XtFree((char *) Actions);
            }
        }

        XawTextSetInsertionPoint(Text, 0);
    }
    MyRealizeWidget(Root);
}
