#ifndef GAMES_H
# define GAMES_H

# include <X11/Intrinsic.h>
# include "gointer.h"
# include "gospel.h"
# include "connect.h"
typedef struct _Game Game;
# include "players.h"
# include "observe.h"

#define GAMEKEY1  "observe"
#define GAMEKEY2  "status"
#define GAMEKEY3  "observers"
#define DUMPGAME  "dumpgame"

# define GameToObservers(game) (*Gametoobservers((Game *)(game)))

extern Widget     GamesButton, gameinfo;
extern CommentFun LastMoveFun, MoveFun;
extern int        nrgames;

# ifndef   HAVE_NO_STDARG_H
extern void      MyGameMessage(const char *Format, ...);
extern XtPointer AddGameComment(const Game *game, const char *Format, ...);
extern XtPointer AddMyGameComment(const char *Format, ...);
# else  /* HAVE_NO_STDARG_H */
extern void      MyGameMessage();
extern XtPointer AddGameComment();
extern XtPointer AddMyGameComment();
# endif /* HAVE_NO_STDARG_H */

extern       void      InitGames(Widget Toplevel);
extern       void      DumpGames(const char *args);
extern       void      GamesResort(void);
extern       Game     *AddMove(int Add, GameDesc *Desc, NameVal *moves);
extern       Game     *Moves(GameDesc *Desc, NameVal *moves);
extern       Game     *Undo(int Add, int Id,
                            const char *black, const char *white,
                            const char *MoveDesc);
extern       void      GameTime(int Id,
                                const char *black, int BTime, int Bbyo,
                                const char *white, int WTime, int Wbyo);
extern       void      GameInfo(int Id, const char *black, const char *white,
                                NameList *Type);
extern       void      Watching(NameList *games);
extern       void      StopObserve(Game *game);
extern       void      UnObserve(int Id);
extern       void      UnobserveGames(Connection conn);
extern       void      ObserveWhilePlaying(void);
extern       void      AssertGamesDeleted(void);
extern       void      TestGamesDeleted(void);
extern       Game     *FindGame(int Id, Player *BLack, Player *WHite, int Move,
                                int XSize, int YSize, int Handicap,
                                const char *Komi, int ByoPeriod, int Mode,
                                int rules, int NrObservers);
extern       Game     *IdPlayersToGame(int Id,
                                       const char *black, const char *white);
extern       Game     *ServerIdToGame(int Id);
extern       int       NewMatch(int Id,
                                const Player *Player1, const Player *Player2);
extern       Observe **Gametoobservers(Game *game);
extern       void      RestoreFromScoring(void);
extern       Game     *Resume(int Id, const char *black, const char *white,
                              int move);
extern       void      Adjourn(int Id, const char *black, const char *white);
extern       void      Done(void);
extern       void      Mailed(char *Names);
extern       void      RemoveGameFile(char *Names);
extern       void      RemoveGroup(const char *Stone);
extern       void      RestoreScoring(void);
extern       int       GamePosition(NameList *black, NameList *white,
                                    NumVal *Lines);
extern       void      CheckMyKomi(const char *Komi);

/* The returned pointers exist until called again */
extern const char     *GameDescription(const Game *game);
extern const char     *GameLongDescription(const Game *game);
extern       char     *GameTemplateDescription(const Game *game,
                                               const char *Template);
extern       void      SetGameHeaders(Widget w, const Game *game);
extern       void      SetGameTitle(Game *game, const char *Title);
extern       void      SetMyGameTitle(const char *title);
extern       void      ChangeGameDescription(Game *game);
extern const char     *GameTitle(const Game *game);
extern const char     *GameCaptures(const Game *game);
extern       int       GameMove(const Game *game);

extern       char     *GameName(const char *Template, const char *Type,
                                const Game *game);
extern const char     *GameBlackName(const Game *game);
extern const char     *GameWhiteName(const Game *game);
extern       int       GameXSize(const Game *game);
extern       int       GameYSize(const Game *game);
extern       Gamelog  *GameGamelog(const Game *game);
extern const char     *GameKomi(const Game *game);
extern       int       GameHandicap(const Game *game);
extern       XtPointer LastFromXY(const Game *game, int x, int y);
extern       void      XYFromLast(const Game *game, int *x, int *y,
                                 XtPointer last);
extern       int       GameServerId(const Game *game);
extern       int       ReviewP(const Game *game);
extern       int       TeachingP(const Game *game);
extern       int       PlayingP(const Game *game);
extern       int       TersePlay(const Game *game);
extern       int       MyGameP(const Game *game);
extern       int       MyTurnP(const Game *game, int ToMove);
extern       int       ScoringP(const Game *game);
extern       int       SayP(const Player *player);
extern const Player   *MyOpponent(const Player *player);
extern const char     *GetTime(const Game *game);
extern       void      TestDeleteGame(Game *game);
extern       void ShowObservers(int Id, const char *black, const char *white,
                                const NameList *observers);
extern       void      GamesTime(unsigned long diff);
#endif /* GAMES_H */
